--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("AniCat")
M.TAG       = "AniCat"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer       = params.layer
	-- 所在的地图id
	self._index       = params.index
	-- 选对次数
	self._count       = 0
	-- 待机表
	self._standbyTab  = {}
	-- 是否可以点击
	self._canTouch    = true
	-- 是否是商人
	self._npcName     = "store"
	-- 是否收可以收集心心
	self._isCanGather = true
	-- 是否可以碰撞检测
	self._isCanCrash  = true
end


----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:breathe()
	-- 待机动画
	self:standby()
	-- 加载爱心
	self:loadLove()
end

-- 收集到爱心
function M:stopWalkHappy()
	-- 收集到心心
	self._layer._layer:collectLove(self, true, self._index)
	self:crashCall()
	self._isCanGather = false
	self._isCanCrash  = false
end

-- 加载爱心
function M:loadLove()
	local love = P.newParticle("particle/drg_jindutiao_tuowei1.plist"):to(self):p(125, 450):scale(3):hide()
	love:setPositionType(kCCPositionTypeRelative)
	--  加载粒子
	local particle = P.newParticle("particle/drg_heart.plist"):to(self, 999):p(125, 460):scale(2.5)
	-- 固定粒子位置
	particle:setPositionType(kCCPositionTypeRelative)
	Tools:insertParticleTb(self, love)
	Tools:insertParticleTb(self, particle)
	self._particleLove = particle
	self._love = love
end

-- 碰撞回调
function M:crashCall()
	soundEffect:playEffectsfx05710030()
	self:stimulate()
	self:stopStandby()
end

-- 星星激励
function M:stimulate()
	self:play("mao_zhaohu_ks")
end

--  待机动画
function M:standby()
	if not self._standbyAct then 
		self._standbyAct = A.cycle({
			{"fn", function ()
				-- 随机动作
				self:randomAct()
			end},
			{"delay", 5.5},
		}):at(self)
	end
end

-- 停止闲置
function M:stopStandby()
	if self._standbyAct then 
		self:stopAction(self._standbyAct)
		self._standbyAct = nil
	end
end

-- 随机动作
function M:randomAct()
	local num = self:createRandom(3, self._standbyTab)
	if num == 1 then 
		self:call1()
	elseif num == 2 then 
		self:standby1()
	elseif num == 3 then 
		self:speak()
	end
end

-- 随机数
function M:createRandom(kind, randomTab)
    if #randomTab == kind then 
		T.clear(randomTab)
    end
    local num = N.randomExcept(1, kind, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 待机1
function M:standby1()
	self:play("mao_daiji1")
end

-- 待机2
function M:standby2()
	self:play("mao_daiji2")
end

-- 说话
function M:speak()
	self:play("mao_shuo1")
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057034", 5)
	A.line({
		{"delay", time},
		{"fn", function ()
			self:play("mao_shuo3")
		end}
	}):at(self)
end

-- 呼吸
function M:breathe()
	self:play("mao_huxi")
end

-- 吆喝1
function M:call1()
	self:play("mao_zhaohu_ks")
end

-- 吆喝1
function M:call1_1()
	self:play("mao_zhaohu_xh")
end

-- 吆喝1
function M:call1_2()
	self:play("mao_zhaohu_js")
end

-- 激励1 选对
function M:right()
	self._count = self._count + 1
	self:play("mao_jili")
end

-- 激励2 选错
function M:error()
	self:play("mao_jil2")
end

-- 激励3 告别
function M:bye()
	self:play("mao_jil3")
end


function M:movementHandler(__evtType, __moveId)
	if __evtType == 1 then
		if __moveId == "mao_shuo1" then
			self:play("mao_shuo2")
		elseif __moveId == "mao_zhaohu_ks" then
			self:call1_1()
		elseif __moveId == "mao_zhaohu_jx" then
			self:breathe()
		elseif __moveId == "mao_zhaohu" or "mao_jil2" or "mao_shuo3" or "mao_daiji1" or "mao_daiji2" then
			self:breathe()
			-- 待机
			self:standby()
			self._canTouch = true
		end
	elseif __evtType == 2 then
		if __moveId == "mao_zhaohu_xh" then
			self:call1_2()
		end
	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)
	
	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end

return M
