--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("AniDog")
M.TAG       = "AniDog"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer       = params.layer
	--是否可以点击
	self._canTouch    = true
	-- 狗狗的id
	self._index       = params.index
	-- 这是狗狗
	self._npcName     = "dog"
	-- 是否为收集心心npc
	self._isGather    = true
	-- 是否可以碰撞
	self._isCanGather = true
	self._dogCrashID  = 1
	-- 狗狗的速度
	self._dogSpeed    = 20
end


----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 换装
	self:chuang()
	self:sitBreathe()
end

-- 碰撞回调
function M:crashCall()
	self:visit()
	A.line({
		{"delay", 1.5},
		{"fn", function ()
			self._layer:getParent()._world:DestroyBody(self._body) 
			T.removeOrder(self._layer["dragonTab"..self._index], self._body)
			self._layer._dogFollow = self._layer._dogFollow + 1
			self._dogCrashID = self._layer._dogFollow
			-- 狗狗的移动
			self:dogMoveTime()
		end}
	}):at(self)
	
end

-- 狗狗的移动
function M:dogMoveTime()
	self._dogMoveTimeAct = A.cycle({
		{"delay", 1/60},
		{"fn", function ()
			local dogPos = self:worldpoint()
			self:z(math.abs(dogPos.y - 540))
			local dragonPos = self._layer._follow:worldpoint()
			local disLeftX = dragonPos.x - self:worldpoint().x - 50 * self._layer._dragon:scaleX() *(self._dogCrashID - 1)
			local disLeftY = dragonPos.y - self:worldpoint().y - 10 * self._layer._dragon:scaleX() *(self._dogCrashID % 2 - 1)
			if math.abs(disLeftX) > 20 then 
				self:run()
				self:px(self:px() + disLeftX / self._dogSpeed)
				if disLeftX > 0 then 
					self:flipX(true)
				else
					self:flipX(false)
				end
			elseif math.abs(disLeftY) < 10 then
				if self._layer._dragon:scaleX() == 1 then 
					self:flipX(true)
				else
					self:flipX(false)
				end
				self:stopWalk()
			elseif math.abs(disLeftX) > 150 then
				self._dogSpeed = 100
			end
			if math.abs(disLeftY) > 10 then
				self:py(self:py() + disLeftY/40)
			end
		end}
	}):at(self)
end

-- 换装
function M:chuang()
	local nameTab = {"wc_wj", "wc_wj1", "wc_wj2"}
	local nameTab1 = {"wc_tou", "wc_tou1", "wc_tou2"}
	local nameTab2 = {"wc_zm", "wc_zm1", "wc_zm2"}
	local nameTab3 = {"wc_ym", "wc_ym1", "wc_ym2"}
	local nameTab4 = {"wc_ze", "wc_ze", "wc_ze2"}
	local nameTab5 = {"wc_ye", "wc_ye1", "wc_ye"}
	self:change("wc_wj", nameTab[self._index])
	self:change("wc_tou", nameTab1[self._index])
	self:change("wc_zm", nameTab2[self._index])
	self:change("wc_ym", nameTab3[self._index])
	self:change("wc_ze", nameTab4[self._index])
	self:change("wc_ye", nameTab5[self._index])
end



-- 走
function M:walk()
	if not self._dogWalk then 
		self._dogWalk = true
		self._stopDogWalk = false
		self:play("wc_zou")
	end
end

-- 停止走
function M:stopWalk()
	if not self._stopDogWalk then 
		self._stopDogWalk = true
		self._dogWalk = false
		self:breathe()
	end
end

-- 跑
function M:run()
	if not self._dogWalk then 
		self._dogWalk = true
		self._stopDogWalk = false
		self:play("wc_zou1")
	end
end

-- 坐下
function M:sit()
	self:play("wc_zuo")
end

-- 站着呼吸
function M:breathe()
	self:play("wc_hx")
end

-- 坐下呼吸
function M:sitBreathe()
	self:play("wc_hx1")
end

-- 反馈
function M:feedBack()
	self:play("wc_fk")
end

-- 拜年
function M:visit()
	self:play("wc_bn")
end

--  待机动画
function M:standbyTime()
	if not self._standbyAct then 
		self._standbyAct = A.cycle({
			{"fn", function ()
				-- 待机（左右看看） 
				self:standby()
			end},
			{"delay", 5},
		}):at(self)
	end
end

-- 停止待机动画
function M:stopstandbyAct()
	if not tolua.isnull(self._standbyAct) then
		self:stopAction(self._standbyAct)
		self._standbyAct = nil
	end
end

-- 随机数
function M:createRandom(kind, randomTab)
    if #randomTab == kind then 
		T.clear(randomTab)
    end
    local num = N.randomExcept(1, kind, randomTab)
    table.insert(randomTab, num)
    return num
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "wc_zuo" then 
			self:sitBreathe()
		elseif __moveId == "wc_fk" then 
			self._canTouch = true
			local num = N.random(1, 2)
			if num == 1 then 
				self:sitBreathe()
			elseif num == 2 then 
				self:sit()
			end
		end
	elseif __evtType == 2 then
		if __moveId == "wc_bn" then 
			self:sitBreathe()
		end
	end
end

----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)
	if not self._layer._canTouchDog then return end
	if not self._canTouch then return end
	self._canTouch = false
	self:feedBack()
	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end
----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
