--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("AniYiYi")
M.TAG       = "AniYiYi"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer          = params.layer
	-- 所在的地图id
	self._index          = params.index
	-- 人物移动距离
	self._offset         = 600
	--是否可以点击
	self._canTouch       = true
	-- 计数
	self._count          = 0
	-- 是否是路人
	self._npcName        = "passer"
	-- 是否收可以收集心心
	self._isCanGather    = true
	-- 是否可以碰撞检测
	self._isCanCrash     = true
	-- 是否可以设置方向
	self._isSetDirection = false
end


----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	self:breathe()
	-- 加载爱心
	self:loadLove()
end

-- 加载爱心
function M:loadLove()
	local love = P.newParticle("particle/drg_jindutiao_tuowei1.plist"):to(self):p(80, 230):hide()
	love:setPositionType(kCCPositionTypeRelative)
	--  加载粒子
	local particle = P.newParticle("particle/drg_heart.plist"):to(self, 999):p(80, 240)
	-- 固定粒子位置
	particle:setPositionType(kCCPositionTypeRelative)
	Tools:insertParticleTb(self, love)
	Tools:insertParticleTb(self, particle)
	self._particleLove = particle
	self._love = love
end

-- 停下来开心
function M:stopWalkHappy()
	self._layer._layer:collectLove(self, true, self._index)
	self:crashCall()
	self._body:SetLinearVelocity(b2Vec2(0, 0))
	self._isCanGather = false
	self._isCanCrash  = false
end

-- 碰撞回调
function M:crashCall()
	soundEffect:playEffectsfx05710029()
	self:stopWalkAct()
	self:stimulate()
end

-- 碰撞回调 1
function M:crashCall1()
	A.line({
		{"delay", 1/ 60},
		{"fn", function ()
			self._layer:getParent()._world:DestroyBody(self._body) 
			T.removeOrder(self._layer["dragonTab"..self._index], self._body)
		end}
	}):at(self)
end

-- 回避 回调
function M:avoidCall()
	self._body:SetLinearVelocity(b2Vec2(0, 8))
	A.line({
		{"delay", 0.15},
		{"fn", function ()
			self._body:SetLinearVelocity(b2Vec2(-8, 0))
		end}
	}):at(self)
end

-- 走路规则
function M:walkRule(speed)
	speed = speed or -4
	self:happyWalk()
	self._body:SetLinearVelocity(b2Vec2(speed, 0))
end

-- 心心激励
function M:stimulate()
	self._isSetDirection = true
	self:play("ctyy_gax")
end

-- 停止走路
function M:stopWalkAct()
	if self._walkAct then 
		self:stopAction(self._walkAct)
		self._walkAct = nil
	end
end

-- 呼吸
function M:breathe()
	self:play("ctyy_hx")
end

-- 开心反馈
function M:happy()
	self:play("ctyy_guz")
end

-- 待机（左右看看）
function M:standby()
	self:play("btyy_dj1")
end

-- 开心走路
function M:happyWalk()
	self:play("ctyy_zl1")
end

-- 开心走路
function M:happyWalk1()
	self._isWalk = true
	self:play("ctyy_zl2")
end

-- 开心走路
function M:happyWalk2()
	self._isWalk = true
	self:play("ctyy_zl3")
end

-- 开心走路
function M:happyWalkEnd()
	self:play("ctyy_zl4")
end

-- 停下转到背面
function M:turnBack()
	self._isWalk = false
	self:play("ctyy_zhuan")
end

-- 背面呼吸
function M:breatheBack()
	self:play("btyy_hx")
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "ctyy_guz"  then
			if self._layer._layer._layer._isGameOver then 
				self:breathe()
			else
				self._isCanCrash = true
				self:walkRule(-8)
				self:flipX(false)
			end
			self._isSetDirection = false
		elseif __moveId == "ctyy_gax"  then
			self:play("ctyy_guz")
		end
	elseif __evtType == 2 then
		if __moveId == "ctyy_dzh2" then
			
		end
	end
end




----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)
	if self._layer._isMove then return end
	if not self._canTouch then return end
	
	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end
----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end
return M
