--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classArmatureTouch("Dragon")
M.TAG       = "Dragon"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer     = params.layer
    --触控
    self._canTouch  = false
    -- 随机数表
    self._randomTab = {}
    -- 是否在移动
    self._isMove    = false
    -- 计数
    self._count     = 0
    -- 是
    self._isWalk    = false
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    self:breathe()
    -- 隐藏妙妙蝴蝶结
    self:showBowknotL()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end


-- 显示妙妙蝴蝶结右
function M:showBowknotR()
    self:getBone("wl_mm_hdj1"):show()
    self:getBone("wl_mm_hdj"):hide()
end


-- 显示妙妙蝴蝶结左
function M:showBowknotL()
    self:getBone("wl_mm_hdj"):show()
    self:getBone("wl_mm_hdj1"):hide()
end

-- “舞龙庙会开始啦！”
function M:talkEvent()
    -- 播放配音
    soundVoice:playEffectv057154()
    self:beginTalk1()
    local time = soundVoice:getVoiceTime("v057154", 2)
    A.line({
        {"delay", time},
        {"fn", function ()
            self:beginTalk1_2()
        end}
    }):at(self)
end

-- 爱心是人们得到的快乐，继续搜集爱心，制造更多的快乐吧”
function M:talkEvent1()
    --停止播放开始引导语音
    self:getScene():getMainLayer():stopBeginVoice()
    -- 播放配音
    soundVoice:playEffectv057157()
    self:guideTalk1()
    local time = soundVoice:getVoiceTime("v057157", 5) 
    A.line({
        {"delay", time},
        {"fn", function ()
            self:guideTalk1_2()
        end}
    }):at(self)
    A.line({
        {"delay", 1},
        {"fn", function ()
            -- 继续游戏
            self:continue()
        end}
    }):at(self)
end

-- “看，有人想看咱们的龙灯表演，快到他身边去”
function M:talkEvent2()
    -- 播放配音
    soundVoice:playEffectv057156()
    self:lookTalk1()
    local time = soundVoice:getVoiceTime("v057156", 4)  
    A.line({
        {"delay", time},
        {"fn", function ()
            self:lookTalk1_2()
        end}
    }):at(self)
    A.line({
        {"delay", 1},
        {"fn", function ()
            -- 继续游戏
            self:continue()
        end}
    }):at(self)
end

-- “小朋友们！祝你们新的一年健康快乐，每天都能笑嘻嘻！”
function M:talkEvent3()
    -- 播放配音
    soundVoice:playEffectv057158()
    self:endTalk1()
    local time = soundVoice:getVoiceTime("v057158", 5)   
    A.line({
        {"delay", time},
        {"fn", function ()
            self:endTalk1_2()
        end}
    }):at(self)
end

-- 待机看
function M:lookStandBy()
    -- 音效
    soundEffect:playEffectsfx05710032()
    self:play("wl_kan1")
end

-- 开始说话（舞龙庙会开始了）
function M:beginTalk1()
    self:play("wl_sh1")
end

function M:beginTalk1_1()
    self:play("wl_sh1_1")
end

function M:beginTalk1_2()
    self:play("wl_sh1_2")
end

-- 引导说话（爱心是人们得到的快乐）
function M:guideTalk1()
    self:play("wl_sh2")
end

function M:guideTalk1_1()
    self:play("wl_sh2_1")
end

function M:guideTalk1_2()
    self:play("wl_sh2_2")
end

-- 吃到第一个心心说话
function M:lookTalk1()
    self:play("wl_sh3")
end

function M:lookTalk1_1()
    self:play("wl_sh3_1")
end

function M:lookTalk1_2()
    self:play("wl_sh3_2")
end

-- 结束说话
function M:endTalk1()
    self:play("wl_sh4")
end

function M:endTalk1_1()
    self:play("wl_sh4_1")
end

function M:endTalk1_2()
    self:play("wl_sh4_2")
end

-- 呼吸
function M:breathe()
    self:play("wl_hx")
end

-- 开始走路
function M:beginWalk()
    self:play("wl_zou_1")
end

-- 进阶激励1
function M:stimulate1()
    soundEffect:playEffectsfx05710033()
    self._isWalk = true
    self._isRun  = true
    self:play("wl_jl1", 1.5)
end

-- 进阶激励2
function M:stimulate2()
    soundEffect:playEffectsfx05710034()
    self:play("wl_jl2")
end

-- 待机
function M:standLook()
    self:play("wl_kan")
end

-- 走路表情1
function M:walk(index)
    if not self._isWalk then
        self._isWalk = true
        self._isBreathe = false
        self._isRun = false
        if self._walkSound then 
            sound.setFinishCallback(self._walkSound, function()
                self._walkSound = nil
                sound.voiceFadeTo(self._walkSound, 0, 1)
            end)
        end
        local nameTab = {"wl_zou", "wl_zou1", "wl_zou2"}
        index = index or 1
        self:play(nameTab[index])
    end
end

-- 停止走路
function M:stopWalk()
    if not self._isBreathe and not self._isWalk then
        if self._walkSound then 
            sound.setFinishCallback(self._walkSound, function()
                self._walkSound = nil
                sound.voiceFadeTo(self._walkSound, 0, 1)
            end)
        end
        self._isRun = false
        self._isBreathe = true
        self:breathe()
    end
end

-- 跑
function M:run()
    if not self._isRun then
        local num = N.random(1, 2)
        if num == 1 and not self._walkSound then 
            self._walkSound = soundEffect:playEffectsfx05710033()
        elseif not self._walkSound then 
            self._walkSound = soundEffect:playEffectsfx05710034()
        end
        sound.setFinishCallback(self._walkSound, function()
            self._walkSound = nil
        end)
        self._isRun = true
        self._isWalk = false
        self:play("wl_pao")
    end
end


-- 随机数
function M:createRandom(kind, randomTab)
    if #randomTab == kind then 
    T.clear(randomTab)
    end
    local num = N.randomExcept(1, kind, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 继续游戏
function M:continue()
    self:dragonStandBy()
    self._layer._layer._layer._canTouch = true
    self._layer._layer:openSC()
end

-- 舞龙待机
function M:dragonStandBy()
    if not self._dragonStandByAct then 
        self._dragonStandByAct = A.line({
            {"delay", 5},
            {"fn", function ()
                self:lookStandBy()
                self._dragonStandByAct = nil
            end}
        }):at(self)
    end
end

-- 停止待机
function M:stopDragonStandBy()
    if self._dragonStandByAct then 
        self:stopAction(self._dragonStandByAct)
        self._dragonStandByAct = nil
        self:stopAllActions()
    end
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "wl_zou_1" then
            self:walk()
        elseif __moveId == "wl_sh1" then
            self:beginTalk1_1()
        elseif __moveId == "wl_sh1_2" then
            self:breathe()
            -- 游戏开始
            self._layer._layer._layer:gameBegin()
        elseif __moveId == "wl_sh2" then
            self:guideTalk1_1()
        elseif __moveId == "wl_sh2_2" then
            self:breathe()
            -- 继续游戏
            self:continue()
        elseif __moveId == "wl_sh3" then 
            self:lookTalk1_1()
        elseif __moveId == "wl_sh3_2" then
            self:breathe()
            -- 继续游戏
            self:continue()
        elseif __moveId == "wl_sh4" then
            self:endTalk1_1()
        elseif __moveId == "wl_sh4_2" then
            self:breathe()
            -- 切换场景
            umengOP.recordNYEnd()
            game:enterScene("select", {}, "fade", 0.5, COLOR3_WHITE)
        elseif __moveId == "wl_jl1" then
            self._isWalk = false
            self._isRun = false
            self._walkSound = nil
            self:walk()
        elseif __moveId == "wl_jl2" then
            self:talkEvent3()
        elseif __moveId == "wl_kan1" then
            self:breathe()
            self:dragonStandBy()
		end
	elseif __evtType == 2 then
        if __moveId == "wl_zou" then
            self._isWalk = false
            self._count = self._count + 1
            if self._count == 2 then 
                local num = self:createRandom(3, self._randomTab)
                self._onceEnter = false
                self:walk(num)
                self._count = 0 
            end
        elseif __moveId == "wl_zou1" then
            self._isWalk = false
            self._count = self._count + 1
            if self._count == 2 then 
                self._onceEnter = false
                local num = self:createRandom(3, self._randomTab)
                self:walk(num)
                self._count = 0 
            end
        elseif __moveId == "wl_zou2" then
            self._isWalk = false
            self._count = self._count + 1
            if self._count == 2 then 
                self._onceEnter = false
                local num = self:createRandom(3, self._randomTab)
                self:breathe()
                self._count = 0 
            end
        elseif __moveId == "wl_hx" then
            self._isBreathe = false
		end
	end
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
