--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Map")
M.TAG       = "Map"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer       = params.layer
    --触控
    self._canTouch    = false
    -- 单元地图大小
    self._bgSize      = cc.size(1024, 626)
    -- 地图列
    self._col         = 1
    -- 地图行
    self._row         = 1
    -- 完整地图宽高
    self._mapSize     = cc.size(self._bgSize.width * self._row, self._bgSize.height * self._col)
    -- 移动的线速度
    self._lineSpeed   = 10
    -- 小马速度系数
    self._speed       = 1
    -- 平台刚体表
    self._sideBodyTab = {}
    -- 计数
    self._num         = 1
    self._num1        = 1
    -- 记录此时的标识
    self._flag        = 0
    -- 是否发生碰撞
    self._isWall      = true
    -- 人物屏幕的位置
    self._midPos      = V.w_2
    -- 是否可以移动
    self._isCanMove   = false
end

-- BG_SCALE = 1.25

----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 创建钢体世界
    self:loadWorld()
    -- 加载地图
    self:loadMapTile()
    -- 开启测试
    -- ZBox2D.openDebug(self) 
    -- 开启钢体碰撞检测
    ZBox2D.openContactListener(handler(self, self.delegateMethod))
    -- 开启迭代
    self:openSC()
    -- self._layer:scale(0.2)
end

-- 加载地图
function M:loadMapTile()
    local mapTile = import("app.nylantern.node.MapTile").new({
        layer     = self,
    }):to(self, 100):bindTouch()
    self._mapTile = mapTile
end

-------------------------------------- 物理世界 --------------------------------------
-- 创建钢体世界
function M:loadWorld()
	-- 创建世界
	world = ZBox2D.createWorld(b2Vec2(0, 0))
	self._world = world
    -- 创建刚体世界边界
    self:createEdge()
end

-- 创建刚体世界边界
function M:createEdge()
    -- 创建可跟随的平台刚体
    local pos = {ccp(70, 0), ccp(100, 0), ccp(100, 450 + Y_OFFSET)}
    local sizeTab = {cc.size(10, 450 + Y_OFFSET), cc.size(V.w, 1), cc.size(V.w, 1)}
    for i = 1, 3 do 
        local side = U.loadNode({}):to(self._layer):unbindTouch():p(pos[i])
        local sideBody = self:createBody(side, sizeTab[i], nil, b2_kinematicBody)
        table.insert(self._sideBodyTab, sideBody)
    end
end

-- 移除物理世界
function M:removeWorld()
    if not self._world then return end
    -- 关闭实时跟随
    self:closeSC()
    -- 摧毁世界
    ZBox2D.destroyWorld(self._world)
    self._world = nil
end

-- 创建刚体
function M:createBridgeBody(node)
    local pos = node:point()
    local bodyInfo = {
        bodyType = b2_staticBody,
        userData = node,
        point    = cc.p(pos.x, pos.y),
    }
    local body = ZBox2D.createBody(bodyInfo, "physics/bridge.plist", "bridge")
    return body
end

-- 创建刚体
function M:createBody(node, bodySize, posOffset, bodyType, categoryBits, maskBits)
    posOffset = posOffset or ccp(0, 0)
	-- 刚体配置信息
    local bodyDef      		= b2BodyDef()
 	-- 位置
    bodyDef.position   		= b2Vec2((node:px() + posOffset.x) / PTM_RATIO, (node:py() + posOffset.y) / PTM_RATIO)
    --动态刚体 b2_dynamicBody,静态刚体 b2_staticBody,平台刚体 b2_kinematicBody
    bodyDef.type       		= bodyType or b2_dynamicBody
    --允许休眠
    bodyDef.allowSleep   	= true
    -- 限制旋转
    bodyDef.fixedRotation 	= true
    -- 角度
    bodyDef.angle 			= 0
    bodyDef.userData 		= node
    bodyDef.isSensor = true
    -- 创建刚体
    local body         = self._world:CreateBody(bodyDef)
    if bodySize then
        local shape = nil
        if istable(bodySize) then
            -- 创建形状，矩形
        	shape 	   = b2PolygonShape:new_local()
        	-- 设置宽高
        	shape:SetAsBox(bodySize.width/PTM_RATIO, bodySize.height/PTM_RATIO)  
        else
            -- 创建形状，矩形
            shape        = b2CircleShape:new_local()
            -- 设置半径
            shape.m_radius     = bodySize / PTM_RATIO
        end
        -- 创建夹具
    	local fixtureDef       = b2FixtureDef()
        fixtureDef.shape       = shape
        -- fixtureDef.m_filter.groupIndex    = -1
        -- 摩擦
        fixtureDef.friction    = 0.1 
        -- 恢复             
        fixtureDef.restitution = 0
        -- 密度               
        fixtureDef.density     = 0.00001
        fixtureDef.categoryBits    = categoryBits or 0x01
        fixtureDef.maskBits        = maskBits or 0x01
        -- fixtureDef.isSensor = true
        body:CreateFixture(fixtureDef)                           --为刚体添加夹具
    end
    return body
end

-- 销毁刚体
function M:destroyBody(body)
    self._world:DestroyBody(body)
end

-- 开启实时跟随
-- 使用帧回调更新，地图需要使用这个方式进行更新，否则会出现画面闪烁
function M:openSC()
    -- 关闭实时跟随
	self:closeSC()
	-- 跟据设备刷新帧率
    if self.scUpdate then return end
	self.scUpdate = scheduler.scheduleUpdateGlobal(handlerP(self, self.tick))
end

-- 关闭实时跟随
function M:closeSC()
    if self.scUpdate then 
		SC.close(self.scUpdate)
		self.scUpdate = nil 
	end
end

-- 物理世界迭代
function M:tick()
    if not self._world then return end
    -- 奇奇层级设置
    self:tierSet()
    -- 移动方法
    self:moveFun()
    local velocityIterations, positionIterations = 8, 8
    -- 物理引擎进行物理模拟，生成模拟后的数据
    self._world:Step(1/60, velocityIterations, velocityIterations)
    -- 同步物理世界和渲染世界
    local body = self._world:GetBodyList()
    if body then
        while body do
            if body:GetUserData() then
                local sprite = tolua.cast(body:GetUserData(), "cc.Sprite")
                if sprite then
                    local point = cc.p(body:GetPosition().x * PTM_RATIO, body:GetPosition().y * PTM_RATIO)
                    -- point = self:convertToNodeSpace(point)
                    sprite:setPosition(point)
                end
            end
            -- 获得下一个body
            body = body:GetNext()
        end
    end
end

--坐标转化方法
function M:ccpToVec(point)
    return b2Vec2(point.x / PTM_RATIO, point.y / PTM_RATIO)
end

-- 第一次引导
function M:loadFirstGuide()
    if not self._onceEnter then
        if self._mapTile._dragon._walkSound then 
            sound.voiceFadeTo(self._mapTile._dragon._walkSound, 0, 1)
        end
        -- 音效
     	soundEffect:playEffectsfx05710009()
        --  加载粒子
        self._particle = Tools:newParticle("particle/drg_heart_first.plist", 50, 35):to(self._mapTile._loveTab[1], 999)
        Tools:insertParticleTb(self, self._particle)
        self._mapTile._loveTab[1]._particle = self._particle
        -- 固定粒子位置
        self._particle:setPositionType(kCCPositionTypeRelative)
        self._onceEnter = true
        self._layer:onTouchEnded()
        self._layer._canTouch = false
        self._mapTile._dragon:stopDragonStandBy()
        self:closeSC()
        -- 奇奇引导说话（爱心是人们的快乐。。。）
        self._mapTile._dragon:talkEvent1()
    end
end

-- 第二次引导
function M:loadSecondGuide()
    if not self._onceEnter1 then
        if self._mapTile._dragon._walkSound then 
            sound.voiceFadeTo(self._mapTile._dragon._walkSound, 0, 1)
        end
        -- 音效
     	soundEffect:playEffectsfx05710009()
        self._layer._isStayGuide = false
        self._onceEnter1 = true
        self._layer:onTouchEnded()
        self._layer._canTouch = false
        self._mapTile._dragon:stopDragonStandBy()
        self:closeSC()
        -- 奇奇引导说话（“看，有人想看咱们的龙灯表演，快到他身边去”）
        self._mapTile._dragon:talkEvent2()
    end
end

-- 层级设置 
function M:tierSet()
    local tier = math.abs(self._mapTile._dragon:py() - 540)
    self._mapTile._dragon:z(tier)
end

-- 移动方法
function M:moveFun()
    if not self._touchPoint then return end
    local worldpos = self._mapTile._dragon:worldpoint()
    worldpos.y = worldpos.y + 50
    local dis = PT.distance(worldpos, self._touchPoint)
    if dis <= 10 then
        self:stopDragon()
        self:stopSideBody()
		return
    else
        self._lineSpeed = 10 + 3/250 * dis
        self._midPos = V.w_2 + dis / 8
        if dis >= 230 then 
            self._mapTile._dragon:run()
        else
            self._mapTile._dragon:walk()
        end
    end
    -- 获取手指与鹿钢体角度
    local angle     = math.rad(bb.UPoint.quadAngle(worldpos, self._touchPoint) - 180)
    -- X轴分力
    local speedX    = math.cos(angle) * self._speed * self._lineSpeed
    -- Y轴分力
    local speedY    = math.sin(angle) * self._speed * self._lineSpeed
    -- 设置线速度
    self._mapTile._dragonBody:SetLinearVelocity(b2Vec2(speedX, speedY))
    -- 运动阻尼
    self._mapTile._dragonBody:SetLinearDamping(0)
    -- 其他移动和反转
    self:otherMove(speedX, worldpos)
end

-- 其他移动和反转
function M:otherMove(speedX, worldpos)
    -- 设置鹿翻转
    if speedX > 0 then 
        self._mapTile._dragon:scaleX(1)
        self._mapTile._dragon:showBowknotL()
    else
        self._mapTile._dragon:scaleX(-1)
        self._mapTile._dragon:showBowknotR()
        self:stopSideBody()
    end
    -- 背景移动 和边界刚体移动
    if worldpos.x > self._midPos then 
        self:bgMove()
        self._layer._isScreenMove = false
        self:sideBody(speedX)
    else 
        self._layer._isScreenMove = true
        self:stopSideBody()
    end
end

-- 背景返回缓存
function M:removeBgMove()
    local offset = self._mapTile._dragon:worldpoint().x - V.w_2
    local time = offset / 30 
    if offset >= 0 then 
        A.line({
            {"easing","ELASTICOUT", {"moveBy", time, ccp(-offset, 0)}, .8},
        }):at(self)
        A.line({
            {"easing","ELASTICOUT", {"moveBy", time, ccp(-offset / 3, 0)}, .8},
        }):at(self._mapTile._backBg)
        A.line({
            {"easing","ELASTICOUT", {"moveBy", time, ccp(-offset / 2, 0)}, .8},
        }):at(self._mapTile._backBg1)
    end
end

-- 碰撞回调
function M:delegateMethod(contactType, contact, oldManifold)
    if contactType ~= 2 then return end
    local bodyA = contact:GetFixtureA() and contact:GetFixtureA():GetBody() or nil -- 获取碰撞的刚体
    local bodyB = contact:GetFixtureB() and contact:GetFixtureB():GetBody() or nil 
    local sprA = nil
    local sprB = nil
    if bodyA and bodyB then 
        -- 获取操作的刚体(根据加载的顺序)
        sprA  = tolua.cast(bodyA:GetUserData(), "cc.Sprite")-- 获取碰撞对象
        -- 被碰撞的刚体
        sprB  = tolua.cast(bodyB:GetUserData(), "cc.Sprite")
        if sprA and not tolua.isnull(sprA) and sprB and not tolua.isnull(sprB) then
            local offsetX = sprB:px() - sprA:px()
            local offsetY = math.abs(sprA:py() - sprB:py())
            if sprB._npcName == "passer" and not sprB._isCanCrash then
                
            elseif sprB._npcName == "store" and sprB._isCanGather then
               
            elseif sprB._isCanCrash and offsetY <= 25 and offsetX >= 0 then
                sprB:avoidCall()
            elseif sprB._npcName == "dog" and sprB._isCanGather then 
                sprB:crashCall()
                sprB._isCanGather = false
                sprB._isCanCrash  = false
            end
        end
    end
end

-- 收集到💗
function M:collectLove(node, isPerson, index)
    local time = 0 
    local time1 = 0
    if isPerson then time = 1 time1 = 0.8
        -- 音效
        soundEffect:playEffectsfx05710011()
        sound.playSoundTrack("sfx05710011", 3, 0)
        self._layer._collect = self._layer._collect + 1
    else
        -- 音效
        soundEffect:playEffectsfx05710010()
        sound.playSoundTrack("sfx05710010", 3, 0)
        self._layer._collect = self._layer._collect + 0.5
    end
    -- 游戏计数
    self:gameAdvanced(index)
    -- 吃到东西舞龙身上的特效
    self:effectAct()
    -- 爱心动作
    self:loveAct(time, time1, node, isPerson)
    -- 移除粒子
    self:removeParticleFirst(node)
end

-- 爱心动作
function M:loveAct(time, time1, node, isPerson)
    if not tolua.isnull(node._love._particle1) then 
        node._love._particle1:remove()
        node._love._particle1 = nil
    end
    A.line({
        {"delay", time},
        {"fn", function()
            if node._love and not tolua.isnull(node._love) then
                node._love:show()
            end
            -- 音效
            soundEffect:playEffectsfx05710012()
            sound.playSoundTrack("sfx05710012", 3, 0)
            -- 星星飞向进度条
            Tools:resetParent(node._love, self._layer:getParent(), 93)
            local hangover = Tools:newParticle("particle/drg_jindutiao_tuowei2.plist", 50, 60):to(node._love)
            Tools:insertParticleTb(self, hangover)
            A.line({
                {"union",{
                    {"jumpto", 1.0, cc.p(65 + X_OFFSET / 2.8, 40 + Y_OFFSET + 365 / 48 *(self._layer._collect - 1)), 250, 1},
                    {"scaleTo", 1.0, 0.5},
                }},
                {"fn", function ()
                    self._layer._ui:setProgress(self._layer._collect, isPerson)
                    hangover:remove()
                    T.removeOrder(self._mapTile._loveTab, node)
                    
                end},
                {"delay", time1},
                {"remove"}
            }):at(node._love)
        end} 
    }):at(self)
end

-- 移除第一次引导粒子
function M:removeParticleFirst(node)
    -- 移除地上的粒子
    if node._particle then 
        node._particle:remove()
        node._particle = nil
    end 
    -- 关闭第一次的粒子
    if node._love then 
        if node._love._particle then 
            node._love._particle:remove()
            node._love._particle = nil
        end
    end
    -- 移除人物头上的粒子
    if node._particleLove then 
        node._particleLove:remove()
        node._particleLove = nil
    end
end


-- 进阶激励1
function M:advancedIncentive1()
    A.line({
        {"fn", function ()
            --  加载粒子
            self._particle1 = Tools:newParticle("particle/drg_snowwind.plist", V.w/2, V.h/2):to(self._layer, 999)
            Tools:insertParticleTb(self, self._particle1)
            local ice = D.img("nylantern/ice.png"):to(self._layer, 999):p(V.w/2 + X_OFFSET, V.h/2):scaleX(1.2):scaleY(1):opacity(100)
            A.line({
                {"fadeout", 1},
                {"remove"}
            }):at(ice)
            self._mapTile._dragon:stimulate1()
        end}
    }):at(self)
end

-- 进阶激励2
function M:advancedIncentive2()
    A.line({
        {"fn", function ()
            self._mapTile._dragon:stimulate1()
            --  加载粒子
            self._particle2 = Tools:newParticle("particle/drg_flowerwind.plist", V.w/2, V.h/4.5):to(self._layer, 999)
            self._particle3 = Tools:newParticle("particle/drg_flowerwind2.plist", V.w/2, V.h/4.5):to(self._layer, 999)
            Tools:insertParticleTb(self._layer, self._particle2)
            Tools:insertParticleTb(self._layer, self._particle3)

        end}
    }):at(self)
end

 -- 游戏计数
function M:gameAdvanced(index)
    if self._layer._collect == 12 or self._layer._collect == 12.5  then 
        self._layer._level = 2
    elseif self._layer._collect == 24 or self._layer._collect == 24.5  then
        self._layer._level = 3
    elseif self._layer._collect == 48 or self._layer._collect == 48.5 and not self._once3 then 
        self._once3 = true
        print("游戏结束")
        self:gameOver(index)
    end
end

-- 特效动作
function M:effectAct()
    local effect = D.img("nylantern/loveeffect/effect1.png"):to(self._mapTile._dragon):p(170, 50):scale(0.6):opacity(150)
    A.line({
        {"imagerange", "nylantern/loveeffect/effect", 1, 6, 0.1},
        {"remove"}
    }):at(effect)
end

-- 游戏结束
function M:gameOver(index)
    -- 游戏结束
    self._layer._isGameOver = true
    self._layer:onTouchEnded()
    self._layer._canTouch = false
    self._mapTile._dragon:stopAllActions()
    self._mapTile:stopAllActions()
    self._layer:stopAllActions()
    self:stopAllActions()
    -- 隐藏场景多余爱心
    for i, v in ipairs(self._mapTile["objectTab"..index]) do
        if v._npcName == "store" or v._npcName == "passer" then 
            if not tolua.isnull(v._particleLove) then 
                v._particleLove:hide()
            end
        elseif not tolua.isnull(v._love) then 
            v._love:hide()
        end
    end
    -- 奇奇引导说话（“小朋友们！祝你们新的一年健康快乐，每天都能笑嘻嘻！”）
    self._mapTile._dragon:stimulate2()
end

-- 背景移动
function M:bgMove()
    -- 移动差值
    local offset = 590 
    if BG_SCALE == 1.25 then 
        offset = 645
    end
    -- 主地图切换
    local index1 = math.abs(math.ceil((self:px()) / offset))
    local index = math.ceil(index1 / 2)
    self._mapTile:loadMap(index + 2, false, self._layer._level)
    self._mapTile:removeMap(index - 1)
    -- 后景移动
	local deerWorldPos = self:convertToWorldSpace(self._mapTile._dragon:point())
	local disx = deerWorldPos.x - self._midPos
    local x = self:px() - disx
    local num = math.abs(self._mapTile._backBg:px() / (1024 * BG_SCALE))
    local num1 = math.abs(self._mapTile._backBg1:px() / (1024 * BG_SCALE))
    self._mapTile._backBg:px(x / 3)
    self._mapTile._backBg1:px(x / 2)
    if num > self._num then
        -- 设置新位置
        self:setNewPos(self._num, 1) 
        self._num = self._num + 1
    end
    if num1 > self._num1 then
        -- 设置新位置
        self:setNewPos(self._num1, 2) 
        self._num1 = self._num1 + 1
    end
    self:px(x)
end

-- 设置新位置
function M:setNewPos(index, type)
    local naneTab = {self._mapTile._skyTab, self._mapTile._skyTab1}
    if V.h > 540 then 
        -- 灯笼重置
        if type == 2 then 
            for i, v in ipairs(naneTab[2][1]._linenTab) do
                v._onceEnter = false
                for j, k in ipairs(v._lanternTab) do
                    k:display("nylantern/map/back/lantern/shack.png")
                end
            end
        end
    end
    naneTab[type][1]:px(naneTab[type][3]:px() + 1024 * BG_SCALE)
    local node = naneTab[type][1]
    T.removeOrder(naneTab[type], node)
    table.insert(naneTab[type], node)
    naneTab[type][3]:z(naneTab[type][1]:z() - 30 * index)
end

-- 狗狗跟随移动
function M:dogMove(speedX)
    for i, v in ipairs(self._mapTile._dogTab) do
        if speedX > 0 then 
            v:flipX(true)
            v._body:SetTransform(b2Vec2(self._mapTile._dragonBody:GetPosition().x - 4, self._mapTile._dragonBody:GetPosition().y), 0)
        else
            v:flipX(false)
            v._body:SetTransform(b2Vec2(self._mapTile._dragonBody:GetPosition().x + 4, self._mapTile._dragonBody:GetPosition().y), 0)
        end 
    end
end

-- 边界移动
function M:sideBody(speedX)
    local b2PosX = {12.8 + X_OFFSET / 35, 10, 10}
    local b2PosY = {0, 14, 0}
    for i, v in ipairs(self._sideBodyTab) do
        v:SetTransform(b2Vec2(self._mapTile._dragonBody:GetPosition().x - b2PosX[i], b2PosY[i]), 0)
    end
end

-- 停止边界移动
function M:stopSideBody(speedX)
    speedX = speedX or 0
    for i, v in ipairs(self._sideBodyTab) do
        v:SetLinearVelocity(b2Vec2(0, 0))
        v:SetLinearDamping(0)
    end
end

-- 停止舞龙移动
function M:stopDragon()
    self._mapTile._dragonBody:SetLinearVelocity(b2Vec2(0, 0))
    self._mapTile._dragonBody:SetLinearDamping(100)
    self._mapTile._dragon:stopWalk()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    self:removeWorld()
    -- if not tolua.isnull(self._particle) then 
    --     self._particle:remove()
    --     self._particle = nil
    -- end
    -- if not tolua.isnull(self._particle1) then 
    --     self._particle1:remove()
    --     self._particle1 = nil
    -- end
    -- if not tolua.isnull(self._particle2) then 
    --     self._particle2:remove()
    --     self._particle2 = nil
    -- end
    -- if not tolua.isnull(self._particle3) then 
    --     self._particle3:remove()
    --     self._particle3 = nil
    -- end
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
