--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("MapTile")
M.TAG       = "MapTile"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch   = false
    -- 随机数表
    self._randomTab  = {}
    self._randomTab1 = {}
    self._randomTab2 = {}
    self._randomTab3 = {}
    self._randomTab4 = {}
    self._randomTab5 = {}
    self._randomTab6 = {}
    -- 天空表
    self._skyTab  = {}
    self._skyTab1 = {}
    -- 路人表
    self._passerTab = {}
    -- 鱼的骨骼名
    self._fishName  = {
        {"bone/cj_ltwy", "cj_ltwy", "ld_hx"},
        {"bone/cj_jy", "cj_jy", "jy_hx"},
        {"bone/maoyu", "hmyu_guge", "jzy_yd"},
        {"bone/maoyu", "hmyu_guge", "qly_yd"},
        {"bone/maoyu", "hmyu_guge", "qy_yd"},
        {"bone/maoyu", "hmyu_guge", "sdy_yd"},
    }
    -- 生成的爱心表
    self._loveTab       = {}
    -- 生成爱心的数量表
    self._loveNumberTab = {
        {1, 0, 2, 3},
        {0, 3, 4, 5},
        {0, 4, 4, 8}
    }
    -- 狗狗表
    self._dogTab    = {}
    -- 跟着的狗狗数量
    self._dogFollow = 0
    -- 跟随节点表
    self._followTab = {}
    -- 场景事物表
    self._objectTab = {}
    -- 循环粒子表
    self._particleTab = {}
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]

function M:onRender()
    -- 预加载烟花
    -- local countTbs = {{ 6, 9,}, { 12, 15 }, { 12, 16 }, { 6, 7 }, { 4, 13 }}
    -- for i = 1, 5 do
    --     Tools:addTextureAsync("evefireworkcut/act/normal/" .. i .. "/" .. i .. "_", countTbs[i][1], countTbs[i][2])
    -- end
    -- end
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
    -- 层级设置定时器(和是否路过场景物)
    -- self:tierTime()
end

-- 层级设置定时器
function M:tierTime()
    A.cycle({
        {"delay", 1/60},
        {"fn", function ()
            for i, v in ipairs(self._passerTab) do
                if not tolua.isnull(v) then
                    local tier = math.abs(v:py() - 540) 
                    v:z(tier)
                end
            end
        end}
    }):at(self)
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    
end

-- 加载结点
function M:loadPageNode()
    -- 加载舞龙
    self:loadDragon()
    -- 初始两张地图
    for i = 1, 2 do 
        self:loadMap(i, true)
    end
    -- 加载后景物
    self:loadBackBg()

    self:interactiveTime()
end

-- 加载舞龙
function M:loadDragon()
    local dragon = import("app.nylantern.node.Dragon").new({
        file         = "bone/cj_wl",
        armatureName = "cj_wl",
        layer        = self,
    }):to(self, 9999):anchor(ccp(0.5, 0.1)):p(245, 180):flipX(false)--:bindTouchLocate()
    self._dragon = dragon
    -- 舞龙的刚体
    self._dragonBody = self._layer:createBody(dragon, cc.size(100, 10))
    local dragonlight = D.img("nylantern/dragonlight.png"):to(dragon, -1):p(180, 18.5)--:bindTouchLocate()
    --  加载粒子
    self._particle = Tools:newParticle("particle/drg_follow.plist", 180, 140):to(dragon, 999)
    Tools:insertParticleTb(self, self._particle)
    -- 在舞龙上加载三个辅助节点
    local pos = {ccp(50 , 10), ccp(10 , 35), ccp(-30 , 10)}
    local follow = D.img("common/help.png"):to(dragon):p(pos[1]):opacity(0)
    self._follow = follow
end

-- 加载地图
function M:loadMap(index, isFirst, level)
    -- level = 2
    if not self["mapTile"..index] then
        local kind1, kind2 = 1, 4
        if level == 2 and not isFirst then 
            kind1, kind2 = 5, 8
            -- 二阶段进阶不生成 8 地图减少 地图量
            -- if not self._onceCanEnter then 
            --     self._onceCanEnter = true
            --     kind1, kind2 = 5, 7
            -- end
        elseif level == 3 then 
            kind1, kind2 = 9, 12
        end
        local num = self:createRandom(kind1, kind2, self._randomTab)
        -- 加载通用景物
        self:loadGeneral(index, level)
        if isFirst then num = index end
        -- num = 8
        if num == 1 then 
            -- 加载第一个心心
            self:loadLove(index, 1, 920, 180)
        else
            self:loadLove(index)
            -- 加载人物的刷新和移动
            self:figureAppearRule(index, nil, nil, num)
        end
        self["map"..num](self, index)
    end
end

-- 加载人物的刷新和移动
function M:figureAppearRule(index, number, posX, type)
    type = type or 1
    posX = posX or V.w * 1.2
    number = number or 1
    local nameTab = {"PiPi", "MeiMei", "Zz", "YiYi", "NaoNao"}
    for i = 1, number do 
        local num = self:createRandom(1, 4, self._randomTab2)
        -- 随机纵坐标
        local posY = N.random(100, 230)
        if type == 12 then 
            posY = N.random(180, 240)
        end
        local tier = math.abs(posY - 540)
        self["load".. nameTab[num]](self, index, ccp(posX + V.w_2 * (i - 1), posY), tier)
    end
end

-- 随机数
function M:createRandom(kind1, kind2, randomTab)
    local last = 0
    if #randomTab == kind2 - kind1 + 1 then 
        last = randomTab[kind2 - kind1 + 1]
        T.clear(randomTab)
    end
    local num = N.randomExcept(kind1, kind2, randomTab)
    while num == last do
        local num1 = N.randomExcept(kind1, kind2, randomTab)
        if num1 ~= num then
            num = num1
        end
    end
    table.insert(randomTab, num)
    return num
end

------------场景景物互动-------------
-- 互动判定定时器（太多互动拆不开）
function M:interactiveTime()
    self._interactiveTimeAct = A.cycle({
        {"delay", 1/60},
        {"fn", function ()
            local dragonPos = self._dragon:worldpoint()
            -- 后景灯笼 亮起
            self:backLightAct(dragonPos)
            -- 人物定时器
            for j, k in ipairs(self._objectTab) do
                -- 不在屏幕内的互动互动事务hide 减少calls
                self:outScreen(k)
                -- 路人事件
                self:figureIncident(k, dragonPos)
                -- 商人事件
                self:shopIncident(k, dragonPos)
                -- -- 路过树亮起
                if k._name == "tree" then 
                    self:treeLightUp(k, dragonPos)
                -- 风车开始转
                elseif k._name == "fance" then 
                    self:windmillTurn(k, dragonPos)
                -- 雪人互动
                elseif k._name == "snow" then 
                    if k:worldpoint().x < dragonPos.x + 150 and not k._onceEnter then 
                        k._onceEnter = true
                        for i, v in ipairs(k._snowManTab) do
                            self:snowManAct(v)
                        end
                    end
                -- 放烟花
                elseif k._name == "firework" then 
                    -- 放烟花
                    self:fireworksUp(k, dragonPos)
                -- 路过梅花树
                -- elseif k._name == "plum" then 
                --     self:plumAppearParticle(k, dragonPos)
                -- 音效互动
                elseif k._name == "pool" then 
                    self:poolInteractive(k, dragonPos)
                -- 下雪激励
                elseif k._name == "snowing" then 
                    if k:worldpoint().x < dragonPos.x - 400 and not self._onceSnowing then 
                        self._onceSnowing = true
                        self._layer:advancedIncentive1()
                    end
                -- 下梅花激励
                elseif k._name == "pluming" then 
                    if k:worldpoint().x < dragonPos.x - 400 and not self._oncePluming then 
                        self._oncePluming = true
                        self._layer:advancedIncentive2()
                    end
                elseif k._name == "love" then
                    -- 爱心碰撞检测
                    self:loveCollision(k, dragonPos)
                    if k:worldpoint().x < - 2 * k:cw() then 
                        T.removeOrder(self._loveTab, k)
                        T.removeOrder(self._objectTab, k)
                        k:remove()
                        k = nil
                    end
                end
            end
        end}
    }):at(self)
end

-- 不在屏幕内的互动互动事务hide 减少calls
function M:outScreen(k)
    if k:worldpoint().x < - 2 * k:cw() or k:worldpoint().x > 3 * V.w_2 then
        if k._name == "snowing" or k._name == "pluming" then
            
        else
            k:hide()
        end
    elseif not k._once1 then
        k._once1 = true
        k:show()
    end
end

-- 爱心碰撞检测
function M:loveCollision(k, dragonPos)
    local lovePos = k:worldpoint()
    if math.abs(dragonPos.x - lovePos.x) < 125 and math.abs(dragonPos.y - lovePos.y) < 40 and not tolua.isnull(k) then 
        self._layer:collectLove(k, false, k._index)
        if not tolua.isnull(k) then 
            T.removeOrder(self._loveTab, k)
            T.removeOrder(self._objectTab, k)
        end
    elseif math.abs(dragonPos.x - lovePos.x) < 255 and self._layer._layer._isStayGuide then
        self._layer:loadFirstGuide()
    end
end

-- 路人判定事件
function M:figureIncident(node, dragonPos)
    if node._npcName == "passer" then 
        local pos = node:worldpoint()
        -- 时时刷新层级
        node:z(math.abs(pos.y - 540))
        local count = math.ceil(math.abs(self._layer:px() / (1024 * BG_SCALE)))
        -- 判断是否靠近奇奇
        if math.abs(pos.x - dragonPos.x) <= 150 and math.abs(pos.y - dragonPos.y) <= 40 and not node._once then
            node._once = true
            T.removeOrder(self._passerTab, node)
            node:stopWalkHappy()
        end
        -- 骨骼离开屏幕立即卸载
        if pos.x / node._index <= -50 - X_OFFSET then
            if not tolua.isnull(node._body) then 
                self._layer._world:DestroyBody(node._body) 
                T.removeOrder(self["dragonTab"..node._index], node._body)
                T.removeOrder(self._objectTab, node)
                T.removeOrder(self._passerTab, node)
                node:remove()
                node = nil 
            end
        -- 骨骼观看舞龙设置方向
        elseif node._isSetDirection then 
            local offset = pos.x - dragonPos.x
            if offset > 0 then 
                if node._isMeiMei then 
                    node:flipX(true)
                else
                    node:flipX(false)
                end
            else
                if node._isMeiMei then 
                    node:flipX(false)
                else
                    node:flipX(true)
                end
            end
        -- 路人骨骼开始行走
        elseif count == node._index and not node._onceEnter and self._layer._layer._isFirstTouch and not self._layer._layer._isGameOver then
            node._onceEnter = true
            -- 延时开始行走
            A.line({
                {"delay", 0.1},
                {"fn", function ()
                    node:walkRule()
                end}
            }):at(node)
        -- 游戏结束人物们开心
        end
        if self._layer._layer._isGameOver then 
            self:stopAllActions()
            node:stopAllActions()
            node._body:SetLinearVelocity(b2Vec2(0, 0))
            node:stimulate()
        end
    end
end

-- 商人判定事件
function M:shopIncident(node, dragonPos)
    if node._npcName == "store" then 
        local pos = node:worldpoint()
        -- 是否迟到爱心
        if math.abs(pos.x - dragonPos.x) <= 150 and math.abs(pos.y - dragonPos.y) <= 80 and not node._once then
            node._once = true
            node:stopWalkHappy()
            T.removeOrder(self._passerTab, node)
        end
        -- 骨骼离开屏幕立即卸载
        if pos.x / node._index <= -50 - X_OFFSET then
            if not tolua.isnull(node._body) then 
                self._layer._world:DestroyBody(node._body) 
                T.removeOrder(self["dragonTab"..node._index], node._body)
                T.removeOrder(self._objectTab, node)
                T.removeOrder(self._passerTab, node)
                node:remove()
                node = nil 
            end
        end
        -- 企鹅的引导判断
        if math.abs(dragonPos.x - pos.x) <= 200 and self._layer._layer._isStayGuide then 
            --  加载粒子
            local particle = Tools:newParticle("particle/drg_heart_first.plist", 170, 35):to(node, 999):scale(4)
            Tools:insertParticleTb(self, particle)
            table.insert(self._particleTab, particle)
            node._particle = particle
            -- 固定粒子位置
            particle:setPositionType(kCCPositionTypeRelative)
            self._layer:loadSecondGuide()
        end
    end
end


-- 梅花出现粒子
function M:plumAppearParticle(k, dragonPos)
    if k:worldpoint().x < dragonPos.x + 150 and not k._onceEnter then 
        k._onceEnter = true
        soundEffect:playEffectsfx05710023()
        -- 加载梅花粒子
        local particle = Tools:newParticle("particle/drg_flower.plist", 180, 140):to(k, 999)
        Tools:insertParticleTb(self, particle)
        table.insert(self._particleTab, particle)
        -- 固定粒子位置
        particle:setPositionType(kCCPositionTypeRelative)
    end
end

-- 水池互动
function M:poolInteractive(k, dragonPos)
    if k:worldpoint().x < dragonPos.x + 250 and not k._onceEnter then 
        k._onceEnter = true
        -- 音效
        self._sfx05710021 = soundEffect:playEffectsfx05710021()
        sound.voiceFadeTo(self._sfx05710021, 1, 1)
        -- 音效
        self._sfx05710022 = soundEffect:playEffectsfx05710022()
        sound.voiceFadeTo(self._sfx05710022, 1, 1)
    elseif k:worldpoint().x < dragonPos.x - 800 and not k._onceEnter1 then 
        k._onceEnter1 = true
        sound.voiceFadeTo(self._sfx05710021, 0, 3)
        sound.voiceFadeTo(self._sfx05710022, 0, 3)
    end
end

-- 放烟花
function M:fireworksUp(k, dragonPos)
    if k:worldpoint().x < dragonPos.x + 150 and not k._onceEnter then 
        k._onceEnter = true
        -- 加载烟花
        self:loadFireworksPut(k)
        self._sfx05710020 = soundEffect:playEffectsfx05710020()
        sound.voiceFadeTo(self._sfx05710019, 0, 2)
    elseif k:worldpoint().x < dragonPos.x + 500 and not k._onceEnter1 then 
        k._onceEnter1 = true
        soundEffect:playEffectsfx05710018()
        self._sfx05710019 = soundEffect:playEffectsfx05710019()
    elseif k:worldpoint().x < dragonPos.x - 550 and not k._onceEnter2 then 
        k._onceEnter2 = true
        sound.voiceFadeTo(self._sfx05710020, 0, 2)
    end
end

-- 风车转起来
function M:windmillTurn(k, dragonPos)
    if k:worldpoint().x < dragonPos.x + 550 and not k._onceEnter then 
        k._onceEnter = true
        -- 音效
        self._sfx05710015 = soundEffect:playEffectsfx05710015()
        sound.setFinishCallback(self._sfx05710015, function()
            self._sfx05710016 = soundEffect:playEffectsfx05710016()
        end)
        for i, v in ipairs(k._fenceTab) do
            local time = 0 + 0.2 * (i - 1)
            A.line({
                {"delay", time},
                {"fn", function ()
                    commonAct:windmillAction(v)
                end}
            }):at(v)
        end
    elseif k:worldpoint().x < dragonPos.x - 300 and not k._onceEnter1 then 
        k._onceEnter1 = true
        if self._sfx05710016 then 
            sound.stopSound(self._sfx05710016)
        end
        soundEffect:playEffectsfx05710017()
    end
end

-- 树亮起来
function M:treeLightUp(k, dragonPos)
    if k:worldpoint().x < dragonPos.x + 250 and not k._onceEnter then 
        k._onceEnter = true
        local num = self:createRandom(1, 2, self._randomTab6)
        if num == 1 then 
            -- 音效
     	    soundEffect:playEffectsfx05710013()
        elseif num == 2 then
            -- 音效
     	    soundEffect:playEffectsfx05710014()
        end
        -- 树粒子动作和显示
        self:loadPartile(k)
    end
end

-- 树粒子动作和显示
function M:loadPartile(k)
    local iniPos = ccp(90, 40)
    local particle = Tools:newParticle("particle/drg_tree_tuowei.plist", 90, 40):to(k, 999)
    Tools:insertParticleTb(self, particle)
    -- -- 固定粒子位置
    particle:setPositionType(kCCPositionTypeRelative)
    local center = ccp(80, 150)								-- 粒子环绕的中心位置
    local rot = 270											-- 初始角度
    local yOff = 0											-- y轴下降像素
    local time = 1											-- 环绕时间
    local frame = time * 60									-- 依据时间计算出多少帧
    local fRot = 1080 / frame 								-- 每一帧改变的角度
    local fYOff = 110 / frame 								-- 每一帧下降的高度
    particle:line({
        A.cycle({
            {"fn", function()
                local a = rot > 180 and particle :z(1) or particle :z(-1)
                rot = (rot + fRot) % 360
                yOff = yOff - fYOff
                local xx = center.x + math.cos(math.rad(rot)) * 120
                local yy = center.y + 50 + math.sin(math.rad(rot))  + yOff
                particle :p(xx, yy)
            end},
            {"delay", 1 / 60},
        }, frame),
        {"fn", function()
            particle :stopSystem()
            for i, v in ipairs(k._lanternTab) do
                local time = 0 + 0.1 * (i - 1)
                A.line({
                    {"delay", time},
                    {"fn", function ()
                        v:display("nylantern/map/first/tree/2.png")
                        if i == #k._lanternTab then 
                            k._particle1 = Tools:newParticle("particle/drg_tree.plist", 90, 140):to(k, 999)
                            Tools:insertParticleTb(self, k._particle1)
                            table.insert(self._particleTab, k._particle1)
                            -- 固定粒子位置
                            k._particle1:setPositionType(kCCPositionTypeRelative)
                        end 
                    end}
                }):at(v)
            end
        end},
    })
end

-- 后景灯笼 亮起
function M:backLightAct(pos)
    if V.h > 540 then 
        for j, k in ipairs(self._skyTab1) do
            if k._name == "lantern" then
                for i, v in ipairs(k._linenTab) do
                    if v:worldpoint().x < pos.x + 120 and not v._onceEnter then 
                        v._onceEnter = true
                        for i, v in ipairs(v._lanternTab) do
                            local time = 0 + 0.25 * (i - 1)
                            A.line({
                                {"delay", time},
                                {"fn", function ()
                                    local particle = Tools:newParticle("particle/drg_light_on.plist", 180, 40):to(v, 999)
                                    Tools:insertParticleTb(self, particle)
                                    -- 固定粒子位置
                                    particle:setPositionType(kCCPositionTypeRelative)
                                    v:display("nylantern/map/back/lantern/light.png")
                                end}
                            }):at(v)
                        end
                    end
                end 
            end
        end
    end
end

-- 加载烟花
function M:loadFireworksPut(node)
    local countTbs = { { 6, 9,}, { 12, 15 }, { 12, 16 }, { 6, 7 }, { 4, 13 } }
    for i = 1, 3 do
        local index = i
        if i >= 2 then i = i + 2 end
        local fire = D.img("evefireworkcut/act/normal/"..i.."/"..i.."_1.png"):to(node):p(ccp(100 + 90 * (index - 1), 200)):scale(1.5)
        A.cycle({
            {"imagerange", "evefireworkcut/act/normal/"..i.."/"..i.."_", countTbs[i][1], countTbs[i][2], 0.1},
            {"remove"}
        }):at(fire)
    end
end

-- 雪人动作
function M:snowManAct(node)
    local number = RD.number(5, 10)
    local time   = RD.number(5, 10) * 0.02
    A.line({
        {"moveBy", time, ccp(0,  number)},
        {"moveBy", time, ccp(0, -number)},
        {"fn", function ()
            commonAct:nodeScale(node, 0.5, 0.5)
        end}
    }):at(node)
end
------------场景景物互动-------------


-------------------------------------------
--------------- 加载后景物  -----------------
-------------------------------------------
function M:loadBackBg()
    -- 加载移动的空节点
    local backBg = U.loadNode({}):to(self._layer._layer, 50)--:bindTouchLocate()
    self._backBg = backBg
    local backBg1 = U.loadNode({}):to(self._layer._layer, 60)--:bindTouchLocate()
    self._backBg1 = backBg1
    -- -- 加载最远天空
    self:loadSky()
    -- 加载中景物
    self:loadMid()
end

-- 加载最远天空
function M:loadSky()
    local scaleTab = {30, 20, 10}
    for j = 1, 3 do 
        -- 加载天空
        local sky   = D.img("nylantern/map/sky/sky.png"):to(self._backBg, scaleTab[j]):p(V.w_2 + 1024 * BG_SCALE * (j - 1), 615):scale(BG_SCALE)--:bindTouchLocate()
        if V.h > 540 then 
            -- 加载不用动的
            self:quietThing(sky)
            -- 加载孔明灯
            self:loadTicket(sky)
        end
        table.insert(self._skyTab, sky)
    end
end

-- 加载中景物
function M:loadMid()
    local scaleTab = {30, 20, 10}
    for j = 1, 3 do 
        -- 加载天空
        local sky   = D.img():to(self._backBg1, scaleTab[j]):p(0 + 1024 * BG_SCALE * (j - 1), 500):scale(BG_SCALE)--:bindTouchLocate()
        if V.h > 540 then 
            -- 加载灯笼
            self:lanternThing(sky)
        end
        local num = self:createRandom(1, 3, self._randomTab1)
        -- self:backLight(sky, num, j)
        table.insert(self._skyTab1, sky)
    end
end

-- 加载孔明灯
function M:loadTicket(node)
    local pos = {ccp(296.0, 101.7), ccp(408.2, 98.4), ccp(552.1, 107.4), ccp(712.5, 102.5), ccp(862.1, 109.6)}
    for i = 1, 5 do 
        local num = i % 2 + 1
        local light = D.img("nylantern/map/sky/light"..num..".png"):to(node, 10):p(pos[i]):anchor(ccp(0.5, 0.3))--:bindTouchLocate()
        commonAct:moveAround(light)
    end
    local pos1 = {ccp(362.9, 120.7), ccp(603.4, 99.7)}
    -- 加载云
    for i = 1, 2 do 
        local cloud = D.img("nylantern/map/sky/cloud"..i..".png"):to(node, 5):p(pos1[i]):anchor(ccp(0.5, 0.3))--:bindTouchLocate()
    end
end


-- 加载不用动的
function M:quietThing( node)
    local pos = {ccp(470.5, 85.4), ccp(403.3, 100), ccp(773.2, 107.6), ccp(80, 118.7), ccp(300, 120), ccp(607.8, 96.8), ccp(950, 128.6)}
      -- 加载阴影
      for i = 3, 9 do 
        local quiet = D.img("nylantern/map/back/"..i..".png"):to(node, 20):p(pos[i - 2].x, pos[i - 2].y - 100):scale(BG_SCALE)--:bindTouchLocate()
    end
end

-- 加载背景灯笼
function M:lanternThing(node)
    node._linenTab = {}
    node._name = "lantern"
    for i = 1, 6 do 
        -- 加载杆
        local pole = D.img("nylantern/map/back/lantern/2.png"):to(node, 22):p(30 + 196 * (i - 1), 10)--:bindTouchLocate()
    end
    local pos = {ccp(33.3, 10), ccp(72.4, 1.2), ccp(118.2, 1.0), ccp(158.6, 10)}
    for i = 1, 5 do 
        -- 加载线
        local pole = D.img("nylantern/map/back/lantern/1.png"):to(node, 22):p(129.1 + 196 * (i - 1), 80)--:bindTouchLocate()
        pole._lanternTab = {}
        table.insert(node._linenTab, pole)
        for j = 1, 4 do 
            local lantern = D.img("nylantern/map/back/lantern/shack.png"):to(pole):p(pos[j]):anchor(ccp(0.5, 0.65))--:bindTouchLocate()
            commonAct:swingAction(lantern)
            table.insert(pole._lanternTab, lantern)
        end
    end
end

-- 亮色背景1
function M:backLight(node, num, index)
    -- 加载亮色背景
    local pos1 = {ccp(215.5, 20), ccp(188.5, -21), ccp(270, 0)}
    for i = 1, 3 do 
        local thing1 = D.img("nylantern/map/back/1_"..i..".png"):to(node, 25):p(pos1[i]):scale(0.8)--:bindTouchLocate()
            if i > 1 then Tools:breathing(thing1) end
        if num == 2 then 
            if i == 1 then 
                if not tolua.isnull(thing1) then 
                    thing1:remove()
                end
            end
        end
    end
    local pos2 = {ccp(582.6, 28.4), ccp(478.9, -44), ccp(610, -29)}
    for i = 1, 3 do 
        local thing2 = D.img("nylantern/map/back/2_"..i..".png"):to(node, 25):p(pos2[i]):scale(0.8)--:bindTouchLocate()
        if i > 1 then Tools:breathing(thing2) end
        if num == 2 then 
            if i == 1 then 
                if not tolua.isnull(thing2) then 
                    thing2:remove()
                end
            end
        end
    end
    if num == 3 then 
        -- 加载一课梅🌲
        local plum = D.img("nylantern/map/first/plum.png"):to(node, 25):p(800, 0):scale(0.8)--:bindTouchLocate()
    end
end
--------------- 加载后景物  -----------------

------------ 不同等级的地图 ----------------
-- 加载地图上的爱心
function M:loadLove(index, number, posX, posY)
    -- 随机纵坐标
    local random = self:createRandom(1, 4, self._randomTab4)
    number = number or self._loveNumberTab[self._layer._layer._level][random]
    local posX = posX or N.random(300, 900)
    local posY = posY or N.random(100, 260)
    for i = 1, number do
        -- 三颗以下
        if number <= 3 and number > 1 then 
            posX = posX + 80 * (i - 1) posY = 200
        end
        -- 四五颗图案
        if number >= 4 and number <= 5 then 
            local num = self:createRandom(1, 5, self._randomTab5)
            posX = posX + 80 * (i - 1) posY = 220 - 35 * (i % num) 
        end
        -- 八颗爱心形状
        if number == 8 then 
            local starPos = ccp(600, 180)
            posX = starPos.x + 50 * (i - 1) posY = starPos.y + 50 * (i % 2) 
            if i == 8 then posX = starPos.x + 100 posY = starPos.y - 50 
            elseif i >= 6 then posX = starPos.x + 50 + 100 * (i - 6) posY = starPos.y + 90  
            end
        end
        local tier = math.abs(posY - 540)
        local love = D.img("nylantern/love1.png"):to(self, tier):p(posX + 1024 * BG_SCALE * (index - 1), posY):scale(0.8)--:bindTouchLocate()
        love._name = "love"
        --  加载粒子
        local particle = Tools:newParticle("particle/drg_heart_groud.plist", 50, 55):to(love, 999)
        Tools:insertParticleTb(self, particle)
        table.insert(self._particleTab, particle)
        love._particle1 = particle
        love._index = index
        -- 固定粒子位置
        particle:setPositionType(kCCPositionTypeRelative)
        -- 爱心呼吸动作
        self:loveAct(love)
        love._love = love
        table.insert(self._loveTab, love)
        table.insert(self["objectTab"..index], love)
        table.insert(self._objectTab, love)
    end
end

-- 爱心呼吸动作
function M:loveAct(node)
    A.cycle({
        {"union",{
            {"jumpby", 0.7, cc.p(0, 0), 8, 1},
            {"fn", function ()
                commonAct:nodeScale(node, 1, 0.5)
            end}
        }},
    }):at(node)
end

------------ 一级地图 ----------------
-- 地图1
function M:map1(index)
    -- 加载树和草地
    self:loadTree(index, ccp(165, 400))
    -- 加载杂货铺
    self:loadGrocery(index)
    -- 加载鞭炮店铺
    self:loadFireCracker(index)
    -- 加载底部的店铺
    self:loadBaseStore(index)
end

-- 地图2
function M:map2(index)
    -- 加载春联店铺
    self:loadCouplet(index, ccp(520, 360))
    -- 加载树和草地
    self:loadTree(index, ccp(880, 400))
    self:loadTree(index, ccp(100, 400))
    -- 加载风车篱笆
    self:loadWindmill(index)

    -- 春联店老板
    self:loadPenguin(index)
  
end

-- 地图3
function M:map3(index)
    -- 加载树和草地
    self:loadTree(index, ccp(165, 370))
    -- 加载鞭炮店铺
    self:loadFireCracker(index, ccp(487.6, 348))
    -- 加载气球店铺
    self:loadBalloon(index)

end

-- 地图4
function M:map4(index)
    -- 加载杂货铺
    self:loadGrocery(index, ccp(120, 370))
    -- 加载糖葫芦店
    self:loadGourd(index)
    -- 加载花店
    self:loadFlower(index)
    -- 加载底部的灯笼书
    for i = 1, 3 do 
        self:loadTree(index, ccp(200 + 200 * (i - 1), -50), 500)
    end
    -- 加载花店老板
    self:loadCat(index)
    -- 加载杂货铺老板
    self:loadBear(index, ccp(0, 270))
end

------------ 二级地图 ----------------
-- 地图5
function M:map5(index)
    -- 加载树和草地
    self:loadTree(index, ccp(165, 400))
    -- 加载杂货铺
    self:loadGrocery(index, nil, true)
    -- 加载糖葫芦
    self:loadGourd(index, ccp(880, 360), 100, true)
    -- -- 加载竹子
    -- self:loadBamboo(index, ccp(250, -70))
    -- self:loadBamboo(index, ccp(150, -70))
    -- 加载前景雪障碍
    self:loadSnowProspect1(index)
    -- 加载场景雪
    self:loadFloorSnow(index, 1)

    -- 加载杂货铺老板
    self:loadBear(index)
end

-- 地图6
function M:map6(index)
    -- 加载鞭炮店铺
    self:loadFireCracker(index, ccp(287.6, 378), 100, true)
    -- 加载气球店铺
    self:loadBalloon(index, ccp(587.6, 378), 100, true)
    local pos = {ccp(920, 350), ccp(700, -70), ccp(700, -70), ccp(800, -70), ccp(900, -70)}
    local scaleTab = {50, 50, 600, 600, 600}
    -- 加载竹子
    for i = 1, 2 do 
        self:loadBamboo(index, pos[i], scaleTab[i])
    end
    -- 加载场景雪
    self:loadFloorSnow(index, 2)
    -- 加载前景雪障碍2
    self:loadSnowProspect2(index)
    -- 加载花店老板
    self:loadCat(index, ccp(700, 275))
end

-- 地图7
function M:map7(index)
    -- 加载非商店的上方景
    self:loadAbove(index)
    -- 加载场景雪
    self:loadFloorSnow(index, 3)
    -- 加载前景雪障碍3
    self:loadSnowProspect3(index)
end

-- 地图8
function M:map8(index)
    if not self._canOnceEnter then 
        self._canOnceEnter = true
        -- 预加载烟花
        local countTbs = {{ 6, 9,}, { 12, 15 }, { 12, 16 }, { 6, 7 }, { 4, 13 }}
        for i = 1, 3 do
            if i >= 2 then i = i + 2 end
            Tools:addTextureAsync("evefireworkcut/act/normal/" .. i .. "/" .. i .. "_", countTbs[i][1], countTbs[i][2])
        end
    end
    -- 加载春联店铺
    self:loadCouplet(index, ccp(600, 360), true)
    -- -- 加载鞭炮店铺
    self:loadFireCracker(index, ccp(940, 370), nil, true)
    -- -- 加载灯
    self:loadLight(index)
    -- -- 加载礼花
    self:loadFireworks(index)
    -- -- 春联店老板
    self:loadPenguin(index)
    -- -- 加载三课竹子
    for i = 2, 2 do 
        self:loadBamboo(index, ccp(150 + 100 * (i - 1), -70))
    end
    -- -- 加载气球店铺
    self:loadBalloon(index, ccp(550, -30), 600, true)
    -- -- 加载场景雪4
    self:loadFloorSnow(index, 4)
    -- -- 加载前景雪障碍4
    self:loadSnowProspect4(index)
end

------------ 三级地图 ----------------
-- 地图9
function M:map9(index)
    -- 加载梅花树
    self:loadPlumTree(index, ccp(280, 370))
    -- 加载花店铺
    self:loadFlower(index, ccp(680, 370))
    -- 加载糖葫芦
    self:loadGourd(index, ccp(950, 360), false)
    -- 加载梅花树
    self:loadPlumTree(index, ccp(350, 0), 600)
    -- 加载水池
    self:loadSmallPool(index)
end

-- 地图10
function M:map10(index)
    -- 加载气球店铺
    self:loadBalloon(index, ccp(550, 380), 100)
    -- 加载梅花树
    self:loadPlumTree(index, ccp(200, 370))
    -- 加载杂货铺
    self:loadGrocery(index, ccp(940, 370))
    -- 加载水池
    self:loadLongPool(index)
end

-- 地图11
function M:map11(index)
    -- 加载鱼缸
    self:loadTank(index)
    -- 加载气球店铺
    self:loadBalloon(index, ccp(250, -50), 600)
    -- 加载梅花树
    self:loadPlumTree(index, ccp(180, 380))
    -- 加载梅花树
    self:loadPlumTree(index, ccp(900, 0), 599)
    -- 加载梅花树
    self:loadPlumTree(index, ccp(570, 0), 599)
end

-- 地图12
function M:map12(index)
    -- 加载桥
    self:loadBridge(index)
    -- 加载鞭炮店铺
    self:loadFireCracker(index, ccp(230, 380), 100, false)
    -- 加载气球店铺
    self:loadBalloon(index, ccp(520, 400), 100, false)
    -- 加载花店铺
    self:loadFlower(index, ccp(830, 390))
    -- 加载花店老板
    self:loadCat(index, ccp(700, 300))
    -- 加载灯
    self:loadLight(index, ccp(0, 410))
    -- 加载灯
    self:loadLight(index, ccp(1005, 410))
end

-- 移除地图
function M:removeMap(index)
    R.removeUnusedFrames()
    R.removeUnusedTextures()
    if self["mapTile"..index] then
        -- 便利刚体表进行移除
        for i, v in ipairs(self["dragonTab"..index]) do
            if not tolua.isnull(v) then 
                self._layer._world:DestroyBody(v) 
                v = nil
            end
        end
        for i, v in ipairs(self["objectTab"..index]) do
            if not tolua.isnull(v) then
                T.removeOrder(self._objectTab, v)
                v:stopAllActions()
                v:remove()
            end
        end
        if not tolua.isnull(self["mapTile"..index]) then 
            self["mapTile"..index]:stopAllActions()
            self["mapTile"..index]:remove()
            self["mapTile"..index] = nil
        end
    end
end

-- 加载通用景物
function M:loadGeneral(index, level)
    -- 创建表来存刚体
    self["dragonTab"..index] = {}
    self["objectTab"..index] = {}
    self["mapTile"..index] = U.loadNode({}):to(self):bindTouch():p(0,0)
    -- 加载天气
    self:loadPlum(index, level)
    -- 加载地板
    local floor = D.img("nylantern/map/floor.png"):to(self, 5):p(V.w_2 + 1024 * BG_SCALE * (index - 1), 250):scale(BG_SCALE)--:bindTouchLocate()
    table.insert(self["objectTab"..index], floor)
    -- table.insert(self._objectTab, floor)
end

-- 下梅花
function M:loadPlum(index, level)
    local weather = U.loadNode({}):to(self._layer, 200):p(0 + 1024 * BG_SCALE * (index - 1), 0):scale(BG_SCALE)
    table.insert(self["objectTab"..index], weather)
    table.insert(self._objectTab, weather)
    local plumTab = {"common/plum/1.png", "common/plum/2.png", "common/plum/3.png", "common/plum/4.png"}
    if level == 2 then 
        weather._name = "snowing"
        Tools:loadSnows(weather, 999, nil, 8, nil, nil, nil, true)
    elseif level == 3 then 
        weather._name = "pluming"
        local config = {scaleSize = cc.p(5, 8)}
        Tools:loadSnows(weather, 999, nil, 8, nil, config, plumTab, true)
    end
end

---------------------------------------------------
-----------------------店铺------------------------
---------------------------------------------------

-- 加载灯笼
function M:loadLantern(node, type, posTab)
    -- node:getParent()._name = "dragon"
    type = type or 1
    posTab = posTab or {ccp(20, -25), ccp(195, -25)}
    local nameTab = {
        {"bone/dl22", "bone/dl44"},
        {"dl22_bones1", "dl44_bones"},
        {"dl22_pd_1", "dl44_pd_1"}
    }
    for i = 1, 2 do 
        local time = N.random(60, 100)/100
        local dragon = DragonBone.addFileAndPlay(nameTab[1][type], nameTab[2][type], nameTab[3][type], time):to(node, -1):p(posTab[i]):scale(0.4)--:bindTouchLocate()
    end
end

-- 加载杂货铺
function M:loadGrocery(index, pos, isSnow)
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(557.5 + 1024 * BG_SCALE * (index - 1), 380)
    end
    local part1 = D.img("nylantern/map/store/1.png"):to(self, 100):p(pos):anchor(ccp(1.9, 0.7))--:bindTouchLocate()
    table.insert(self["objectTab"..index], part1)
    -- table.insert(self._objectTab, part1)
    local part4 = D.img("nylantern/map/store/1_3.png"):to(part1, 15):p(292.9, 170.5)--:bindTouchLocate()
    local part2 = D.img("nylantern/map/store/1_1_1.png"):to(part1, 10):p(156.9, 73.2)--:bindTouchLocate()
    local part2_1 = D.img("nylantern/map/store/1_1_2.png"):to(part2, 10):anchor(ccp(0.5, 1)):p(27.8, 165.1)--:bindTouchLocate()
    commonAct:swingAction(part2_1)
    local part3 = D.img("nylantern/map/store/1_2.png"):to(part1, 10):p(315.8, 53.1)--:bindTouchLocate()
    -- 加载光
    local light = D.img("nylantern/map/light/1.png"):to(part1, -1):p(191.7, 10):scale(0.7)--:bindTouchLocate()
    if isSnow then 
        local snow = D.img("nylantern/map/second/snow/shop/1.png"):to(part1, 10):p(217.0, 108.1)--:bindTouchLocate()
    end
    -- 加载灯笼
    self:loadLantern(part4)
    local body = self._layer:createBody(part1, cc.size(200, 90), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载鞭炮店铺
function M:loadFireCracker(index, pos, tier, isSnow)
    tier = tier or 100
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(904.6 + 1024 * BG_SCALE * (index - 1), 378.6)
    end
    local part1 = D.img("nylantern/map/store/2.png"):to(self, tier):p(pos):anchor(ccp(0.5, 0.5))--:bindTouchLocate()
    table.insert(self["objectTab"..index], part1)
    -- table.insert(self._objectTab, part1)
    local flag = D.img("nylantern/map/store/2_1_1.png"):to(part1):p(246.4, 147.5):anchor(ccp(0.5, 1))--:bindTouchLocate()
    commonAct:swingAction(flag)
    local flag1 = D.img("nylantern/map/store/2_1_2.png"):to(part1):p(240.2, 155.7):anchor(ccp(0.5, 1))--:bindTouchLocate()
    local part2 = D.img("nylantern/map/store/2_1.png"):to(part1, 10):p(101.2, 191.6)--:bindTouchLocate()
    -- 加载光
    local light = D.img("nylantern/map/light/2.png"):to(part1, -1):p(128.8, 10.8):scale(0.7)--:bindTouchLocate()
    if isSnow then 
        local snow = D.img("nylantern/map/second/snow/shop/4.png"):to(part1, 30):p(98.9, 134.7):scale(1)--:bindTouchLocate()
    end
    -- 加载灯笼
    self:loadLantern(part2)
    local body = self._layer:createBody(part1, cc.size(135, 80), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载底部的店铺障碍物
function M:loadBaseStore(index)
    local part1 = D.img("nylantern/map/store/2_2.png"):to(self, 500):p(395 + 1024 * BG_SCALE * (index - 1), 35):anchor(ccp(2.4, 0.45))--:bindTouchLocate()
    table.insert(self["objectTab"..index], part1)
    -- table.insert(self._objectTab, part1)
    local part2 = D.img("nylantern/map/store/2.png"):to(part1, 10):p(244.2, -32.6)--:bindTouchLocate()
    local part3 = D.img("nylantern/map/store/2_1.png"):to(part2, 10):p(106.2, 190)--:bindTouchLocate()
    -- 加载灯笼
    self:loadLantern(part3)
    local part4 = D.img("nylantern/map/store/4.png"):to(part1, 5):p(473.6, -59.1)--:bindTouchLocate()
    local part5 = D.img("nylantern/map/store/4_1.png"):to(part4, 5):p(109.1, 216.5)--:bindTouchLocate()
    local body = self._layer:createBody(part1, cc.size(260, 20), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载春联店铺
function M:loadCouplet(index, pos, isSnow)
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(270 + 1024 * BG_SCALE * (index - 1), 357)
    end
    local part1 = D.img("nylantern/map/store/3.png"):to(self, 100):p(pos):anchor(ccp(0.47, 0.4))--:bindTouchLocate()
    table.insert(self["objectTab"..index], part1)
    table.insert(self._objectTab, part1)
    local part2 = D.img("nylantern/map/store/3_1.png"):to(part1, 10):p(217.5, 198.6)--:bindTouchLocate()
    -- 加载光
    local light = D.img("nylantern/map/light/3.png"):to(part1, -1):p(131.9, 11):scale(0.7)--:bindTouchLocate()
    if isSnow then 
        local snow = D.img("nylantern/map/second/snow/shop/6.png"):to(part1, 30):p(172.8, 122.4):scale(1)--:bindTouchLocate()
    end
    -- 加载灯笼
    self:loadLantern(part2, 2, {ccp(14, -45), ccp(185, -45)})
    -- 加载一个单独的灯笼
    -- local dragon = DragonBone.addFileAndPlay("bone/dl22", "dl22_bones1", "dl22_pd_1", 0.8):to(part1, -1):p(ccp(354.1, 122.2)):scale(0.4)--:bindTouchLocate()
    part1._name = "dragon"
    local body = self._layer:createBody(part1, cc.size(170, 70), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载气球店铺
function M:loadBalloon(index, pos, tier, isSnow)
    tier = tier or 100
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(790 + 1024 * BG_SCALE * (index - 1), 354.3)
    end
    local part1 = D.img("nylantern/map/store/4.png"):to(self, tier):p(pos):anchor(ccp(0.5, 0.5))--:bindTouchLocate()
    table.insert(self["objectTab"..index], part1)
    local part2 = D.img("nylantern/map/store/4_1.png"):to(part1, 10):p(110.0, 195)--:bindTouchLocate()
    -- 加载光
    local light = D.img("nylantern/map/light/4.png"):to(part1, -1):p(131.9, 11):scale(0.4)--:bindTouchLocate()
    if isSnow then 
        local snow = D.img("nylantern/map/second/snow/shop/5.png"):to(part1, 30):p(162.3, 129.8):scale(1)--:bindTouchLocate()
    end
    -- 加载灯笼
    self:loadLantern(part2, 1, {ccp(13, -20), ccp(195, -20)})
    local part3 = D.img("nylantern/map/store/4_3.png"):to(part1, 10):p(295, 101.3):anchor(ccp(0.5, 0))--:bindTouchLocate()
    Tools:breathing(part3)
    -- 加载4个气球
    local pos = {ccp(107.0, 166.6), ccp(51.6, 166.6), ccp(52.4, 104.9), ccp(106.6, 104.9)}
    for i = 1, 4 do 
        local part4 = D.img("nylantern/map/store/4_2_"..i..".png"):to(part1, 20):p(pos[i])--:bindTouchLocate()
        commonAct:balloonAct(part4)
    end
    local body = self._layer:createBody(part1, cc.size(155, 80), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载糖葫芦店
function M:loadGourd(index, pos, tier, isSnow)
    tier = tier or 100
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(520 + 1024 * BG_SCALE * (index - 1), 360)
    end
    local part1 = D.img("nylantern/map/store/5.png"):to(self, tier):p(pos):anchor(ccp(0.5, 0.6))--:bindTouchLocate()
    table.insert(self["objectTab"..index], part1)
    -- table.insert(self._objectTab, part1)
    -- 加载光
    local light = D.img("nylantern/map/light/2.png"):to(part1, -1):p(106.4, 12.0):scale(0.7)--:bindTouchLocate()
    if isSnow then 
        local snow = D.img("nylantern/map/second/snow/shop/2.png"):to(part1, 30):p(102.3, 130.4):scale(1)--:bindTouchLocate()
    end
    local part2 = D.img("nylantern/map/store/5_1.png"):to(part1, 10):p(101, 200)--:bindTouchLocate()
    -- 加载灯笼
    self:loadLantern(part2, 2, {ccp(18, -43), ccp(199, -43)})
    local body = self._layer:createBody(part1, cc.size(105, 90), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载花店铺
function M:loadFlower(index, pos)
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(850 + 1024 * BG_SCALE * (index - 1), 375.9)
    end
    local part1 = D.img("nylantern/map/store/6.png"):to(self, 100):p(pos):anchor(ccp(0.45, 0.65))--:bindTouchLocate()
    table.insert(self["objectTab"..index], part1)
    -- table.insert(self._objectTab, part1)
    local part2 = D.img("nylantern/map/store/6_1.png"):to(part1, 10):p(101, 200)--:bindTouchLocate()
    -- 加载光
    local light = D.img("nylantern/map/light/2.png"):to(part1, -1):p(106.4, 12.0):scale(0.7)--:bindTouchLocate()
    -- 加载灯笼
    self:loadLantern(part2, 2, {ccp(18, -43), ccp(199, -43)})
    local body = self._layer:createBody(part1, cc.size(135, 100), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end


--------------------------------------------------
-----------------------店铺------------------------
---------------------------------------------------

---------------------------------------------------
---------------------路人和店主----------------------
---------------------------------------------------
-- 加载熊老板
function M:loadBear(index, pos)
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(473.2 + 1024 * BG_SCALE * (index - 1), 260)
    end
    local bear = import("app.nylantern.node.AniBear").new({
        file         = "bone/gcj_tzx",
        armatureName = "gxn_tzx",
        index        = index,
        layer        = self,
    }):to(self, 105):p(pos):scale(0.28):anchor(ccp(0.5, 0.25)):hide()--:bindTouchLocate()
    bear._name = "dragon"
    table.insert(self["objectTab"..index], bear)
    table.insert(self._objectTab, bear)
    bear._body = self._layer:createBody(bear, cc.size(35, 8), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], bear._body)
end


-- 加载企鹅老板
function M:loadPenguin(index, pos)
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(420 + 1024 * BG_SCALE * (index - 1), 275)
    end
    local penguin = import("app.nylantern.node.AniPenguin").new({
        file         = "bone/gcj_tzf",
        armatureName = "gxn_tzf",
        index        = index,
        layer        = self,
    }):to(self, 105):p(pos):scale(0.28):anchor(ccp(0.5, 0.25))
    penguin._name = "dragon"
    table.insert(self["objectTab"..index], penguin)
    table.insert(self._objectTab, penguin)
    penguin._body = self._layer:createBody(penguin, cc.size(35, 8), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], penguin._body)
end

-- 加载花店老板
function M:loadCat(index, pos)
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(830 + 1024 * BG_SCALE * (index - 1), 275)
    end
    local cat = import("app.nylantern.node.AniCat").new({
        file         = "bone/gcj_tzm",
        armatureName = "gcj_tzm",
        index        = index,
        layer        = self,
    }):to(self, 105):p(pos):scale(0.28):anchor(ccp(0.5, 0.25))
    cat._name = "dragon"
    table.insert(self["objectTab"..index], cat)
    table.insert(self._objectTab, cat)
    cat._body = self._layer:createBody(cat, cc.size(35, 8), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], cat._body)
end

-- 加载皮皮
function M:loadPiPi(index, pos, tier)
    tier = tier or 341
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(615 + 1024 * BG_SCALE * (index - 1), 195)
    end
    local pipi = import("app.nylantern.node.AniPiPi").new({
        file         = "bone/cj_pp",
        index        = index,
        armatureName = "cj_pp",
        layer        = self,
    }):to(self, tier):p(pos):scale(0.5):anchor(ccp(0.5, 0.2))
    pipi._name = "dragon"
    table.insert(self["objectTab"..index], pipi)
    table.insert(self._objectTab, pipi)
    table.insert(self._passerTab, pipi)
    pipi._body = self._layer:createBody(pipi, cc.size(25, 5), nil, b2_kinematicBody)
    table.insert(self["dragonTab"..index], pipi._body)
end

-- 加载闹闹
function M:loadNaoNao(index, pos, tier)
    tier = tier or 341
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(615 + 1024 * BG_SCALE * (index - 1), 195)
    end
    local naonao = import("app.nylantern.node.AniNaoNao").new({
        file         = "bone/cj_nn",
        index        = index,
        armatureName = "cj_nn",
        layer        = self,
    }):to(self, tier):p(pos):scale(0.7):anchor(ccp(0.5, 0.2))
    naonao._name = "dragon"
    table.insert(self["objectTab"..index], naonao)
    table.insert(self._objectTab, naonao)
    table.insert(self._passerTab, naonao)
    naonao._body = self._layer:createBody(naonao, cc.size(25, 5), nil, b2_kinematicBody)
    table.insert(self["dragonTab"..index], naonao._body)
end

-- 加载兔一一
function M:loadYiYi(index, pos, tier)
    tier = tier or 341
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(425 + 1024 * BG_SCALE * (index - 1), 190)
    end
    local yiyi = import("app.nylantern.node.AniYiYi").new({
        file         = "bone/cj_tyy",
        index        = index,
        armatureName = "cj_tyy",
        layer        = self,
    }):to(self, tier):p(pos):scale(0.5):anchor(ccp(0.5, 0.2))
    yiyi._name = "dragon"
    table.insert(self["objectTab"..index], yiyi)
    table.insert(self._objectTab, yiyi)
    table.insert(self._passerTab, yiyi)
    yiyi._body = self._layer:createBody(yiyi, cc.size(30, 5), nil, b2_kinematicBody)
    table.insert(self["dragonTab"..index], yiyi._body)
end

-- 加小土狗
function M:loadDog(index, pos, i, tier)
    tier = tier or 300
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(425 + 1024 * BG_SCALE * (index - 1), 190)
    end
    local dog        = import("app.nylantern.node.AniDog").new({
        file         = "bone/cj_wc",
        armatureName = "cj_wc", 
        layer        = self,
        index        = i,
    }):to(self, tier):p(pos):flipX(false):scale(0.65)
    table.insert(self._dogTab, dog)
    table.insert(self["objectTab"..index], dog)
    dog._body = self._layer:createBody(dog, cc.size(15, 5), nil, b2_kinematicBody)
    -- table.insert(self["dragonTab"..index], dog._body)
end

-- 加载美美
function M:loadMeiMei(index, pos, tier)
    tier = tier or 368
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(72.4 + 1024 * BG_SCALE * (index - 1), 175.5)
    end
    local meimei = import("app.nylantern.node.AniMeiMei").new({
        file         = "bone/cj_mmls",
        armatureName = "cj_mmls",
        index        = index,
        layer        = self,
    }):to(self, tier):p(pos):scale(0.6):anchor(ccp(0.55, 0.15)):flipX(true)
    meimei._name = "dragon"
    table.insert(self["objectTab"..index], meimei)
    table.insert(self._objectTab, meimei)
    table.insert(self._passerTab, meimei)
    meimei._body = self._layer:createBody(meimei, cc.size(30, 5), nil, b2_kinematicBody)
    table.insert(self["dragonTab"..index], meimei._body)
end

-- 加载壮壮
function M:loadZz(index, pos, tier)
    tier = tier or 360
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(618.8 + 1024 * BG_SCALE * (index - 1), 180)
    end
    local zz = import("app.nylantern.node.AniZz").new({
        file         = "bone/cj_zz",
        index        = index,
        armatureName = "cj_zz",
        layer        = self,
    }):to(self, tier):p(pos):scale(0.6):anchor(ccp(0.5, 0.2))
    zz._name = "dragon"
    table.insert(self["objectTab"..index], zz)
    table.insert(self._objectTab, zz)
    table.insert(self._passerTab, zz)
    zz._body = self._layer:createBody(zz, cc.size(30, 5), nil, b2_kinematicBody)
    table.insert(self["dragonTab"..index], zz._body)
end

---------------------------------------------------
---------------------路人和店主----------------------
---------------------------------------------------


---------------------------------------------------
----------------树和风车等装饰物----------------------
---------------------------------------------------
-- 加载灯笼树
function M:loadTree(index, pos, tier)
    tier = tier or 100
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(634.9 + 1024 * BG_SCALE * (index - 1), 400)
    end
    local tree = D.img("nylantern/map/first/tree/1.png"):to(self, tier):p(pos):anchor(ccp(0.75, 0.2))--:bindTouchLocate()
    tree._name = "tree"
    tree._lanternTab = {}
    local lawn = D.img("nylantern/map/first/2.png"):to(tree, -1):p(150, 14.1)--:bindTouchLocate()
    table.insert(self["objectTab"..index], tree)
    table.insert(self._objectTab, tree)
    local posTab = {ccp(9.0, 142.5), ccp(61.2, 142.5), ccp(49.6, 203.3), ccp(85.0, 256.2),
                    ccp(129.2, 194.7), ccp(165.6, 191.6), ccp(160.9, 135.3), ccp(121.8, 107.1)}
    -- 加载树上的小灯笼
    for i = 1, 8 do 
        local lantern = D.img("nylantern/map/first/tree/3.png"):to(tree, 20):p(posTab[i]):anchor(ccp(0.5, 0.9))--:bindTouchLocate()
        table.insert(tree._lanternTab, lantern)
        commonAct:swingAction(lantern, 4, 8)
    end
    local body = self._layer:createBody(tree, cc.size(160, 90), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载风车篱笆
function M:loadWindmill(index)
    local fence = D.img("nylantern/map/first/1.png"):to(self, 500):p(471.2 + 1024 * BG_SCALE * (index - 1), 23.5):anchor(ccp(0.5, 0.5))--:bindTouchLocate()
    fence._name = "fance"
    fence._fenceTab = {}
    table.insert(self["objectTab"..index], fence)
    table.insert(self._objectTab, fence)
    for i = 1, 9 do
        local num = i % 2 + 1
        local under = D.img("nylantern/map/first/windmill/1.png"):to(fence):p(60 + 95 * (i-1), 63.0)--:bindTouchLocate()
        local fences = D.img("nylantern/map/first/windmill/1_"..num..".png"):to(under):p(17.1, 59.3):anchor(ccp(0.5, 0.5))--:bindTouchLocate()
        table.insert(fence._fenceTab, fences)
    end
    local body = self._layer:createBody(fence, cc.size(440, 60), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载梅花树
function M:loadPlumTree(index, pos, tier)
    tier = tier or 100
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(80 + 1024 * BG_SCALE * (index - 1), 345)
    end
    local lawn = D.img("nylantern/map/first/3.png"):to(self, tier):p(pos):anchor(ccp(0.5, 0.65))--:bindTouchLocate()
    lawn._name = "plum"
    table.insert(self["objectTab"..index], lawn)
    table.insert(self._objectTab, lawn)
    for i = 1, 2 do 
        local plum = D.img("nylantern/map/first/plum.png"):to(lawn):p(112.9 + 115 * (i-1), 045 + 5 * (i-1)):anchor(ccp(0.5, 0))--:bindTouchLocate()
        Tools:breathing(plum)
    end
    local body = self._layer:createBody(lawn, cc.size(160, 70), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载竹子
function M:loadBamboo(index, pos, tier)
    tier = tier or 600
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(432.5 + 1024 * BG_SCALE * (index - 1), 65)
    end
    local part1 = D.img("nylantern/map/second/bamboo/1.png"):to(self, tier):p(pos):anchor(ccp(0.45, 1))--:bindTouchLocate()
    table.insert(self["objectTab"..index], part1)
    table.insert(self._objectTab, part1)
    local part2 = D.img("nylantern/map/second/bamboo/2_1.png"):to(part1, -1):p(-9.3, 110)--:bindTouchLocate()
    local part2_1 = D.img("nylantern/map/second/bamboo/2_2.png"):to(part2):p(50.4, 162.7)--:bindTouchLocate()
    local part3 = D.img("nylantern/map/second/bamboo/2_3.png"):to(part1, -5):p(20.8, 120)--:bindTouchLocate()
    local part4 = D.img("nylantern/map/second/bamboo/2_4.png"):to(part1, -5):p(40.3, 120)--:bindTouchLocate()
    local part4_1 = D.img("nylantern/map/second/bamboo/2_5.png"):to(part4):p(55.7, 186.2)--:bindTouchLocate()
    local part4_2 = D.img("nylantern/map/second/bamboo/2_6.png"):to(part4):p(34.6, 208.1)--:bindTouchLocate()
    local part5 = D.img("nylantern/map/second/bamboo/2_7.png"):to(part1, -6):p(81.2, 110)--:bindTouchLocate()
    local part5_1 = D.img("nylantern/map/second/bamboo/2_8.png"):to(part5):p(49.8, 160.1)--:bindTouchLocate()
    local partTab = {part2, part3, part4, part5}
    for i = 1, 4 do
        commonAct:breathing(partTab[i])
    end
    local body = self._layer:createBody(part1, cc.size(50, 55), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载场景雪
function M:loadFloorSnow(index, type)
    if type == 1 then 
        local pos = {ccp(278.4 + 1024 * BG_SCALE * (index - 1), 170), ccp(880.8 + 1024 * BG_SCALE * (index - 1), 251.6)}
        for i = 1, 2 do
            local part1 = D.img("nylantern/map/second/snow/floor/"..i..".png"):to(self, 10):p(pos[i]):anchor(ccp(0.5, 0.65))--:bindTouchLocate()
            table.insert(self["objectTab"..index], part1)
            -- table.insert(self._objectTab, part1)
        end
    elseif type == 2 then
        local pos = {ccp(125.6 + 1024 * BG_SCALE * (index - 1), 298.5), ccp(705.8 + 1024 * BG_SCALE * (index - 1), 120.9),
                    ccp(924.3 + 1024 * BG_SCALE * (index - 1), 320.0)}
        for i = 1, 3 do
            local num = i + 2
            local part1 = D.img("nylantern/map/second/snow/floor/"..num..".png"):to(self, 10):p(pos[i]):anchor(ccp(0.5, 0.5))--:bindTouchLocate()
            table.insert(self["objectTab"..index], part1)
            -- table.insert(self._objectTab, part1)
        end
        -- 加载一滩水
        local water = D.img("nylantern/map/second/prospect/14.png"):to(self, 11):p(ccp(50 + 1024 * BG_SCALE * (index - 1), 0)):scale(0.5)--:bindTouchLocate()
        table.insert(self["objectTab"..index], water)
        -- table.insert(self._objectTab, water)
    elseif type == 3 then
        local pos = {ccp(455.9 + 1024 * BG_SCALE * (index - 1), 383.5), ccp(491.5 + 1024 * BG_SCALE * (index - 1), 253.7),
                    ccp(853.6 + 1024 * BG_SCALE * (index - 1), 183.1), ccp(940.9 + 1024 * BG_SCALE * (index - 1), 365.4)}
        for i = 1, 4 do 
            local num = i + 5
            local under = D.img("nylantern/map/second/snow/floor/"..num..".png"):to(self, 10):p(pos[i]):anchor(ccp(0.5, 0.5))--:bindTouchLocate()
            table.insert(self["objectTab"..index], under)
            -- table.insert(self._objectTab, under)
        end
    elseif type == 4 then
        local pos = {ccp(203.1 + 1024 * BG_SCALE * (index - 1), 307.3), ccp(725.5 + 1024 * BG_SCALE * (index - 1), 268.1)}
        for i = 1, 2 do
            local num = i + 9
            local part1 = D.img("nylantern/map/second/snow/floor/"..num..".png"):to(self, 10):p(pos[i]):anchor(ccp(0.5, 0.65))--:bindTouchLocate()
            table.insert(self["objectTab"..index], part1)
            -- table.insert(self._objectTab, part1)
        end
    end
end

-- 加载前景的雪障碍物1
function M:loadSnowProspect1(index)
    local snow = D.img("nylantern/map/second/snow/front/1.png"):to(self, 10):p(ccp(603.6 + 1024 * BG_SCALE * (index - 1), 35)):anchor(ccp(0.38, 0.65))--:bindTouchLocate()
    snow._name = "snow"
    snow._snowManTab = {}
    table.insert(self["objectTab"..index], snow)
    table.insert(self._objectTab, snow)
    -- 加载三个雪人
    local ice = D.img("nylantern/map/second/prospect/1.png"):to(self, 499):p(650 + 1024 * BG_SCALE * (index - 1), 30):anchor(ccp(4, 0.65))--:bindTouchLocate()
    local particle = Tools:newParticle("particle/drg_snow.plist", 280, 20):to(ice, 999)
    Tools:insertParticleTb(self, particle)
    table.insert(self._particleTab, particle)
    -- 固定粒子位置
    particle:setPositionType(kCCPositionTypeRelative)
    table.insert(self["objectTab"..index], ice)
    table.insert(self._objectTab, ice)
    local pos = {ccp(154.9, 10), ccp(253.6, 10), ccp(353.0, 10), ccp(487.0, 10)}
    local scaleTab = {499, 499, 499, 480}
    for i = 1, 4 do 
        local index = i + 1
        local snowman = D.img("nylantern/map/second/prospect/"..index..".png"):to(ice, scaleTab[i]):anchor(ccp(0.5, 0)):p(pos[i]):scale(0.8)--:bindTouchLocate()
        if i <= 3 then table.insert(snow._snowManTab, snowman) end
    end
    local body = self._layer:createBody(ice, cc.size(310, 15), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载前景的雪障碍物2
function M:loadSnowProspect2(index)
    local snow = D.img("nylantern/map/second/snow/front/2.png"):to(self, 10):p(ccp(275 + 1024 * BG_SCALE * (index - 1), 36)):anchor(ccp(0.38, 0.65))--:bindTouchLocate()
    snow._name = "snow"
    snow._snowManTab = {}
    table.insert(self["objectTab"..index], snow)
    table.insert(self._objectTab, snow)
    local shadow = D.img("nylantern/map/second/prospect/10.png"):to(snow, 10):p(425.7, 74.3):scale(0.8)--:bindTouchLocate()
    -- 加载雪球
    local snowball = D.img("nylantern/map/second/prospect/11.png"):to(self, 600):p(420 + 1024 * BG_SCALE * (index - 1), 40):anchor(ccp(1.2, 0.4)):scale(0.7)--:bindTouchLocate()
    table.insert(self["objectTab"..index], snowball)
    table.insert(self._objectTab, snowball)
    local particle = Tools:newParticle("particle/drg_snow.plist", 80, 25):to(snowball, 999)
    Tools:insertParticleTb(self, particle)
    table.insert(self._particleTab, particle)
    -- 固定粒子位置
    particle:setPositionType(kCCPositionTypeRelative)
    local snowman = D.img("nylantern/map/second/prospect/12.png"):to(snowball):p(154.9, 0):anchor(ccp(0.5, 0))--:bindTouchLocate()
    table.insert(snow._snowManTab, snowman)
    local body = self._layer:createBody(snowball, cc.size(70, 20), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
    local pos = {ccp(-303.8, 45.5), ccp(-218.8, 30.2), ccp(-134.0, 43.1), ccp(-56.8, 20.1)}
    -- 加载4个气球
    for i = 1, 4 do 
        local num = i + 5
        local balloon = D.img("nylantern/map/second/prospect/"..num..".png"):to(snowball):p(pos[i])--:bindTouchLocate()
        commonAct:balloonAct(balloon)
    end
end

-- 加载前景的雪障碍物3
function M:loadSnowProspect3(index)
    local pos = {ccp(375.6 + 1024 * BG_SCALE * (index - 1), 41.6), ccp(1025.9 + 1024 * BG_SCALE * (index - 1), 50)}
    for i = 1, 2 do 
        local num = i + 2
        local snow = D.img("nylantern/map/second/snow/front/"..num..".png"):to(self, 10):p(pos[i]):anchor(ccp(0.38, 0.65))--:bindTouchLocate()
        table.insert(self["objectTab"..index], snow)
        -- table.insert(self._objectTab, snow)
    end
    -- 加载雪堆
    local snow = D.img("nylantern/map/second/prospect/5.png"):to(self, 600):p(665 + 1024 * BG_SCALE * (index - 1), 48.1):anchor(ccp(0.7, 0.4)):scale(0.7)--:bindTouchLocate()
    local particle = Tools:newParticle("particle/drg_snow.plist", 20, 25):to(snow, 999)
    Tools:insertParticleTb(self, particle)
    table.insert(self._particleTab, particle)
    -- 固定粒子位置
    particle:setPositionType(kCCPositionTypeRelative)
    table.insert(self["objectTab"..index], snow)
    table.insert(self._objectTab, snow)
    snow._name = "snow"
    snow._snowManTab = {}
    local pos1 = {ccp(-12.8, 62.7), ccp(-237.6, 56.8), ccp(559.4, -47.9), ccp(870.7, 44.6)}
    for i = 1, 4 do
        local num = i + 11
        local things = D.img("nylantern/map/second/prospect/"..num..".png"):to(snow):p(pos1[i]):anchor(ccp(0.5, 0.48))--:bindTouchLocate()
        if i == 1 then table.insert(snow._snowManTab, things) end
    end
    local body = self._layer:createBody(snow, cc.size(450, 30), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载前景的雪障碍物4
function M:loadSnowProspect4(index)
    local snow = D.img("nylantern/map/second/snow/front/5.png"):to(self, 10):p(803.1 + 1024 * BG_SCALE * (index - 1), 35.8):anchor(ccp(0.38, 0.65))--:bindTouchLocate()
    table.insert(self["objectTab"..index], snow)
    -- table.insert(self._objectTab, snow)
    -- 加载木桩
    local deadman = D.img("nylantern/map/second/prospect/17.png"):to(self, 600):p(920 + 1024 * BG_SCALE * (index - 1), 33):anchor(ccp(0, 0.2)):scale(0.85)--:bindTouchLocate()
    local particle = Tools:newParticle("particle/drg_snow.plist", 20, 25):to(deadman, 999)
    Tools:insertParticleTb(self, particle)
    table.insert(self._particleTab, particle)
    -- 固定粒子位置
    particle:setPositionType(kCCPositionTypeRelative)
    table.insert(self["objectTab"..index], deadman)
    table.insert(self._objectTab, deadman)
    deadman._name = "snow"
    deadman._snowManTab = {}
    local snowman = D.img("nylantern/map/second/prospect/16.png"):to(deadman):anchor(ccp(0.5, 0)):p(-120, 0):scale(0.85)--:bindTouchLocate()
    table.insert(deadman._snowManTab, snowman)
    local body = self._layer:createBody(deadman, cc.size(130, 20), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载上方无店铺景
function M:loadAbove(index)
    local pos = {ccp(370, 370), ccp(470, 370), ccp(980, 370)}
    -- 加载三个竹子
    for i = 1, 2 do 
        self:loadBamboo(index, pos[i], 50)
    end
    local shoots = D.img("nylantern/map/second/desk/5.png"):to(self, 40):p(ccp(380.9 + 1024 * BG_SCALE * (index - 1), 377.3))--:bindTouchLocate()
    table.insert(self["objectTab"..index], shoots)
    -- table.insert(self._objectTab, shoots)
    -- 加载桌子
    local desk = D.img("nylantern/map/second/desk/1.png"):to(self, 80):anchor(ccp(0.1, 0.5)):p(ccp(560 + 1024 * BG_SCALE * (index - 1), 386.5))--:bindTouchLocate()
    desk._name = "fance"
    desk._fenceTab = {}
    table.insert(self["objectTab"..index], desk)
    table.insert(self._objectTab, desk)
    -- 加载灯光
    local pos1 = {ccp(61.9, 39.5), ccp(383.8, 39.5)}
    for i = 1, 2 do 
        local light = D.img("nylantern/map/second/desk/2.png"):to(desk, 80):p(pos1[i])--:bindTouchLocate()
    end
    -- 加载竹竿鞭炮
    local bamboo = D.img("nylantern/map/second/desk/4.png"):to(desk, 80):p(ccp(524.9, 62))--:bindTouchLocate()
    local gun    = D.img("nylantern/map/second/desk/3.png"):to(bamboo, 80):anchor(ccp(0.5, 1)):p(ccp(23.5, 110.5))--:bindTouchLocate()
    commonAct:swingAction(gun)
    -- 加载8 个风车
    for i = 1, 8 do 
        local num = i % 2 + 1
        local num1 = i 
        local num2 = 2
        if i > 2 then num1 = i - 2 num2 = 1 end
        local under = D.img("nylantern/map/first/windmill/1.png"):to(desk):p(-431.0 + 80 * (num1 - 1), 37.0 + 50 * (num2 - 1))--:bindTouchLocate()
        local fences = D.img("nylantern/map/first/windmill/1_"..num..".png"):to(under):p(17.1, 59.3):anchor(ccp(0.5, 0.5))--:bindTouchLocate()
        table.insert(desk._fenceTab, fences)
    end
    local body = self._layer:createBody(desk, cc.size(510, 110), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载灯
function M:loadLight(index, pos, tier)
    tier = tier or 100
    if pos then 
        pos = ccp(pos.x + 1024 * BG_SCALE * (index - 1), pos.y)
    else 
        pos = ccp(393.7 + 1024 * BG_SCALE * (index - 1), 449.0)
    end
    local light1 = D.img("nylantern/map/second/light/1.png"):to(self, tier):anchor(ccp(0.5, 0.35)):p(pos)--:bindTouchLocate() 
    light1._name = "dragon"
    table.insert(self["objectTab"..index], light1)
    table.insert(self._objectTab, light1)
    -- 加载5个小灯
    local pos = {ccp(36.2, 208.3), ccp(56.6, 200.4), ccp(77.9, 197.3), ccp(100.2, 201.0), ccp(119.8, 207.6)}
    for i = 1, 5 do 
        local lamplet = D.img("nylantern/map/second/light/2.png"):to(light1):p(pos[i]):anchor(ccp(0.5, 1))--:bindTouchLocate() 
        commonAct:swingAction(lamplet)
    end
    local body = self._layer:createBody(light1, cc.size(20, 110), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载礼花
function M:loadFireworks(index)
    local firework = D.img("nylantern/map/second/fireworks/1.png"):to(self, 90):p(ccp(100 + 1024 * BG_SCALE * (index - 1), 310)):anchor(ccp(3.8, 0.5))--:bindTouchLocate() 
    firework._name = "firework"
    table.insert(self["objectTab"..index], firework)
    table.insert(self._objectTab, firework)
    for i = 2, 6 do 
        local num = i
        local num1 = 1
        local num2 = i
        if i > 10 then num = i - 10 
        elseif i > 5 then num = i - 5 
        end
        if i > 6 then num1 = 2 num2 = i - 6 end
        firework._particleTab = {}
        local fireworks = D.img("nylantern/map/second/fireworks/"..num..".png"):to(firework, 20):p(78.0 + 55 * (num2 - 2), 32 - 65 * (num1 - 1))--:bindTouchLocate() 
        if i % 2 == 0 and i <= 6 then 
            local particle = Tools:newParticle("particle/drg_yanhua_green.plist", 20, 60):to(fireworks, 999)
            Tools:insertParticleTb(self, particle)
            table.insert(self._particleTab, particle)
            particle:setPositionType(kCCPositionTypeRelative)
        elseif i % 2 == 1 and i > 6 then 
            local particle = Tools:newParticle("particle/drg_yanhua_yellow.plist", 20, 60):to(fireworks, 999)
            Tools:insertParticleTb(self, particle)
            table.insert(self._particleTab, particle)
            particle:setPositionType(kCCPositionTypeRelative)
        end
    end
    local body = self._layer:createBody(firework, cc.size(160, 20), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载泡泡升起
function M:loadBubble(node, pos, tier)
    tier = tier or -5
    for i = 1, 6 do 
        local num = N.random(1, 2)
        local offsetY = N.random(-14, 14)
        local bubble = D.img("nylantern/map/thirdly/pool/flutter1.png"):to(node, tier):p(pos.x + 25 * (i - 1), pos.y + offsetY * (num - 1)):opacity(0)--:bindTouchLocate()
        local time = N.random(10, 20)/5
        local time1 = N.random(10, 50)/10
        local offset = N.random(30, 50)
        A.line({
            {"delay", time1},
            {"union",{
                {"fadein", 0.25},
                {"sinby", time, cc.p(0, offset), 5 - 10 * (num-1), 1},
            }},
            {"fn", function ()
                bubble:display("nylantern/map/thirdly/pool/flutter2.png")
            end},
            {"fadeout", 0.5},
            {"remove"}
        }):at(bubble)
    end
    node._bubbleAct = A.line({
        {"delay", 5},
        {"fn", function ()
            if not tolua.isnull(node:getParent()) then 
                self:loadBubble(node, pos, tier)
            end
        end}
    }):at(self)
end

-- 加载水池
function M:loadSmallPool(index)
    local part1 = D.img("nylantern/map/thirdly/pool/1.png"):to(self, 599):p(ccp(753.9 + 1024 * BG_SCALE * (index - 1), -10)):anchor(ccp(0.5, 0.5))--:bindTouchLocate() 
    part1._name = "dragon"
    table.insert(self["objectTab"..index], part1)
    table.insert(self._objectTab, part1)
    -- 加载泡泡升起
    self:loadBubble(part1, ccp(120, 90))
    local particle = P.newParticle("particle/drg_water.plist"):to(part1, 999):p(250, 100):scale(1)
    Tools:insertParticleTb(self, particle)
    table.insert(self._particleTab, particle)
    -- 固定粒子位置
    particle:setPositionType(kCCPositionTypeRelative)
    local water  = D.img("nylantern/map/thirdly/pool/1_2.png"):to(part1, -10):p(189.2, 54.0)--:bindTouchLocate()
    local water1 = D.img("nylantern/map/thirdly/pool/1_3.png"):to(part1, -10):p(192.3, 98.0)--:bindTouchLocate()
    local water2 = D.img("nylantern/map/thirdly/pool/1_up.png"):to(part1, -5):p(180.5, 63.5)--:bindTouchLocate()
    local part2  = D.img("nylantern/map/thirdly/pool/1_4.png"):to(part1, -10):p(195.1, 113.3)--:bindTouchLocate()
    local part3  = D.img("nylantern/map/thirdly/pool/1_5.png"):to(part1, -4):anchor(ccp(0.5, 0)):p(110.5, 68.2)--:bindTouchLocate()
    local part4  = D.img("nylantern/map/thirdly/pool/1_6.png"):to(part1, -4):anchor(ccp(0.5, 0)):p(280.0, 87.8)--:bindTouchLocate()
    Tools:breathing(part3)
    Tools:breathing(part4)
    local shadow = D.img("nylantern/map/thirdly/pool/1_shadow.png"):to(part1, -20):p(184.5, 38.7)--:bindTouchLocate()
    local pos = {ccp(97.1, 95.3), ccp(161.5, 87.7), ccp(241.8, 77.1), ccp(127.4, 71.6), ccp(209.0, 60.2)}
    -- 加载小鱼
    for i = 1, 2 do 
        local num = self:createRandom(1, 6, self._randomTab3)
        local dragon = DragonBone.addFileAndPlay(self._fishName[num][1], self._fishName[num][2], self._fishName[num][3], 1):to(water2, -1):p(pos[i])--:bindTouchLocate() 
        commonAct:moveAroundFish(dragon)
    end
    local body = self._layer:createBody(part1, cc.size(180, 60), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载长鱼池
function M:loadLongPool(index)
    local part1 = D.img("nylantern/map/thirdly/pool/2.png"):to(self, 600):p(ccp(508.6 + 1024 * BG_SCALE * (index - 1), 34.0)):anchor(ccp(0.5, 0.5))--:bindTouchLocate() 
    part1._name = "dragon"
    table.insert(self["objectTab"..index], part1)
    table.insert(self._objectTab, part1)
    -- 加载泡泡升起
    self:loadBubble(part1, ccp(120, 30), 1)
    self:loadBubble(part1, ccp(420, 30), 1)
    local particle = P.newParticle("particle/drg_water.plist"):to(part1, 999):p(450, 50):scale(1)
    Tools:insertParticleTb(self, particle)
    table.insert(self._particleTab, particle)
    -- 固定粒子位置
    particle:setPositionType(kCCPositionTypeRelative)
    local grass = D.img("nylantern/map/thirdly/grass.png"):to(part1):p(485.6, -100.7):anchor(ccp(0.5, 0.5))--:bindTouchLocate() 
    local part2 = D.img("nylantern/map/thirdly/pool/2_1.png"):to(part1, 10):p(447.3, 30.8):anchor(ccp(0.5, 0.5))--:bindTouchLocate() 
    local water = D.img("nylantern/map/thirdly/pool/2_2.png"):to(part1):p(449.7, 30.7):anchor(ccp(0.5, 0.5))--:bindTouchLocate() 
    local pos   = {ccp(131.3, 34.8), ccp(191.2, 28.2), ccp(575.0, 29.3), ccp(609.1, 41.9), 
                   ccp(630.4, 28.8), ccp(811.2, 37.5)}
    -- 加载荷叶
    for i = 1, 6 do 
        local num = i % 2 + 3
        local leaf = D.img("nylantern/map/thirdly/pool/2_"..num..".png"):to(part1, 15):p(pos[i]):anchor(ccp(0.5, 0.5))--:bindTouchLocate()
    end
    local pos1 = {ccp(57.5, 18.6), ccp(203.8, 26.3), ccp(250.6, 26.7), ccp(359.3, 19.3), 
                ccp(524.1, 6.1), ccp(439.9, 30.4), ccp(713.2, 17.1), ccp(822.8, 18.0)}
    -- 加载8只鱼
    for i = 1, 3 do 
        local num = self:createRandom(1, 6, self._randomTab3)
        local dragon = DragonBone.addFileAndPlay(self._fishName[num][1], self._fishName[num][2], self._fishName[num][3], 1):to(water, -1):p(pos1[i]):scale(0.8)--:bindTouchLocate() 
        commonAct:moveAroundFish(dragon, 60, 790, 3, 20)
    end
    local body = self._layer:createBody(part1, cc.size(500, 25), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载鱼缸
function M:loadTank(index)
    -- 加载小的
    local part1 = D.img("nylantern/map/thirdly/pool/3.png"):to(self, 100):p(ccp(475 + 1024 * BG_SCALE * (index - 1), 365)):anchor(ccp(0.5, 0.5))--:bindTouchLocate() 
    part1._name = "pool"
    table.insert(self["objectTab"..index], part1)
    table.insert(self._objectTab, part1)
    local wave  = D.img("nylantern/map/thirdly/pool/wave/wave/10001.png"):to(part1):p(156.6, 35.2)--:bindTouchLocate() 
    local water = D.img("nylantern/map/thirdly/pool/wave/water/10001.png"):to(part1):p(173.0, 47)--:bindTouchLocate() 
    A.cycle({
        {"imagerange", "nylantern/map/thirdly/pool/wave/wave/1000", 1, 9, 0.1},
    }):at(wave)
    A.cycle({
        {"imagerange", "nylantern/map/thirdly/pool/wave/water/1000", 1, 4, 0.1},
    }):at(water)
    local body = self._layer:createBody(part1, cc.size(130, 50), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
    -- 加载大浴缸
    self:loadBigTank(index)
end

-- 加载大浴缸
function M:loadBigTank(index)
    local bigTank = D.img("nylantern/map/thirdly/pool/4.png"):to(self, 100):p(ccp(890 + 1024 * BG_SCALE * (index - 1), 415.2)):anchor(ccp(0.5, 0.5))--:bindTouchLocate() 
    bigTank._name = "dragon"
    local particle = P.newParticle("particle/drg_water.plist"):to(bigTank, 999):p(300, 100):scale(1)
    Tools:insertParticleTb(self, particle)
    table.insert(self._particleTab, particle)
    -- 固定粒子位置
    particle:setPositionType(kCCPositionTypeRelative)
    -- 加载泡泡升起
    self:loadBubble(bigTank, ccp(120, 90), -1)
    self:loadBubble(bigTank, ccp(320, 80), -1)
    table.insert(self["objectTab"..index], bigTank)
    table.insert(self._objectTab, bigTank)
    local water = D.img("nylantern/map/thirdly/pool/4_water.png"):to(bigTank, -2):p(284.3, 85)--:bindTouchLocate() 
    Tools:shaderWave(water, 0.01, 3, 6, 0)
    local pos = {ccp(58.7, 209.0), ccp(515.7, 209.0)}
    for i = 1, 2 do 
        local bigTank1 = D.img("nylantern/map/thirdly/pool/4_2.png"):to(bigTank):p(pos[i])--:bindTouchLocate() 
        commonAct:breathing(bigTank1)
    end
    local bigTank2 = D.img("nylantern/map/thirdly/pool/4_3.png"):to(bigTank, -20):p(ccp(290.9, 158.8))--:bindTouchLocate() 
    -- 加载三个水柱
    for i = 1, 3 do 
        local water1 = D.img("nylantern/map/thirdly/pool/4_water1.png"):to(bigTank):p(ccp(193 + 95 * (i - 1), 158.8))--:bindTouchLocate() 
        A.cycle({
            {"imagerange", "nylantern/map/thirdly/pool/4_water", 1, 2, 0.1},
        }):at(water1)
    end
    -- 加载8只鱼
    local pos1 = {ccp(75.8, 35.0), ccp(95.4, 17.7), ccp(148.0, 47.8), ccp(195.5, 64.8), 
                ccp(224.6, 45.7), ccp(258, 33.5), ccp(303.3, 47.2)}
    for i = 1, 3 do 
        local num = self:createRandom(1, 6, self._randomTab3)
        local dragon = DragonBone.addFileAndPlay(self._fishName[num][1], self._fishName[num][2], self._fishName[num][3], 2):to(water, 3):p(pos1[i]):scale(0.8)--:bindTouchLocate() 
        commonAct:moveAroundFish(dragon, 40, 300, 10, 440)
    end
    local water3 = D.img("nylantern/map/thirdly/pool/4_water3.png"):to(water, 5):p(192.2, 25.5)--:bindTouchLocate() 
    for i = 1, 2 do
        local grass = D.img("nylantern/map/thirdly/pool/4_grass"..i..".png"):to(water, i * 2):p(191.7, 29.6)--:bindTouchLocate() 
    end
    local body = self._layer:createBody(bigTank, cc.size(270, 100), nil, b2_staticBody)
    table.insert(self["dragonTab"..index], body)
end

-- 加载桥
function M:loadBridge(index)
    local bridge = D.img("nylantern/map/thirdly/bridge.png"):to(self, 100):p(ccp(495.6 + 1024 * BG_SCALE * (index - 1), 223.7)):anchor(ccp(0.5, 0.5))--:bindTouchLocate() 
    table.insert(self["objectTab"..index], bridge)
    table.insert(self._objectTab, bridge)
    local bridgeMask = D.img("nylantern/map/thirdly/bridgemask.png"):to(self, 600):p(ccp(496.1 + 1024 * BG_SCALE * (index - 1), 100))
    table.insert(self["objectTab"..index], bridgeMask)
    table.insert(self._objectTab, bridgeMask)
    local water = D.img("nylantern/map/thirdly/1.png"):to(bridge, -20):p(ccp(442.3, 127.5)):scale(0.8)--:bindTouchLocate() 
    -- 加载荷叶
    local pos = {ccp(307.1, 52.1), ccp(356.1, 64.1), ccp(410.3, 76.9), ccp(482.1, 51.5), 
                ccp(543.9, 67.2), ccp(600.8, 75.6), ccp(728.6, 52.2)}
    for i = 1, 3 do 
        local num = i % 2 + 2
        local leaf = D.img("nylantern/map/thirdly/"..num..".png"):to(bridge, 20):p(pos[i]):scale(0.8)--:bindTouchLocate() 
    end
    -- 加载桥刚体
    local body = self._layer:createBridgeBody(bridgeMask)
    table.insert(self["dragonTab"..index], body)
end

---------------------------------------------------
----------------树和风车等装饰物----------------------
---------------------------------------------------

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    -- if not tolua.isnull(self._particle) then 
    --     self._particle:remove()
    -- end
    -- for i, v in pairs(self._particleTab) do
    --     if not tolua.isnull(v) then 
    --         v:remove()
    --     end
    -- end
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
