--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Ui")
M.TAG       = "Ui"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = false
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 加载结点
function M:loadPageNode()
    local uiBg = D.img("nylantern/ui/1.png"):to(self):p(65 + X_OFFSET / 2.8, 218 + Y_OFFSET)--:bindTouchLocate()
    -- 加载背景
    local uiBg1 = D.img("nylantern/ui/2.png"):to(uiBg):p(32.2, 217)--:bindTouchLocate()
    -- 加载进度条
    local progress    = U.loadProgressBar({
        imgName       = "nylantern/ui/3.png",
        mode          = kCCProgressTimerTypeBar,
        midpoint      = ccp(0, 0),
        barChangeRate = ccp(0, 1),
        progressTo    = 0,
        isAutoRun     = false,
    }):p(32.2, 217):to(uiBg)--:bindTouchLocate()
    self._progress = progress
    --  加载粒子
    local follow = Tools:newParticle("particle/drg_jindutiao_jiangjiu.plist", 65 + X_OFFSET / 2.8, 45.5 + Y_OFFSET):to(self, 99999)
    Tools:insertParticleTb(self, follow)
    self._follow = follow
end

-- 加载进度条上的样式
function M:loadFigure()
    local pos = {ccp(20, 100), ccp(20, 100), ccp(20, 100), ccp(20, 100),
                ccp(20, 100), ccp(20, 100), ccp(20, 100), ccp(20, 100),
                ccp(20, 100), ccp(20, 100), ccp(20, 100), ccp(20, 100),
                ccp(20, 100)}
    for i = 1, 13 do 
        local num = N.random(4, 5)
        local decorate = D.img("nylantern/ui/"..num..".png"):to(self._progress):p(pos[i])--:bindTouchLocate()
    end
end

-- 设置进度条
function M:setProgress(count, isPerson)
    local offset = self._progress:ch()/48
    local posY = 354 / 48 * count
    self._up = Tools:newParticle("particle/drg_jindutiao_up.plist", 23, 2.5 + posY):to(self._progress)
    Tools:insertParticleTb(self, self._up)
	self._up:setPositionType(kCCPositionTypeRelative)
    A.line({
        {"ProgressTo", 0.25, 100 / 48 * count}
    }):at(self._progress)
    if not isPerson then 
        offset = self._progress:ch()/48/2
    end
    A.line({
        {"moveBy", 0.5, ccp(0, offset)}
    }):at(self._follow)
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    -- if not tolua.isnull(self._up) then 
    --     self._up:remove()
    --     self._up = nil
    -- end
    -- if not tolua.isnull(self._follow) then 
    --     self._follow:remove()
    --     self._follow = nil
    -- end
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
