--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..

----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch = true
    -- 家表
    self._homeTab  = {}
    -- 是否有前情
    self._isFirst  = ifnil(self:getScene()._isFirst, true)
    -- 左表
    self._leftTab      = {}
    -- 右表
    self._rightTab     = {}
    -- 引导线表
    self._lineTab      = {}
    -- 贴福次数
    self._blessCount   = 0
    -- 可以赠送的年货
    self._goodsGive    = {}
    -- 奇奇打招呼计数
    self._qqCount      = 0
    -- 游戏的事件进程
    self._totalCount   = 0
    -- 弹窗计数
    self._order = 1
    -- 年糕表
    self._newCakeTab   = {}
    -- 年糕是否可以点击
    self._cakeCanTouch = false
    -- 年糕计数
    self._cakeCount    = 0
    -- 是否放置到盒子里了
    self._isPutTab     = {false, false, false, false, false}
    -- 数据清空
    G_GIFT_TB          = {1, 2, 3, 5, 6}
    -- 随机数去重
    self._randomTab    = {}
    self._randomTab1   = {}
    -- 生成一个路人出现的情况
    -- self._index = N.random(1, 2)
    -- 粒子表
    self._particleTab = {}
end

----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 加载背景
    self:loadBg()
    -- 加载结点
    self:loadPageNode()
    -- 加载奇奇妙妙
    self:loadQm()
    -- 加载移动按钮
    self:loadBtnMove()
    -- 加载兔一一
    self:loadYiYi(false)
    -- 加载壮壮
    self:loadZz(false)

    -- 预览礼物清单
    -- self._totalCount = 1
    -- self:loadList()
    
    -- 快捷场景进入
    -- 美美事件
    -- self._order = 1
    -- self:meiMeiEvent(true)
    -- self:loadBox(ccp(385 + X_OFFSET, 80 + Y_OFFSET), ccp(90, 150))

    -- 皮皮事件
    -- self._order = 2
    -- self._yiyi:remove()
    -- self._qq:px(2498 - 200)
    -- self._mm:px(2384 - 200)
    -- self._node:px(-2200 + 200 + X_OFFSET * 2)
    -- -- self:piPiEvent(true)
    -- self:loadBox(ccp(385 + X_OFFSET, 80 + Y_OFFSET), ccp(90, 135))

    -- 闹闹事件
    -- self._order = 3
    -- self:naoNaoEvent(true)
    -- -- 最后的前情
    -- self._mm:talkEvent1()
    -- self:loadBox(ccp(385 + X_OFFSET, 80), ccp(90, 150))
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    Tools:openAd()
    -- 播放音效[bgm09]拜年
    sound:play057BGM09()
    if self._isFirst then 
        -- 前情
        self._homeTab[1]:openDoor()
        A.line({
            {"delay", 0.9},
            { "fn", function()
                Tools:resetParent(self._qq, self._node, 180)
                Tools:resetParent(self._mm, self._node, 200)
            end },
            {"fn", function()
                self._qq:moveOutDoor()
                self._mm:moveOutDoor()
            end}
        }):at(self)
    else
        -- 游戏开始
        self:gameBegin()
    end
end

-- 游戏开始
function M:gameBegin()
    self._btnMove._canTouch = true
    -- 显示按钮
    self._btnMove:btnShow()
end

--加载背景
function M:loadBg()
    -- 加载一个空节点
    local node = U.loadNode({}):to(self):bindTouch():p(-120 + X_OFFSET, 0)--:bindTouchLocate()
    self._node = node
    -- 加载地面
    self:loadLand()
    -- 加载墙
    self:loadWall()
    -- 加载后景
    self:loadBackGround()
    -- 加载门前景物
    self:loadFrontGround()
    -- 加载雪
    self:loadSnow()
end

-- 下梅花
function M:loadSnow()
    local plumTab = {"common/plum/1.png", "common/plum/2.png", "common/plum/3.png", "common/plum/4.png"}
    local pos = {ccp(0, 0), ccp(V.w, 0), ccp(V.w * 2, 0), ccp(V.w * 3, 0), ccp(V.w * 4, 0)}
    for i = 1, 5 do 
        local node = U.loadNode({}):to(self._node, 299):unbindTouch():p(pos[i])
        Tools:loadSnows(node, 999, nil, 8, nil, nil, plumTab)
    end
end

-- 妙妙说话事件 -- “敲敲门，给里面的小伙伴拜年吧！”
function M:mmTalkEvent()
    -- 播放配音
    soundVoice:playEffectv057120()
    self._mm:lookSpeakAni1_1()
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057120", 1.5)
	self:line({
		{"delay", time},
		{"fn", function ()
			-- 开心说话（结束）
			self._mm:lookSpeakAni1_3()
		end}
	})
end

-- 美美事件
function M:meiMeiEvent(isSkip)
    if not self._onceEnter then 
        if isSkip then 
            self._qq:px(1248)
            self._mm:px(1134)
            self._node:px(-950 + X_OFFSET * 2)
        end
        self._onceEnter = true
        print("=====触发美美事件")
        self._btnMove:btnHide()
        self._btnMove:onTouchEnded(nil, nil, nil, 0)
        self._btnMove._moveSpeed = 0 
        self._btnMove:meetStopAct()
        -- 妙妙说话事件 -- “敲敲门，给里面的小伙伴拜年吧！”
        self:mmTalkEvent()
        self:loadMeiMei()
        self._totalCount = 1
    end
end

-- 兔一一事件
function M:yiYiEvent(isSkip)
    if not self._onceEnter then
        self._onceEnter = true
        if isSkip then 
            -- 显示按钮
            self._btnMove:btnShow()
            self._qq:px(1705)
            self._mm:px(1591)
            self._node:px(-1407)
        end
        self._btnMove:stopSoundEffect()
        self._btnMove:meetStopAct()
        self._btnMove:btnHide()
        -- 播放配音
        soundVoice:playEffectv057107()
     	soundVoice:playEffectv057122()
        self._qq:helloAni1_1(true)
        self._mm:greetAni1_1(true)

        local time = soundVoice:soundDuration("v057107", 1) + soundVoice:soundDuration("v05711", 1)
        A.line({
            {"delay", time + 0.5}, 
            {"fn", function ()
                self:passerbyEvent()
            end}
        }):at(self)
        self._btnMove._moveSpeed = 0 
    end
end

-- 皮皮事件
function M:piPiEvent(isSkip)
    if not self._onceEnter1 then 
        if isSkip then
            self._yiyi:remove() 
            self._qq:px(2498 )
            self._mm:px(2384 )
            self._node:px(-2200 + X_OFFSET * 2)
        end
        print("=====触发皮皮事件")
        self._onceEnter1 = true
        self._btnMove:btnHide()
        -- self._btnMove:onTouchEnded(nil, nil, nil, 0)
        self._btnMove._moveSpeed = 0 
        self._btnMove:meetStopAct()
        -- 妙妙说话事件 -- “敲敲门，给里面的小伙伴拜年吧！”
        self:mmTalkEvent()
        -- 加载皮皮
        self:loadPiPi()
        self._totalCount = 3
    end
end

-- 壮壮事件
function M:zzEvent()
    if not self._onceEnter2 then 
        self._btnMove:stopSoundEffect()
        self._onceEnter2 = true
        self._btnMove:meetStopAct()
        -- 播放配音
        soundVoice:playEffectv057110()
        soundVoice:playEffectv057125()
        self._qq:helloAni1_1(true)
        self._mm:greetAni1_1(true)

        local time = soundVoice:soundDuration("v057110", 1) + soundVoice:soundDuration("v05711", 1)
        A.line({
            {"delay", time + 0.5}, 
            {"fn", function ()
                self:passerbyEvent()
            end}
        }):at(self)
        self._btnMove:btnHide()
        self._btnMove._moveSpeed = 0 
        self._qqCount = 2
    end
end

-- 闹闹事件
function M:naoNaoEvent(isSkip)
    if not self._onceEnter3 then 
        if isSkip then
            self._zz:remove()
            self._qq:px(3760 + X_OFFSET * 2)
            self._mm:px(3645 + X_OFFSET * 2)
            self._node:px(-3461 + X_OFFSET * 2)
        end
        self._onceEnter3 = true
        print("=====触发闹闹事件")
        self._btnMove:btnHide()
        self._btnMove:meetStopAct()
        -- self._btnMove:onTouchEnded(nil, nil, nil, 0)
        self._btnMove._moveSpeed = 0 
        -- 妙妙说话事件 -- “敲敲门，给里面的小伙伴拜年吧！”
        self:mmTalkEvent()
        
        -- 加载闹闹
        self:loadNaoNao()
        self._totalCount = 5
    end
end

-- 路人事件
function M:passerbyEvent()
    if self._qqCount == 0 then 
        -- 打招呼完准备送礼
        self._yiyi:hello(true)
    elseif self._qqCount == 1 then 
        self._totalCount = self._totalCount + 1
        print("结束兔一一送礼")
        self._yiyi:walkRule(2.5)
        -- 显示按钮
        self._btnMove:btnShow()
    elseif self._qqCount == 2 then
        self._zz:hello(true)
    elseif self._qqCount == 3 then
        print("结束壮壮送礼")
        self._zz:walkRule(2.5)
        -- 显示按钮
        self._btnMove:btnShow()
    end
    self._qqCount =  self._qqCount + 1
end

-- 加载棒棒糖
function M:loadLolly(index, node, pos)
    index = self:createRandom(5, self._randomTab1)
    -- 音效
    soundEffect:playEffectsfx05708008()
    local lolly = D.img("nyvisit/lolly/"..index..".png"):to(node):p(pos)
    self._lolly = lolly
    local lolly1 = D.img("nyvisit/lolly/"..index..".png"):to(node):p(pos)
    self._lolly1 = lolly1
    local light = D.img("common/light2.png"):to(node, -2):p(pos.x, pos.y):scale(1):opacity(200)
    local newPos = cc.p(node:cw()/2, node:ch() / 2)
    local x, y = newPos.x, newPos.y + 200
    local particle = Tools:newParticle("particle/huili.plist", x, y):to(node, node:z() + 100):scale(1)
    Tools:insertParticleTb(self, particle)
    table.insert(self._particleTab, particle)
    -- 亮光的动作
    self:lightAct(light, newPos, node, pos)
end

-- 亮光的动作
function M:lightAct(light, newPos, node, pos)
    local x, y = newPos.x, newPos.y + 200
    light:line({
        {"Delay", 0.8},
        {"fn", function ()
            local particle = Tools:newParticle("particle/huili.plist", x, y):to(node, node:z() + 100):scale(1)
            Tools:insertParticleTb(self, particle)
            table.insert(self._particleTab, particle)
        end},
        { "Delay", 0.8 },
        { "fn", function()
            local particle = Tools:newParticle("particle/huili.plist", x, y):to(node, node:z() + 100):scale(1)
            Tools:insertParticleTb(self, particle)
            table.insert(self._particleTab, particle)
        end }
    })
    light:line({
        {"rotateBy", 1.5, 180},
        {"fn", function ()
            Tools:resetParent(self._lolly, self._node, 300)
            Tools:resetParent(self._lolly1, self._node, 300)
             -- 音效
            soundEffect:playEffectsfx05708017()
            -- 棒棒糖动作
            self:lollyAction(1, self._lolly, pos)
            self:lollyAction(2, self._lolly1, pos)
        end},
        {"remove"}
    })
end

-- 棒棒糖动作
function M:lollyAction(index, node, pos)
    local pos = self._qq:point()
    if index == 2 then 
        pos = self._mm:point()
    end
    A.line({
        {"union",{
            {"jumpTo", 0.8, ccp(pos.x + 10, pos.y), 100, 1},
            {"scaleTo", 0.8, 1.2},
        }},
        {"fn", function ()
            if index == 1 then 
                -- 欢呼音效
                self:cheerSound()
                if self._totalCount % 2 == 0 then 
                    self._qq:sideStimulate()
                    self._mm:sideStimulate()
                else
                    self._qq:backStimulate()
                    self._mm:backStimulate()
                end
            end
        end},
        {"remove"}
    }):at(node)
end

-- 欢呼音效
function M:cheerSound()
    local num = self:createRandom(3, self._randomTab)
    if num == 1 then
        -- 音效
        soundEffect:playEffectsfx05708009()
    elseif num == 2 then 
        -- 音效
        soundEffect:playEffectsfx05708010()
    else
        -- 音效
        soundEffect:playEffectsfx05708011()
    end
end

-- 随机数
function M:createRandom(kind, randomTab)
    if #randomTab == kind then 
    T.clear(randomTab)
    end
    local num = N.randomExcept(1, kind, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 加载菜单卷轴
function M:loadList()
    local list = self:createNode("List", {
        layer  = self
    }):to(self, 300):p(0, 0):bindTouch()--:bindTouchLocate()
    self._list = list
end

-- 加载美美
function M:loadMeiMei()
    -- 加载敲门引导圈
    self:loadKnock(2)
    -- 加载美美
    local meimei = import("app.nyvisit.node.AniMeiMei").new({
        file         = "bone/cj_mmls",
        armatureName = "cj_mmls",
        layer        = self,
    }):to(self._homeTab[2], -2):p(370, 144.4):flipX(true):scale(0.5)--:bindTouchLocate()
    self._meimei = meimei
end

-- 加载兔一一
function M:loadYiYi(isSkip)
    if not self._yiyi then
        if isSkip then 
            self._totalCount = 2
            -- 显示按钮
            self._btnMove:btnShow()
            self._qq:px(1500 + X_OFFSET)
            self._mm:px(1391 + X_OFFSET)
            self._node:px(-1207 + X_OFFSET)
        end 
        local pos = ccp(2500 + X_OFFSET * 1.5, 180)
        local yiyi       = import("app.nyvisit.node.AniYiYi").new({
            file         = "bone/cj_tyy",
            armatureName = "cj_tyy",
            layer        = self,
        }):to(self._node, 190):p(pos):flipX(false):scale(0.89)--:bindTouchLocate()
        self._yiyi = yiyi
    end
end

-- 加载壮壮
function M:loadZz(isSkip)
    if not self._zz then
        if isSkip then
            self._yiyi:hide() 
            self._totalCount = 4
            -- 显示按钮
            self._btnMove:btnShow()
            self._qq:px(2800)
            self._mm:px(2709)
            self._node:px(-2525)
        end 
        local pos = ccp(3690 + X_OFFSET * 1.5, 160)
        local zz = import("app.nyvisit.node.AniZz").new({
            file         = "bone/cj_zz",
            armatureName = "cj_zz",
            layer        = self,
        }):to(self._node, 190):p(pos):flipX(false):scale(1.1)--:bindTouchLocate()
        self._zz = zz
    end
end

-- 加载皮皮
function M:loadPiPi()
    -- 加载敲门引导圈
    self:loadKnock(3)
    local pipi = import("app.nyvisit.node.AniPiPi").new({
        file         = "bone/cj_pp",
        armatureName = "cj_pp",
        layer        = self,
    }):to(self._homeTab[3], -2):p(355.7, 144.4):flipX(false):scale(0.5)--:bindTouchLocate()
    self._pipi = pipi
end

-- 加载闹闹
function M:loadNaoNao()
    -- 加载敲门引导圈
    self:loadKnock(4)
    -- 加载美美
    local naonao     = import("app.nyvisit.node.AniNaoNao").new({
        file         = "bone/cj_nn",
        armatureName = "cj_nn",
        layer        = self,
    }):to(self._homeTab[4], -2):p(385, 120):flipX(false):scale(0.5):bindTouch()
    self._naonao = naonao
end

-- 加载敲门引导圈
function M:loadKnock(index)
    local pos = ccp(258, 179)
    if index == 3 then pos = ccp(245, 179) 
    elseif index == 4 then pos = ccp(260, 195) 
    end
    local knock = import("app.nyvisit.node.Knock").new({
        imgName = "nyvisit/knock/1.png",
        layer   = self,
        index   = index
    }):to(self._homeTab[index], 9999):p(pos):bindTouch({rectFactorX = 1.5, rectFactorY = 1.5})
end

-- 加载弹框
function M:loadBox(pos, offsetPos)
    local box    = import("app.common.node.BaseBox").new({
        layer    = self,
        movePos  = offsetPos,
        enterPos = pos
    }):to(self, 998):bindTouch()
    self._box = box
end

-- 加载box事件
function M:loadThing(node)
    if self._order == 1 then 
        -- 加载门
        self:loadDoor(node, self._order)
    elseif self._order == 2 then 
        -- 加载年糕场景 
        self:riceCake(node)
    end
end

-- 弹框回调
function M:boxCallEvent()
    if self._order == 1 then 
        --加载递出的手
        self:loadHand()
        A.line({
            {"delay", 0.6},
            {"fn", function ()
                self._hand:enter()
            end}
        }):at(self)
    elseif self._order == 2 then 
        -- 年糕动画 
        self:cutAct(1)
    end 
    self._order = self._order + 1
end

-- 加载门
function M:loadDoor(node)
    local door = D.img("nyvisit/home2/second/door.png"):to(node):p(351.8, 215.9)--:bindTouchLocate()
    local pos  = {ccp(182.5, 187.7), ccp(476.8, 187.7)}
     -- 加载引导线
    for i = 1, 2 do 
        local line = D.img("nyvisit/home2/second/line.png"):to(door):p(pos[i]):opacity(0)--:bindTouchLocate()
        table.insert(self._lineTab, line)
    end
end

--------------------------------------
--------------- 年糕 ------------------
--------------------------------------
-- 年糕场景
function M:riceCake(node)
    -- 播放配音
    soundVoice:playEffectv057131()
    local time = soundVoice:getVoiceTime("v057131", 2)
    A.line({
        {"delay", time},
        {"fn", function ()
            soundVoice:playEffectv057144()
        end}
    }):at(self)
    -- 帧动画预加载
    Tools:addTextureAsync("nyvisit/home3/second/action/1/", 1, 5)
    local cake  = import("app.nyvisit.node.Cake").new({
        layer   = self,
        imgName = "nyvisit/home3/second/action/1/1.png"
    }):to(node, 5):p(480 , 255):anchor(ccp(0.5, 0.5)):scale(1.68):unbindTouch()
    self._cake = cake
    
    local touchArea = U.loadMaskNode({ 
        color       = ccc3(0, 0, 255) 
    }):to(node, 5):p(350 , 215):bindTouch():scale(0.62):opacity(0)
    self._touchArea = touchArea
    local this = self
    function touchArea:onTouchBegan(x, y, touches)
        this._cake:onTouchBegan(x, y)
        return
    end
    function touchArea:onTouchMoved(x, y, touches)
        -- this:touchMoveEvent(x, y) 
    end
    function touchArea:onTouchEnded(x, y, touches)
        this._cake:onTouchEnded(x, y)
    end

    -- 加载用来拖动的年糕
    self:loadRiceCake(node)
    -- 加载盒子
    self:loadCover(node)
end

-- 加载用来拖动的年糕
function M:loadRiceCake(node)
    local pos = {ccp(218.8, 173.7), ccp(287.4, 173.9), ccp(353.8, 173.7), ccp(422.3, 172.5), ccp(484.6, 169.1)}
    local scaleTab = {100, 200, 300, 400, 500}
    for i = 1, 5 do 
        local newCake = import("app.nyvisit.node.NewCake").new({
            layer   = self,
            imgName = "nyvisit/home3/second/cut/"..i..".png",
            index   = i
        }):to(node, scaleTab[i]):p(pos[i]):hide()--:bindTouchLocate()
        table.insert(self._newCakeTab, newCake)
    end
end

-- 加载盒子
function M:loadCover(node)
    local cover = import("app.nyvisit.node.Cover").new({
        layer   = self,
        imgName = "nyvisit/home3/second/install/cover1.png"
    }):to(self, 1000):p(140.0 - 500 + X_OFFSET, 66.3 + Y_OFFSET):scale(1.05)--:bindTouchLocate()
    self._cover = cover
end

-- 加载脱位粒子
function M:loadFlyParticle()
    local particle = Tools:newParticle("particle/drg_jindutiao_tuowei2.plist", 790 + X_OFFSET, 420 + Y_OFFSET):to(self, 999)
    Tools:insertParticleTb(self, particle)
    A.line({
        {"jumpto", 0.8, cc.p(380 + X_OFFSET, 150 + Y_OFFSET), 150, 1},
        {"delay", 0.2},
        {"fn", function ()
            particle:stopSystem()
        end}
    }):at(particle)
end

-- 音效
function M:cutSound(index)
    if index == 1 then 
        -- 音效
        soundEffect:playEffectsfx05708020()
        -- 加载脱位粒子
        self:loadFlyParticle()
    else
        -- 音效
        soundEffect:playEffectsfx05708021()
    end
end

-- 年糕切
function M:cutAct(index)
    -- 音效
    self:cutSound(index)
    local indexTab = {5, 11, 10, 10, 12}
    local type = index + 1
    A.line({
        {"union",{
            {"imagerange", "nyvisit/home3/second/action/"..index.."/", 1, indexTab[index], 0.1},
            {"line", {
                {"delay", 0.5},
                {"fn", function()
                    if index == 5 then 
                        --音效
                        soundEffect:playEffectsfx05708022()
                    end
                end},
            }}
        }},
        {"fn", function ()
            if index == 5 then 
                self._cover:enter()
                self._cake:hide()
                for i, v in ipairs(self._newCakeTab) do
                    v:show()
                end
                return 
            end
            Tools:addTextureAsync("nyvisit/home3/second/action/"..type.."/", 1, indexTab[type])
            self._cake._canTouch = true
        end}
    }):at(self._cake)
end
--------------------------------------
--------------- 年糕 ------------------
--------------------------------------

--------------------------------------
--------------- 贴福 ------------------
--------------------------------------
--加载递出的手
function M:loadHand()
    local hand    = import("app.common.node.BaseHand").new({
        layer     = self,
        handImg   = "nyvisit/home2/second/hand.png",
    }):to(self, 999):scale(0.9)
    self._hand = hand
    -- 加载手上的东西
    self:loadBless()
end

-- 加载手上的东西 
function M:loadBless()
    local bless = import("app.nyvisit.node.Bless").new({
        imgName = "nyvisit/home2/second/bless.png",
        layer   = self,
    }):to(self._hand, 999):scale(0.9)
    local handPos = self._hand:getCenterPos()
    local offsetX = 0
    local offsetY = 65
    bless:p(handPos.x + offsetX, handPos.y + offsetY)
   
    self._hand._handThing = bless
    self._bless = bless
end
--------------------------------------
--------------- 贴福 ------------------
--------------------------------------

-- 加载结点
function M:loadPageNode()
    -- 加载每家每户
    self:loadHome()
end

-- 加载奇奇妙妙
function M:loadQm()
    local nodeName = self._homeTab[1]
    local index = -2
    local scale = 0.5
    local offset = 0
    local pos = {ccp(283.7 , 133.4), ccp(188.4, 135)}
    if not self._isFirst then 
        nodeName = self._node
        index = 200
        scale = 1
        offset = 0.15
        pos = {ccp(415.3 , 170), ccp(300.9 , 122.0)}
    end
    -- 加载qiqi
    local qq = import("app.nyvisit.node.AniQq").new({
        layer    = self,
    }):to(nodeName, index - 20):p(pos[1]):flipX(true):scale(scale - offset)--:bindTouchLocate()
    self._qq = qq
    -- 加载妙妙
    local mm  = import("app.nyvisit.node.AniMm").new({
        layer    = self,
    }):to(nodeName, index):p(pos[2]):scale(scale)--:bindTouchLocate()
    self._mm = mm
end

-- 加载按钮移动
function M:loadBtnMove()
    local btnMove = import("app.nyvisit.node.BtnMove").new({
        imgName = "tfgoodswalk/ui/btn.png",
        layer   = self
    }):to(self, 300):p(880 + X_OFFSET , 245 + Y_OFFSET):flipX(false):scale(0):hide()
    self._btnMove = btnMove
end

-- 加载每家每户
function M:loadHome()
    local pos = {ccp(595.5, 290), ccp(1428, 274), ccp(2670, 283), ccp(3968, 292)}
    local scaleTab = {1, 1, 1.1, 1}
    -- 加载每家每户
    for i = 1, 4 do 
        local home  = import("app.nyvisit.node.Home").new({
            imgName  = "nyvisit/home"..i.."/1.png",
            index    = i,
            layer    = self,
        }):to(self._node, 150):p(pos[i]):bindTouch():scale(scaleTab[i])--:bindTouchLocate()
        table.insert(self._homeTab, home)
    end
end

-- 加载地面
function M:loadLand()
    local pos = {ccp(0, -30), ccp(V.w, -30), ccp(V.w * 2, -30), ccp(V.w * 3, -30), ccp(V.w * 4, -30)}
    for i = 1, 5 do 
        local flip = false
        if i == 2 or i == 4 then flip = true end
        -- 加载地面
        local land = D.img("nyvisit/bg/land/land.png"):to(self._node, 100):scale(BG_SCALE):anchor(cc.p(0, 0)):p(pos[i]):flipX(flip)--:bindTouchLocate()
    end
end

-- 加载墙
function M:loadWall()
    local pos = {ccp(-25, 155), ccp(806, 155), ccp(1626, 155), ccp(2908, 155), ccp(4126.2, 155)}
    for i = 1, 5 do 
        local wall = D.img("nyvisit/bg/wall/"..i..".png"):to(self._node, 50):anchor(cc.p(0, 0)):p(pos[i])--:bindTouchLocate()
    end
end

-- 加载后景
function M:loadBackGround()
    -- 加载天空颜色
    U.loadLayer({ color = ccc3(255, 252, 236) }):to(self._node):scale(10)
    -- 加载屋顶
    local pos = {ccp(155, 375), ccp(782, 340), ccp(1700, 365), ccp(2855, 340), ccp(3551, 375)} 
    local pos1 = {ccp(-28, 298), ccp(972, 328.0), ccp(3047, 330), ccp(4170, 300)} 
    local pos2 = {ccp(3, 280), ccp(60, 286), ccp(4210, 258), ccp(4258, 260)} 
    local pos3 = {ccp(-138, 375), ccp(415, 366), ccp(906, 355), ccp(1719, 306), ccp(2995, 305), ccp(4200, 338)} 
    for i = 1, 5 do 
        local index = 1 
        if i == 2 or i == 4 then index = 2 end
        local roof = D.img("nyvisit/bg/background/roof"..index..".png"):to(self._node, 40):anchor(cc.p(0, 0)):p(pos[i])--:bindTouchLocate()
    end
    -- 加载屋顶的草
    for i = 1, 4 do 
        local index = 1 
        if i == 2 or i == 3 then index = 2 end
        local roof = D.img("nyvisit/bg/background/roofgrass"..index..".png"):to(self._node, 40):anchor(cc.p(0, 0)):p(pos1[i])--:bindTouchLocate()
        Tools:breathing(roof)
    end
    -- 加载竹子
    for i = 1, 4 do 
        local index = i 
        if i == 3 or i == 4 then index = i - 2 end
        local roof = D.img("nyvisit/bg/background/bamboo"..index..".png"):to(self._node, 35):anchor(cc.p(0, 0)):p(pos2[i])--:bindTouchLocate()
        Tools:breathing(roof)
    end
    -- 加载山
    for i = 1, 6 do 
        local index = i 
        if i == 4 then index = 2 
        elseif i == 5 then index = 3
        elseif i == 6 then index = 1
        end
        local roof = D.img("nyvisit/bg/background/hill"..index..".png"):to(self._node, 30):anchor(cc.p(0, 0)):p(pos3[i])--:bindTouchLocate()
    end
    -- 加载梅花
    local plum = D.img("nyvisit/bg/background/plum.png"):to(self._node, 9999):anchor(cc.p(0.5, 0)):p(ccp(2200, 377))--:bindTouchLocate()
    commonAct:breathing(plum, 1, 1)
end

-- 加载门前景
function M:loadFrontGround()
    local pos = {ccp(885, -40.9), ccp(1429.2, -67.4), ccp(2204.8, -53.2), ccp(2992.4, -51.), ccp(4048.4, -46)} 
    local pos1 = {ccp(885, 160), ccp(2185.0, 160)}
    local pos2 = {ccp(1735, 156.2), ccp(2972.1, 142.7)}
    -- 加载雪
    for i = 1, 5 do 
        local snow = D.img("nyvisit/bg/land/snow.png"):to(self._node, 180):anchor(cc.p(0, 0)):p(pos[i])
    end
    -- 加载草
    for i = 1, 2 do 
        local grass = D.img("nyvisit/bg/land/grass.png"):to(self._node, 180):anchor(cc.p(0, 0)):p(pos1[i])
    end
    -- 加载地上的不动的景物
    for i = 1, 2 do 
        local prop = D.img("nyvisit/bg/prop/"..i..".png"):to(self._node, 180):anchor(cc.p(0, 0)):p(pos2[i])
    end
    -- 加载地上的动的景物
    self:loadProps()
end

-- 加载地上的动的景物
function M:loadProps()
    -- 加载灯
    self:loadLamp()
    -- 加载花圃
    self:loadFlower()
    -- 加载🌲
    self:loadTree()
    -- 加载竹子
    self:loadBamboo()
end

-- 加载灯
function M:loadLamp()
    local lamp = D.img("nyvisit/bg/prop/lamp/1.png"):to(self._node, 180):anchor(cc.p(0, 0)):p(ccp(4315, 138))
    local pos = {ccp(28.0, 210.3), ccp(45.3, 204.2), ccp(71.0, 200.5), ccp(93.6, 203.6), ccp(113.4, 209.9)}
    for i = 1, 5 do 
        local samll = D.img("nyvisit/bg/prop/lamp/2.png"):to(lamp, 5):anchor(cc.p(0.5, 1)):p(pos[i])
        self:swingAction(samll)
    end
end

-- 加载花圃
function M:loadFlower()
    local front = D.img("nyvisit/bg/prop/flower/front.png"):to(self._node, 180):anchor(cc.p(0, 0)):p(ccp(4389.8, 144.8))
    local pos = {ccp(9.8, 27.8), ccp(26.7, 28.8), ccp(92.9, 24.6), ccp(77.1, 22.3), ccp(118.2, 25.1)}
    local scaleTab = {-5, -1, -2, -3, -4}
    for i = 1, 5 do 
        local grass = D.img("nyvisit/bg/prop/flower/"..i..".png"):to(front, scaleTab[i]):anchor(cc.p(0, 0)):p(pos[i])
        commonAct:breathing(grass)
    end
end

-- 加载🌲
function M:loadTree()
    local tree = D.img("nyvisit/bg/prop/tree/1.png"):to(self._node, 180):anchor(cc.p(0, 0)):p(ccp(3385, 145))
    local pos = {ccp(41.1, 238.5), ccp(19.6, 325.8), ccp(97.9, 344.5), ccp(161.1, 341.7), ccp(206.4, 290.2), ccp(152.0, 171.7)}
    -- 加载6个灯笼
    for i = 1, 6 do 
        local samllLamp = D.img("nyvisit/bg/prop/tree/2.png"):to(tree, 5):anchor(cc.p(0.5, 1)):p(pos[i])
        self:swingAction(samllLamp)
    end
end

-- 加载竹子
function M:loadBamboo()
    local bamboo = D.img("nyvisit/bg/prop/bamboo/1.png"):to(self._node, 180):anchor(cc.p(0, 0)):p(ccp(2293.2, 135.7))
    local lamp = D.img("nyvisit/bg/prop/bamboo/2.png"):to(bamboo, 5):anchor(cc.p(0.6, 1)):p(ccp(36, 168.9))
    self:swingAction(lamp)
end

--摇摆动作
function M:swingAction(node)
    local num = math.random(5, 8)
    local time = math.random(8, 12)/10
    self._swingAct = A.line({
        {"rotateby", time, -num},
        {"rotateby", time, num},
        {"rotateby", time, num},
        {"rotateby", time, -num},
        {"fn", function ()
            return self:swingAction(node)
        end}
    }):at(node)
end

--停止摇摆动作
function M:stopSwingAction()
    if self._swingAct then
        self:stopAction(self._swingAct)
        self._swingAct = nil
        self:rotate(0)
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end
    self._btnMove:onTouchBegan()
    local px, py = Tools:dragLimit(self._btnMove, x, y, self._btnMove:cw(), V.w - self._btnMove:cw() , self._btnMove:ch(), V.h - self._btnMove:ch())
    self._btnMove:p(px, py)
    bb.si.Tool.limitRectMove({
        node      = self._btnMove,
        -- marginTop = 80,
    })
    bb.si.Tool.limitButtonMove({node = self._btnMove})
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    if not self._btnMove._isTouch then return end
    local px, py = Tools:dragLimit(self._btnMove, x, y, self._btnMove:cw(), V.w - self._btnMove:cw() , self._btnMove:ch(), V.h - self._btnMove:ch())
    self._btnMove:p(px, py)
    bb.si.Tool.limitRectMove({
        node      = self._btnMove,
        -- marginTop = 80,
    })
    bb.si.Tool.limitButtonMove({node = self._btnMove})
end

function M:onTouchEnded(x, y, touches)
    if not self._btnMove._isTouch then return end
    self._btnMove:onTouchEnded() 
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end

function M:onExitTransitionStart()
    for k, v in pairs(self._particleTab) do
        if not tolua.isnull(v) then 
            v:remove()
            v = nil
        end
    end
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
