--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("AniMeiMei")
M.TAG       = "AniMeiMei"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer    = params.layer
	-- 选对次数
	self._count    = 0
	--是否可以点击
	self._canTouch = true
end


----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:breathe()
end

-- 离开门
function M:moveOutDoor()
	-- 正面走
	self:happyWalk()
	A.line({
		{"delay", 0.5},
		{"union",{
			{"moveBy", 0.5, ccp(-62, -10)},
            --缩放
			{"scaleTo", 0.5, 0.6},
		}},
		{"union",{
			{"moveBy", 0.8, ccp(-62, -26)},
            --缩放
			{"scaleTo", 0.8, 0.8},
			{"line", {
				{"delay", 0.1},
				{"fn", function ()
					self:z(100)
				end}
			}}
		}},
		{"fn", function ()
			-- 拜年讲话
			self:talkEvent()
		end},
	}):at(self)
end


-- 贴春联
function M:pasteBless()
	A.line({
		{"fn", function ()
			self._layer._homeTab[2]:closeDoor()
			-- 准备出现弹框
			self._layer:loadBox(ccp(385 + X_OFFSET, 80 + Y_OFFSET), ccp(90, 150))
		end}
	}):at(self)
end

-- 拜年讲话
function M:talkEvent()
	-- 播放配音
	soundVoice:playEffectv057106()
	soundVoice:playEffectv057121()
	self._layer._qq:backHelloAni1_1(true)
	self._layer._mm:backHelloAni1_1(true)
	self:breathe()

	local time = soundVoice:soundDuration("v057106", 1) + soundVoice:soundDuration("v057127", 1)
	A.line({
		{"delay", time}, 
		{"fn", function ()
			-- 播放配音
			soundVoice:playEffectv057134()
			self:visitAni1_1()
		end}
	}):at(self)
	local time1 = soundVoice:soundDuration("v057134", 2)
	A.line({
		{"delay", time + time1},
		{"fn", function ()
			self:visitAni1_3()
		end}
	}):at(self)
end

-- 接收礼物
function M:receiveAni(index)
	local nametab = {"mmls_lw", "mmls_lw1", "mmls_lw2", "mmls_lw3", "mmls_lw4", "mmls_lw5", "mmls_lw6"}
	self:play("mmls_sl")
	self:changeBoneIndex(self:getBone("mmls_lw"), nametab[index]..".png", 0)
end

-- 骨骼内部换装(骨骼，图片路径， 索引)
function M:changeBoneIndex(bone1, filePath, index)
	--换装图片 装载器
	local skin = ccs.Skin:create()
	skin:initWithSpriteFrameName(filePath)
 
	bone1:addDisplay(skin, index)
end

-- 说话循环
function M:speak1()
	self:play("mmls_sh1")
end

-- 说话循环
function M:speak2()
	self:play("mmls_sh2")
end

-- 说话循环
function M:speak3()
	self:play("mmls_sh3")
end

-- 收礼物呼吸
function M:receiveBreathAni()
	self:play("mmls_slhx")
end

-- 收礼物说话
function M:giftTalkAni1_1()
	self:play("mmls_slsh1")
end

-- 收礼物说话（循环）
function M:giftTalkAni1_2()
	self:play("mmls_slsh2")
end

-- 收礼物说话（结束）
function M:giftTalkAni1_3()
	self:play("mmls_slsh3")
end


-- 拜年
function M:visitAni1_1()
	self:play("mmls_zysh1")
end

-- 拜年
function M:visitAni1_2()
	self:play("mmls_zysh2")
end

-- 拜年
function M:visitAni1_3()
	self:play("mmls_zysh3")
end

-- 呼吸
function M:breathe()
	self:play("mmls_hx")
end

-- 待机东张西望
function M:standby1()
	self:play("mmls_dj")
end

-- 开心走路
function M:happyWalk()
	self:play("mmls_zl1")
end

-- 开心走路
function M:happyWalk1()
	self:play("mmls_zl2")
end

-- 开心走路
function M:happyWalk2()
	self:play("mmls_zl3")
end


-- 打招呼(开始)
function M:hello()
	self:play("mmls_dzh1")
end

-- 打招呼(循环)
function M:hello1()
	self:play("mmls_dzh2")
end

-- 打招呼(结束)
function M:hello2()
	self:play("mmls_dzh3")
end

-- 美美收礼物说话
function M:talkEvent1()
	-- 播放配音
	soundVoice:playEffectv057135()
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057135", 2)
	self:giftTalkAni1_1()
	A.line({
		{"delay", time},
		{"fn", function ()
			self:giftTalkAni1_3()
		end},
	}):at(self)
end

-- 美美说话 正好要切春联
function M:talkEvent2()
	self:speak1()
	-- 播放配音
	soundVoice:playEffectv057136()
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057136", 2)
	A.line({
		{"delay", time},
		{"fn", function ()
			self:speak3()
			-- 播放配音
			soundVoice:playEffectv057115()
			-- 获取时长
			local time1 = soundVoice:getVoiceTime("v057115", 2)
			A.line({
				{"delay", time1},
				{"fn", function ()
					self:pasteBless()
				end}
			}):at(self)
		end}
	}):at(self)
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "mmls_zysh1"  then
			self:visitAni1_2()
		elseif __moveId == "mmls_zysh3" then
			-- 开始送礼物
			self._layer:loadList()
			self:breathe()
		elseif __moveId == "mmls_sl" then
			-- 美美收礼物说话
			self:talkEvent1() 
		elseif __moveId == "mmls_slsh1" then
			self:giftTalkAni1_2()
		elseif __moveId == "mmls_slsh3" then
			-- 加载棒棒糖
			self._layer:loadLolly(self._layer._totalCount, self, ccp(80, 340))
			self:breathe()
		elseif __moveId == "mmls_dzh1" then
			self:hello1()
		elseif __moveId == "mmls_dzh3" then
			local time = soundVoice:soundDuration("v057130", 1.5)
			A.line({
				{"delay", time},
				{"fn", function ()
					self._layer._qq:turnSide()
					self._layer._mm:turnSide()
							-- 显示按钮
					self._layer._btnMove:btnShow()
				end}
			}):at(self)
			self:breathe()
			
			-- 结束游戏计数加一
			self._layer._totalCount = self._layer._totalCount + 1
		elseif __moveId == "mmls_sh1" then
			self:speak2()
		elseif __moveId == "mmls_sh3" then 
			self:breathe()
		end
	elseif __evtType == 2 then
		-- if __moveId == "mmls_dzh2" then
		-- 	self:hello2()
		-- end
	end
end

function M:meimeiHelow()
	local time = soundVoice:soundDuration("v057138", 1.5)
	self:line({
		{"delay", time},
		{"fn", function()
			self:hello2()
		end}
	})
end

----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)
	
	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end
----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
