--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = class("AniMm", import("app.common.node.BaseMm"))
M.TAG       = "AniMm"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(710 + X_OFFSET, 90))
	-- 是否处于拜年
	self._isHello = true
	-- 计数
	self._count = 0
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	--换装
	self:changeClose()
	if self._layer._isFirst then 
		-- 呼吸
		self:breatheFrontAni()
	else
		-- 侧面呼吸
		self:breatheSideAni()
	end
end

-- 显示蝴蝶结L
function M:hideBowknotL()
	self:getBone("cmm_hdj1"):hide()
	self:getBone("cmm_hdj2"):hide()
	self:getBone("cmm_hdj3"):hide()
	self:getBone("cmm_hdj1_1"):show()
	self:getBone("cmm_hdj2_1"):show()
	self:getBone("cmm_hdj3_1"):show()
end

-- 显示蝴蝶结R
function M:hideBowknotR()
	self:getBone("cmm_hdj1"):show()
	self:getBone("cmm_hdj2"):show()
	self:getBone("cmm_hdj3"):show()
	self:getBone("cmm_hdj1_1"):hide()
	self:getBone("cmm_hdj2_1"):hide()
	self:getBone("cmm_hdj3_1"):hide()
end

-- 待机
function M:standby()
	self:play("mm_ksz")
end

-- 疑问待机
function M:standby1_1()
	self:play("mm_csh4")
end

function M:standby1_2()
	self:play("mm_csh4_2")
end

function M:standby1_3()
	self:play("mm_csh4_3")
end

-- 侧转背
function M:turnBack()
	self:play("mm_czb")
end

-- 侧转背
function M:turnSide()
	self:play("mm_bzc")
end

-- 背面笑
function M:backSmile()
	self:play("mm_x")
end

-- 侧面激励
function M:sideStimulate()
	self:play("mm_jl")
end

-- 背面激励
function M:backStimulate()
	self:play("mm_bjl")
end

-- 背面呼吸
function M:backBreatheAni()
	self:play("mm_bhx")
end

-- 背面打招呼
function M:backHelloAni1_1(isHellow, time)
	if isHellow then 
		A.line({
			{"delay", 0.9},
			{"fn", function ()
				soundVoice:playEffectv057127()
			end}
		}):at(self)
		self:play("mm_hs1")
	else
		time = time or 0
		A.line({
			{"delay", time},
			{"fn", function ()
				soundVoice:playEffectv057130()
				self:play("mm_hs1")
			end},
		}):at(self)
	end
end

-- 背面打招呼(循环)
function M:backHelloAni1_2()
	self:play("mm_hs1_1")
end

-- 背面打招呼
function M:backHelloAni1_3()
	self:play("mm_hs1_2")
end

-- 打招呼
function M:greetAni1_1(isHello)
	self:play("mm_zs1")
	if isHello then 
		A.line({
			{"delay", 0.9},
			{"fn", function ()
				-- 新年快乐
				soundVoice:playEffectv057126()
			end}
		}):at(self)
	else
		-- 再见
		soundVoice:playEffectv057130()
	end
end

-- 打招呼(说话)
function M:greetAni1_2()
	self:play("mm_zs1_1")
end

-- 打招呼
function M:greetAni1_3()
	self:play("mm_zs1_2")
end

-- 打招呼
function M:greetAni1_4()
	self:play("mm_zs1_3")
end

-- 走路看
function M:walkSeeAni()
	self:play("mm_cz1")
end

-- 侧面呼吸
function M:breatheSideAni()
	self:play("mm_chx")
end

-- 走路（年货）
function M:walkSideAni()
	self:play("mm_cz")
end

-- 正面走路
function M:walkFrontAni()
	self:play("mm_zou1")
end

-- 正面呼吸
function M:breatheFrontAni()
	self:play("mm_hx2")
end

-- 看镜头说话(开始)
function M:lookSpeakAni1_1()
	self:play("mm_csh6")
end

-- 看镜头说话(循环)
function M:lookSpeakAni1_2()
	self:play("mm_csh6_1")
end

-- 看镜头说话(结束)
function M:lookSpeakAni1_3()
	self:play("mm_csh6_2")
end

-- 说话给奇奇(开始)
function M:speakToQqAni1()
	self:play("mm_csh7")
end

-- 说话给奇奇(循环)
function M:speakToQqAni1_1()
	self:play("mm_csh7_1")
end

-- 说话给奇奇(结束)
function M:speakToQqAni1_2()
	self:play("mm_csh7_2")
end

--换装
function M:changeClose()
	self._armature:getBone("cmm_wq"):hide()
end

-- 离开门
function M:moveOutDoor()
	-- 正面走
	self:walkFrontAni()
	A.line({
		{"union",{
			{"moveBy", 1.2, ccp(-40, -80)},
            --缩放
            {"scaleTo", 1.2, 0.8},
		}},
		{"fn", function ()
			self:walkInto()
		end}	
	}):at(self)
end



-- 走到目标位
function M:walkInto()
	-- 侧面走路
	self:walkSideAni()
	self:hideBowknotR()
	A.line({
		{"union",{
			{"moveBy", 1, ccp(-200, -40)},
            --缩放
            {"scaleTo", 1, 1},
		}},
		{"fn", function ()
			self:flipX(true)
			self:hideBowknotL()
			-- 侧面呼吸
			self:breatheSideAni()
		end}
	}):at(self)
end


-- “记得要有礼貌哦~”
function M:talkEvent()
	-- 播放配音
	soundVoice:playEffectv057119()
	-- 看镜头说话(开始)
	self:lookSpeakAni1_1()
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057119", 1.5)
	self:line({
		{"delay", time},
		{"fn", function ()
			-- 待机定时器
			self._layer._btnMove:standbyTime()
			-- 开心说话（结束）
			self:lookSpeakAni1_3()
			
		end}
	})
end

-- 太可爱啦~~
function M:talkEvent1()

	self:lookSpeakAni1_1()
	self._layer._qq:hearMmAni1()

	-- 播放配音
	soundVoice:playEffectv057132()
	-- -- v057132
	local time = soundVoice:getVoiceTime("v057132", 2)
	A.line({
		{"delay", time},
		{"fn", function ()
			self:lookSpeakAni1_3()
		end}
	}):at(self)
end

-- 拜年可真开心呀~
function M:talkEvent2()
	self:lookSpeakAni1_1()
	self._layer._qq:hearMmAni1()

	-- 播放配音
	soundVoice:playEffectv057133()
	local time = soundVoice:getVoiceTime("v057133", 2)
	A.line({
		{"delay", time},
		{"fn", function ()
			self._layer._totalCount = self._layer._totalCount + 1
			self:lookSpeakAni1_3()
		end}
	}):at(self)

end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "mm_csh6" then
			-- 看镜头说话(循环)
			self:lookSpeakAni1_2()
		elseif __moveId == "mm_csh6_2" then
			if self._layer._totalCount == 5 and not self._isHello then
				-- 侧面
				self:breatheSideAni()
				self._layer._qq:talkEvent1()
			elseif self._layer._totalCount == 6 then
				self:breatheSideAni()
				self._layer._qq:talkEvent2()
			elseif self._layer._totalCount == 0 then
				--侧面呼吸
				self:breatheSideAni()
				self._layer._btnMove:btnShow()
				self._layer._totalCount = self._layer._totalCount + 1
			else
				-- 侧面
				self:turnBack()
				self._layer._qq:turnBack()
			end
		elseif __moveId == "mm_zs1" then
			self:greetAni1_2()
		elseif __moveId == "mm_zs1_3" then
			-- 侧面
			self:breatheSideAni()
		elseif __moveId == "mm_hs1" then
			self:backHelloAni1_2()
		elseif __moveId == "mm_hs1_2" then
			self:backBreatheAni()
		elseif __moveId == "mm_bjl" then 
			self:backBreatheAni()
		elseif __moveId == "mm_jl" then 
			self:greetAni1_1()
		elseif __moveId == "mm_csh7" then 
			self:speakToQqAni1_1()
		elseif __moveId == "mm_csh7_2" then
			self:talkEvent2()
			self:breatheSideAni()
			self._layer._qq:breathAni4()
			-- 切换场景
			game:enterScene("quick", {}, "fade", 1, COLOR3_WHITE)
		elseif __moveId == "mm_czb" then 
			self:backBreatheAni()
		elseif __moveId == "mm_bzc" then 
			self:breatheSideAni()
		elseif __moveId == "mm_xiao" then 
			self:breatheSideAni()
		elseif __moveId == "mm_ksz" then 
			self:breatheSideAni()
		elseif __moveId == "mm_csh4" then 
			self:standby1_2()
		elseif __moveId == "mm_csh4_3" then 
			self:breatheSideAni()
		end
	elseif __evtType == 2 then
		if __moveId == "mm_zs1_1" then
			self:greetAni1_4()
		elseif __moveId == "mm_hs1_1" then
			self:backHelloAni1_3()
		elseif __moveId == "mm_cz" then
			self:walkSeeAni()
		elseif __moveId == "mm_cz1" then
			self:walkSideAni()
		elseif __moveId == "mm_csh4_2" then
			self:standby1_3()
		end
	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
