--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("AniNaoNao")
M.TAG       = "AniNaoNao"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	-- 选对次数
	self._count = 0
	-- 人物移动距离
	self._offset = -1000
	--是否可以点击
	self._canTouch = true
	-- 狗狗表
	self._dogTab   = {}
	-- 是否可以点击狗狗
    self._canTouchDog  = false
end


----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:breathe()
	-- 加载小狗狗
	self:loadDog()
	-- 隐藏爆竹
	self:hideThing()
end

-- 隐藏爆竹
function M:hideThing()
	self:getBone("nn_dj1"):hide()
	self:getBone("nn_dj2"):hide()
end

-- 离开门
function M:moveOutDoor()
	self._layer._mm._isHello = false
	-- 正面走
	self:happyWalk()
	-- 狗狗有自己的想法移动
	self:dogMove()
	A.line({
		{"delay", 0.5},
		{"union",{
			{"moveBy", 0.8, ccp(-105, -20)},
            --缩放
			{"scaleTo", 0.8, 0.75},
			{"line", {
				{"delay", 0.8},
				{"fn", function ()
					-- 音效
					soundEffect:playEffectsfx05708027()
					self:z(100)
				end}
			}},
		}},
		{"union",{
			{"moveBy", 0.8, ccp(-15, -40)},
            --缩放
			{"scaleTo", 0.8, 1.1},
		}},
		{"fn", function ()
			self:happyWalkEnd()
			-- 拜年讲话
			self:talkEvent()
		end},
	}):at(self)
end

-- 加载小狗狗
function M:loadDog()
	local pos = {ccp(300, 110), ccp(260, 110), ccp(320, 110)}
	local indexTab = {-2, -5, -3}
	-- 加载三只小狗狗
	for i = 1, 3 do 
		local dog        = import("app.nyvisit.node.AniDog").new({
			file         = "bone/cj_wc",
			armatureName = "cj_wc", 
			layer        = self,
			index        = i,
		}):to(self._layer._homeTab[4], indexTab[i]):p(pos[i]):flipX(false):scale(0.8)--:bindTouchLocate()--:bindTouch()
		table.insert(self._dogTab, dog)
		self._dog = dog 
	end
end

-- 狗狗有自己的想法移动
function M:dogMove()
	for i, v in ipairs(self._dogTab) do
		v:walkToDoor()
	end
end

-- 狗狗表演
function M:perform()
	soundVoice:playEffectv057152()
	self:talkAni()
	local time = soundVoice:getVoiceTime("v057152", 3)
	A.line({
		{"delay", time},
		{"fn", function ()
			self:breathe()
		end}
	}):at(self)
	for i, v in ipairs(self._dogTab) do
		v:run()
		A.line({
			{"union",{
				{"moveBy", 0.4, ccp(-30, -55)},
				--缩放
				{"scaleTo", 0.4, 1.15},
				{"line", {
					{"delay", 0.2},
					{"fn", function ()
						self._layer._qq:turnSide()
						self._layer._mm:turnSide()
					end}
				}}
			}},
			{"fn", function ()
				self:dogVisit(i, v)
 			end}
		}):at(v)
	end
	-- 结尾前情
	self:finishAntecedent()
end

-- 狗狗拜年
function M:dogVisit(i, v)
	local indexTab = {2, 0, 2}
	v:breathe()
	if i == 2 then 
		-- 音效
		soundEffect:playEffectsfx05708029()
		-- 拜年
		v:visit()
	else
		A.line({
			{"delay", indexTab[i]},
			{"fn", function ()
				-- 拜年
				v:visit()
			end}
		}):at(self)
	end
end

-- 结尾前情
function M:finishAntecedent()
	A.line({
		{"delay", 5},
		{"fn", function ()
			-- “拜年可真开心呀~”
			self._layer._mm:talkEvent1()
		end}
	}):at(self)
end

-- 狗狗骨骼动作
function M:dogAct(node,index)
	self._canTouchDog = true
	local indexTab = {0.1, 0, 0.5}
	node:breathe()
	if index ~= 2 then 
		A.line({
			{"delay", indexTab[index]},
			{"fn", function ()
				node:sit()
			end}
		}):at(self)
	end
end

-- 新年快乐
function M:talkEvent()
	-- 播放配音
	soundVoice:playEffectv057123()
	soundVoice:playEffectv057108()
	self._layer._qq:backHelloAni1_1(true)
	self._layer._mm:backHelloAni1_1(true)

	local time = soundVoice:soundDuration("v057123", 1) + soundVoice:soundDuration("v057112", 1)
	A.line({
		{"delay", time }, 
		{"fn", function ()
			soundVoice:playEffectv057150()
			self:visitAni1_1()
		end}
	}):at(self)
	local time1 = soundVoice:soundDuration("v057150", 2)
	A.line({
		{"delay", time + time1},
		{"fn", function ()
			self:visitAni1_3()
		end}
	}):at(self)
end


-- 停止走路
function M:stopWalkAct()
	if self._walkAct then 
		self:stopAction(self._walkAct)
		self._walkAct = nil
	end
end

--  待机动画
function M:standby()
	A.cycle({
		{"delay", 3.5},
		{"fn", function ()
			local num = self:createRandom(4, self._standbyTab)
			if num == 1 then 
				self:call1()
			elseif num == 2 then 
				self:call2()
			elseif num == 3 then 
				self:speak1()
			elseif num == 4 then 
				self:speak2()
			end
		end}
	}):at(self)
end

-- 随机数
function M:createRandom(kind, randomTab)
    if #randomTab == kind then 
		T.clear(randomTab)
    end
    local num = N.randomExcept(1, kind, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 收礼说话
function M:giftTalkAni()
	self:play("nn_slsh1")
end

-- 普通讲话
function M:talkAni()
	self:play("nn_sh")
end

-- 收礼呼吸
function M:giftBreatheAni()
	self:play("nn_slhx")
end

-- 收礼物开心
function M:giftHappy()
	self:play("nn_sljl")
end

-- 接收礼物
function M:receiveAni(index)
	local nametab = {"nn_lw", "nn_lw1", "nn_lw2", "nn_lw3", "nn_lw4", "nn_lw5", "nn_lw6"}
	A.line({
		{"delay", 0.4},
		{"fn", function ()
			self:play("nn_sl")
			-- 音效
			soundEffect:playEffectsfx05708028()
			self:changeBoneIndex(self:getBone("nn_lw"), nametab[index]..".png", 4)
		end}
	}):at(self)
end

-- 骨骼内部换装(骨骼，图片路径， 索引)
function M:changeBoneIndex(bone1, filePath, index)
	--换装图片 装载器
	local skin = ccs.Skin:create()
	skin:initWithSpriteFrameName(filePath)
 
	bone1:addDisplay(skin, index)
end


-- 拜年
function M:visitAni1_1()
	self:play("zysh1")
end

-- 拜年
function M:visitAni1_2()
	self:play("zysh2")
end

-- 拜年
function M:visitAni1_3()
	self:play("zysh3")
end

-- 呼吸
function M:breathe()
	self:play("nn_hx")
end

-- 待机东张西望
function M:standby1()
	self:play("nn_dj")
end

-- 走路
function M:walk()
	self:play("nn_zl1")
end

-- 开心走路
function M:happyWalk()
	self:play("nn_kxzl1")
end

-- 开心走路
function M:happyWalk1()
	self:play("nn_kxzl2")
end

-- 开心走路
function M:happyWalk2()
	self:play("nn_kxzl3")
end

-- 开心走路
function M:happyWalkEnd()
	self:play("nn_kxzl4")
end

-- 打招呼(开始)
function M:hello()
	self:play("nn_jl1")
end

-- 打招呼(循环)
function M:hello1()
	self:play("nn_jl2")
end

-- 打招呼(结束)
function M:hello2()
	self:play("nn_jl3")
end

-- 闹闹讲话
function M:talkEvent1()
	self:giftTalkAni()
	soundVoice:playEffectv057151()
	local time = soundVoice:getVoiceTime("v057151", 1.92)
	A.line({
		{"delay", time},
		{"fn", function ()
			self:breathe()
			-- 加载棒棒糖
			self._layer:loadLolly(self._layer._totalCount, self, ccp(50, 180))
		end}
	}):at(self)
end

-- 我们三个一起去舞龙吧
function M:talkEvent2()
	self:talkAni()
	-- 播放配音
	soundVoice:playEffectv057153()
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057153", 3)
	time = time + 0.3
	A.line({
		{"delay", time},
		{"fn", function ()
			self:breathe()
			-- 切换场景
			game:enterScene("nylantern", {}, "fade", 1, COLOR3_WHITE)
		end}
	}):at(self)
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "nn_kxzl1"  then
			self:happyWalk2()
		elseif __moveId == "nn_kxzl4" then
			self:breathe()
		elseif __moveId == "nn_dj" then
			
		elseif __moveId == "nn_jl1" then
			-- 循环打招呼
			self:hello1()
		elseif __moveId == "nn_jl2" then
			-- 打招呼结束
			self:hello2()
		elseif __moveId == "zysh1" then
			self:visitAni1_2()
		elseif __moveId == "zysh3" then
			-- 开始送礼物
			self._layer:loadList()
			self:breathe()
		elseif __moveId == "nn_sl" then
			self:giftHappy()
		elseif __moveId == "nn_sljl" then
			self:talkEvent1()
		end
	elseif __evtType == 2 then
		if __moveId == "tzx_sh1" or "tzx_sh2" then
			
		end
	end
end




----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)
	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end
----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
