--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("AniPiPi")
M.TAG       = "AniPiPi"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer    = params.layer
	-- 选对次数
	self._count    = 0
	-- 人物移动距离
	self._offset   = 2000
	--是否可以点击
	self._canTouch = true
	-- 是否结束
	self._isOver   = false
end


----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:breathe()
	-- 隐藏糖葫芦
	self:hideBerry()
end

-- 隐藏糖葫芦
function M:hideBerry()
	self:getBone("pp_thl"):hide()
	self:getBone("pp_thl1"):hide()
end

-- 特殊事件切年糕
function M:cutCake()
	-- 准备出现弹框
	self._layer:loadBox(ccp(385 + X_OFFSET, 80 + Y_OFFSET), ccp(90, 150))
end

-- 皮皮回礼
function M:reply()
	self._isOver = true
	self:receiveAni(7)
end

-- 笑着说话
function M:smileSpeak()
	self:play("pp_sh1")
end

-- 离开门
function M:moveOutDoor()
	-- 正面走
	self:happyWalk()
	A.line({
		{"union",{
			{"moveBy", 1, ccp(-80, -20)},
            --缩放
			{"scaleTo", 1, 0.5},
		}},
		{"union",{
			{"moveBy", 0.5, ccp(-21, -22)},
            --缩放
			{"scaleTo", 0.5, 0.7},
			{"line", {
				{"delay", 0.1},
				{"fn", function ()
					self:z(100)
				end}
			}}
		}},
		{"fn", function ()
			self:happyWalkEnd()
			-- 拜年讲话
			self:talkEvent()
		end},
	}):at(self)
end

-- 我有礼物送给你们哟
function M:talkEvent()
	-- 播放配音
	soundVoice:playEffectv057109()
	soundVoice:playEffectv057124()
	self._layer._qq:backHelloAni1_1(true)
	self._layer._mm:backHelloAni1_1(true)

	local time = soundVoice:soundDuration("v057109", 1) + soundVoice:soundDuration("v057127", 1)
	A.line({
		{"delay", time}, 
		{"fn", function ()
			soundVoice:playEffectv057142()
			self:visitAni1_1()
		end}
	}):at(self)
	local time1 = soundVoice:soundDuration("v057142", 2)
	A.line({
		{"delay", time + time1},
		{"fn", function ()
			self:visitAni1_3()
		end}
	}):at(self)
end


-- 停止走路
function M:stopWalkAct()
	if self._walkAct then 
		self:stopAction(self._walkAct)
		self._walkAct = nil
	end
end

-- 皮皮收礼物说话
function M:talkEvent1()
	local time = 2 
	if not self._isOver then 
		-- 播放配音
		soundVoice:playEffectv057143()
		time = soundVoice:getVoiceTime("v057143", 5)
		self:smileSpeak()
	else
		-- 播放配音
		soundVoice:playEffectv057145()
		time = soundVoice:getVoiceTime("v057145", 3)
		self:giftTalkAni()
	end
	A.line({
		{"delay", time},
		{"fn", function ()
			if not self._isOver then 
				self:breathe()
				self:cutCake()
			else
				-- 呼吸
				self:breathe()
				self:loadParticle()
			end
		end},
	}):at(self)
end

-- 加载飞出的粒子
function M:loadParticle()
	local particle = Tools:newParticle("particle/window_jili.plist", 480, 250):to(self._layer, 999)
	Tools:insertParticleTb(self._layer, particle)
	-- 音效
	soundEffect:playEffectsfx05708007()
	A.line({
		{"union",{
			{"jumpBy", 1.0, ccp(-125 + X_OFFSET, -120), 100, 1},
			{"line", {
				{"delay", 0.7},
				{"fn", function ()
					-- qiqi接收礼物
					self._layer._qq:backAccept()
				end}
			}},
		}},
		{"fn", function ()
			particle:stopSystem()
		end},
	}):at(particle)
end

-- 收礼呼吸
function M:giftBreatheAni()
	self:play("pp_slhx")
end

-- 收礼说话
function M:giftTalkAni()
	self:play("pp_slsh")
end

-- 接收礼物
function M:receiveAni(index)
	local nametab = {"pp_lw", "pp_lw1", "pp_lw2", "pp_lw3", "pp_lw4", "pp_lw5", "pp_lw6"}
	A.line({
		{"delay", 0.2},
		{"fn", function ()
			self:play("pp_sl")
			if self._isOver then 
			else
				soundEffect:playEffectsfx05708019()
			end
			self:changeBoneIndex(self:getBone("pp_lw"), nametab[index]..".png", 0)
		end}
	}):at(self)
end

-- 骨骼内部换装(骨骼，图片路径， 索引)
function M:changeBoneIndex(bone1, filePath, index)
	--换装图片 装载器
	local skin = ccs.Skin:create()
	skin:initWithSpriteFrameName(filePath)
 
	bone1:addDisplay(skin, index)
end

-- 拜年
function M:visitAni1_1()
	self:play("pp_zysh1")
end

-- 拜年
function M:visitAni1_2()
	self:play("pp_zysh1_1")
end

-- 拜年
function M:visitAni1_3()
	self:play("pp_zysh1_2")
end

-- 呼吸
function M:breathe()
	self:play("pp_hx")
end

-- 待机东张西望
function M:standby1()
	self:play("nn_dj")
end

-- 开心走路
function M:happyWalk()
	self:play("pp_zl1")
end

-- 开心走路
function M:happyWalk1()
	self:play("pp_zl2")
end

-- 开心走路
function M:happyWalk2()
	self:play("pp_zl3")
end

-- 开心走路
function M:happyWalkEnd()
	self:play("pp_zl4")
end

-- 打招呼(开始)
function M:hello()
	-- 播放配音
	soundVoice:playEffectv057146()
	self:play("pp_dzh")
end

-- 激励
function M:stimulate()
	self:play("pp_jl")
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "pp_zl1"  then
			self:happyWalk1()
		elseif __moveId == "pp_zl4" then
			-- 呼吸
			self:breathe()
		elseif __moveId == "pp_zysh1" then
			self:visitAni1_2()
		elseif __moveId == "pp_zysh1_2" then
			-- 开始送礼物
			self._layer:loadList()
			-- 呼吸
			self:breathe()
		elseif __moveId == "pp_sl" then
			if self._isOver then 
				self:talkEvent1() 
			else
				self:stimulate()
			end
		elseif __moveId == "pp_jl" then	
			-- 皮皮收礼物说话
			self:talkEvent1() 
		elseif __moveId == "pp_dzh" then
			print("==== 皮皮事件结束")
			self._layer._qq:turnSide()
			self._layer._mm:turnSide()
			-- 显示按钮
			self._layer._btnMove:btnShow()
			-- 结束游戏计数加一
			self._layer._totalCount = self._layer._totalCount + 1
			-- 呼吸
			self:breathe()
		end
	elseif __evtType == 2 then
		
	end
end



----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end
----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end
return M
