--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 基类
----------------------
local M     = class("AniQq", import("app.common.node.BaseQq"))
M.TAG       = "AniDad"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer    = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(880 + X_OFFSET, 175))
	-- 计数
	self._count    = 0
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 年货正面
	self:breatheFrontAni()
	-- 隐藏桶
	self:hideBucket()
	if self._layer._isFirst then 
		-- 呼吸
		self:breatheFrontAni()
	else
		-- 侧面呼吸
		self:breathAni4()
	end
end

-- 待机
function M:standby()
	self:play("qq_dj0")
end

-- 疑问待机
function M:standby1_1()
	self:play("qq_csh4")
end

function M:standby1_2()
	self:play("qq_csh4_1")
end

function M:standby1_3()
	self:play("qq_csh4_2")
end

-- 侧转背
function M:turnBack()
	self:play("qq_czb")
end

-- 侧转背
function M:turnSide()
	self:play("qq_bzc")
end

-- 背面笑
function M:backSmile()
	self:play("qq_bx")
end

-- 收手
function M:stopAni()
	self:play("qq_ss")
end

-- 侧面激励
function M:sideStimulate()
	self:play("qq_jl")
end

-- 背面激励
function M:backStimulate()
	self:play("qq_bjl")
end

-- 侧面送礼物
function M:giveAni(index)
	self:getBone("cqq_lw"):show()
	local nametab = {"bqq_lw", "bqq_lw1", "bqq_lw2", "bqq_lw3", "bqq_lw4", "bqq_lw5", "bqq_lw6"}
	self:play("qq_slhx")
	self:change("cqq_lw", nametab[index])
	A.line({
		{"delay", 1},
		{"fn", function ()
			self:hideGiftAni(index)
			self:stopAni()
		end}
	}):at(self)
end

--隐藏礼物
function M:hideGiftAni(index)
	local nameTab = {"", self._layer._yiyi, "", self._layer._zz, } 
	local pos = nameTab[self._layer._totalCount]:worldpoint()
	local time = 0.4
	if self._layer._totalCount == 4 or self._layer._totalCount == 2 then time = 0 end
	-- 加载飞出的粒子
	local particle = Tools:newParticle("particle/window_jili.plist", 130, 50):to(self._layer._qq, 999)
	Tools:insertParticleTb(self, particle)
	-- 音效
	soundEffect:playEffectsfx05708007()
	Tools:resetParent(particle, self._layer._mm, 93)
	self:getBone("cqq_lw"):hide()
	-- 加载飞的礼物
	self:loadFlayGif(index, ccp(pos.x - 170 - X_OFFSET , pos.y - 60), 999)
	A.line({
		{"union",{
			{"jumpto", 1.0, ccp(pos.x - 170 - X_OFFSET , pos.y - 60), 100, 1},
			{"line", {
				{"delay", time},
				{"fn", function ()
					-- 兔一一接收礼物
					nameTab[self._layer._totalCount]:receiveAni(index)
				end}
			}},
		}},
		{"fn", function ()
			particle:stopSystem()
		end},
		{"remove"},
	}):at(particle)
end

-- 背面呼吸
function M:backBreatheAni()
	self:play("qq_bhx")
end

-- 侧面打招呼
function M:helloAni1_1(isHello)
	if isHello then 
		A.line({
			{"delay", 0.9},
			{"fn", function ()
				-- 新年快乐
				soundVoice:playEffectv057111()
			end}
		}):at(self)
	else
		-- 再见
		soundVoice:playEffectv057114()
	end
	self:play("qq_zs1")
end

-- 背面打招呼
function M:backHelloAni1_1(isHellow,time)
	if isHellow then 
		A.line({
			{"delay", 0.9},
			{"fn", function ()
				soundVoice:playEffectv057112()
			end}
		}):at(self)
		self:play("qq_hs1")
	else
		time = time or 0
		A.line({
			{"delay", time},
			{"fn", function ()
				soundVoice:playEffectv057114()
				self:play("qq_hs1")
			end},
		}):at(self)
	end
end

-- 背面打招呼(循环)
function M:backHelloAni1_2()
	self:play("qq_hs1_1")
end

-- 背面打招呼(结束)
function M:backHelloAni1_3()
	self:play("qq_hs1_2")
end

-- 背面收礼
function M:backAccept()
	soundVoice:playEffectv057129()
	-- 播放配音
	A.line({
		{"delay", 0.25},
		{"fn", function ()
			soundVoice:playEffectv057113()
		end}
	}):at(self)
	self:getBone("bqq_lw"):show()
	self:play("qq_bsl")
	self:changeBoneIndex(self:getBone("bqq_lw"), "bqq_lw6.png", 0)
end

-- 骨骼内部换装(骨骼，图片路径， 索引)
function M:changeBoneIndex(bone1, filePath, index)
	--换装图片 装载器
	local skin = ccs.Skin:create()
	skin:initWithSpriteFrameName(filePath)
 
	bone1:addDisplay(skin, index)
end

-- 背面送礼
function M:backGiftAni(index)
	self:getBone("bqq_lw"):show()
	local nametab = {"bqq_lw", "bqq_lw1", "bqq_lw2", "bqq_lw3", "bqq_lw4", "bqq_lw5", "bqq_lw6"}
	self:play("qq_bslhx")
	self:change("bqq_lw", nametab[index])
	A.line({
		{"delay", 1},
		{"fn", function ()
			self:backGiftHandAni(index)
		end}
	}):at(self)
end

-- 背面送礼收手
function M:backGiftHandAni(index)
	self:play("qq_bss")
	self:getBone("bqq_lw"):hide()
	local idTab = {2, "", 3, "", 4}
	local nameTab = {self._layer._meimei, "", self._layer._pipi, "", self._layer._naonao}
	local pos = {ccp(240, 174), "", ccp(240, 160), "", ccp(240, 134)}
	-- 加载飞出的粒子
	local particle = Tools:newParticle("particle/window_jili.plist", 130, 50):to(self, 999)
	Tools:insertParticleTb(self, particle)
	-- 加载飞的礼物
	self:loadFlayGif(index, pos[self._layer._totalCount], -1)
	-- 音效
    soundEffect:playEffectsfx05708007()
	A.line({
		{"union",{
			{"jumpto", 1.0, pos[self._layer._totalCount], 100, 1},
			{"line", {
				{"fn", function ()
					-- 屋内人接收礼物
					if nameTab[self._layer._totalCount] and not tolua.isnull(nameTab[self._layer._totalCount]) then
						nameTab[self._layer._totalCount]:receiveAni(index)
					end
				end}
			}},
		}},
		{"fn", function ()
			particle:stopSystem()
		end},
	}):at(particle)
end

-- 加载飞的礼物
function M:loadFlayGif(index, pos, tier)
	local time = 0.8
	local scale = 0.5
	if self._layer._totalCount == 1 then 
		time = 0.7
	elseif self._layer._totalCount == 2 then 
		time = 0.6
		scale = 0.55
		pos = ccp(pos.x + 25, pos.y - 10) 
	elseif self._layer._totalCount == 3 then
		pos = ccp(pos.x + 15, pos.y - 20) 
	elseif self._layer._totalCount == 4 then 
		time = 0.7
	end
	local flyGit = D.img("nyvisit/gift/"..index..".png"):to(self._layer._qq, tier):p(130, 50):scale(0.6):rotate(30)
	if tier > 0 then 
		Tools:resetParent(flyGit, self._layer._mm, 93)
	end
	A.line({
		{"union",{
			{"jumpto", time, pos, 100, 1},
			{"scaleTo", time, scale},
		}},
		{"hide"}
	}):at(flyGit)
end

--隐藏桶
function M:hideBucket()
	self._armature:getBone("cqq_tong"):hide()
	self._armature:getBone("cqq_yy1"):hide()
end

--走路（年货）
function M:walkGoodsAni()
	self:play("qq_zl")
end

-- 看镜头说话(开始)
function M:lookSpeakAni1_1()
	self:play("qq_csh6")
end

-- 看镜头说话(循环)
function M:lookSpeakAni1_2()
	self:play("qq_csh6_1")
end

-- 看镜头说话(结束)
function M:lookSpeakAni1_3()
	self:play("qq_csh6_2")
end

-- 听妙妙说话(开始)
function M:hearMmAni1()
	self:play("qq_csh7")
end

-- 听妙妙说话(循环)
function M:hearMmAni1_1()
	self:play("qq_csh7_1")
end

-- 看妙妙说话(开始)
function M:lookMmAni1()
	self:play("qq_csh7_2")
end

-- 看妙妙说话(循环)
function M:lookMmAni1_1()
	self:play("qq_csh7_3")
end

-- 看妙妙说话(结束)
function M:lookMmAni1_2()
	self:play("qq_csh7_4")
end

-- 离开门
function M:moveOutDoor()
	-- 正面走
	self:walkFrontAni()
	A.line({
		{"union",{
			{"moveBy", 1.2, ccp(-40, -70)},
            --缩放
            {"scaleTo", 1.2, 0.7},
		}},
		{"fn", function ()
			self:walkInto()
		end}
	}):at(self)
end

-- 走到目标位
function M:walkInto()
	self:walkGoodsAni()
	A.line({
		{"union",{
			{"moveBy", 1, ccp(-180, -10)},
            --缩放
            {"scaleTo", 1, 0.85},
		}},
		{"fn", function ()
			self:flipX(true)
			--讲话事件 “向遇到的亲人朋友们拜年吧！”
			self:talkEvent()
		end}
	}):at(self)
end

--讲话事件 “向遇到的亲人朋友们拜年吧！”
function M:talkEvent()
	-- 播放配音
	soundVoice:playEffectv057105()
	-- -- 获取时长
	local time = soundVoice:getVoiceTime("v057105", 3)
	-- 看妈妈说话（开始）
	self:lookSpeakAni1_1()
	self:line({
		{"delay", time},
		{"fn", function()
			-- 看妈妈说话（结束）
			self:lookSpeakAni1_3()
		end}
	})
end

--“天快黑了，舞龙庙会就要开始啦！”
function M:talkEvent1()
	-- -- 播放配音
	soundVoice:playEffectv057117()
	-- -- 获取时长
	local time = soundVoice:getVoiceTime("v057117", 3)
	-- 看妈妈说话（开始）
	self:lookMmAni1()
	self:line({
		{"delay", time},
		{"fn", function()
			self._layer._qq:breathAni4()
			self._layer._mm:talkEvent2()
		end}
	})
end


--“天快黑了，舞龙庙会就要开始啦！”
function M:talkEvent2()
	-- -- 播放配音
	soundVoice:playEffectv057118()
	-- -- 获取时长
	local time = soundVoice:getVoiceTime("v057118", 3)
	-- 看妈妈说话（开始）
	self:lookMmAni1()
	self:line({
		{"delay", time},
		{"fn", function()
			self._layer._qq:breathAni4()
			self._layer._naonao:talkEvent2()
		end}
	})
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "qq_csh6" then
			-- 看镜头说话(循环)
			self:lookSpeakAni1_2()
		elseif __moveId == "qq_csh6_2" then
			self:breathAni4()
			self._layer._mm:talkEvent()
		elseif __moveId == "qq_zs1" then
			self:helloAni1_2()
		elseif __moveId == "qq_zs1_3" then
			if self._isHello then
				self._isHello = false
				-- 打完招呼
				self._layer:passerbyEvent()
			else
				self._isHello = true
			end

			self:breathAni4()
		elseif __moveId == "qq_ss" then 
			self:breathAni4()
		elseif __moveId == "qq_hs1" then 
			self:backHelloAni1_2()
		elseif __moveId == "qq_hs1_2" then 
			self:backBreatheAni()
		elseif __moveId == "qq_bss" then 
			self:backBreatheAni()
		elseif __moveId == "qq_bjl" then 
			self:backBreatheAni()
			if self._layer._totalCount == 1 then 
				-- 触发特殊事件(贴春联)
				self._layer._meimei:talkEvent2()
			elseif self._layer._totalCount == 3 then 
				-- 触发特殊事件(切年糕)
				self._layer._pipi:cutCake()
			elseif self._layer._totalCount == 5 then 
				-- 狗狗拜年
				self._layer._naonao:perform()
			end
		elseif __moveId == "qq_jl" then 
			self:helloAni1_1()
			if self._layer._totalCount == 2 then 
				self._layer._yiyi:hello()
			elseif self._layer._totalCount == 4 then 
				self._layer._zz:hello()
			end
		elseif __moveId == "qq_bsl" then 
			self:backSmile()
			self._layer._mm:backSmile()
		elseif __moveId == "qq_bx" then 
			-- 再见
			self:backHelloAni1_1()
			self._layer._mm:backHelloAni1_1()
			self._layer._pipi:hello()
		elseif __moveId == "qq_csh7" then 
			self:hearMmAni1_1()
		elseif __moveId == "qq_csh7_2" then 
			self:lookMmAni1_1()
		elseif __moveId == "qq_czb" then 
			self:backBreatheAni()
		elseif __moveId == "qq_bzc" then 
			self:breathAni4()
			if self._layer._totalCount == 5 then 
				self:smile()
			end
		elseif __moveId == "qq_dj0" then 
			self:breathAni4()
		elseif __moveId == "qq_csh4" then 
			self:standby1_2()
		elseif __moveId == "qq_csh4_2" then 
			self:breathAni4()
		end
	elseif __evtType == 2 then
		if  __moveId == "qq_zs1_1" then
			self:helloAni1_4()
		elseif __moveId == "qq_hs1_1" then 
			self:backHelloAni1_3()
		elseif __moveId == "qq_csh4_1" then 
			self:standby1_3()
		end
	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end



----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end
return M
