--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("AniZz")
M.TAG       = "AniZz"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	-- 人物移动距离
	self._offset   = 600
	--是否可以点击
	self._canTouch = true
	-- 计数
	self._count    = 0
	-- 只进来一次
	self._onceEnter = false
end


----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 移动定时器
	self:moveTime()
end


-- 停止走路
function M:stopWalkAct()
	if self._walkAct then 
		self:stopAction(self._walkAct)
		self._walkAct = nil
	end
end

-- 移动定时器
function M:moveTime()
	self._moveTimeAct = A.cycle({
		{"delay", 1/60},
		{"fn", function ()
			local distance = math.abs(self:point().x - self._layer._qq:point().x)
			if distance <= 250 then 
				self:stopWalkAct()
				self:happyWalkEnd()
				self:stopAction(self._moveTimeAct)
				self._layer:zzEvent()
			end
		end}
	}):at(self)
end

-- 走路规则
function M:walkRule(num)
	 num = num or 1
	if not self._walkAct then 
		self:happyWalk()
		self._walkAct = A.line({
			{"moveBy", 1.3 * num, ccp(-320 * num, 0)},
			{"fn", function ()
				self:happyWalkEnd()
				self._walkAct = nil
			end}
		}):at(self)
	end
end

--  待机动画
function M:standbyTime()
	if not self._standbyAct then 
		self._standbyAct = A.cycle({
			{"fn", function ()
				-- 待机（左右看看） 
				self:standby()
			end},
			{"delay", 5},
		}):at(self)
	end
end

-- 停止待机动画
function M:stopstandbyAct()
	if not tolua.isnull(self._standbyAct) then
		self:stopAction(self._standbyAct)
		self._standbyAct = nil
	end
end

-- 随机数
function M:createRandom(kind, randomTab)
    if #randomTab == kind then 
		T.clear(randomTab)
    end
    local num = N.randomExcept(1, kind, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 收礼物呼吸
function M:giftBreatheAni()
	self:play("zz_slhx")
end

-- 收礼物说话感谢
function M:giftSpeakAni()
	soundVoice:playEffectv057148()
	self:play("zz_slsh")
end

-- 收礼物
function M:receiveAni(index)
	local nametab = {"zz_lw", "zz_lw1", "zz_lw2", "zz_lw3", "zz_lw4", "zz_lw5", "zz_lw6"}
	self:play("zz_sl")
	-- 音效
	soundEffect:playEffectsfx05708026()
	A.line({
		{"delay", 0.6},
		{"fn", function ()
			self:changeBoneIndex(self:getBone("zz_lw"), nametab[index]..".png", 0)
		end}
	}):at(self)
end

-- 骨骼内部换装(骨骼，图片路径， 索引)
function M:changeBoneIndex(bone1, filePath, index)
   --换装图片 装载器
   local skin = ccs.Skin:create()
   skin:initWithSpriteFrameName(filePath)

   bone1:addDisplay(skin, index)
end

-- 呼吸
function M:breathe()
	self:play("zz_hx")
end


-- 待机（左右看看）
function M:standby()
	self:play("btyy_dj1")
end

-- 开心走路
function M:happyWalk()
	self:play("zz_zl2")
end

-- 开心走路
function M:happyWalkEnd()
	self:play("zz_zl3")
end


-- 打招呼(开始)
function M:hello(isHello)
	if isHello then 
		soundVoice:playEffectv057147()
	else
		soundVoice:playEffectv057149()
	end
	self:play("zz_dzh1")
end

-- 打招呼(循环)
function M:hello1()
	-- 播放配音
	-- soundVoice:playEffectv057037()
	self:play("zz_dzh2")
end

-- 打招呼(结束)
function M:hello2()
	self:play("zz_dzh3")
end


-- 会礼道谢
function M:talkEvent()
	self._layer:loadLolly(self._layer._totalCount, self, ccp(70, 250))
	self:giftBreatheAni()
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "zz_zl3"  then
			self:breathe()
		elseif __moveId == "zz_dzh1" then
			-- 循环打招呼
			self:hello1()
		elseif __moveId == "zz_dzh3" then
			if not self._onceEnter then 
				-- 开始送礼
				self._layer:loadList()
			end
			self._onceEnter = true
			self:breathe()
		elseif __moveId == "zz_sl" then
			self:giftSpeakAni()
		elseif __moveId == "zz_sljl" then
		end
	elseif __evtType == 2 then
		if __moveId == "zz_dzh2" then
			self._count = self._count + 1
			if self._count == 2 then 
				-- 打招呼结束
				self:hello2()
				self._count = 0
			end
		elseif __moveId == "zz_slsh" then
			self._count = self._count + 1
			if self._count == 2 then 
				self:talkEvent()
				self._count = 0
			end
		end
	end
end




----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)
	if self._layer._isMove then return end
	if not self._canTouch then return end
	
	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end
----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
