--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Bless")
M.TAG       = "Bless"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = false
    -- 是否可以移动
    self._canMove  = true
    -- 累计角度
    if self._countAngle == nil then
        self._countAngle = 0
    end
    self._count    = 0
    -- 是否在讲话
    self._isTalk   = true
    -- 是否移动 过
    self._isMove   = true
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- self:rotate(135)
end

-- 引导
function M:openGuide()
    -- 开启引导
    guideFn:openGuide(self, 0.2, 3)
end

-- 加载结点
function M:loadPageNode()
    -- 加载阴影
    local shadow = D.img("nyvisit/home2/second/shadow.png"):to(self, -1):p(90, 88)
    self._shadow = shadow
end

-- 虚线引导圈
function M:lineAct()
    local tabName = {self._layer._leftTab, self._layer._rightTab}
    for i = 1, 2 do 
        if not tabName[i][1] then
            if self._layer._lineTab[i]._lineAct then return end
            self._layer._lineTab[i]._lineAct = A.cycle({
                {"fadein", 0.5},
                {"delay", .3},
                {"fadeout", 0.5},
            }):at(self._layer._lineTab[i])
        end
    end
end

-- 停止引导
function M:stopLineAct() 
    for i, v in ipairs(self._layer._lineTab) do
        if v._lineAct then 
            A.line({
                {"fadeout", 0.2},
            }):at(v)
            v:stopAction(v._lineAct)
            v._lineAct = nil
        end
    end
end

-- 返回
function M:back()
    self._canTouch = false
    -- 开启引导
    guideFn:openGuide(self, 0.2, 3, 0.8) 
    local worldPos = self:getParent():convertToWorldSpace(self._layer._hand:point())
    A.line({
        {"union",{
            {"scaleTo", 0.3, 0.8},
            {"jumpTo", 0.3, ccp(worldPos.x - 3, worldPos.y + 2), 50, 1},
            {"fn", function()
                -- 音效[sfx05700008]
                soundEffect:playEffectsfx05700008()
            end},
        }},
        {"fn", function ()
            self._shadow:show()
            commonAct:nodeScale(self, 0.3, 0.3)
            self._canTouch = true
        end}
    }):at(self)
end

-- 放置
function M:put(type)
    guideFn:stopGuide(self)
    self._canTouch = false
    local tabName = {self._layer._rightTab, self._layer._leftTab}
    local pos = {ccp(630 + X_OFFSET, 260 + Y_OFFSET), ccp(320 + X_OFFSET, 260 + Y_OFFSET)}
    -- 加载引导
    local guide = D.img("nyvisit/guide.png"):to(self, 100):scale(0.8):p(90, 90):hide()
    self._guide = guide
    A.line({
        {"union",{
            {"scaleTo", 0.3, 1.1},
            {"jumpTo", 0.3, ccp(pos[type].x, pos[type].y), 50, 1},
        }},
        {"fn", function ()
            -- 音效[sfx05703008]
            soundEffect:playEffectsfx05703018()
            if self._layer._blessCount == 0 then 
                -- 播放配音
                soundVoice:playEffectv057137()
            end
            self._shadow:show():scale(1.05):p(80, 78)
            self._canMove = false
            self._layer._hand:quit()
            Tools:resetParent(self._shadow, self._layer._box._box, 93)
            self:blessGuide()
            self:bindTouch({
                rectFactorX = 1.5,
                rectFactorY = 1.5,
            })
            self._canTouch = true
        end}
    }):at(self)
    table.insert(tabName[type], self)
end

-- 开启引导动画
function M:blessGuide()
    if not self._guideAction then 
        self._guideAction = A.cycle({
            {"delay", 0.3},
            {"fn", function ()
                self._guide:show()
                self._guide:line({
                    {"rotateBy", 5, 360},
                    {"fn", function ()
                        self._guide:hide()
                    end}
                })
            end},
            {"delay", 7.5},
        }):at(self)
    end
end

-- 停止引导动画
function M:stopBlessGuide()
    if self._guideAction then
        self._guide:hide()
        self._guide:stopAllActions()
        self:stopAction(self._guideAction)
        self._guideAction = nil
	end
end

--旋转结束的事件
function M:endAct()
    -- 阴影消失
    self:shadowAct()
    -- 福字贴入
    A.line({
        {"easing", "backout", {"union",{
            {"scaleTo", 0.2, 1.2},
            {"moveBy", 0.2, ccp(20, 10)},
            {"fn", function ()
                -- 音效[sfx05703008]
                soundEffect:playEffectsfx05703008()
            end}
        }},},
        {"union",{
            {"scaleTo", 0.1, 1.1},
            {"moveBy", 0.1, ccp(-20, -10)}
        }},
        {"fn", function ()
            Tools:resetParent(self, self._layer._box._box, 93)
            self._shadow:hide()
            --  加载粒子
            local particle = Tools:newParticle("particle/window_chuanghua.plist", 90, 75):to(self, 999)
            Tools:insertParticleTb(self, particle)
            commonAct:nodeScale(self, 0.5, 0.5)
            -- 再来一次
            self:onceAgain()
        end}
    }):at(self)
end

-- 阴影消失
function M:shadowAct()
    A.line({
        {"scaleTo", 0.2, 1.2},
        {"union",{
            {"moveBy", 0.1, ccp(15, 10)},
            {"scaleTo", 0.1, 0.95},
        }},
    }):at(self._shadow)
end

 -- 再来一次
function M:onceAgain()
    self._layer._blessCount = self._layer._blessCount + 1
    if self._layer._blessCount == 1 then 
        A.line({
            {"delay", 1.5},
            {"fn", function ()
                self._layer._hand:enter()
                self._layer:loadBless()
            end}
        }):at(self)
    else
        -- 播放配音
        soundVoice:playEffectv057116()
        A.line({
            {"delay", 1},
            {"fn", function ()
                self._layer._box:quit()
                -- 在门上加载贴好的福
                self:loadDoorBless()
            end},
            {"delay", 1},
            {"fn", function ()
                -- 老师感谢奇奇妙妙 并且打招呼离开
                soundVoice:playEffectv057138()
                local time = soundVoice:soundDuration("v057138")
                self._layer._meimei:hello()
                self._layer._meimei:meimeiHelow()
                self._layer._qq:backHelloAni1_1(false,time)
                self._layer._mm:backHelloAni1_1(false,time)
            end}
        }):at(self)
       
    end
end

-- 在门上加载贴好的福
function M:loadDoorBless()
    local pos = {ccp(78.2, 132.8), ccp(78, 132.8)}
    for i = 1, 2 do 
        local bless = D.img("nyvisit/home2/4.png"):to(self._layer._homeTab[2]._doorTab[i], 999):p(pos[i])
    end
end

-- 反馈 
function M:feedback(node, index)
    if not node._feedbackAct then 
        node._feedbackAct = A.line({
            {"union",{
                {"rotateby", 0.15, -5},
                {"fn", function ()
                    if index == 1 then 
                        self._countAngle = self._countAngle - 5
                    end
                end},
            }},
            {"union",{
                {"rotateby", 0.15, 35},
                {"fn", function ()
                    if index == 1 then 
                        self._countAngle = self._countAngle + 35
                    end
                end},
            }},
            {"fn", function ()
                if self._countAngle >= 180  then
                    self:rotate(180)
                    self._shadow:rotate(180)
                    self._canTouch = false
                    if index == 1 then 
                        soundEffect:playEffectsfx05708015()
                        --旋转结束的事件
                        self:endAct()
                    end
                end
                node._feedbackAct = nil
            end}
        }):at(node)
    end
end

-- 旋转音效
function M:rotateSound(count)
    if count >= 90 then
        if not self._sfx05708014 then
            self._sfx05708014 = soundEffect:playEffectsfx05708014()
            sound.setFinishCallback(self._sfx05708014, function()
                self._sfx05708014 = nil
            end)
        end
    elseif count >= 45 then 
        if not self._sfx05708013 then
            self._sfx05708013 = soundEffect:playEffectsfx05708013()
            sound.setFinishCallback(self._sfx05708013, function()
                self._sfx05708013 = nil
            end)
        end
    elseif count > 0 then 
        if not self._sfx05708012 then
            self._sfx05708012 = soundEffect:playEffectsfx05708012()
            sound.setFinishCallback(self._sfx05708012, function()
                self._sfx05708012 = nil
            end)
        end
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end
    -- 关闭引导
    guideFn:stopGuide(self)
    if self._canMove then 
        self:lineAct()
        self:scale(1)
        self._shadow:hide()
    else
        self._isMove = false
        self._shadow:scale(1.3)
        self:scale(1.2)
        self:stopBlessGuide()
        --获得本身的角度
        self._pos = self:getParent():convertToWorldSpace(self:point())
        --鼠标移动的角度
        self._lastAngle = bb.UPoint.quadAngle(ccp(x, y), self._pos)
    end
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    if not self._canTouch then return end
    if self._canMove then 
        self:p(x, y) 
        bb.si.Tool.limitRectMove({
            node      = self,
            -- marginTop = 80,
        })
        bb.si.Tool.limitButtonMove({node = self})
    else
        self._isMove = true
        self._angle = bb.UPoint.quadAngle(ccp(x,y), self._pos)
        local difference = self._angle - self._lastAngle
        -- 顺时针
        if difference < 0 and difference > -10 then 
            self._shadow:rotate(self._shadow:rotate() - difference)
            self:rotate(self:rotate() - difference)
            self._countAngle = self._countAngle + math.abs(difference)
            -- 旋转音效
            self:rotateSound(self._countAngle)
            if self._countAngle > 180 then
                soundEffect:playEffectsfx05708015()
                self._canTouch = false
                self:rotate(180)
                self._shadow:rotate(180)
                --旋转结束的事件
                self:endAct()
            end
        end
        --更新上一个坐标的值
        self._lastAngle = self._angle
    end
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return end
    if self._canMove then  
        self:stopLineAct()
        --
        if self:py() <= 380 + Y_OFFSET and self:py() >= 90 + Y_OFFSET then 
            if self:px() <= 775 + X_OFFSET and self:px() >= 480 + X_OFFSET and not self._layer._rightTab[1] then
                -- 成功
                self:put(1)
            elseif self:px() < 480 + X_OFFSET and self:px() >= 165 + X_OFFSET and not self._layer._leftTab[1] then
                -- 成功
                self:put(2)
            else
                self:back()
            end
        else
            self:back()
        end
    else
        self._shadow:scale(1.2)
        self:scale(1.1)
        self:blessGuide()
        if not self._isMove then 
            self:feedback(self, 1)
            self:feedback(self._shadow, 2)
        end
    end
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
