--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("BtnMove")
M.TAG       = "BtnMove"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    self._isTouch  = false
    -- 移动速度
    self._moveSpeed = 0
    -- 是否移动过
    self._isMove    = false
    -- 等待时间
    self._waitTime  = 1.5
    -- 随机数表
    self._randomTab = {}
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
    -- 背景移动定时器
    self:moveTime()
  
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- 按钮特效动作
    self:btnMaskAct()
end

-- 加载待机定时器
function M:standbyTime()
    if not self._standbyTimeAct then 
        self._standbyTimeAct = A.cycle({
            {"delay", 5},
            {"fn", function ()
                local num = self:createRandom(2, self._randomTab)
                if num == 1 then 
                    self._layer._qq:standby()
                    self._layer._mm:standby1_1()
                else
                    self._layer._qq:standby1_1()
                    self._layer._mm:standby()
                end
            end}
        }):at(self)
    end
end

-- 停止待机
function M:stopStandbyTime()
    if self._standbyTimeAct then
        self:stopAction(self._standbyTimeAct)
        self._standbyTimeAct = nil
    end
end

-- 随机数
function M:createRandom(kind, randomTab)
    if #randomTab == kind then 
    T.clear(randomTab)
    end
    local num = N.randomExcept(1, kind, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 加载结点
function M:loadPageNode()
    local btnMask = D.img("tfgoodswalk/ui/btnmask.png"):to(self, -1):p(54, 53):scale(0.85)
    self._btnMask = btnMask
end

 -- 背景移动定时器
function M:moveTime()
    A.cycle({
        {"delay", 1/60},
        {"fn", function ()
            -- print(self._layer._node:px(), self._layer._qq:px(), self._layer._mm:px())
            if self._layer._node:px() <= -950 + X_OFFSET  and self._layer._node:px() >=  -955 + X_OFFSET  then 
                -- 触发美美事件
                self._layer:meiMeiEvent()
            elseif self._layer._node:px() <= -1405 + X_OFFSET  and self._layer._node:px() >=  -1410 + X_OFFSET  and not self._onceEnter then 
                self._onceEnter = true
                -- 兔一一开始走
                self._layer._yiyi:walkRule(3)
                self._layer._onceEnter = false
            elseif self._layer._node:px() <= -1650 + X_OFFSET  and self._layer._node:px() >=  -1655 + X_OFFSET  then 
                -- 触发兔一一事件
                self._layer:yiYiEvent()
            elseif self._layer._node:px() <= -2200 + X_OFFSET  and self._layer._node:px() >=  -2205 + X_OFFSET  then 
                -- 触发皮皮事件
                self._layer:piPiEvent()
            elseif self._layer._node:px() <= -2625 + X_OFFSET  and self._layer._node:px() >=  -2630 + X_OFFSET  and not self._onceEnter1 then 
                self._onceEnter1 = true
                -- 壮壮开始走
                self._layer._zz:walkRule(3)
                self._layer._onceEnter = false
            elseif self._layer._node:px() <= -2845 + X_OFFSET  and self._layer._node:px() >=  -2850 + X_OFFSET  then 
                -- 触发壮壮事件
                self._layer:zzEvent()
            elseif self._layer._node:px() <= -3461 + X_OFFSET  and self._layer._node:px() >=  -3465 + X_OFFSET  then 
                -- 触发闹闹事件
                self._layer:naoNaoEvent()
            end
            -- 背景移动
            self:bgMove()
        end}
    }):at(self)
end

-- 背景移动
function M:bgMove()
    self._layer._node:px(self._layer._node:px() - 0.1 * self._moveSpeed)
    self._layer._qq:px(self._layer._qq:px() + 0.1 * self._moveSpeed)
    self._layer._mm:px(self._layer._mm:px() + 0.1 * self._moveSpeed)
end

-- 按钮隐藏
function M:btnHide()
    self:stopStandbyTime()
    self:stopSoundEffect()
    self._canTouch = false
    self._isTouch  = false
    self._layer._canTouch = false
    A.line({
        {"union",{
            {"fadeout", 0.2},
            {"scaleTo", 0.2, 0}
        }},
        {"hide"}
    }):at(self)
end

-- 按钮显示
function M:btnShow()
    self:standbyTime()
    -- 音效
    soundEffect:playEffectsfx05708016()
    self._canTouch = true
    self._isTouch  = true
    self._layer._canTouch = true
    A.line({
        {"show"},
        {"union",{
            {"fadeTo", 0.2, 255},
            {"scaleTo", 0.2, 1.1}
        }},
    }):at(self)
end

-- 按钮遮罩动作
function M:btnMaskAct()
    A.cycle({
        {"union",{
            {"fadeout", 0.8},
            {"scaleTo", 0.8, 1.1},
        }},
        {"scaleTo", 0.1, 0.85},
        {"fadein", 0.1},
    }):at(self._btnMask)
end

-- 计算是否可以移动
function M:countIsMove()
    self._waitTime = 1.5
    if not self._countIsMoveAct then
        A.line({
            {"delay", 0.3},
            {"fn", function ()
                self._waitTime = 0
            end}
        }):at(self)
        self._moveSpeed = 40
        self._countIsMoveAct = nil
        -- 奇奇妙妙走路
        self:qmWalk()
    end
end

-- 结束移动
function M:stopCountIsMove(time)
    time = time or self._waitTime
    print(time)
    if not self._stopAct then 
        self._stopAct = A.line({
            {"delay", time},
            {"fn", function ()
                self._stopAct = nil
                self._canTouch = true
                if self._isMove then 
                    self:stopQmWalk()
                end
                self._moveSpeed = 0 
                if self._countIsMoveAct then
                    self:stopAction(self._countIsMoveAct)
                    self._countIsMoveAct = nil
                end
            end}
        }):at(self)
    end
end

-- 遇见停止
function M:meetStopAct()
    if self._stopAct then 
        self:stopAction(self._stopAct)
        self._stopAct = nil
    end
    self:stopQmWalk()
end

-- 奇奇妙妙走路
function M:qmWalk()
    self._isMove = true
    self._layer._mm:walkSideAni()
    self._layer._qq:walkSeeAni()
end

-- 停止奇奇妙妙走路
function M:stopQmWalk()
    self._isMove = false
    self._layer._mm:breatheSideAni()
    self._layer._qq:breathAni4()
end

-- 前进1
function M:playSoundEffect1()
    if not self._sfx05708003 then
        self._isContinue = true
        self._sfx05708003     = soundEffect:playEffectsfx05708003()
        sound.setFinishCallback(self._sfx05708003, function()
            if self._isContinue then 
                self:playSoundEffect2()
                self._sfx05708003 = nil
            end
        end)
    end
end

-- 前进2 
function M:playSoundEffect2()
    if not self._sfx05708004 then
        self._isContinue = true
        self._sfx05708004     = soundEffect:playEffectsfx05708004()
        sound.setFinishCallback(self._sfx05708004, function()
            if self._isContinue then 
                self:playSoundEffect1()
                self._sfx05708004 = nil
            end
        end)
    end
end

-- 停止前进音效
function M:stopSoundEffect()
    self._isContinue = false
    self._sfx05708003 = nil
    self._sfx05708004 = nil
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end
    self:stopStandbyTime()
    -- 音效
    self:playSoundEffect1()
    self._canTouch = false
    self:countIsMove()
    self:scale(1.2)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    if not self._isTouch then return end
    local px, py = Tools:dragLimit(self, x, y, self:cw(), V.w - self:cw() , self:ch(), V.h - self:ch())
    self:p(px, py)
    bb.si.Tool.limitRectMove({
        node      = self,
        -- marginTop = 80,
    })
    bb.si.Tool.limitButtonMove({node = self})
end

function M:onTouchEnded(x, y, touches, time)
    if not self._isTouch then return end
    self:standbyTime()
    self:stopSoundEffect()
    self:scale(1.1)
    self:stopCountIsMove(time)
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
