--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 书皮
----------------------
local M     = classSpriteTouch("DoorPage")
M.TAG       = "DoorPage"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer       = params.layer
    --触控
    self._canTouch    = false
    -- 初始旋转z角
    self._initZ       = 0
    -- 标记, 是否翻转到另一面, 1: 否, -1: 是
    self._a           = 1
    -- 页图片名
    self._pageImg     = params.pageImg or "tfdoor/door/door.png"
    -- 方向
    self._direction   = params.direction
    --翻转角度
    self._angle       = params.angle or 70
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- 翻页
    -- self:turnPage()
end

-- 图片渲染
function M:loadDisplay()
    self:display(self._pageImg):opacity(0)
end

-- 加载结点
function M:loadPageNode()
    -- 初始化
    self:init()
    -- 加载页面
    self:loadPage()
end

-- 初始化
function M:init()
    -- 页的大小
    self._pageSize = cc.size(self:ch(), self:cw())
end

-- 加载多边形精灵
function M:loadPolySprite(params)
    local image    = params.image
    local stretchY = ifnil(params.stretchY, 20)
    local sp = CCNodeExtend.extend(PolySprite:create(image))
    -- 多边形精灵翻转时拉伸的高度
    sp._stretchY = stretchY
    return sp
end

-- 加载页面
function M:loadPage()
    -- 加载多边形精灵
    local sp = self:loadPolySprite({
        image    = self._pageImg,
    }):to(self, 5):p(self:cw() / 2, self:ch() / 2)
    self._showImg = sp
end

--加载背面
function M:loadBack()
    local imgTb = { "handbook/book/3.png", "handbook/book2/3.png" }
    local back = self:loadPolySprite({
        image    = imgTb[self._bookType],
        stretchY = 50
    }):to(self, 10):p(self:cw() / 2, self:ch() / 2):bindTouch()--:scale(2)
    self._back = back
end

-- 凹陷
function M:sunken(node, posX, posY, isFlipX, size, offset)
    local size = ifnil(size, self._pageSize)
    -- 总长度
    local width = size.height
    -- 总高度
    local height = size.width
    -- 总下标数
    local num = 40
    -- 每格间距
    local span = width / num 
    -- 高度
    local y = { height / 2, 0, -height / 2 }
    local p = {}
    offset = ifnil(offset, 1)
    for i = 1, 3 do
        for j = 1, num do
            local number = isFlipX == true and num - j or j - 1
            local x    = width /  (num - 1) * (j - num) + width / 2 + posX / (num - 1) * number
            if i == 1 then
                table.insert(p, cc.p(x, y[i] + posY / (num - 1) * number * offset * 0.1))
            elseif i == 2 then -- 正常位置
                table.insert(p, cc.p(x, y[i]))
            elseif i == 3 then
                table.insert(p, cc.p(x, y[i] + posY / (num - 1) * number * offset))
            end
        end
    end
    node:setVertices(Tools:meshVerticesAndTexcoords(3, num, p))
end


-- 翻页
function M:turnPage(type, callBack)
    type = ifnil(type, "open")
    local angle = type == "open" and self._angle or - self._angle 
    print(angle)
    local time = 1
    self:line({
        { "OrbitCamera", time, 1, 0, self._initZ, angle, 0, 0 }, -- 水平翻转-180度
        {"fn", function ()
            -- self._layer._center:z(50)
            -- if self._layer._rightDownPage then
            --     self._layer._rightDownPage:z(3)
            -- end

            -- if self._layer._rightPage then
            --     self._layer._rightPage:z(60)
            -- end
        end}
    })
    if type == "open" then
        self:changeAction(time, callBack)
    else
        -- 翻页动作, times-翻页时间
        self:changeAction2(time, callBack)
    end
    
end


-- 翻页动作, times-翻页时间
function M:changeAction(times, callBack)
    local isLeft = self._direction == "left" and true or false
    print(isLeft)
    -- if self._a == -1 then
    --     isLeft = not isLeft
    -- end
    local time = 0
    local offset = 1
    self:line({
        A.cycle({
            { "delay", 1 / 60 },
            { "fn", function()
                time = time + 1
                offset = 0.6--offset * 1.1
                self:sunken(self._showImg, 0, self._showImg._stretchY / 30 * time, isLeft, nil, offset)
                -- if self._a == -1 then
                --     self:sunken(self._back, 0, self._showImg._stretchY / 30 * time, isLeft)
                -- end
            end },
        }, times * 60),
        { "fn", function()
            if self._initZ == 0 then
                self._initZ = self._angle
                self._a = -1
            else
                self._initZ = 0
                self._a = 1
            end
            if callBack then
                callBack()
            end
        end }
    })
end

-- 翻页动作, times-翻页时间
function M:changeAction2(times, callBack)
    local isLeft = self._direction == "left" and true or false
    print(isLeft)
    -- if self._a == -1 then
    --     isLeft = not isLeft
    -- end
    local time = 60
    local offset = 1
    self:line({
        A.cycle({
            { "delay", 1 / 60 },
            { "fn", function()
                time = time - 1
                offset = 0.6--offset * 1.1
                self:sunken(self._showImg, 0, self._showImg._stretchY / 30 * time, isLeft, nil, offset)
                -- if self._a == -1 then
                --     self:sunken(self._back, 0, self._showImg._stretchY / 30 * time, isLeft)
                -- end
            end },
        }, times * 60),
        { "fn", function()
            if self._initZ == 0 then
                self._initZ = self._angle
                self._a = -1
            else
                self._initZ = 0
                self._a = 1
            end
        end }
    })
end

-- -- 更新页面
-- function M:updatePage()
--     if self._back then 
--         self._back:z(10)
--         self._showImg:z(9)
--         return 
--     end
--     local isLeft = self._direction == "left" and true or false
--     if self._a == -1 then
--         isLeft = not isLeft
--     end
--     --加载背面
--     self:loadBack()
--     self:sunken(self._showImg, 0, self._showImg._stretchY, isLeft)
--     self:sunken(self._back, 0, self._back._stretchY, isLeft)
--     -- self:sunken(self._pageBase, 0, self._pageBase._stretchY, isLeft, self._pageBase._size)
-- end

-- -- 翻页完成
-- function M:turnFin()
--     if self._direction == "left" then
--         self._main._page[1]:remove()
--         self._main._page[1] = self
--     elseif self._direction == "right" then
--         self._main._page[2]:remove()
--         self._main._page[2] = self
--     end
--     self:z(20)
--     self._main._isFlipPage = false
--     self._isTurn = false
-- end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    -- if self._layer._canTouch then
    --     if self._canTouch then
    --         return true
    --     end
    -- end
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
