--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Gift")
M.TAG       = "Gift"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = false
    -- 点击的礼物id
    self._index    = params.index
    -- 点击的哪一个
    self._type     = params.type
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end


-- 加载结点
function M:loadPageNode()
    -- local goods = D.img("nyvisit/gift/"..self._index..".png"):to(self, 5):scale(1):p(75, 72)
end

-- 其他商品消失
function M:otherThing()
    for i, v in ipairs(self._layer._giftTab) do
        if i ~= self._type then 
            A.line({
                {"union",{
                    {"scaleTo", 0.35, 0},
                    {"rotateBy", 0.35, 360},
                }},
            }):at(v)
        end
    end
end

-- 商品语音
function M:goodsSound(index)
    local indexTab = {"v057184", "v057188", "v057187", "", "v057189", "v057194"}
    -- 播放配音
    soundVoice["playEffect"..indexTab[index]](soundVoice)
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._layer._canTouch then return end
    -- 音效
    soundEffect:playEffectsfx05708006()
    -- 商品语音
    self:goodsSound(self._index)
    self._layer._canTouch = false
    table.remove(G_GIFT_TB, self._type)
    self:z(9999)
    A.line({
        {"union",{
            {"scaleTo", 0.5, 1.8},
            {"rotateBy", 0.5, 360},
            {"jumpTo", 0.5, ccp(245, 180), 100, 1}
        }},
        {"fn", function ()
            soundEffect:playEffectsfx05700013()
            Tools:loadLightAndParticle(self, self._layer, nil, 2, 2, 1.2)
        end},
        {"delay", 1.8},
        {"fn", function ()
            self._layer:close(self._index)
        end},
    }):at(self)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return end
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
