--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Home")
M.TAG       = "Home"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer     = params.layer
    --触控
    self._canTouch  = false
    -- 家的id
    self._index     = params.index
    -- 门表
    self._doorTab   = {}
    -- 门拴表
    self._fastenTab = {}
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- self._layer._node:p(-2200, 0)
end

-- 加载结点
function M:loadPageNode()
    -- 加载屋顶
    self:loadRoof()
    if self._index == 1 then
        -- 加载奇妙家
        self:loadQmHome()
    elseif self._index == 2 then 
        -- 加载美美家
        self:loadMeiHome()
    elseif self._index == 3 then 
        -- 加载皮皮家
        self:loadPiHome()
    elseif self._index == 4 then 
        -- 加载闹闹家
        self:loadNaoHome()
    end
    if self._index > 1 then 
        local pos = {"", ccp(186, 35), ccp(180, 51), ccp(195, 51)}
        -- 加载特效在门上
        local effect = D.img("nyvisit/knock/effect/1.png"):to(self, 200):anchor(cc.p(0, 0)):p(pos[self._index]):scale(0.9):hide()--:bindTouchLocate()
        self._effect = effect
    end
end

-- 加载屋顶
function M:loadRoof()
    local pos = {ccp(-88.2, 323.2), ccp(-27.0, 317.8), ccp(-89.4, 302.5), ccp(-14, 335)}
    local scaleTab = {1, 1.1, 1, 1.1}
    local roof = D.img("nyvisit/home"..self._index.."/2.png"):to(self, 10):anchor(cc.p(0, 0)):p(pos[self._index]):scale(scaleTab[self._index])--:bindTouchLocate()
    local posTab = {
        {ccp(188.3, 157.2), ccp(353.6, 159.7), ccp(440.3, 159.1), ccp(215.7, 28.1)},
        {ccp(181.8, 165.6), ccp(278.2, 161.0), ccp(70.6 , 32.0 ), ccp(411.1, 32.8)},
        {ccp(210.7, 165.8), ccp(353.9, 158.0), ccp(464.4, 44.8)},
        {ccp(265.0, 132.2), ccp(350.8, 132.4), ccp(56.5, 18.4), ccp(121.1, 21.2)}
    }
    local canRainTab = {
        {0, 0, 0, 1},
        {0, 0, 1, 1},
        {0, 0, 1},
        {0, 0, 1, 1}
    } 
    local index = 4
    if self._index == 3 then index = 3 end
    -- 加载雪
    for i = 1, index do 
        local snow = D.img("nyvisit/home"..self._index.."/snow/"..i..".png"):to(roof, 10):anchor(cc.p(0.5, 1)):p(posTab[self._index][i])--:bindTouchLocate()
        --  加载粒子
        if canRainTab[self._index][i] == 1 then 
            local particle = Tools:newParticle("particle/waterdown.plist", 30, 0):to(snow, 999):scale(0.8)
            Tools:insertParticleTb(self._layer, particle)
            particle:setPositionType(kCCPositionTypeRelative)
        end
    end
end

-- 加载奇妙家
function M:loadQmHome()
    for i = 1, 2 do 
        local pos = {ccp(106.9, 143.2), ccp(367.8, 143.2)}
        local pos1 = {ccp(21, 327), ccp(455.1, 327)}
        local pos2 = {cc.p(0, 0.5), cc.p(1, 0.5)}
        local pos3 = {ccp(78.2, 132.8), ccp(55.3, 132.8)}
        local directionTab = {"right", "left"}
        local flip = false
        if i == 2 then flip = true end
        -- 加载门
        local door  = import("app.nyvisit.node.DoorPage").new({
            layer   = self._layer,
            direction = directionTab[i],
            pageImg =  "nyvisit/home"..self._index.."/door/"..i..".png",
        }):to(self, -1):p(pos[i]):anchor(pos2[i]):scale(1)--:bindTouchLocate()
        local bless = D.img("nyvisit/home2/4.png"):to(door, 999):p(pos3[i]):scale(0.8)
        table.insert(self._doorTab, door)
        -- 加载灯笼
        local lantern = D.img("nyvisit/home"..self._index.."/3.png"):to(self, 5):anchor(cc.p(0.5, 1)):p(pos1[i])--:bindTouchLocate()
        self._layer:swingAction(lantern)
    end
    -- 加载里面的景
    local inside = D.img("nyvisit/home"..self._index.."/inside.png"):to(self, -30):anchor(cc.p(0, 0)):p(ccp(106.0, 50.3)):scale(1.05)--:bindTouchLocate()
end

-- 加载美美家
function M:loadMeiHome()
    for i = 1, 2 do 
        local pos = {ccp(97, 150), ccp(405, 150)}
        local pos1 = {ccp(21, 210), ccp(455.1, 210)}
        local pos2 = {ccp(125, 91.0), ccp(28, 91.0)}
        local pos3 = {cc.p(0, 0.5), cc.p(1, 0.5)}
        local directionTab = {"right", "left"}
        local time = {0.9, 1.1}
        local flip, flip1 = false, true
        if i == 2 then flip, flip1 = true, false end
        -- 加载门
        local door  = import("app.nyvisit.node.DoorPage").new({
            layer   = self._layer,
            direction = directionTab[i],
            pageImg =  "nyvisit/home"..self._index.."/door/"..i..".png",
        }):to(self, -1):p(pos[i]):anchor(pos3[i]):scale(1)
        table.insert(self._doorTab, door)
        -- 加载灯笼
        local dragon = DragonBone.addFileAndPlay("bone/dl2", "dl_bones1", "dl_pd_1", time[i]):to(self):p(pos1[i])
        -- 加载门拴
        local fastens = D.img("nyvisit/knock/fasten"..self._index.."/1.png"):to(door, 300):p(pos2[i]):scale(0.5):flipX(flip1)--:bindTouchLocate()
        table.insert(self._fastenTab, fastens)
    end
    -- 加载里面的景
    local inside = D.img("nyvisit/home"..self._index.."/inside.png"):to(self, -5):anchor(cc.p(0, 0)):p(ccp(50, 40)):scale(0.98)--:bindTouchLocate()
end

-- 加载皮皮家
function M:loadPiHome()
    local pos = {ccp(108, 155), ccp(374, 155)}
    local pos1 = {ccp(7, 305), ccp(483.1, 308.9)}
    local pos2 = {ccp(120, 92.0), ccp(29, 92)}
    local pos3 = {cc.p(0, 0.5), cc.p(1, 0.5)}
    local directionTab = {"right", "left"}
    for i = 1, 2 do 
        local door  = import("app.nyvisit.node.DoorPage").new({
            layer   = self._layer,
            direction = directionTab[i],
            pageImg =  "nyvisit/home"..self._index.."/door/"..i..".png",
        }):to(self, -1):p(pos[i]):anchor(pos3[i]):scale(0.9)
        table.insert(self._doorTab, door)
        -- 加载灯笼
        local lantern = D.img("nyvisit/home"..self._index.."/3.png"):to(self, 5):anchor(cc.p(0.5, 1)):p(pos1[i])--:bindTouchLocate()
        self._layer:swingAction(lantern)
        -- 加载门拴
        local fastens = D.img("nyvisit/knock/fasten"..self._index.."/1.png"):to(door, 300):p(pos2[i]):scale(0.5)--:bindTouchLocate()
        table.insert(self._fastenTab, fastens)
    end
    -- 加载里面的景
    local inside = D.img("nyvisit/home"..self._index.."/inside.png"):to(self, -5):anchor(cc.p(0, 0)):p(ccp(75, 30)):scale(0.9)--:bindTouchLocate()
end

-- 加载闹闹家
function M:loadNaoHome()
    local time = {0.9, 1.1}
    local pos = {ccp(135.5, 145), ccp(383.5, 145)}
    local pos1 = {ccp(21, 235), ccp(490, 235)}
    local pos2 = {ccp(104, 105.4), ccp(21.5, 105.4)}
    local pos3 = {cc.p(0, 0.5), cc.p(1, 0.5)}
    local directionTab = {"right", "left"}
    for i = 1, 2 do 
        -- 加载门
        local door  = import("app.nyvisit.node.DoorPage").new({
            layer   = self._layer,
            direction = directionTab[i],
            pageImg =  "nyvisit/home"..self._index.."/door/"..i..".png",
        }):to(self, -1):p(pos[i]):anchor(pos3[i])
        -- local door = D.img("nyvisit/home"..self._index.."/door/1.png"):to(self, 10):anchor(cc.p(0, 0)):p(pos[i])--:bindTouchLocate()
        table.insert(self._doorTab, door)
        -- 加载灯笼
        local dragon = DragonBone.addFileAndPlay("bone/dl2", "dl_bones1", "dl_pd_1", time[i]):to(self):p(pos1[i])
        -- 加载门拴
        local fastens = D.img("nyvisit/knock/fasten"..self._index.."/1.png"):to(door, 300):p(pos2[i]):scale(0.4)--:bindTouchLocate()
        table.insert(self._fastenTab, fastens)
    end
    -- 加载里面的景
    local inside = D.img("nyvisit/home"..self._index.."/inside.png"):to(self, -5):anchor(cc.p(0, 0)):p(ccp(110, 47.6)):scale(1.15)--:bindTouchLocate()
end

-- 开门
function M:openDoor()
    local indexTab = {0, 12, 11, 13} 
    local time = indexTab[self._index] * 0.1 * 0.8
    local name = "nyvisit/knock/fasten"..self._index.."/"
    if self._index > 1 then
        for i, v in ipairs(self._fastenTab) do
            if i == 1 then 
                A.line({
                    {"imagerange", name, 1, indexTab[self._index], 0.06},
                    {"imagerange", name, 1, indexTab[self._index], 0.06},
                }):at(v)  
            end
        end
        -- 敲门特效
        self:knockEffect(time)
    end
    A.line({
        {"delay", time * 3},
        {"fn", function ()
            local nameTab  = {"", self._layer._meimei, self._layer._pipi, self._layer._naonao}
            if self._index > 1 then 
                nameTab[self._index]:moveOutDoor()
            end
            self:openDoorAct()
        end},
    }):at(self)
end

-- 敲门特效
function M:knockEffect(time)
    A.line({
        {"delay", time - 0.4},
        {"show"},
        {"union",{
            {"imagerange", "nyvisit/knock/effect/", 1, 4, 0.1},
            {"line", {
                {"delay", 0.1},
                {"fn", function()
                    -- 音效
                    soundEffect:playEffectsfx05708005()
                end},
            }},
        }},
        {"hide"},
        {"delay", time - 0.55},
        {"show"},
        {"imagerange", "nyvisit/knock/effect/", 1, 4, 0.1},
        {"hide"},
    }):at(self._effect)
end

-- 开门帧动画
function M:openDoorAct()
    -- 音效
    soundEffect:playEffectsfx05708001()
    -- 音效
    soundEffect:playEffectsfx05708002()
    local name1 = "nyvisit/home"..self._index.."/door/"
    for i, v in ipairs(self._doorTab) do
        if self._index >= 3 then
            name1 = "nyvisit/home"..self._index.."/door/"..i.."/"
        end
        v:turnPage("open")
    end
end

-- 关门
function M:closeDoor()
    for i, v in ipairs(self._doorTab) do
        v:turnPage("close")
    end
end

-- 雪的动作
function M:snowAct(node)
    local num = math.random(105, 118)/100
    local time = 1.4
    self._snowAct = A.line({
        {"scaleTo", time, 1, num},
        {"scaleTo", time, 1},
        {"scaleTo", time, 1, num},
        {"scaleTo", time, 1},
        {"fn", function ()
            return self:snowAct(node)
        end}
    }):at(node)
end



--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
