--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("List")
M.TAG       = "ListNode"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    -- 礼物表
    self._giftTab  = {}
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end


-- 加载结点
function M:loadPageNode()
    -- 播放配音
	-- soundVoice:playEffectv057023()
    -- 生成清单
    -- self:createList()
    -- 加载遮罩
    self:loadMask()
    -- self._layer._totalCount = 5
    -- 加载礼物盒
    self:loadGiftBox()
    -- 加载物品
    self:loadItem()
end

-- 加载礼物盒
function M:loadGiftBox()
    local box = D.img("nyvisit/box/2.png"):to(self, 2200):p(V.w_2, 80 + Y_OFFSET):scale(0):opacity(0):anchor(ccp(0.5, 0)):bindTouch()
    local cover = D.img("nyvisit/box/1.png"):to(box, 100):p(250, 60):anchor(ccp(0.5, 0))--:bindTouchLocate()
    self._box = box
    self._cover = cover
    self:enter()
end

-- 盒子进场动作
function M:enter()
    -- 去广告
    Tools:closeAd()
    -- 音效
    soundEffect:playEffectsfx05708030()
    A.line({
        {"union", {
            {"fadeTo", 0.2, 255 },
            {"easing", "backout", {"scaleTo", 0.5, 1}}
        }},
        {"fn", function ()
            local time1 = 0.04
            self._box:line({
                { "scaleTo", 0.35, 0.95, 1.08},
                { "scaleTo", 0.3, 1.1, 0.95},
                { "scaleTo", 0.2, 0.95, 1.08},
                { "scaleTo", 0.3, 1.15, 0.85},
                { "scaleTo", 0.25, 1 },
            })
            self._cover:line({
                {"moveby", 0.3, ccp(0, 10)},
                {"moveby", 0.3, ccp(0, -10)},
                {"moveby", 0.3, ccp(0, 10)},
                {"moveby", 0.3, ccp(0, -10)},
            })
            self._cover:cycle({
                { "moveby", 0.05, ccp(-2, 2) },
                { "moveby", 0.05, ccp(2, -2) },
            })
            self._cover:cycle({
                {"rotateBy", time1, -2},
                {"rotateBy", time1, 2},
                {"rotateBy", time1, 2},
                {"rotateBy", time1, -2},
            })
        end},
        {"delay", 1.4},
        {"fn",function ()
            -- 播放配音[v057128]选个年货送给他吧~
            soundVoice:playEffectv057128()
            -- 打开盒子
            self:openBox()
        end}
    }):at(self._box)
end

-- 打开盒子
function M:openBox()
    self._cover:rotate(0)
    self._cover:stopAllActions()
    self._box:stopAllActions()
    self._cover:line({
        {"moveBy", 0.2, ccp(0, -15)},
        {"moveBy", 0.1, ccp(0, 40)},
        A.union({
            {"rotateBy", 0.5, -180},
            {"jumpTo", 0.5, ccp(-500, 370), 350, 1},
            {"fn", function ()
                 -- 商品弹动
                self:bounce() 
            end}
        }),
        {"fn",function ()
            -- 加广告
            Tools:openAd()
            self._cover:hide()
            self._canTouch = true
        end},
    })
end

-- 弹动
function M:bounce()
     -- 商品跳动
     for i, v in ipairs(self._giftTab) do
        local number = RD.number(5, 10)
        local time   = RD.number(5, 10) * 0.015
        A.line({
            {"moveBy", time, ccp(0,  number)},
            {"moveBy", time, ccp(0, -number)},
            {"fn", function ()
                commonAct:nodeScale(v, 0.1, 0.1)
            end}
        }):at(v)
    end
end

-- 生成清单
function M:createList()
    T.clear(self._layer._listTab)
    for i = 1, 6 do 
        local kind1, kind2 = 1, 5
        if i == 3 or i == 4 then 
            kind1 = 6
            kind2 = 9
        elseif i > 4 then 
            kind1 = 10
            kind2 = 13
        end
        local num1 = self:createRandom(kind1, kind2, 6, self._layer._listTab)
    end
end


-- 随机数
function M:createRandom(kind1, kind2, index, randomTab)
    if #randomTab == index then 
    T.clear(randomTab)
    end
    local num = N.randomExcept(kind1, kind2, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 加载物品
function M:loadItem()
    if not self._box or tolua.isnull(self._box) then return end
    local posTab = {
        {ccp(-145, 65), ccp(-2.5, 65), ccp(140, 65), ccp(-75, -55), ccp(77.5, -55)},
        {ccp(-90, 65), ccp(85, 65), ccp(-90, -55), ccp(85, -55)},
        {ccp(-145, -2.5), ccp(-2.5, -2.5), ccp(140, -2.5)},
        {ccp(-90, -2.5), ccp(85, -2.5)},
        {ccp(2.5, -2.5)},
    }
    local indexTab = {5, 4, 3, 2, 1}
    for i = 1, indexTab[self._layer._totalCount] do
        local pos = posTab[self._layer._totalCount][i]
        local index = G_GIFT_TB[i]
        if index then
            local gift = import("app.nyvisit.node.Gift").new({
                imgName = "nyvisit/gift/"..index..".png",
                layer   = self,
                index   = index,
                type    = i
            }):to(self._box, 50):p(ccp(pos.x + 250, pos.y + 190)):scale(1):bindTouch()
        end

        table.insert(self._giftTab, gift)
    end
end


-- 加载遮罩
function M:loadMask()
    local mask = U.loadNodeMask({
		contentSize = cc.size(V.w + 100, V.h + 100),
		color 		= ccc3(0, 0, 0)
    }):anchor(cc.p(0.5, .5)):p(V.w_2, V.h/2):opacity(180):to(self, 1):scale(1.1):bindTouch( {rectFactorX = 5,rectFactorY = 5,})
    self._mask = mask
end



-- 关闭
function M:close(index)
    -- 音效
    soundEffect:playEffectsfx05700012()
    self:stopAllActions()
    self._box:line({
        {"union", {
            {"fadeTo", 0.5, 0},
            {"scaleTo", 0.5, 0},
            {"jumpTo", 0.5, ccp(345 + X_OFFSET, 125 + Y_OFFSET), 100, 1}
        }},
        {"fn", function ()
            -- 到位置
            self:intoQq(index)    
        end},
    })
end

-- 到ui栏位置
function M:intoQq(index)
    self:unbindTouch()
    -- 移除遮罩
    self._mask:remove()
    A.line({
        {"fn", function ()
            if self._layer._totalCount % 2 ~= 0 then 
                -- 奇奇背面递出礼物
                self._layer._qq:backGiftAni(index)
            else
                -- 奇奇正面递出礼物
                self._layer._qq:giveAni(index) 
            end
        end},
        {"remove"},
    }):at(self._box)
end

-- 游戏开始
function M:gameBegin()
    -- 打开触控
    self._layer._isMove = false
    self._layer._bgMove._canTouch = true
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
