--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("NewCake")
M.TAG       = "NewCake"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = true
    -- 点击的哪一块年糕
    self._index    = params.index
    -- 层级表
    self._scaleTab = {100, 200, 300, 400, 500}
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- 开启引导
end


-- 加载结点
function M:loadPageNode()
   
end

function M:openGuide()
    for i, v in ipairs(self._layer._newCakeTab) do
        for i, t in ipairs(self._layer._isPutTab) do
            if t == false then 
                self._layer._newCakeTab[i]:scale(1)
                -- 开启引导
                guideFn:openGuide(self._layer._newCakeTab[i], 0.1, 3, 1)
                return
            end
        end
    end
end

-- 停止引导
function M:stopGuide()
    for i, v in ipairs(self._layer._newCakeTab) do
        -- 关闭引导
        guideFn:stopGuide(v)
    end
end

-- 返回
function M:back()
    self._layer._cakeCanTouch = false
    local pos = {ccp(218.8, 173.7), ccp(287.4, 173.9), ccp(353.8, 173.7), ccp(422.3, 172.5), ccp(484.6, 169.1)}
    A.line({
        {"union",{
            {"jumpto", 0.3, pos[self._index], 70, 1},
            {"fn", function()
                --音效
                soundEffect:playEffectsfx05700008()
            end},
        }},
        {"fn", function ()
            self:openGuide()
            self:beat1()
            self:z(self._scaleTab[self._index])
        end},
        {"delay", 0.25},
        {"fn", function ()
            self._layer._cakeCanTouch = true
        end}
    }):at(self)
end

-- 跳动
function M:beat()
    -- 商品跳动
    for i, v in ipairs(self._layer._isPutTab) do
        if v then  
            local number = RD.number(5, 10)
            local time   = RD.number(5, 10) * 0.01
            A.line({
                {"moveBy", time, ccp(0,  number)},
                {"moveBy", time, ccp(0, -number)},
                {"fn", function ()
                    commonAct:nodeScale(self._layer._newCakeTab[i], 0.3, 0.3)
                end}
            }):at(self._layer._newCakeTab[i])
        end
    end 
end

function M:beat1()
    -- 商品跳动
    for i, v in ipairs(self._layer._isPutTab) do
        if not v then  
            local number = RD.number(5, 10)
            local time   = RD.number(5, 10) * 0.01
            A.line({
                {"moveBy", time, ccp(0,  number)},
                {"moveBy", time, ccp(0, -number)},
                {"fn", function ()
                    commonAct:nodeScale(self._layer._newCakeTab[i], 0.3, 0.3)
                end}
            }):at(self._layer._newCakeTab[i])
        end
    end 
end

-- 放置
function M:put()
    self._layer._cakeCanTouch = false
    self._canTouch = false
    self._layer._isPutTab[self._index] = true
    local pos = {ccp(-60, 75), ccp(-20, 75), ccp(20, 75), ccp(60, 75), ccp(95, 72.5)}
    A.line({
        {"union",{
            {"jumpto", 0.5, pos[self._index], 100, 1},
            {"scaleTo", 0.5, 0.55},
        }},
        {"fn", function ()
            --音效
            soundEffect:playEffectsfx05708024()
            self:z(self._scaleTab[self._index])
            self:beat()
            self:openGuide()
        end},
        {"delay", 0.25},
        {"fn", function ()
            self._layer._cakeCanTouch = true
        end}
    }):at(self)
    self._layer._cakeCount = self._layer._cakeCount + 1
    if self._layer._cakeCount == 5 then 
        self:loadAboveCover()
    end
end

-- 加载上层盖子
function M:loadAboveCover()
    local aboveCover = D.img("nyvisit/home3/second/install/cover3.png"):to(self._layer._box._box, 999):p(-350, 160):scale(1.065)
    A.line({
        {"union",{
            {"jumpBy", 0.7, ccp(365, -25), 50, 1},
            {"rotateBy", 0.7, 360},
            {"fn", function ()
                soundEffect:playEffectsfx05708025()
            end},
        }},
        --音效
        {"moveBy", 0.2, ccp(0, -52)},
        {"fn", function ()
            commonAct:nodeScale(self._layer._cover, 0.3, 0.5)
            commonAct:nodeScale(self._layer._cover._coverMask, 0.3, 0.5)
            commonAct:nodeScale(aboveCover, 0.2, 0.2)
        end},
        {"delay", 1},
        {"fn", function ()
            self:showCover(aboveCover)
        end},
        {"delay", 1},
    }):at(aboveCover)
end

-- 展示
function M:showCover(node)
    self._layer._cover._coverMask:hide()
    Tools:resetParent(self._layer._cover, self._layer, 9999)
    Tools:resetParent(node, self._layer._cover, 90)
    for i, v in ipairs(self._layer._newCakeTab) do
        Tools:resetParent(v, self._layer._cover, 80)
    end
    A.line({
        {"union",{
            {"jumpTo", 0.5, ccp(V.w_2, V.h_2 - 50), 50, 1},
            --缩放
            {"scaleTo", 0.5, 1.25},
        }},
        {"fn", function ()
            Tools:loadLightAndParticle(self._layer._cover, self._layer, nil, 2, 2, 1.2)
        end},
        {"delay", 1.8},
        {"fn", function ()
            self._layer._cover:unbindTouch()
            A.line({
                {"delay", 0.5},
                {"scaleTo", 0.25, 0},
                {"remove"}
            }):at(self._layer._cover)
            self._layer._box:quit()
            -- 皮皮回礼
            self._layer._pipi:reply()
        end},
    }):at(self._layer._cover)
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end
    if not self._layer._cakeCanTouch then return end
    self:stopGuide()
    self:z(1000)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    if not self._canTouch then return end
    if not self._layer._cakeCanTouch then return end
    self:p(x - 100 - X_OFFSET, y + 10 - Y_OFFSET)
    bb.si.Tool.limitRectMove({
        node      = self,
        -- marginTop = 80,
    })
    bb.si.Tool.limitButtonMove({node = self})
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return end
    if not self._layer._cakeCanTouch then return end
    self._layer._cakeCanTouch = false
    if self:py() <= 175 then 
        if self:px() <= 165 and self:px() >= -100 then 
            self:put()
        else 
            self:back()
        end
    else
        self:back()
    end
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
