--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch = true
    --是否结束
    self._isOver = false
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 加载背景
    self:loadBg()
    -- 加载结点
    self:loadPageNode()
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
    --[友盟][bbgcj002]开场动画进入
    umengOP.recordbbgcj002()
    --开始歌谣
    -- self:startOpenAni()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- 播放音效[057BGM02]开场动画、图鉴-春节歌谣
    sound:play057BGM02()
    --开始歌谣
    self:startOpenAni()
end

--加载背景
function M:loadBg()
    local bg = U.loadBg("handbook/bg1.png"):to(self)
    self._bg = bg
    bg:plan(function ()
        bg:display("handbook/bg.png")
    end, 2)
end

-- 加载结点
function M:loadPageNode()
    --加载歌谣书本
    self:loadOpenAni()
    --加载开场首页剪纸
    self:loadOpenPage()
    --加载剪纸
    self:loadRoundPage()
end

--加载歌谣书本
function M:loadOpenAni()
    local enterPos = cc.p(V.w_2 - 150, V.h_2 - 40)
    -- 加载书本节点
    local bookNode = self:createNode("Book", {
        layer    = self,
        autoFlip = true,
        bookType = 1,
    }):to(self):p(V.w_2 - 50, V.h + 200):scale(0.5):rotate(-30)
    self._bookNode = bookNode
end

--开始歌谣
function M:startOpenAni()
    self._bookNode:scale(1.3):p(V.w_2 + 20, V.h_2 - 40):rotate(0)
    self:scale(1.65):p(0, 80)
    --开场动画打开书本
    self._bookNode:openAniOpenBook()
end

--加载跳过建
function M:loadSkip()
    if ST.getNumber("FIRST_ENTER_ENTERANI") == 0 then
        self:plan(function ()
            --跳过按钮显示
            self:getScene():getButtonLayer():skipBtnShow()
        end, 0.7)
    end
end

--整体放大
function M:zoomIn()
    self:line({
        { "union", {
            { "scaleto", 1, 1.65 },
            { "moveby", 1, cc.p(0, 80) }
        } }
    })
end

--整体恢复
function M:zoomOut()
    self._isOver = true
    self:stopAllActions()
    self:line({
        { "union", {
            { "scaleto", 0.8, 1 },
            { "moveto", 0.8, cc.p(0, 0) }
        } },
        { "delay", 0.1 + 1 },
        { "fn", function()
            game:enterScene("openani2", {}, "fade", 0.5, COLOR3_WHITE)
        end }
    })
    local enterPos = cc.p(V.w_2 - 150, V.h_2 - 40)
    self._bookNode:line({
        {"union", {
            { "scaleto", 0.8, 1},
            { "moveto", 0.8, enterPos }
        }}
    })
    --关闭书本
    self._bookNode:closeBook()
    --剪纸隐藏掉
    self:paperHide()
end

--剪纸隐藏掉
function M:paperHide()
    for i, v in ipairs(self._pageTb) do
        if not tolua.isnull(v) then
            v:stopAllActions()
            if v._replaceImg and not tolua.isnull(v._replaceImg) then
                v._replaceImg:stopAllActions()
                v._replaceImg:line({
                    { "fadeto", 0.2, 0 },
                    { "remove",}
                })
            end
            --子节点跟随父节点透明度
            v._moveNode:setCascadeOpacityEnabled(true)
            v._moveNode:line({
                { "fadeto", 0.2, 0 },
                { "fn", function()
                    v:remove()
                end }
            })
        end
    end
    if not tolua.isnull(self._openPage) then
        self._openPage:line({
            { "fadeto", 0.2, 0 },
            { "fn", function()
                self._openPage:remove()
            end }
        })
    end
end

--加载开场首页剪纸
function M:loadOpenPage()
    local openPaper = import("app.openani1.node.OpenPaper").new({
        layer       = self,
        scaleSize    = 1/1.65
    }):to(self):p(V.w_2, V.h_2 - 40):opacity(0):scale(1.2 / 1.65):hide()
    self._openPage = openPaper
end


--加载剪纸
function M:loadRoundPage()
    local config = {
        ccp(0, 0),
        ccp(500, 0),
        ccp(0, 0),
        ccp(0, 0),
        ccp(0, 300),
        ccp(0, 300),
        ccp(0, 0),
        ccp(500, 0),
        ccp(0, 0),
        ccp(500, 0),
    }
    self._pageTb = {}
    for i, v in ipairs(config) do
        local page = self:loadPage(i, v):hide()
        table.insert(self._pageTb, page)
    end
end


--剪纸动起来
function M:paperMove()
    --进场
    self._openPage:enter()
    self:line({
        {"Delay", 5},
        {"fn", function ()
            self._openPage:quit(function ()
                local id = 1
                self._pageTb[id]:enter(function()
                    --播放歌谣
                    self:delayPlaySound(id)
                end)
            end)
        end}
    })
end

--播放歌谣
function M:delayPlaySound(index)
    --剪纸一 腊八粥  --剪纸二 糖瓜粘 --剪纸三 扫房子 --剪纸四 冻豆腐 --剪纸五 去买肉
    --剪纸六 宰公鸡  --剪纸七 把面发 --剪纸八 蒸馒头 --剪纸九 熬一宿 --剪纸十 满街走
    local timeTb = {
          3.5, 2, 1.5, 1.3, 1.3, 
        1.3, 1,   1,   1, 1.5}
    local time = timeTb[index]
    self:line({
        { "Delay", time},
        {"fn", function ()
            if self._isOver then
               return 
            end
            self._pageTb[index]:quit(function()
                if index + 1 <= 10 then
                    self._pageTb[index + 1]:enter(
                    function()
                        self:delayPlaySound(index + 1)                        
                    end
                    )
                else
                    if ST.getNumber("FIRST_ENTER_ENTERANI") ~= 0 then
                        ST.setNumber("FIRST_ENTER_ENTERANI", 0)        
                    end
                    --整体恢复
                    self:zoomOut()
                end
            end)
        end},
    })
end


--加载剪纸
function M:loadPage(id, pos, zNum, opacityNum, size)
    zNum = ifnil(zNum, 999)
    size = ifnil(size, 1)
    opacityNum = ifnil(opacityNum, 255)
    local enterPos = ccp(V.w_2, V.h_2 - 60)
    local offsetPos = ccp(enterPos.x +  pos.x, enterPos.y + pos.y)
    local book = import("app.openani1.node.Paper")
    local rightPage = book.new({
        layer     = self,
        id        = id,
        bookType  = 1,
        opciatyNum=opacityNum
    }):to(self, zNum):p(offsetPos):scale(size)
    rightPage._pos = enterPos
    return rightPage
end


--进入下个场景
function M:enterNextScene()
    --整体恢复
    self:zoomOut()
end

-- 加载其他
function M:loadRenderOtherwise()

end

--移除粒子表
function M:removeParticleTb(node1)
    if node1 and not tolua.isnull(node1) then
        if node1._myParticleTb then
            for k, particle in pairs(node1._myParticleTb) do
                self:removeParticle(particle)
            end
        end
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    -- 清除图片资源
    R.removeAllTextures()
    R.removeAllFrames()
    -- 清除骨骼资源
    bb.si.DragonBone.removeAll()
    -- 停止音频
    sound.stopAllSounds()
end

return M
