--[[
Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

----------------------
-- 页面纸张基类
----------------------

local M = classSpriteTouch("BasePage")
M.TAG   = "BasePage"

----------------------
-- 构造方法
----------------------

function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    -- 主层
    self._layer         = params.layer
    -- 书页索引
    self._pageId        = ifnil(params.pageId, 1)
    -- 对象页面
    self._targetPage    = params.targetPage
    -- 书本总页数
    self._totalPage     = ifnil(params.totalPage, 1)--params.totalPage
    -- 图片路径
    self._path          = params.path
    -- 是否为拍照的页面
    self._isPhotoNode   = ifnil(params.isPhotoNode, false)
    -- 创建的模块照片集合
    self._moduleTab     = {{nil, nil}, {nil, nil}, {1, 2}, {3, 4}, {5, 6}, {7, nil}}
    -- 模块照片的集合
    self._photos        = {}
    --书本类型 1:春节歌谣 2:春节小知识
    self._bookType = ifnil(params.bookType, 2)
end

----------------------
-- 结点渲染 
----------------------

function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 初始化页面数据
    self:initPageId()
    -- 是否需要加载书本内容
    self:isNeedPageContent()
end

-- 场景跳转结束
function M:onEnterTransitionFinish()
    -- -- 延迟拍照
    -- self:delayTakePhoto()
end

-- 延迟拍照
function M:delayTakePhoto(callBack)
    self:performWithDelay(function ()
        -- 拍下书页
        self:takePhoto()
        -- self:hide()
        if callBack then
            callBack()
        end
    end, 1 / 60)
end

-- 拍下书页
function M:takePhoto()
    local photoPath = PH.combine(G_CAMERA_PHOTO_PATH, "/page/openani/" .. self._id .. ".png")
    -- 过滤已有的拍照截图
    local paths = self._layer._photoPaths
    -- local index = T.indexOf(paths, photoPath)
    -- if index ~= -1 then 
    --     self._path = paths[index]
    --     return 
    -- end 
    -- if IO.exists(photoPath) then
    --     self._path = photoPath
    -- end
    -- 创建新的拍照截图
    if self._pageId >= 1 and self._pageId <= self._totalPage then
        local box  = self:getBoundingBox()
        local color =  ccc4(255, 230, 201, 0)
        local path = SO.shot({
            renderBackground    = true,
            rect                = box,
            path                = photoPath,
            nodes               = {self},
            backgroundColor = color,
        })
        self._path = path
    end
end

-- 初始化页面数据
function M:initPageId()
    if self._targetPage then
        if self._pageType == "left" then
            self._pageId = self._targetPage:getPageIndex() + 2
        elseif self._pageType == "right" then
            self._pageId = self._targetPage:getPageIndex() - 2
        end
    end 
end

-- 是否需要加载书本内容
function M:isNeedPageContent()
    if self._pageId >= 1 and self._pageId <= self._totalPage then
        -- 加载书本内容
        self:loadPageContent()
    end
end

-- 加载书本内容
function M:loadPageContent()
    -- 图片渲染
    self:loadDisplay()
    self:removeCurrentPhotos()
    -- 创建模块照片
    self:createModulePhoto()
end

-- 图片渲染
function M:loadDisplay()
    self:display("handbook/book/page/2.png")
end

-- 移除现有照片节点
function M:removeCurrentPhotos() 
    if #self._photos ~= 0 then 
        for i = 1, #self._photos do
            self._photos[i]:removeFromParent()
        end 
        self._photos = {}
    end 
end 

-- 创建模块照片
function M:createModulePhoto(pageId)
    local aaa = D.img("handbook/book/6.png"):to(self):p(self:cw() / 2, self:ch() / 2)
end 

-- 设置书本页数
function M:setPageIndex(value)
    self._pageId = value
end

-- 获取书本页数
function M:getPageIndex()
    return self._pageId
end

-- 获取拍照的图片路径
function M:getPhotoPath()
    return self._path
end

-- 是否需要改变书页内容
function M:isNeedChangePageContent()
    if self._pageId >= 1 and self._pageId <= self._totalPage then
        -- 改变书页内容
        self:changePageContent()
    end
end

-- 改变书页内容
function M:changePageContent()
    
end

-- 改变预备书页内容
function M:changePhotoPage()
    local pageId = nil
    if self._pageType == BookDirection.Left then
        pageId = self._targetPage:getPageIndex() - 1
    elseif self._pageType == BookDirection.Right then
        pageId = self._targetPage:getPageIndex() + 1
    end 
    if pageId ~= self._pageId then
        -- 初始化页面数据
        self:initPageId()
        -- 是否需要加载书本内容
        self:isNeedChangePageContent()
    end
end

-- 触控穿透
function M:onTouchBegan(x, y)
    return SIGN_TOUCH_BEGAN_NO_SWALLOWS
end

----------------------
-- 结点析构
----------------------

function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end

return M
