--[[
Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]


--------------------------
-- 引入命名空间
--------------------------
-- local BaseLayer = import("app.common.layer.BaseLayer")




--[[
	类
--]]


local M 	= classSpriteTouch("Book")




--------------------------
-- 构造函数
--------------------------

function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
 	-- [本类调用]
	self._layer 		= params.layer
	--触控锁
	self._canTouch  = false
 	-- 是否在翻页
	self._isFlipPage = false
	-- 翻页方向
	self._flipDir    = ""
	-- 是否拖动
	self._isDrag     = false
	-- 存储的照片数据
	self._storePhoto = {}
	--翻页数目
	self._flipCount = 1
	--图本是否需要自动翻页
	self._autoFlip  = ifnil(params.autoFlip, true)
	--书本类型 1:春节歌谣 2:春节小知识
	self._bookType  = ifnil(params.bookType, 1)
end

--------------------------
-- 渲染
--------------------------

function M:onRender()
	-- [超类调用]
	M.super.onRender(self)

	 -- [本类调用]
	 --初始化
	self:initDate()
	-- 加载书本背景
	self:loadBookBg() 
	
end 

--初始化
function M:initDate()
	local imgTb = {"handbook/book/page/1.png", "handbook/book2/page/1.png"}
	local a = D.img(imgTb[self._bookType])
	local size = a:getContentSize()
	size = cc.size(size.width, size.height)
	self._size = size
end

-- 加载书本背景
function M:loadBookBg()
	--加载打开书的动画
	self:loadBookClose()
	-- self:loadBookOpen()
end 

--加载打开书的动画
function M:loadBookClose()
	local width = self._size.width * 2
	local height = self._size.height
	local pos = cc.p(0, 0)
	local closeBook = import("app.openani1.node.BookClose").new({
		layer = self._layer,
		bookType = self._bookType
	}):to(self):anchor(cc.p(0, 0)):p(pos):unbindTouch()
	self._closeBook = closeBook
end

--开场动画打开书本
function M:openAniOpenBook()
	--打开书本
	self._closeBook:openBook(function()
		--剪纸动起来
		self._layer:paperMove()
		--加载跳过建
		self._layer:loadSkip()
	end)
end

--关闭书本
function M:closeBook()
	--关闭书本
	self._closeBook:closeBook(function()
		--开启返回按钮触控
		-- self._layer:openBackBtnTouch()
	end)
end




--------------------------
-- 析构
--------------------------
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
 	-- [本类调用]

end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)

	return SIGN_TOUCH_BEGAN_SWALLOWS 
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)

end

--------------------------
-- 属性
--------------------------




--------------------------
-- 父类重写
-------------------------- 




return M






