--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("BookClose")
M.TAG       = "BookClose"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    --书左侧移动书页
    self._leftPageTb = {}
    --书左侧移动书页
    self._rightPageTb = {}
    --书本类型 1:春节歌谣 2:春节小知识
    self._bookType = ifnil(params.bookType, 1)
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()

end

-- 加载结点
function M:loadPageNode()
    --加载书的中间部分
    self:loadBookOther()
    --加载书右侧（底下）书皮
    self:loadRightBookCover()
    --加载书左侧书皮(移动)
    self:loadLeftBookCover()
    --加载书右侧移动页
    self:loadRightMovePage()
end

--加载书的中间部分
function M:loadBookOther()
    local imgTb = {"handbook/book/2.png", "handbook/book2/2.png"} 
    local posTb = { cc.p(-17.5, self:ch() / 2 + 3), cc.p(-19.5, self:ch() / 2 + 3) }
    --中轴
    local center = D.img(imgTb[self._bookType]):to(self, 10):p(posTb[self._bookType])
    self._center = center
end

--加载书右侧（底下）书皮
function M:loadRightBookCover()
    local imgTb = { "handbook/book/3.png", "handbook/book2/3.png" }
    local posTb = { cc.p(self:cw() / 2, self:ch() / 2), cc.p(self:cw() / 2, self:ch() / 2) }
    --书右侧书皮
    local rightCover = D.img(imgTb[self._bookType]):to(self):p(posTb[self._bookType]):anchor(cc.p(0, 0.5))
end

--加载书左侧书皮(移动)
function M:loadLeftBookCover()
    local book = import("app.handbook.node.BookCloseCover").new({
        layer     = self,
        direction = "right",
        bookType  = self._bookType
    }):to(self, 5):p(self:cw() / 2 + 1.5, self:ch() / 2):anchor(cc.p(0, 0.5))
    self._leftCover = book
end

--加载书左侧移动页
function M:loadLeftMovePage()
    -- 获取拍照的图片路径
    local path1 = "handbook/book/page/2.png"
    local imgTb1 = {"handbook/book/page/2.png", "handbook/book2/page/2.png" }
    local imgTb2 = { "handbook/book/page/2_1.png", "handbook/book2/page/1_1.png" }
    local pagePath1 = imgTb1[self._bookType]
    local pagePath2 = imgTb2[self._bookType]
    local pagePathTb = {
        { path = pagePath1, backPageImg = path1, pos = cc.p(self:cw() / 2 + 3 + 3, self:ch() / 2 + 2) },
        { path = pagePath1, backPageImg = path1, pos = cc.p(self:cw() / 2 + 3 + 3, self:ch() / 2 + 2) },
        { path = pagePath1, backPageImg = path1, pos = cc.p(self:cw() / 2 + 3 + 3, self:ch() / 2 + 2) },
        { path = pagePath2, backPageImg = pagePath2, pos = cc.p(self:cw() / 2 + 4 + 3, self:ch() / 2), stretchY = 120 },
    }
    local pagePathTb = pagePathTb
    for i, v in ipairs(pagePathTb) do
        local page = import("app.handbook.node.BookClosePage").new({
            layer       = self,
            direction   = "right",
            pageImg     = v.path,
            backPageImg = v.backPageImg,
            stretchY    = v.stretchY
        }):to(self, 4):p(v.pos):anchor(cc.p(0, 0.5))
        table.insert(self._leftPageTb, page)
    end
end

--加载书右侧移动页
function M:loadRightMovePage()
    local imgTb = { "handbook/book/page/2_1.png", "handbook/book2/page/2_1.png" }
    local posTb = { cc.p(self:cw() / 2 - 25 + 4, self:ch() / 2), cc.p(self:cw() / 2 - 25 + 4, self:ch() / 2 + 30) }
    local rightDownPage    = D.img(imgTb[self._bookType]):to(self, 2):p(posTb[self._bookType]):anchor(cc.p(0, 0.5))
    self._rightDownPage = rightDownPage
    
    --加载右页显示页
    local rightPage = D.img("handbook/book/page/1.png"):to(self, 4):p(cc.p(self:cw() / 2 + 1 + 4, self:ch() / 2 + 2)):anchor(cc.p(0, 0.5)):flipX(true)
    self._rightPage = rightPage

    --加载歌谣书本装饰
    self:loadDecorate()
end

--加载歌谣书本装饰
function M:loadDecorate()
    if self._bookType == 2 then return end
    local decorate = D.img("handbook/book/4.png"):to(self, 1):p(365, -100)
    local fish = D.img("handbook/book/5.png"):to(self, 1):p(175, 210)
end

--加载右页显示页
function M:loadRightPage(id, pos, zNum)
    local book = self._bookType == 1 and import("app.handbook.node.BookPage1") or import("app.handbook.node.BookPage2")
    local rightPage = book.new({
        layer    = self,
        scaleX   = 1,
        id       = id,
        bookType = self._bookType
    }):to(self, zNum):p(pos):anchor(cc.p(0, 0.5))
    return rightPage
end

--右边页移动
function M:rightPageMove(type, node, callBack)
    type = ifnil(type, "open")
    node = ifnil(node, self._rightPage)
    local offsetX = type == "open" and (-21 - 5) or 26
    node:line({
        { "moveBy", 0.8, cc.p(offsetX, 0) },
        { "fn", function ()
            if callBack then
                callBack()
            end
        end}
    })
end

--打开书本
function M:openBook(callBack, needFeedBack)
    needFeedBack = ifnil(needFeedBack, false)
    --加载书左侧移动页
    self:loadLeftMovePage()
    self._center:z(2):hide()
    self:line({
        {"delay", 1/60},
        {"fn", function ()
            self._center:show()
        end}
    })
    self._rightPage:px(self._rightPage:px() - 26)
    self._leftCover:z(30)
    -- 快速翻页
    self._leftCover:quickTurnPage()
    self._leftCover:z(1)

    self._leftPageTb[#self._leftPageTb]:quickTurnPage()
    self._leftPageTb[3]:quickTurnPage()
    self._leftPageTb[2]:quickTurnPage()
    self._leftPageTb[1]:quickTurnPage()
    for i, v in ipairs(self._leftPageTb) do
        if i ~= 1 then
            v:hide()
        end
        v._showImg:hide()
    end
    self._leftCover:hide()
    if needFeedBack then
        self:scale(1)
        if callBack then
            callBack()
        end
    else
        if callBack then
            callBack()
        end
    end
end

--开场动画回调
function M:openAniCallBack()
    
end

--图鉴页面回调
function M:handbookCallBack()
    
end

--关闭书本
function M:closeBook(callBack)
    for i, v in ipairs(self._leftPageTb) do
        v:show()
        v._showImg:show()
    end
    self._leftCover:show()
    --右边页移动
    self:rightPageMove("close")
    self:line({
        { "fn", function()
            -- self._leftPageTb[1]:turnPage("left")
            if (self._leftPageTb and not tolua.isnull(self._leftPageTb[1])) then
                self._leftPageTb[1]:turnPage("left") 
            end
        end },
        { "Delay", 0.03 },
        { "fn", function()
            -- self._leftPageTb[2]:turnPage("left")
            if (self._leftPageTb and not tolua.isnull(self._leftPageTb[2])) then
                self._leftPageTb[2]:turnPage("left") 
            end
        end },
        { "Delay", 0.03 },
        { "fn", function()
            -- self._leftPageTb[3]:turnPage("left")
            if (self._leftPageTb and not tolua.isnull(self._leftPageTb[3])) then
                self._leftPageTb[3]:turnPage("left") 
            end
        end },
        { "Delay", 0.03 },
        { "fn", function()
            self._leftPageTb[4]:turnPage("left", function()
            end)
            -- 书皮翻页
            self._leftCover:turnPage("left", function()
                self._center:z(60)
                --重置页数
                self:removeAllPage()
                if callBack then
                    callBack()
                end
            end)
        end },
    })
end

--重置页数
function M:removeAllPage()
    for i, v in ipairs(self._leftPageTb) do
        if v then
            v:remove()
            v = nil
        end
    end
    T.clear(self._leftPageTb)
end

function M:loadEndClosePage(path)
    self._leftPageTb[1]:hide()
    local zNum = self._leftPageTb[1]:z()
    local backImgTb = { "handbook/book/page/2.png", "handbook/book2/page/2.png" }
    local config = { path = path, backPageImg = backImgTb[self._bookType], pos = cc.p(self:cw() / 2 + 3 + 3 - 27, self:ch() / 2 + 2) }
    local page = import("app.handbook.node.BookClosePage").new({
        layer       = self,
        direction   = "left",
        pageImg     = config.path,
        backPageImg = config.backPageImg,
        stretchY    = config.stretchY
    }):to(self, zNum):p(config.pos):anchor(cc.p(1, 0.5))
    self._endClosePageL = page
end

function M:resetPage(path, id)
    --重置左页
    self:resetLeftPage(path)
    --重置左页
    self:resetRightPage(id + 1)
end

--重置左页
function M:resetLeftPage(path)
    self:loadEndClosePage(path)
end

--重置左页
function M:resetRightPage(id)
    if self._endClosePageR then
        self._endClosePageR:remove()
        self._endClosePageR = nil
    end
    local pos  = self._rightPage:point()
    local zNum = self._rightPage:z()
    --加载右页显示页
    local page = self:loadRightPage(id, pos, zNum)
    self._endClosePageR = page
end


--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    -- if self._layer._canTouch then
    --     if self._canTouch then
    --         return true
    --     end
    -- end
    --  触控有效
    -- return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
