--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 书的移动页
----------------------
local M     = classSpriteTouch("BookClosePage")
M.TAG       = "BookClosePage"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer       = params.layer
    --触控
    self._canTouch    = false
    -- 初始旋转z角
    self._initZ       = 0
    -- 标记, 是否翻转到另一面, 1: 否, -1: 是
    self._a           = 1
    -- 页图片名
    self._pageImg     = ifnil(params.pageImg, "handbook/book/page/2.png")
    -- 背面也图片名
    self._backPageImg = ifnil(params.backPageImg, "handbook/book/page/2.png")
    -- 方向
    self._direction   = params.direction

    self._stretchY    = params.stretchY or 100
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display(self._pageImg):opacity(0)
end

-- 加载结点
function M:loadPageNode()
    -- 初始化
    self:init()
    -- 加载页面
    self:loadPage()
end

-- 初始化
function M:init()
    -- 页的大小
    self._pageSize = cc.size(self:ch(), self:cw())
end

-- 加载多边形精灵
function M:loadPolySprite(params)
    local image    = params.image
    local stretchY = ifnil(params.stretchY, 100)
    local sp = CCNodeExtend.extend(PolySprite:create(image))
    -- 多边形精灵翻转时拉伸的高度
    sp._stretchY = stretchY
    return sp
end

-- 加载页面
function M:loadPage(path, z)
    path = ifnil(path, self._pageImg)
    z = ifnil(z, 5)
    -- 加载多边形精灵
    local sp = self:loadPolySprite({
        image    = path,
        stretchY = self._stretchY
    }):to(self, z):p(self:cw() / 2, self:ch() / 2)
    self._showImg = sp
end

-- 更新页面
function M:updatePage()
    if self._backShowImg then return end
    local isLeft = self._direction == "left" and true or false
    if self._a == -1 then
        isLeft = not isLeft
    end
    -- 加载多边形精灵
    local sp = self:loadPolySprite({
        image    = self._backPageImg,
    }):to(self, 10):p(self:cw() / 2, self:ch() / 2)
    self._backShowImg = sp
    self:sunken(self._backShowImg, 0, self._backShowImg._stretchY, isLeft)
end

-- 翻页
function M:turnPage(dir, callBack)
    dir = ifnil(dir, "right")
    local offsetX =  dir == "left" and 27 or -27
    -- self:z(28)
    local time = 0.8
    self:line({
        { "union", {
            { "moveBy", time, cc.p(offsetX, 0) },
            { "OrbitCamera", time, 1, 0, self._initZ, 180, 0, 0 }, -- 水平翻转-180度
        } },
    })
    self:changeAction(time, callBack)
    -- self:change()
end

-- 翻页动作, times-翻页时间
function M:changeAction(times, callBack)
    local isLeft = self._direction == "left" and true or false
    local time = 0
    self:line({
        A.cycle({
            { "delay", 1 / 60 },
            { "fn", function()
                time = time + 1
                self:sunken(self._showImg, 0, self._showImg._stretchY / 30 * time, isLeft)
                if self._a == -1 then
                    self:sunken(self._backShowImg, 0, self._backShowImg._stretchY / 30 * time, isLeft)
                end
            end },
        }, times * 30),
        { "fn", function()
            if self._a ~= -1 then
                if self._direction == "left" then
                    self:z(60 - 1)
                else
                    self:z(60)
                end
                -- 更新页面
                self:updatePage() 
            else
                self:z(60-1)
                self._showImg:z(10)
            end
        end },
        A.cycle({
            { "delay", 1 / 60 },
            { "fn", function()
                time = time - 1
                self:sunken(self._showImg, 0, self._showImg._stretchY / 30 * time, isLeft)
                self:sunken(self._backShowImg, 0, self._backShowImg._stretchY / 30 * time, isLeft)
            end },
        }, times * 30),
        { "fn", function()
            if self._initZ == 0 then
                self._initZ = 180
                self._a = -1
            else
                self._initZ = 0
                self._a = 1
            end
            if callBack then
                callBack()
            end
        end }
    })
end

-- 凹陷
function M:sunken(node, posX, posY, isFlipX, size)
    local size = ifnil(size, self._pageSize)
    -- 总长度
    local width = size.height
    -- 总高度
    local height = size.width
    -- 总下标数
    local num = 4
    -- 每格间距
    local span = width / num
    -- 高度
    local y = { height / 2, 0, -height / 2 }
    local p = {}
    for i = 1, 3 do
        for j = 1, num do
            local number = isFlipX == true and num - j or j - 1
            local x    = width / (num - 1) * (j - num) + width / 2 + posX / (num - 1) * number
            if i == 1 then
                table.insert(p, cc.p(x, y[i] + posY / (num - 1) * number))
            elseif i == 2 then -- 正常位置
                table.insert(p, cc.p(x, y[i]))
            elseif i == 3 then
                table.insert(p, cc.p(x, y[i] - posY / (num - 1) * number))
            end
        end
    end
    node:setVertices(Tools:meshVerticesAndTexcoords(3, num, p))
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
