--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("OpenPaper")
M.TAG       = "OpenPaper"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    --缩放大小
    self._scaleSize = ifnil(params.scaleSize, 1)
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:scale(self._scaleSize)
    --子节点跟随父节点透明度
    self:setCascadeOpacityEnabled(true)
end

-- 加载结点
function M:loadPageNode()
    self._childrenNodeTb = {}
    local rate = 1 - (0.1 * (Y_FACTOR / 1.33))
    local scaleTb = {rate * 1.05, rate * 1.05, 1, rate * 1.2, 1.3}
    local posTb = {cc.p(0, 0), cc.p(0, 0), cc.p(V.w_2, 0), cc.p(0, 0), cc.p(0, 0),}
    for i = 1, 5 do
        local childrenNode = U.loadNode({})
        :to(self, 999 + i):p(posTb[i]):scale(scaleTb[i]):opacity(255)
        table.insert(self._childrenNodeTb, childrenNode)
        childrenNode._size = scaleTb[i]
        childrenNode._pos = posTb[i]
        if i==3 then
            childrenNode:bindTouch()
        end
        --子节点跟随父节点透明度
        childrenNode:setCascadeOpacityEnabled(true)
    end
    local grassland = D.img("openani/open/1_1.png"):to(self._childrenNodeTb[1]):p(10.8, -207.2)
    self:playPaperAni(grassland, 1, 0.3)

    --加载女孩
    self:loadGirl()
    --加载男孩
    self:loadBoy()
    --加载牌匾
    self:loadPlaque()
    --加载花
    self:loadFlower()
    --加载其他花
    self:loadFlowerOther()
    --加载字
    self:loadWord()
end

--加载女孩
function M:loadGirl()
    local girl = D.img("openani/open/4_1.png"):to(self._childrenNodeTb[4]):p(-118.0, -204.7):anchor(cc.p(0.53, 0.06))
    --子节点跟随父节点透明度
    girl:setCascadeOpacityEnabled(true)
    local hand =D.img("openani/open/3.png"):to(girl, 5):p(17.6, 134.4):anchor(cc.p(0.06, 0.15))
    local head = D.img("openani/open/2_1.png"):to(girl):p(36.8, 163):anchor(cc.p(0.8, 0.23))

    --剪纸缩放
    self:paperScale(girl, 1, 0.012)
    --剪纸摇晃
    self:paperRotate(head, 1, -5)

    self:playPaperAni(girl, 4, 0.5)
    self:playPaperAni(head, 2, 0.5)
end

--加载男孩
function M:loadBoy()
    local boy = D.img("openani/open/6.png"):to(self._childrenNodeTb[4]):p(117.9, -212):anchor(cc.p(0.46, 0.03))
    --子节点跟随父节点透明度
    boy:setCascadeOpacityEnabled(true)
    local hand = D.img("openani/open/7.png"):to(boy, 5):p(74.9, 141.9):anchor(cc.p(0.89, 0.15))--
    local head = D.img("openani/open/5_1.png"):to(boy):p(63.8, 169):anchor(cc.p(0.26, 0.25))--

    --剪纸缩放
    self:paperScale(boy, 1, 0.012)
    --剪纸摇晃
    self:paperRotate(head, 1, 5)

    self:playPaperAni(head, 5, 0.5)
end

--加载牌匾
function M:loadPlaque()
    self._birdTb = {}

    local plaque = {}
    if device.language == "zh"   then
        plaque = D.img("openani/open/10_1.png"):to(self._childrenNodeTb[2]):p(0, 65):bindTouchLocate()
    else
        plaque = D.img("openani/open/13_1.png"):to(self._childrenNodeTb[2]):p(0, 65):bindTouchLocate()
    end

    --子节点跟随父节点透明度
    plaque:setCascadeOpacityEnabled(true)
    local birdL = D.img("openani/open/11_1.png"):to(plaque):p(39.3, 280):anchor(cc.p(0.73, 0.08)):opacity(0):scale(0.8)
    local birdR = D.img("openani/open/11_1.png"):to(plaque):p(302.4, 280):anchor(cc.p(0.25, 0.1)):flipX(true):opacity(0):scale(0.8)
    table.insert(self._birdTb, birdL)
    table.insert(self._birdTb, birdR)

    --支架
    local bracketL = D.img("openani/open/8.png"):to(plaque):p(119.9, 132.2)
    local bracketR = D.img("openani/open/9.png"):to(plaque):p(233.7, 133.2)

    --剪纸移动
    self:paperMove(plaque, 1, cc.p(0, 5))
    --剪纸摇晃
    self:paperRotate(birdL, 0.5, -9)
    --剪纸摇晃
    self:paperRotate(birdR, 0.5, 9)

    --播放帧动画
    if device.language == "zh"   then
        self:playPaperAni(plaque, 10, 0.4)
    else
        self:playPaperAni(plaque, 13, 0.4)
    end

    self:playPaperAni(birdL, 11, 0.4)
    self:playPaperAni(birdR, 11, 0.4)
end

--加载花
function M:loadFlower()
    local posTb = {cc.p(435.6, -312.5), cc.p(430.7, -255.2), cc.p(381.6, -323.8), cc.p(263.9, -315.7), cc.p(315.5, -344.3),
                cc.p(324.7, -266.6), cc.p(377.5, -233.1),   cc.p(330.8, -309.9),cc.p(432.2, -205.4), cc.p(379, -267.4),}
    for i, v in ipairs(posTb) do
        local flower = D.img("openani/open/flower.png")
        :to(self._childrenNodeTb[5], 50):scale(math.random(90,100)/ 100):rotate(math.random(0, 100))
        :p(v.x + X_OFFSET, v.y + 80 - Y_OFFSET)
        --花旋转
        self:flowerRotate(flower)
    end
end

--花旋转
function M:flowerRotate(flower)
    local time = math.random(250, 350) / 100
    flower:cycle({
        {"rotateby", time, 360},
    })
end

--加载其他花
function M:loadFlowerOther()
    local posTb = {cc.p(487.6, 320.3), cc.p(417.2, 371.1), cc.p(-297.5, 370.2), cc.p(-498.1, 297.0), cc.p(-435.6, 376.0),
                    cc.p(-458.6, -371.9), cc.p(-300.8, -371.7), }
    local anchorTb = { cc.p(0.93, 0.98), cc.p(0.96, 0.95), 
                    cc.p(0.02, 0.89), cc.p(0.01, 0.98), cc.p(0.01, 0.98), 
                    cc.p(0.13, 0.02), cc.p(0.02, 0.01)}
    local angleTb = { 10, 0, 15, 0, 15,
                    0, 0 }
    local offsetTb = {cc.p(20 + X_OFFSET, -80 + Y_OFFSET), cc.p(20 + X_OFFSET, -80 + Y_OFFSET), cc.p(-20 - X_OFFSET, -80 + Y_OFFSET), cc.p(-20 - X_OFFSET, -80 + Y_OFFSET), cc.p(-20 - X_OFFSET, -80 + Y_OFFSET),
                    cc.p(-20 - X_OFFSET, 80 - Y_OFFSET), cc.p(-20 - X_OFFSET, 80 - Y_OFFSET),}
    for i, v in ipairs(posTb) do
        local flower = D.img("openani/open/flower/"..i.."_1.png"):to(self._childrenNodeTb[5], 60)
        :p(v.x + offsetTb[i].x, v.y + offsetTb[i].y):anchor(anchorTb[i]):rotate(angleTb[i])
        flower._isFlower = true
        --播放帧动画
        self:playPaperAni(flower, i, 0.5)
    end
end

--加载字
function M:loadWord()

    local word = D.img("openani/open/12.png"):to(self._childrenNodeTb[3]):p(280.3, 98.7)
end


--进场
function M:enter()
    local time = 1.5
    self:line({
        { "show"},
        { "union", {
            { "fadeto", time, 255 },
            { "scaleto", time, self._scaleSize }
        } },
        {"fn", function ()
            for i, v in ipairs(self._birdTb) do
                v:line({
                    {"union", {
                        { "scaleto", 1, 1 },
                        { "fadeto", 1, 255 },
                    }}
                })
            end

        end}
    })
    for i, v in ipairs(self._childrenNodeTb) do
        local rate = 0.1 * (Y_FACTOR/1.33)
        local size = (i == 2 or i == 4 or i == 1) and (1 - rate) or 1 
        v:line({
            { "scaleto", time, size }
        })
    end
    self._childrenNodeTb[3]:line({
        { "Delay", 0.2},
        { "union", {
            { "fadeto", time, 255 },
            { "easing", "backout", { "moveto", time, cc.p(0, 0) }}
        } }
    })

end

function M:quit(callBack)
    local time = 0.7
    for i, v in ipairs(self._childrenNodeTb) do
        v:line({
            { "scaleto", time, v._size }
        })
    end
    self:line({
        { "union", {
            { "fadeto", time, 0 },
            { "scaleto", time, 1.2 }
        } },
        {"remove",},
        {"fn", function ()
            if callBack then
                callBack()
            end
        end}
    })
    self._childrenNodeTb[3]:line({
        { "delay", 0.3},
        { "easing", "backin", { "moveto", 1, self._childrenNodeTb[3]._pos } }
    })
end

---------------------
--方法
---------------------
--播放帧动画
function M:playPaperAni(node, id, time, num)
    time = ifnil(time, 1 / 3)
    num = ifnil(num, 2)
    local img = "openani/open/" .. id .. "_"
    if node._isFlower then
        img = "openani/open/flower/" .. id .. "_"
    end
    node:cycle({
        { "image", img, num, time }
    })
end

--剪纸摇晃
function M:paperRotate(node, time, angle)
    node:cycle({
        { "rotateby", time, -angle },
        { "rotateby", time, angle },
    })
end

--剪纸移动
function M:paperMove(node, time, pos)
    node:cycle({
        { "moveby", time, cc.p(pos.x, pos.y) },
        { "moveby", time, cc.p(-pos.x, -pos.y) },
    })
end

--剪纸缩放
function M:paperScale(node, time, size)
    node:cycle({
        { "scaleto", time, 1 + size  },
        { "scaleto", time, 1 - size },
    })
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
