--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 剪纸纸张页
----------------------
local M    = class("Paper", import("app.openani1.node.BasePage"))
M.TAG      = "Paper"
local DateConfig = import("app.openani1.config.Config")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    -- id
    self._id = ifnil(params.id, 1)
    --是否需要翻转
    self._scaleX = ifnil(params.scaleX, 1)
    --需要拍照
    self._needPhoto = ifnil(params.needPhoto, false)
    --动起来的函数表
    self._fnHandlerTb = {}
    --透明度
    self._opciatyNum = ifnil(params.opciatyNum, 255)

    --进场动作表
    self._fnEnterHandlerTb = {}
    --退场动作表
    self._fnQuitHandlerTb = {}
    --五个层级的子结点
    self._childrenNodeTb = {}
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    
end


-- 加载书本内容
function M:loadPageContent()
    -- 图片渲染
    self:loadDisplay()
    --移除现有照片
    self:removeCurrentPhotos()
    --加载剪纸父节点
    self:loadPaperParent()
    -- 加载结点
    self:loadPageNode()
end

-- 图片渲染
function M:loadDisplay()
    self:display("handbook/book/page/1.png"):scaleX(self._scaleX):opacity(0)
end

--加载剪纸父节点
function M:loadPaperParent()
    local moveNode = U.loadNode({}):to(self, 999):p(self:cw() / 2, self:ch() / 2):opacity(self._opciatyNum):bindTouch()
    self._moveNode = moveNode

    local configTb = {}
    T.copyTable(configTb, DateConfig.PaperParentConfig[self._id])
    for i, v in ipairs(configTb) do
        local childrenNode = U.loadNode({})
        :to(self._moveNode, 999 + i):p(v.pos):scale(v.scaleSize):opacity(v.opacityNum):bindTouch()
        table.insert(self._childrenNodeTb, childrenNode)
        --子节点跟随父节点透明度
        childrenNode:setCascadeOpacityEnabled(true)
        --加入进场函数表
        self:insertEnterHandler(childrenNode, v.enterConfig)
        --加入退场函数表
        self:insertQuitHandler(childrenNode, v.quitConfig)
    end
end

--加入进场函数表
function M:insertEnterHandler(parent, config)
    --加入进场函数表
    self:insertEnterHandlerTb(function()
        local enterConfig = config
        local id = ifnil(enterConfig.id, 1)
        if id == 1 then
            self:enterAct1(parent, enterConfig.delayTime, enterConfig.time, nil, enterConfig.moveSpringback, enterConfig.scaleSpringback)
        else
            self:enterAct2(parent, enterConfig.delayTime, enterConfig.time, nil, enterConfig.moveSpringback, enterConfig.scaleSpringback)
        end
    end)
end

--加入退场函数表
function M:insertQuitHandler(parent, config)
    if not config then return end
    --加入退场函数
    self:insertQuitHandlerTb(function()
        local quitConfig = config
        local id = ifnil(quitConfig.id, 1)
        if id == 1 then
            --进场动作
            self:quitAct1(parent, quitConfig.delayTime, quitConfig.time, quitConfig.size, quitConfig.opacityNum, quitConfig.pos)
        elseif id == 2 then
            --进场动作
            self:quitAct2(parent, quitConfig.delayTime)
        end
    end)
end

-- 加载结点
function M:loadPageNode()
    local configTb = {}
    T.copyTable(configTb, DateConfig.paperConfig[self._id])
    for i, config in ipairs(configTb) do
        --图片Id
        local id     = config.aniNum == 1 and config.id or (config.id .. "_1")
        --角度
        local angle  = config.angle == nil and 0 or config.angle
        --所属结点
        local parent = self._childrenNodeTb[config.parentIndex]

        local paper = D.img("handbook/paper/" .. self._id .. "/" .. id .. ".png")
        :to(parent, config.z):p(config.pos):anchor(config.anchor):rotate(angle)
        paper.id           = config.id
        paper.aniNum       = config.aniNum
        paper.rotateConfig = config.rotateConfig
        paper.moveConfig   = config.moveConfig
        --加入剪纸动的函数
        self:insertPaperMoveHandler(paper, config)
    end
    --加载其他剪纸
    self:loadPaperOther()
    --加载标题
    self:loadTitle()
end

--加载标题
function M:loadTitle()
    if not isZhLanguage() then
        return
    end
    local indexTb = { 1, 5, 3, 4, 4, 6, 6, 5, 6, 6 }
    --所属结点
    local parent = self._childrenNodeTb[indexTb[self._id]]
    local title = D.img((self._id + 41) .. ".png"):to(parent, 20):p(-81.2, 145.6)
end

--加入剪纸动的函数
function M:insertPaperMoveHandler(paper, config)
    if paper.aniNum > 1 then
        --加入函数表
        self:insertHandlerTb(function()
            --播放帧动画
            self:playPaperAni(paper, paper.id, paper.aniNum)
        end)
    end
    if config.rotateConfig then
        --加入函数表
        self:insertHandlerTb(function()
            --剪纸摇晃
            self:paperRotate(paper, config.rotateConfig[1], config.rotateConfig[2])
        end)
    end
    if config.moveConfig then
        --加入函数表
        self:insertHandlerTb(function()
            --剪纸移动
            self:paperMove(paper, config.moveConfig[1], config.moveConfig[2])
        end)
    end
    if self._id == 1 and (config.id == 2 or config.id == 11) then
        --加入函数表
        self:insertHandlerTb(function()
            --烟雾
            self:smokeAct(paper)
        end)
    end
    if config.scaleConfig then
        --加入函数表
        self:insertHandlerTb(function()
            --剪纸放大
            self:paperScale(paper, config.scaleConfig[1], config.scaleConfig[2])
        end)
    end
end

--加载其他剪纸
function M:loadPaperOther()
    local otherHandlerTb = {
        {},
        { "loadGirlPage2", "loadBoyPage2" },
        { "loadGirlPage3", "loadMomPage3" },
        { "loadMomPage4", "loadGirlPage4" },
        { "loadDogPage5", "loadBoyPage5", "loadManPage5" },
        { "loadBoy1Page6", "loadBoy2Page6", "loadChickenPage6" },
        {},
        { "loadGirlPage8", "loadMomPage8" },
        {},
        { "loadGirlPage10", "loadBoyPage10" },
    }
    local configTb = otherHandlerTb[self._id]
    for i1, v1 in ipairs(configTb) do
        self[v1](self)
    end
end

--进场动作
function M:enterAct1(node, delayTime, time, callBack, moveSpringback, scaleSpringback)
    time            = ifnil(time, 0.5)
    delayTime       = ifnil(delayTime, 0)
    moveSpringback  = ifnil(moveSpringback, false)
    scaleSpringback = ifnil(scaleSpringback, false)
    local action1   = moveSpringback == false and 
    A.line({
        { "moveto", time, ccp(0, 0) }
    })
    or 
    A.line({
        { "easing", "backout", { "moveto", time, ccp(0, 0) }}
    })

    local action2 = scaleSpringback == false and
    A.line({
        { "scaleto", time, 1 },
    })
    or
    A.line({
        { "easing", "backout", { "scaleto", time, 1 }, }
    })
    node:line({
        { "Delay", delayTime},
        { "union", {
            { "fadeto", time, 255 },
            action1,
            action2,
        } },
        { "fn", function()
            if callBack then
                callBack()
            end
        end }
    })
end

--进场动作
function M:enterAct2(node, delayTime, time, callBack, moveSpringback, scaleSpringback)
    time            = ifnil(time, 0.5)
    delayTime    = ifnil(delayTime, 0)
    moveSpringback = ifnil(moveSpringback, false)
    scaleSpringback = ifnil(scaleSpringback, false)
    local action1 = moveSpringback == false and
    A.line({
        { "moveto", time, ccp(0, 0) }
    })
    or
    A.line({
        { "easing", "backout", { "moveto", time, ccp(0, 0) } }
    })

    local action2 = scaleSpringback == false and
    A.line({
        { "scaleto", time, 0.9 },
    })
    or
    A.line({
        { "easing", "backout", { "scaleto", time, 0.9 },}
    })
    node:line({
        { "Delay", delayTime },
        { "union", {
            { "fadeto", time, 255 },
            action1,
            action2,
        } },
        {"scaleto", 0.3, 1},
        { "fn", function()
            if callBack then
                callBack()
            end
        end }
    })
end

--退场场动作
function M:quitAct1(node, delayTime, time, size, opacityNum, pos)
    delayTime       = ifnil(delayTime, 0)
    time            = ifnil(time, 0.5)
    size            = ifnil(size, 1)
    opacityNum      = ifnil(opacityNum, 255)
    pos             = ifnil(pos, ccp(0, 0))
    node:line({
        { "Delay", delayTime},
        { "union", {
            { "fadeto", time, opacityNum },
            { "scaleto", time, size },
            { "moveby", time, pos }
        } },
    })
end

--退场场动作
function M:quitAct2(node, delayTime)
    node:line({
        { "Delay", delayTime },
        { "fn", function ()
            node:cycle({
                { "rotateby", 0.1, -10 },
                { "rotateby", 0.1, 10 },
                { "rotateby", 0.1, 10 },
                { "rotateby", 0.1, -10 },
            })
        end}
    })
end

--拍照
function M:takePhoto()
    -- 拍下书页
    local photoPath = PH.combine(G_CAMERA_PHOTO_PATH, "/page/openani/" .. self._id .. ".png")
    -- G_CAMERA_PHOTO_PATH .. "/page/openani/" .. self._id .. ".png"
    -- 过滤已有的拍照截图
    local paths = self._layer._photoPaths
    -- local index = T.indexOf(paths, photoPath)
    -- if index ~= -1 then 
    --     self._path = paths[index]
    --     return 
    -- end 
    -- if IO.exists(photoPath) then
    --     self._path = photoPath
    -- end
    -- 创建新的拍照截图
    if self._pageId >= 1 and self._pageId <= self._totalPage then
        local box = self:getBoundingBox()
        local color = ccc4(255, 230, 201, 0)
        local path = SO.shot({
            renderBackground    = true,
            rect                = box,
            path                = photoPath,
            nodes            = { self },
            backgroundColor = color,
        })
        self._path = path
        -- table.insert(paths, path)
    end
end

--获取路径
function M:getPath()
    return self._path
end

--进场
function M:enter(callBack)
    if self._layer._isOver then
        return
    end
    local paperQuitTb = { 1, 2, 1, 2, 2, 2, 1, 2, 1, 2}
    self["enter" .. paperQuitTb[self._id]](self, callBack)
end

--进场方式一， 直接剪纸进场
function M:enter1(callBack)
    local time = 0
    if self._id == 9 then
        time = 1
    end
    self:line({
        {"Delay", time},
        {"fn", function ()
            self:paperEnter()
            self:line({
                { "delay", 1 },
                { "fn", function()
                    if callBack then
                        callBack()
                    end
                end }
            })
        end}
    })
end

--进场方式二， 右侧进场
function M:enter2(callBack)
    self:line({
        { "Delay", 0.8 },
        { "fn", function()
            self:paperEnter()
        end }
    })
    self:line({
        { "show" },
        { "union", {
            { "scaleto", 1.5, 1 },
            { "moveto", 1.5, self._pos }
        } },
        {"fn", function ()
            if callBack then
                callBack()
            end
        end}
    })
end

--进场
function M:paperEnter()
    self:show()
    -- self["enter"..self._id](self)
    for i, v in ipairs(self._fnEnterHandlerTb) do
        v()
    end
    --剪纸动起来
    self:paperOpenAct()
end

function M:quit(callBack)
    if self._layer._isOver then
        return
    end
    local paperQuitTb = {1, 2, 1, 1, 1, 3, 4, 4, 4, 3}
    local quitPos = {nil, nil, nil, cc.p(0, -V.h / 1.5), cc.p(V.w / 1.5, 0),
                    nil, nil, nil, nil, nil,}
    self._quitPos = quitPos[self._id]
    self["quit"..paperQuitTb[self._id]](self, callBack)
end

function M:quit1(callBack)
    local quitPos = ifnil(self._quitPos, cc.p(-V.w / 1.5, 0))
    -- self:takePhoto()
    -- self:line({
    --     {"delay", 0.15},
    --     {"fn", function ()
    --         if self._layer._isOver then
    --             return
    --         end
    --         local path = self:getPath()
    --         local pos = self:point()
    --         local replaceImg = D.img(path):to(self:getParent(), self:z()):p(self:point()):scale(self:scale())
    --         self._replaceImg = replaceImg
    --         self:hide()
    --         --高斯模糊
    --         Tools:shaderGaussianBlur(replaceImg, 2)
    --         replaceImg:line({
    --             { "union", {
    --                 { "scaleto", 1, 0.5 },
    --                 { "easing", "backin", { "moveby", 1, quitPos } }
    --                 -- { "moveby", 1, quitPos }
    --             } }
    --         })
    --         if callBack then
    --             callBack()
    --         end
    --     end}
    -- })
    self:line({
        { "delay", 0.15 },
        { "fn", function()
            if callBack then
                callBack()
            end
        end },
                { "union", {
                    { "scaleto", 1, 0.5 },
                    { "easing", "backin", { "moveby", 1, quitPos } }
                    -- { "moveby", 1, quitPos }
        } },
        {"fn", function ()
            Tools:removeNode(self)
        end}
    })
end

function M:quit2(callBack)
    --子节点跟随父节点透明度
    self._moveNode:setCascadeOpacityEnabled(true)
    self._moveNode:line({
        { "fadeto", 0.5, 0 },
        { "fn", function()
            if callBack then
               callBack() 
            end
            self:remove()
        end }
    })
    for i, v in ipairs(self._fnQuitHandlerTb) do
        v()
    end
end

function M:quit3(callBack)
    --子节点跟随父节点透明度
    self._moveNode:setCascadeOpacityEnabled(true)
    self._moveNode:line({
        {"union", {
            { "fadeto", 0.5, 0 },
            { "scaleto", 0.5, 1.3}
        }},
        { "fn", function()
            if callBack then
                callBack()
            end
            self:remove()
        end }
    })
end

function M:quit4(callBack)
    local quitPos = ifnil(self._quitPos, cc.p(-V.w / 1.5, 0))
    self._moveNode:line({
        { "union", {
            { "scaleto", 1.6, 0.5 },
            { "easing", "backin", { "moveby", 1.6, quitPos }}
        } },
        { "fn", function()
            self:remove()
        end }
    })
    for i, v in ipairs(self._fnQuitHandlerTb) do
        v()
    end
    if callBack then
        callBack()
    end
end

--加入退场函数
function M:insertQuitHandlerTb(handler)
    table.insert(self._fnQuitHandlerTb, handler)
end

--加入进场函数表
function M:insertEnterHandlerTb(handler)
    table.insert(self._fnEnterHandlerTb, handler)
end


---------------------
--页面二人物
---------------------
--加载女娃
function M:loadGirlPage2()
    --加载女娃
    local girl = D.img("handbook/paper/2/7_1.png"):to(self._childrenNodeTb[4], 10):p(-72.7, -149):anchor(cc.p(0.16, -0.29))
    --子节点跟随父节点透明度
    girl:setCascadeOpacityEnabled(true)
    
    local legL = D.img("handbook/paper/2/10.png"):to(girl, -1):p(15.6, -7.8)
    local legR  = D.img("handbook/paper/2/11.png"):to(girl, -1):p(39.5, 6.8):anchor(cc.p(0.33, 0.91))
    local handL = D.img("handbook/paper/2/8.png"):to(girl, -1):p(13.6, 46.5):anchor(cc.p(0.88, 0.68))
    local handR = D.img("handbook/paper/2/9.png"):to(girl, -1):p(40.8, 53.4):anchor(cc.p(0.11, 0.23))
    local head  = D.img("handbook/paper/2/6_1.png"):to(girl, -1):p(31.2, 61.8):anchor(cc.p(0.71, 0.05))

    --加入函数表
    self:insertHandlerTb(function ()
        self:paperRotate(girl, 0.5, 4)
        self:paperRotate(handL, 0.5, 5)
        self:paperRotate(handR, 0.5, -40)
        self:paperRotate(legR, 0.5, -8)
        --播放帧动画
        self:playPaperAni(head, 6, 2, 1 / 2)
        self:playPaperAni(girl, 7, 2, 1 / 3)
    end)
end

--加载男娃
function M:loadBoyPage2()
    --加载男娃
    local boy = D.img("handbook/paper/2/14.png"):to(self._childrenNodeTb[4], 10):p(75.2, -145.1):anchor(cc.p(0.26, 0.05))
    --子节点跟随父节点透明度
    boy:setCascadeOpacityEnabled(true)
    local head = D.img("handbook/paper/2/12_1.png"):to(boy, 1):p(39.7, 100):anchor(cc.p(0.47, 0.02))
    local thing = D.img("handbook/paper/2/13_1.png"):to(boy, 1):p(38.6, 80.3)

    --加入函数表
    self:insertHandlerTb(function()
        self:paperRotate(boy, 0.6, 3)
        self:paperRotate(head, 0.6, 6)
        --播放帧动画
        self:playPaperAni(thing, 13, 2)
        self:playPaperAni(head, 12, 2, 1 / 2)
    end)
end

---------------------
--页面三人物
---------------------
--加载页面三女娃
function M:loadGirlPage3()
    --加载女娃
    local girl = D.img("handbook/paper/3/5_1.png"):to(self._childrenNodeTb[2], 10):p(-92.3, -128.8):anchor(cc.p(0.16, -0.29))
    --子节点跟随父节点透明度
    girl:setCascadeOpacityEnabled(true)
    local head = D.img("handbook/paper/3/4_1.png"):to(girl, -1):p(36.4, 46.2):anchor(cc.p(0.26, 0.14))
    local handL1 = D.img("handbook/paper/3/6.png"):to(girl, 3):p(28.1, 45.8):anchor(cc.p(0.83, 0.89))
    local handL2 = D.img("handbook/paper/3/6_1.png"):to(handL1, 1):p(7, 7.5):anchor(cc.p(0.16, 0.82)):rotate(-20)
    local broom = D.img("handbook/paper/3/7.png"):to(handL2, -1):p(31.5,  -8):anchor(cc.p(0.3, 0.5)):rotate(6)
    local handR = D.img("handbook/paper/3/8.png"):to(girl, 3):p(47.5, 39):anchor(cc.p(0.23, 0.92)):rotate(-16)
    local legL = D.img("handbook/paper/3/9.png"):to(girl, -1):p(17.3, -6.5)
    local legR = D.img("handbook/paper/3/10.png"):to(girl, -1):p(32.1, 3.4):anchor(cc.p(0.33, 0.91))

    --子节点跟随父节点透明度
    handL1:setCascadeOpacityEnabled(true)
    --子节点跟随父节点透明度
    handL2:setCascadeOpacityEnabled(true)
    --加入函数表
    self:insertHandlerTb(function()
        self:paperRotate(girl, 0.5, 3)
        self:paperRotate(handL1, 0.5, -30)
        self:paperRotate(handL2, 0.5, 15)
        self:paperRotate(broom, 0.5, -10)
        self:paperRotate(handR, 0.5, -20)
        --播放帧动画
        self:playPaperAni(girl, 5, 2)
        self:playPaperAni(head, 4, 2, 1 / 2)
        --加载灰尘
        self:playDust()
    end)
end

--加载页面三妈妈
function M:loadMomPage3()
    --加载妈妈
    local mom = D.img("handbook/paper/3/12_1.png"):to(self._childrenNodeTb[2], 10):p(31.2, -133.6):anchor(cc.p(0.25, -0.37))
    --子节点跟随父节点透明度
    mom:setCascadeOpacityEnabled(true)
    local head = D.img("handbook/paper/3/11.png"):to(mom, -1):p(31.1, 76.5):anchor(cc.p(0.48, 0.16))
    local handL = D.img("handbook/paper/3/13.png"):to(mom, -1):p(15.5, 68.3):anchor(cc.p(0.9, 0.9))
    local handR = D.img("handbook/paper/3/14.png"):to(mom, 1):p(43.9, 67):anchor(cc.p(0.35, 0.88))
    --子节点跟随父节点透明度
    handR:setCascadeOpacityEnabled(true)
    local broom2 = D.img("handbook/paper/3/15.png"):to(handR, -1):p(6.4, 12.1):anchor(cc.p(0.21, 0.78))

    local legL = D.img("handbook/paper/3/16.png"):to(self._childrenNodeTb[2], 1):p(31.7, -93.7):anchor(cc.p(0.53, 0.93))
    local legR = D.img("handbook/paper/3/17.png"):to(self._childrenNodeTb[2], 1):p(56.1, -96.1):anchor(cc.p(0.43, 0.90))
    local broom1 = D.img("handbook/paper/3/18.png"):to(self._childrenNodeTb[2], 1):p(-6.1, -75.3):anchor(cc.p(0.87, 0.75))


    --加入函数表
    self:insertHandlerTb(function()
        self:paperRotate(head, 0.5, 5)
        self:paperMove(mom, 0.5, cc.p(0, 2))
        self:paperRotate(handR, 0.5, -3)
        --播放帧动画
        self:playPaperAni(mom, 12, 2)
    end)
end

--加载灰尘
function M:playDust()
    local dust = D.img("handbook/paper/1/4.png"):to(self._childrenNodeTb[2], 1):p(-35.6, -116.5):scale(0)
    dust:cycle({
        {"union", {
            { "rotateBy", 0.7, math.random(-30, 30) },
            { "moveBy", 0.7, cc.p(math.random(8, 15), math.random(10, 16)) },
            { "fadeto", 0.7, 0},
            { "scaleTo", 0.7, 1.5}
        }},
        {"Delay", 0.3},
        { "fn", function()
            dust:p(-35.6, -116.5):opacity(255):scale(0)
        end },
    })
end

---------------------
--页面四人物
---------------------
--加载页面4妈妈
function M:loadMomPage4()
    --加载妈妈
    local mom = D.img("handbook/paper/4/5_1.png"):to(self._childrenNodeTb[2], 10):p(77.4, -107.2):anchor(cc.p(0.25, -0.37))
    --子节点跟随父节点透明度
    mom:setCascadeOpacityEnabled(true)
    -- Tools:adjustAnchor(paper)
    local head = D.img("handbook/paper/4/4.png"):to(mom, -1):p(37.8, 84.5):anchor(cc.p(0.54, 0.07))
    local handL = D.img("handbook/paper/4/6.png"):to(mom, -1):p(38.1, 77.7):anchor(cc.p(0.92, 0.79))
    local handR = D.img("handbook/paper/4/7.png"):to(mom, 2):p(48.9, 76):anchor(cc.p(0.90, 0.88))
    local thing = D.img("handbook/paper/4/8.png"):to(mom, 1):p(1.8, 45.2):anchor(cc.p(0.85, 0.41))

    --左右臂
    local legR = D.img("handbook/paper/4/10.png"):to(self._childrenNodeTb[2], 9):p(109.6, -104.98):anchor(cc.p(0.56, 0.1))
    local legL = D.img("handbook/paper/4/9.png"):to(self._childrenNodeTb[2], 9):p(75.7, -99.3):anchor(cc.p(0.37, 0.12))
    -- Tools:adjustAnchor(legL)

    --加入函数表
    self:insertHandlerTb(function()
        self:paperMove(mom, 0.55, cc.p(4, 0))
        self:paperMove(thing, 0.55, cc.p(3, 0))
        self:paperRotate(handR, 0.6, 6)
        self:paperRotate(handL, 0.55, 8)
        self:paperRotate(legL, 0.55, -5)
        self:paperRotate(legR, 0.55, -6)
        --播放帧动画
        self:playPaperAni(mom, 5, 2)
    end)
end

--加载页面4女孩
function M:loadGirlPage4()
    --加载女娃
    local girl = D.img("handbook/paper/4/17_1.png"):to(self._childrenNodeTb[1], 4):p(-107.0, -151.0):anchor(cc.p(0.16, -0.29))
    --子节点跟随父节点透明度
    girl:setCascadeOpacityEnabled(true)
    local head = D.img("handbook/paper/4/16.png"):to(girl, -1):p(32.2, 46.4):anchor(cc.p(0.39, 0.04))
    local handL = D.img("handbook/paper/4/18.png"):to(girl, 3):p(25.5, 41.7):anchor(cc.p(0.09, 0.93))
    local handR = D.img("handbook/paper/4/19.png"):to(girl, -1):p(28.1, 42.3):anchor(cc.p(0.09, 0.88))

    local legL = D.img("handbook/paper/4/20.png"):to(girl, -1):p(15.7, 12.8):anchor(cc.p(0.80, 0.79))
    local legR = D.img("handbook/paper/4/21.png"):to(girl, -1):p(27.7, 6.4):anchor(cc.p(0.37, 0.87))


    local thing1 = D.img("handbook/paper/4/15.png"):to(handL, -1):p(22.8, 25.1):anchor(cc.p(0.09, 0.88))
    local thing2 = D.img("handbook/paper/4/14.png"):to(thing1, 1):p(12.5, 46.4):anchor(cc.p(0.09, 0.88))
    --子节点跟随父节点透明度
    handL:setCascadeOpacityEnabled(true)
    --子节点跟随父节点透明度
    thing1:setCascadeOpacityEnabled(true)
    -- Tools:adjustAnchor(legR)
    --加入函数表
    self:insertHandlerTb(function()
        self:paperRotate(handL, 0.5, -2)
        self:paperRotate(head, 0.5, 6)
        self:paperRotate(legL, 0.5, -8)
        --播放帧动画
        self:playPaperAni(girl, 17, 2)
    end)

end


---------------------
--页面五人物
---------------------
--加载页面五狗
function M:loadDogPage5()
    local dog = D.img("handbook/paper/5/8.png"):to(self._childrenNodeTb[3], 4):p(-75.9, -159.6):anchor(cc.p(0.16, 0.18)) 
    --子节点跟随父节点透明度
    dog:setCascadeOpacityEnabled(true)
    local head = D.img("handbook/paper/5/7.png"):to(dog, 4):p(21.6, 22.9):anchor(cc.p(0.62, 0.09))
    local tail = D.img("handbook/paper/5/9.png"):to(dog, -4):p(10.5, 18.7):anchor(cc.p(0.95, 0.22))
    -- Tools:adjustAnchor(tail)

    --加入函数表
    self:insertHandlerTb(function()
        self:paperRotate(dog, 0.5, -2)
        self:paperRotate(head, 0.5, -2)
        self:paperRotate(tail, 0.15, 15)
    end)
end

--加载页面五男孩
function M:loadBoyPage5()
    local boy = D.img("handbook/paper/5/15.png"):to(self._childrenNodeTb[2], 4):p(11, -154.1):anchor(cc.p(0.16, 0.18))
    --子节点跟随父节点透明度
    boy:setCascadeOpacityEnabled(true)
    local body = D.img("handbook/paper/5/11_1.png"):to(boy, 4):p(10.5, 36.5):anchor(cc.p(0.70, 0.14))
    --子节点跟随父节点透明度
    body:setCascadeOpacityEnabled(true)
    local head = D.img("handbook/paper/5/10_1.png"):to(body, 4):p(32.6, 42.6):anchor(cc.p(0.56, 0.08))

    local handL = D.img("handbook/paper/5/12.png"):to(body, 4):p(23.8, 37.9):anchor(cc.p(0.07, 0.88))
    local handR = D.img("handbook/paper/5/13.png"):to(body, -4):p(22, 35.1):anchor(cc.p(0.10, 0.63))
    local legL = D.img("handbook/paper/5/14.png"):to(body, -4):p(15, 11.4):anchor(cc.p(0.84, 0.85))

    --加入函数表
    self:insertHandlerTb(function()
        self:paperRotate(body, 0.5, -3)
        self:paperRotate(legL, 0.5, -10)
        self:paperRotate(handL, 0.5, 10)
        self:paperRotate(handR, 0.5, 6)
        self:paperRotate(head, 0.5, -3)
        --播放帧动画
        self:playPaperAni(body, 11, 2, 1 / 2)
        self:playPaperAni(head, 10, 2, 1 / 2)
    end)
end

--加载页面五爷爷
function M:loadManPage5()
    local man = D.img("handbook/paper/5/17.png"):to(self._childrenNodeTb[1], 4):p(77.2, -104.2):anchor(cc.p(0.16, 0.18))
    --子节点跟随父节点透明度
    man:setCascadeOpacityEnabled(true)
    local head = D.img("handbook/paper/5/16.png"):to(man, 4):p(20.8, 53.8):anchor(cc.p(0.47, 0.06))
    local hand = D.img("handbook/paper/5/18.png"):to(man, -4):p(13.5, 41.1):anchor(cc.p(0.92, 0.61))
    local legL = D.img("handbook/paper/5/19.png"):to(man, -4):p(46.4, -11.6):anchor(cc.p(0.92, 0.61))
    local legR = D.img("handbook/paper/5/20.png"):to(man, -4):p(26.5, -11.4):anchor(cc.p(0.92, 0.61))

    --加入函数表
    self:insertHandlerTb(function()
        self:paperRotate(hand, 0.5, 20)
        self:paperRotate(head, 0.5, 6)
    end)
end


---------------------
--页面六人物
---------------------
--加载页面6男孩
function M:loadBoy1Page6()
    local boy = D.img("handbook/paper/6/11.png"):to(self._childrenNodeTb[3], 4):p(-118.9,-66.9):anchor(cc.p(0.37, 0.12))
    --子节点跟随父节点透明度
    boy:setCascadeOpacityEnabled(true)
    local body = D.img("handbook/paper/6/9.png"):to(boy, 4):p(13.3,43.3):anchor(cc.p(0.17, 0.81))
    local handL = D.img("handbook/paper/6/7.png"):to(boy, 4):p(55.8, 30):anchor(cc.p(0.11, 0.68))
    local handR = D.img("handbook/paper/6/8.png"):to(boy, 4):p(26, 17.8):anchor(cc.p(0.17, 0.81))
    local head = D.img("handbook/paper/6/6.png"):to(boy, 4):p(56.3, 8.9):anchor(cc.p(0.64, 0.15))
    local leg = D.img("handbook/paper/6/10.png"):to(boy, 1):p(26.4,40.5):anchor(cc.p(0.78, 0.2)):rotate(-15)

    -- Tools:adjustAnchor(leg)

    --加入函数表
    self:insertHandlerTb(function()
        self:paperRotate(boy, 0.5, 3)
        self:paperRotate(leg, 0.5, -15)
        self:paperRotate(handL, 0.5, 10)
        self:paperRotate(handR, 0.5, -10)
    end)
end

--加载页面6男孩
function M:loadBoy2Page6()
    local boy = D.img("handbook/paper/6/16.png"):to(self._childrenNodeTb[4], 4):p(44.1, -129.5):anchor(cc.p(0.2, 0.13))
    --子节点跟随父节点透明度
    boy:setCascadeOpacityEnabled(true)
    local body = D.img("handbook/paper/6/13.png"):to(boy, 4):p(60.4, 43.9):anchor(cc.p(0.52, 0.03))
    --子节点跟随父节点透明度
    body:setCascadeOpacityEnabled(true)
    local head = D.img("handbook/paper/6/12.png"):to(body, 4):p(14.2, 46.7):anchor(cc.p(0.52, 0.03))
    local handL = D.img("handbook/paper/6/14.png"):to(body, -1):p(5.9, 36):anchor(cc.p(0.92, 0.68))
    local handR = D.img("handbook/paper/6/15.png"):to(body, 4):p(32.3, 41.7):anchor(cc.p(0.07, 0.69))
    local leg = D.img("handbook/paper/6/17.png"):to(boy, -4):p(72.8, 50.6):anchor(cc.p(0.2, 0.88))


    --加入函数表
    self:insertHandlerTb(function()
        self:paperRotate(boy, 0.5, 5)
        self:paperRotate(leg, 0.5, 5)
        self:paperRotate(body, 0.5, -7)
        self:paperRotate(handL, 0.5, -10)
        self:paperRotate(handR, 0.5, -9)
        self:paperRotate(head, 0.5, 7)
    end)
end

--加载页面6鸡
function M:loadChickenPage6()
    local chicken = D.img("handbook/paper/6/19.png"):to(self._childrenNodeTb[5], 4):p(-13.6, -138.6):anchor(cc.p(0.47, 0.05))
    --子节点跟随父节点透明度
    chicken:setCascadeOpacityEnabled(true)
    local face = D.img("handbook/paper/6/20_1.png"):to(chicken, 4):p(23, 44.8):anchor(cc.p(0.47, 0.05))
    local head = D.img("handbook/paper/6/18.png"):to(chicken, -4):p(9.2, 69):anchor(cc.p(0.47, 0.05))
    local handL = D.img("handbook/paper/6/21.png"):to(chicken, 2):p(10.4, 43.7):anchor(cc.p(0.73, 0.83))
    local handR = D.img("handbook/paper/6/22.png"):to(chicken, -2):p(23.8, 45.3):anchor(cc.p(0.13, 0.72))
    local tail = D.img("handbook/paper/6/23_1.png"):to(chicken, -2):p(3.5,  31.4):anchor(cc.p(0.92, 0.29))

    --加入函数表
    self:insertHandlerTb(function()
        self:paperRotate(chicken, 0.4, -5)
        self:paperRotate(handL, 0.07, -30)
        self:paperRotate(handR, 0.07, 30)
        self:paperMove(head, 0.4, cc.p(0, 5))
        --播放帧动画
        self:playPaperAni(face, 20, 2, 1 / 2)
        self:playPaperAni(tail, 23, 2, 1 / 2)
    end)
    --羽毛飞
    self:featherFly()
end


--羽毛飞
function M:featherFly()
    local feather1 = D.img("handbook/paper/6/24.png"):to(self._childrenNodeTb[5], 3):p(-6, -108.6)
    local feather2 = D.img("handbook/paper/6/24.png"):to(self._childrenNodeTb[5], 3):p(-6, -100.6)
    local feather3 = D.img("handbook/paper/6/24.png"):to(self._childrenNodeTb[5], 3):p(-6, -100.6)
    local function featherFlyAct(feather, offset)
        local time  = math.random(50, 60)/100
        local rateX = math.random(20, 35) / 10
        local rateY = math.random(20, 35) / 10
        local angle = math.random(0, 180)
        feather:line({
            { "union", {
                { "line", {
                    { "Delay", time - 0.05 },
                    { "fadeTo", 0.05, 0 }
                } },
                { "rotateby", time, angle},
                { "moveBy", time, cc.p(offset.x * rateX, offset.y * rateY) },
            } },
            { "fn", function()
                feather:p(-6, -108.6):opacity(255)
                featherFlyAct(feather, offset)
            end }
        })
    end
    --加入函数表
    self:insertHandlerTb(function()
        featherFlyAct(feather1, cc.p(-30, -10))
        featherFlyAct(feather2, cc.p(30, 30))
        featherFlyAct(feather3, cc.p(-30, 30))
    end)
end

---------------------
--页面八人物
---------------------
--加载页面八女孩
function M:loadGirlPage8()
    --加载女娃
    local girl = D.img("handbook/paper/8/16.png"):to(self._childrenNodeTb[3], 10):p(58.9, -150.9):anchor(cc.p(0.48, 0.09))
    --子节点跟随父节点透明度
    girl:setCascadeOpacityEnabled(true)
    local leg = D.img("handbook/paper/8/17.png"):to(girl, 4):p(30.4, 3):anchor(cc.p(0.48, 0.09))
    local body = D.img("handbook/paper/8/12_1.png"):to(girl, 4):p(19.5,27.4):anchor(cc.p(0.48, 0.09))
    --子节点跟随父节点透明度
    body:setCascadeOpacityEnabled(true)
    local handL = D.img("handbook/paper/8/13.png"):to(body, -1):p(28.5, 54.4):anchor(cc.p(0.88, 0.84))
    local handR = D.img("handbook/paper/8/13.png"):to(body, 3):p(37.9, 48):anchor(cc.p(0.88, 0.84))
    local thing = D.img("handbook/paper/8/14.png"):to(body, 2):p(21.6, 51.1):anchor(cc.p(0.88, 0.84))
    local head = D.img("handbook/paper/8/11_1.png"):to(body, -1):p(27.7, 58.9):anchor(cc.p(0.28, 0.09))

    --加入函数表
    self:insertHandlerTb(function()
        self:paperMove(body, 0.6, cc.p(0, 2))
        self:paperRotate(head, 0.4, 5)
        --播放帧动画
        self:playPaperAni(body, 12, 2, 1 / 3)
        self:playPaperAni(head, 11, 2, 1 / 3)
        --烟雾
        self:smokeAct(thing)
    end)
end

--加载页面八妈妈
function M:loadMomPage8()
    --加载女娃
    local mom = D.img("handbook/paper/8/6.png"):to(self._childrenNodeTb[4], 10):p(-56.3, -151.1):anchor(cc.p(0.48, 0.09))
    --子节点跟随父节点透明度
    mom:setCascadeOpacityEnabled(true)
    local leg = D.img("handbook/paper/8/7.png"):to(mom, 4):p(41.8, 3.6):anchor(cc.p(0.48, 0.09))
    local body = D.img("handbook/paper/8/5.png"):to(mom, 4):p(27.8, 46.5):anchor(cc.p(0.48, 0.09))
    --子节点跟随父节点透明度
    body:setCascadeOpacityEnabled(true)
    local handL = D.img("handbook/paper/8/8.png"):to(body, -1):p(36.6, 81.3):anchor(cc.p(0.79, 0.85))
    local handR = D.img("handbook/paper/8/9.png"):to(body, 3):p(55.4, 83.8):anchor(cc.p(0.63, 0.89))
    local thing = D.img("handbook/paper/8/10.png"):to(body, 2):p(40.5, 74):anchor(cc.p(0.88, 0.84))
    local head = D.img("handbook/paper/8/4.png"):to(body, -1):p(38.4, 92.4):anchor(cc.p(0.51, 0.15))
    -- Tools:adjustAnchor(head)

    --加入函数表
    self:insertHandlerTb(function()
        self:paperMove(body, 0.6, cc.p(0, 2.5))
        self:paperRotate(head, 0.4, 2)
        --烟雾
        self:smokeAct(thing, { cc.p(12.2, 68.1), cc.p(24.7, 65.4), cc.p(38.9, 60.1), cc.p(33, 62),})
    end)
end

---------------------
--页面十人物
---------------------
--加载页面十女孩
function M:loadGirlPage10()
    --加载女娃
    local girl = D.img("handbook/paper/10/18.png"):to(self._childrenNodeTb[5], 10):p(22.9, -135.3):anchor(cc.p(0.48, 0.09))
    --子节点跟随父节点透明度
    girl:setCascadeOpacityEnabled(true)
    local leg = D.img("handbook/paper/10/19.png"):to(girl, 4):p(26.2, 2.8):anchor(cc.p(0.48, 0.09))
    local body = D.img("handbook/paper/10/17_1.png"):to(girl, 4):p(15, 29.3):anchor(cc.p(0.48, 0.09))
    --子节点跟随父节点透明度
    body:setCascadeOpacityEnabled(true)
    local head = D.img("handbook/paper/10/13_1.png"):to(body, 4):p(25.5, 44.7):anchor(cc.p(0.46, 0.12))
    local head2 = D.img("handbook/paper/10/16.png"):to(body, 4):p(21.7, 31.8):anchor(cc.p(0.46, 0.12))
    local handL = D.img("handbook/paper/10/14.png"):to(body, -1):p(15.6, 37.9):anchor(cc.p(0.9, 0.56))
    local handR = D.img("handbook/paper/10/15.png"):to(body, -1):p(32.2, 34.3):anchor(cc.p(0.09, 0.25))


    --加入函数表
    self:insertHandlerTb(function()
        self:paperMove(body, 0.6, cc.p(0, 2.5))
        self:paperRotate(handL, 0.6, -13)
        self:paperRotate(handR, 0.6, 13)
        --播放帧动画
        self:playPaperAni(body, 17, 2, 1 / 3)
        self:playPaperAni(head, 13, 2, 1 / 3)
    end)
end

--加载页面十男孩
function M:loadBoyPage10()
    --加载女娃
    local boy = D.img("handbook/paper/10/12.png"):to(self._childrenNodeTb[4], 10):p(-70.0, -134.3):anchor(cc.p(0.48, 0.09))
    --子节点跟随父节点透明度
    boy:setCascadeOpacityEnabled(true)
    local body = D.img("handbook/paper/10/11.png"):to(boy, 4):p(19.2, 40.3):anchor(cc.p(0.53, 0.1))
    --子节点跟随父节点透明度
    body:setCascadeOpacityEnabled(true)
    local handL = D.img("handbook/paper/10/9.png"):to(body, -1):p(23.3, 33.7):anchor(cc.p(1.43, 0.04))
    --子节点跟随父节点透明度
    handL:setCascadeOpacityEnabled(true)
    local handR = D.img("handbook/paper/10/10.png"):to(handL, 1):p(34.5, 1.2):anchor(cc.p(-0.24, -0))
    local head = D.img("handbook/paper/10/8.png"):to(body, -2):p(22.2,  42.1):anchor(cc.p(0.58, 0.1))
    local thing = D.img("handbook/paper/10/7.png"):to(handL, -2):p(32.1, 38.8):anchor(cc.p(0.58, 0.1))
    -- Tools:adjustAnchor(handL)
    -- Tools:adjustAnchor(handR)

    --加入函数表
    self:insertHandlerTb(function()
        self:paperMove(body, 0.6, cc.p(0, 2))
        self:paperRotate(body, 0.6, -2)
        self:paperRotate(handL, 0.6, 10)
        self:paperRotate(head, 0.6, 5)
    end)
end



---------------------
--方法
---------------------
--播放帧动画
function M:playPaperAni(node, id, num, time)
    time = ifnil(time, 1/3)
    node:cycle({
        { "image", "handbook/paper/"..self._id.."/"..id.."_", num, time }
    })
end

--剪纸摇晃
function M:paperRotate(node, time, angle)
    node:cycle({
        { "rotateby", time, -angle },
        { "rotateby", time, angle },
    })
end

--剪纸移动
function M:paperMove(node, time, pos)
    node:cycle({
        { "moveby", time, cc.p(pos.x, pos.y) },
        { "moveby", time, cc.p(-pos.x, -pos.y) },
    })
end

--剪纸放大
function M:paperScale(node, time, size)
    --子节点跟随父节点透明度
    node:setCascadeOpacityEnabled(true)
    local nodeSize = node:scale()
    node:cycle({
        { "scaleto", time, nodeSize - size },
        { "scaleto", time, nodeSize + size },
    })
end

--烟雾
function M:smokeAct(node, posTb)
    --子节点跟随父节点透明度
    node:setCascadeOpacityEnabled(true)
    if not node._smokeIndex then
        node._smokeIndex = 0
    end 
    --加载烟雾
    node._smokeIndex = node._smokeIndex + 1
    if node._smokeIndex > 4 then
        node._smokeIndex = 1
    end
    local index = node._smokeIndex
    local posTb = ifnil(posTb, { cc.p(12.2, 38.1), cc.p(24.7, 35.4), cc.p(38.9, 30.1), cc.p(33, 32),})
    local newPos = posTb[index]--self:convertToWorldSpace(pos[index])
    local offset =  0
    local smoke = D.img("handbook/paper/1/"..math.random(4, 5)..".png"):p(newPos.x, newPos.y + offset):to(node, node:z())--:scale(0)
    smoke:line({
        { "union", {
            { "rotateBy", 1, math.random(-30, 30) },
            { "moveBy", 1, cc.p(math.random(-15, 15), math.random(20, 30)) },
            { "line", {
                { "fadeOut", 1 },
                { "sinBy", 1, ccp(0, 20), 20, 2 },
            } },
            { "line", {
                { "delay", 0.3 },
                { "fn", function()
                    if not self._isStopSmoke then
                        self:smokeAct(node, posTb)
                    end
                end },
            } },
        } },
        { "remove" },
    })
end

--加入函数表
function M:insertHandlerTb(handler)
    table.insert(self._fnHandlerTb, handler)
end

--剪纸动起来
function M:paperOpenAct()
    for i, handlera in ipairs(self._fnHandlerTb) do
        handlera()
    end
end

--剪纸停止动
function M:paperPauseAct()
    local function pauseNodeAction(node)
        -- node:stopAllActions()
        A.pauseTarget(node)
        -- 要展示的节点出现
        local children = node:getChildren()
        for i, v in ipairs(children) do
            -- v:stopAllActions()
            A.pauseTarget(v)
            local children2 = v:getChildren()
            for i1, v1 in pairs(children2) do
                pauseNodeAction(v1)
            end
        end
    end
    pauseNodeAction(self._moveNode)
end

--剪纸恢复动
function M:paperResumeAct()
    local function resumeNodeAction(node)
        -- node:stopAllActions()
        A.resumeTarget(node)
        -- 要展示的节点出现
        local children = node:getChildren()
        for i, v in ipairs(children) do
            -- v:stopAllActions()
            A.resumeTarget(v)
            local children2 = v:getChildren()
            for i1, v1 in pairs(children2) do
                resumeNodeAction(v1)
            end
        end
    end
    resumeNodeAction(self._moveNode)
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    -- if self._layer._canTouch then
    --     if self._canTouch then
    --         return true
    --     end
    -- end
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
