--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch = true
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 加载背景
    self:loadBg()
    -- 加载结点
    self:loadPageNode()
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
    umengOP.recordOpenAniBegin()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- 播放音效[057BGM03]选择界面
    sound:play057BGM03()
    --开始说话
    self:startTalk()
end

--加载背景
function M:loadBg()
    local bg = U.loadBg("tfroom/bg.png"):to(self):bindTouch()
    self._bg = bg
end

-- 加载结点
function M:loadPageNode()
    -- 加载家具
    self:loadFurniture()
    -- 加载大花瓶
    self:loadBigVase()
    -- 加载小花瓶
    self:loadSmallVase()
    -- 加载窗户
    self:loadWindow()
    -- 加载挂饰
    self:loadDecorate()
    --加载灯
    self:loadLight()
    --加载奇奇
    self:loadQq()
    --加载妙妙
    self:loadMm()
    --加载浮想框未打开
    self:loadThinkBox()
end


-- 加载家具
function M:loadFurniture()
    -- 加载沙发
    local pos = { ccp(512.3, 202.6), ccp(754.7, 121.7), ccp(261.9, 120.8) }
    local zorder = {50, 100, 100}
    for i = 1, 3 do
        local sofa = D.img("tfroom/furniture/sofa" .. i .. ".png"):to(self._bg, zorder[i]):p(pos[i]):scale(0.86)
    end
    -- 加载桌子
    local desk    = D.img("tfroom/furniture/desk.png"):to(self._bg, 100):p(515.6, 95.4):scale(0.86)
end

-- 加载大花瓶
function M:loadBigVase()
    -- G_FLOWER_TB = {4, 3, 1, 2}
    -- G_FLOWER_ISFLIPX = {true, true, true, true, false, false}
    local bigFlowerConfig = G_ROOM_DECORATE_CONFIG["bigFlowerTb"]
    local pos = { ccp(140, 238.1), ccp(885, 238.1) }
    for i = 1, 2 do
        -- 加载瓶身
        local vase    = import("app.tfroom.node.BigVase").new({
            imgName = "tfroom/flower/big/vase.png",
            layer    = self,
            index    = i,
        }):to(self._bg, 50):p(pos[i]):scale(0.86)
        local vase1 = D.img("tfroom/flower/big/vase1.png"):to(vase, -2):p(41.8, 145.1):scale(1)
        for j = 1, 3 do
            local flowerId = bigFlowerConfig[j]
            local flipX, angle, pos1, tier = Tools:getFlowerConfig(flowerId, j, 1)
            local flower = D.img("tfroom/flower/big/" .. flowerId .. ".png")
            :anchor(ccp(0.5, 0)):to(vase, tier):p(pos1):flipX(flipX):rotate(angle)
        end
    end

end

-- 加载小花瓶
function M:loadSmallVase()
    -- 加载瓶身
    local smallVase = import("app.tfroom.node.SmallVase").new({
        imgName = "tfroom/flower/small/vase.png",
        layer    = self,
    }):to(self._bg, 100):p(578.6, 149.4):scale(0.86):bindTouch()
    local vase1    = D.img("tfroom/flower/small/vase1.png"):to(smallVase, -2):p(29.6, 66.2):scale(1)
    self._smallVase = smallVase

    local smallFlowerConfig = G_ROOM_DECORATE_CONFIG["smallFlowerTb"]
    for j = 1, 3 do
        local flowerId = smallFlowerConfig[j]
        local flipX, angle, pos1, tier = Tools:getFlowerConfig(flowerId, j, 2)
        local flower = D.img("tfroom/flower/small/" .. flowerId .. ".png")
        :anchor(ccp(0.5, 0)):to(smallVase, tier):p(pos1):flipX(flipX):rotate(angle)
    end
end

-- 加载窗户
function M:loadWindow()
    local frame = D.img("tfroom/door/frame.png"):to(self._bg, 30):p(512.5, 414.6):scale(0.86)
    local windowbg = D.img("evemoney/win/winBg.png"):to(frame, -1):p(152, 150.9):scale(1.1)

    local pos = { ccp(205, 155), ccp(100, 155) }
    local decorateConfig = G_ROOM_DECORATE_CONFIG["decorateTb"]
    -- 加载窗花
    for i = 1, 2 do
        local windowFlower = D.img("tfroom/doorflower/" .. decorateConfig[i] .. ".png"):to(frame):p(pos[i]):scale(1.25)
    end

    local clipImg = D.img("evemoney/win/winBg.png"):p(0, 0)--:scaleX(0.08)
    local clip    = CCNodeExtend.extend(cc.ClippingNode:create(clipImg)):p(windowbg:cw() / 2, windowbg:ch() / 2):bindTouch()
    windowbg:addChild(clip, 1)
    -- 设置裁剪区域的显示，false为显示裁剪的区域，true为裁剪后的区域(很关键)
    clip:setInverted(false)
    clip:setAlphaThreshold(0)
    local tree = D.img("evemoney/win/1.png"):to(clip, 1):p(161.7, -43):anchor(cc.p(1,0))
    commonAct:breathing(tree)
    local tree = D.img("evemoney/win/2.png"):to(clip, 1):p(122.4, -79.2):anchor(cc.p(1, 0))
    commonAct:breathing(tree)

    Tools:loadSnows(clip, 13, nil, 5, nil, {
        posY = 100,
        offset1 = -windowbg:cw()/2, 
        offset2 = windowbg:cw()/2
    }, nil, true)
end

-- 加载装饰
function M:loadDecorate()
    local pos = { ccp(322.1, 390.2), ccp(241.1, 397.6), ccp(779, 397.6), ccp(696.9, 397.6) }
    local decorateConfig = G_ROOM_DECORATE_CONFIG["decorateTb"]
    for i = 1, 4 do
        local decorate = D.img("tfroom/decorate/" .. decorateConfig[i + 2] .. ".png"):to(self._bg):p(pos[i]):scale(0.86)
    end
end

--加载灯
function M:loadLight()
    local posTb = { cc.p(251.6, 596), cc.p(711.9, 604.8)}
    for i, v in ipairs(posTb) do
        local light = D.img("evemoney/light.png"):to(self, 10):p(v)
    end
end

--加载奇奇
function M:loadQq()
    local enterPos = cc.p(461.6, 272.7)
    local qq = import("app.openani2.node.AniQq").new({
        layer    = self,
        enterPos = enterPos
    }):to(self._bg, 90):scale(0.8)
    qq:p(enterPos.x, enterPos.y)
    self._qq = qq
end

--加载妙妙
function M:loadMm()
    local enterPos = cc.p(567.6, 267.4)
    local mm = import("app.openani2.node.AniMm").new({
        layer    = self,
        enterPos = enterPos
    }):to(self._bg, 90):scale(0.8)
    mm:p(enterPos.x, enterPos.y)
    self._mm = mm
end

--加载浮想框未打开
function M:loadThinkBox()
    local pos =cc.p(492.2, 348.1)
    local thinkbox = import("app.openani2.node.ThinkBox").new({
        layer      = self,
        id         = 2,
        pos        = pos,
        needBreath = false,
        scaleSize  = 0.88 / BG_SCALE
    }):to(self._bg, 1000):p(pos)
    self._thinkBox = thinkbox
end

--镜头缩进
function M:zoomIn()
    self._bg:line({
        {"union", {
            { "scaleTo", 0.5, BG_SCALE * 1.3},
            { "moveby", 0.5, cc.p(0, -300 + Y_OFFSET)}
        }},
        {"fn", function ()
            self._thinkBox:enter(f)
        end}
    })
end

--开始说话
function M:startTalk()
    -- 看向妙妙（开始）
    self._qq:watchAni()
    -- 看向奇奇（开始）
    self._mm:watchAni()
end

--说话结束，出现浮想框
function M:talkFinish()
    -- 向浮想框（开始）
    self._mm:lookBoxAni1()
    --镜头缩进
    self:zoomIn()
end

--进入下个场景
function M:enterNextScene()
    --洞窥出场
    local title = "openani/box/box.png"
    local pos = self._thinkBox:worldpoint()
    --停止妙妙思考音效
    self:stopMMEffect()
    Tools:exitSceneScale(self, title, 0.7, pos, 1.1, nil, 0.5, function()
        umengOP.recordOpenAniEnd()
        game:enterScene("select", {openAniEnter = true})
    end, "common/exitbg/4.png")
end

--妙妙思考音效
function M:playMMEffect()
    -- 播放音效[sfx05704023]妙妙思考等待
    self._mmEffect = soundEffect:playEffectsfx05704023()
end

--停止妙妙思考音效
function M:stopMMEffect()
    self:line({
        {"delay", 1},
        {"fn", function ()
            if self._mmEffect then
                sound.stopSound(self._mmEffect)
                self._mmEffect = nil
            end      
        end}
    })
end

-- 加载其他
function M:loadRenderOtherwise()

end

--移除粒子表
function M:removeParticleTb(node1)
    if node1 and not tolua.isnull(node1) then
        if node1._myParticleTb then
            for k, particle in pairs(node1._myParticleTb) do
                self:removeParticle(particle)
            end
        end
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    -- 清除图片资源
    R.removeAllTextures()
    R.removeAllFrames()
    -- 清除骨骼资源
    bb.si.DragonBone.removeAll()
    -- 停止音频
    sound.stopAllSounds()
end

return M
