--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 妙妙类
----------------------
local M     = class("AniMm", import("app.common.node.BaseMm"))
M.TAG       = "AniDad"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(880 + X_OFFSET, 175))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:bookBreathAni()
end

-- 呼吸
function M:bookBreathAni()
    self:play("mm_kshx")
end

-- 看向奇奇（开始）
function M:watchAni()
    self:play("mm_kqq1")
end

-- 听奇奇说话（循环）
function M:listenAni()
 	self:play("mm_kqq1_1")
end

-- 向浮想框（开始）
function M:lookBoxAni1()
	--妙妙思考音效
	self._layer:playMMEffect()
    self:play("mm_kfxk1")
end

-- 看浮想框（循环）
function M:lookBoxAni2()
    self:play("mm_kfxk1_1")
end


function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "mm_kqq1" then
			-- 听奇奇说话（循环）
			self:listenAni()
		elseif __moveId == "mm_kfxk1" then
   			-- 看浮想框（循环）
			self:lookBoxAni2()
		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
