--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 奇奇类
----------------------
local M     = class("AniQq", import("app.common.node.BaseQq"))
M.TAG       = "AniDad"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(880 + X_OFFSET, 175))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:bookBreathAni()
end

-- 呼吸
function M:bookBreathAni()
    self:play("qq_kshx")
end

-- 看向妙妙（开始）
function M:watchAni()
    self:play("qq_ksh1")
end

-- 看向妙妙说话（循环）
function M:listenAni()
    self:play("qq_ksh1_1")
end

-- 看向镜头
function M:lookBoxAni1()
    self:play("qq_kqm1")
end

-- 看向镜头呼吸（循环）
function M:lookBoxAni2()
    self:play("qq_kqm1_1")
end


--说话
function M:talkAct()
	-- 看向妙妙说话（循环）
	self:listenAni()
	-- 播放配音[v057181]妙妙，什么时候过年呐~
	soundVoice:playEffectv057181()
	local time = soundVoice:soundDuration("v057181", 2)
	self:line({
		{"delay", time},
		{"fn", function ()
			-- 看向镜头
			self:lookBoxAni1()
			--说话结束，出现浮想框
			self._layer:talkFinish()
		end}
	})
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "qq_ksh1" then
			--说话
			self:talkAct()
		elseif __moveId == "qq_kqm1" then
			-- 看向镜头呼吸（循环）
			self:lookBoxAni2()
		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
