--[[
Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]



--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
	M.super.ctor(self, params)
	--是否为二级页面
	self._isSecondPage   = false
	-- 按钮集合
	self._btns 		= {}
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
	self:loadBg()
	-- 项目配置表【主要在这里配置】
	self:init()
	--阶段选择按钮加载
	self:loadChoosePhaseBtn()
	--加载返回按钮
	self:loadBackBtn()
	--加本地xml清空按钮
	self:loadUStoreClearButton():to(self, 10)
	--加载骨骼查看按钮
	self:loadDragonBoneBtn()
end
-- 背景颜色（需要颜色自己设）
function M:loadBg()
	 U.loadLayer({ color = ccc4(255, 192, 203, 255) }):to(self)
end

--加载骨骼查看按钮
function M:loadDragonBoneBtn()
	-- 按钮图片资源（正常状态，点击状态，禁用状态(可不用)），默认使用框架资源
	local ButtonImages = {
		normal    = "g/setting/btn_lang_box0.png",
		pressed = "g/setting/btn_lang_box1.png",
	-- disabled = "btn_disable.png",
	}
	local btn = cc.ui.UIPushButton.new(ButtonImages, { scale9 = true })
	btn:addTo(self):scale(0.7)
	btn:pos(ccp(V.w_2, V.h - 60))
	btn:setButtonSize(200, 100)
	--按钮标签
	btn.lable = U.loadLabelTTF({
		text        = "骨骼查看器",
		fontSize    = 30,
		color    = COLOR3_WHITE,
		position    = ccp(V.w_2, V.h - 60),
	}):to(self, 100):scale(0.7)
	btn:onButtonClicked(function()
		game:enterScene("Dragonbone")
	end)
end

-- 项目配置表【主要在这里配置】
function M:init()
	-- 阶段名称（阶段二集合记得加上阶段一的）
	self._stageString = {"阶段一", "阶段二", "家长入口"}

	--阶段1的{场景名, 场景名对应的标签名, 需要传的值} (一列8个)
	self._scenes1 = {
				{"tfgoodswalk",         '年货选择',        {} },
				{"tfroom", 	       		'大扫除-客厅', 		{}},
				{"tfcleanwindow",    	'大扫除-擦窗户', 	{}},
				{"tfroom",    			'大扫除-擦花瓶', 	{enterCount = 2}},
				{"tfdoor", 	       		'大扫除-装饰门外(前情)',   {test = false}},
				{ "tfdoor",             '大扫除-装饰门外(春联)',  {test = true, putType = 1} },
				{ "tfdoor",            '大扫除-装饰门外(灯笼)', { test = true, putType =2 } },
				{ "quick",    " ", {} },


				{"evefishingredient",	'鱼-鱼配料',  {}},
				{"evefishboil", 		'鱼-煮鱼',   	{}},
				{"evefishadd", 	   		'鱼-加调料',   {}},
				{ "quick",    " ", {} },
				{ "evedumplingfarci",	'饺子-包馅', 		{} },
				{"evedumplingwater",	'饺子-煮饺子',   	{}},
				{"evedumplingadd", 		'饺子-撒调料',   	{}},
				{ "quick",    " ", {} },


				{ "evekitchen",        '厨房-第一次进来',        {enterNum = 1, fromWhere = 1} },
				{ "evekitchen",        '厨房-第二次进来',        { enterNum = 2, fromWhere = 1 } },
				{ "quick",    " ", {} },
				{ "eveputfood",        '上菜咯',            { type = 1 } },
				{ "eveputfood",        '排排坐咯',        { type = 2 } },
				{ "eveputfood",         '吃饭咯',            { type = 3 } },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },

				{ "evemoney",                '除夕-压岁钱',        {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				
			}

	--阶段2的场景名{场景名, 场景名对应的标签名}
	self._scenes2 = {
				{ "nyvisit",    "拜年", {} },
				{ "nylantern",    "舞龙", {} },
				{ "quick",    " ", {} },
				{ "evefireworkput",    "放置烟花(前情)", { firstEnter = "put", directEnter = false }},
				{ "evefireworkput",    "放置烟花(直接)", { firstEnter = "put", directEnter = true } },
				{ "evefireworkput",    "切烟花", { firstEnter = "cut"}},
				{ "evefireworkput",    "倒计时(前情)", { firstEnter = "countDown", directEnter = false } },
				{ "evefireworkput",    "倒计时(直接)", { firstEnter = "countDown", directEnter = true } },


				{ "handbook",    "开场动画（废弃）", { sceneType = 1 } },
				{ "openani1",    "开场动画", {} },
				{ "Openani2",    "选择过度", {} },
				{ "handbook",    "图鉴页面", { sceneType = 2 } },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },

				{ "select",    "选择页面：一周目", {} },
				{ "select",    "选择页面：非一周目",  { doneGame = 4 } },
				-- { "loading",    "loading", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },

				{ "gameplay",    "欢迎界面", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
			}
	--阶段3的场景名{场景名, 场景名对应的标签名}
	self._scenes3 = {
				{ "tfgoodswalk",        '买年货',        {} },
				{ "tfroom",             '大扫除',        {} },
				{ "tfdoor",             '贴春联', { test = false } },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },	

				{ "evekitchen",        '年夜饭',        { enterNum = 1, fromWhere = 1 } },
				{ "evemoney",           '收红包',        {} },
				{ "evefireworkput",    "放烟花", { firstEnter = "put", directEnter = false } },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },

				{ "nyvisit",    "拜年", {} },
				{ "nylantern",    "舞龙", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} }, 
				{ "quick",    " ", {} },

				{ "gameplay",    "欢迎界面", {} },
				{ "select",    "选择页面：一周目", {} },
				{ "select",    "选择页面：非一周目", { doneGame = 4 } },
				{ "openani1",    "开场动画", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },
				{ "quick",    " ", {} },   
			}
end



----------------------
-- 按钮添加
----------------------
--[[--

选择阶段按钮

--]]
function M:loadChoosePhaseBtn()
	-- 按钮图片资源（正常状态，点击状态，禁用状态(可不用)），默认使用框架资源
	local ButtonImages = {
     	normal 	= "g/setting/btn_lang_box0.png",
        pressed = "g/setting/btn_lang_box1.png",
		-- disabled = "btn_disable.png",
	}
	local string = self._stageString
	local px = {
				{V.w / 2},
				{V.w / 2 - 150, V.w / 2 + 150},
				{V.w / 2 - 300, V.w / 2 , V.w / 2 + 300}
			}
	for k,v in pairs(string) do
		local btn = cc.ui.UIPushButton.new(ButtonImages, {scale9 = true})
	    btn:addTo(self)
	    btn:pos(px[#string][k], V.h / 2)
	    btn:setButtonSize(200, 100)
		--按钮标签
	    btn.lable = U.loadLabelTTF({ 
		        text        = v, 
		        fontSize    = 20, 
		        color       = COLOR3_WHITE,
		        position    = ccp(px[#string][k], V.h / 2),
		    }):to(self, 100)
	    table.insert(self._btns, btn)
	end
	--按钮点击
	self:choosePhaseBtnClicked()

end
--[[--

返回按钮

--]]
function M:loadBackBtn()
    local back = D.img('g/button/btn_back.png'):p(getButtonX_Left(), V.h - 60):to(self, 11):bindTouch({
		fnBegan = function( target, x, y )
			if target._isTouch then return end
			target._isTouch = true
			target:line({
				{"scaleTo", 0.1, 0.8},
				{"scaleTo", 0.1, 1},
				{"fn", function()
					target._isTouch = false
					if self._isSecondPage then
						-- 退出还原默认
						bb.hotUpdate.reset()
						game:enterScene("quick")
					else
						local nextScene = game:getPreSceneName() or "gameplay"
						bb.si.DragonBone.removeAll()
			            R.removeAllTextures()
						R.removeAllFrames()
						if nextScene == "gameplay" or nextScene == "quick" then
							-- 退出还原默认
							bb.hotUpdate.reset()
						end
						game:enterScene(nextScene)
					end 
				end}
			})
    		
    	end,
    	pnCool = true, 
    	coolTime = 1,
    })
end


--[[--

加载清除UStore按钮

--]]
function M:loadUStoreClearButton(pos)
	local pos = ifnil(pos, cc.p(getButtonX_Right(), V.h - 60))

    -- 节点
    local node    = D.img("g/button/btn_delete.png"):p(pos):bindTouchHandled(function(target)
        target:line({
        	{"scaleto", .1, .6},
        	{"scaleto", .1, 1}
        	})
        ST.clearUStore()
    end)

    return node
end








----------------------
-- 按钮逻辑
----------------------
--[[--

选择阶段按钮点击逻辑

--]]
function M:choosePhaseBtnClicked()
	for k,v in pairs(self._btns) do
		v:onButtonClicked(function()
			--隐藏阶段按钮
			for i,v1 in pairs(self._btns) do
				v1:hide()
				v1.lable:hide()
			end
			self:loadBtns(k)
			--进入二级页面
	    	self._isSecondPage = true
		end)
	end
end





--[[--

阶段n内容按钮逻辑
id 代表阶段几
--]]--
function M:loadBtns(id)
	local scenes  	= {self._scenes1, self._scenes2, self._scenes3}

	local num 	=  math.ceil(#scenes[id] / 8)
	local px 	= {
			{V.w / 2},
			{V.w / 2 - 150, V.w / 2 + 150},
			{V.w / 2 - 300, V.w / 2 , V.w / 2 + 300},
			{V.w / 2 - 350, V.w / 2 - 110 , V.w / 2 + 110, V.w / 2 + 350}
		}
	local title = {
		{ "【廿四】", "【除夕-做菜】", "【除夕-上菜】" , "【除夕-红包】"},
		{ "【春节】", "【开场动画 + 图鉴】", "【选择】", "【欢迎】",},
		{ "【廿四】", "【除夕】", "【大年初一】", "【其他】",}
	}
	local color = {
		{ ccc3(135, 206, 250), ccc3(50, 255, 200), ccc3(224, 102, 255) },
		{ ccc3(255, 255, 0), ccc3(255, 150, 185), ccc3(255, 140, 0), ccc3(175, 238, 238) },
		{ ccc3(255, 255, 0), ccc3(255, 150, 185), ccc3(255, 140, 0), ccc3(175, 238, 238) },
	}
	--显示左边列的标签名，点击进入对应场景名的场景
	for i,v in ipairs(scenes[id]) do
 		local lb = U.loadLabelTTF({ 
	        text        = string.format("%s", v[2]), 
	        fontSize    = 20, 
			-- color       = COLOR3_WHITE,
			color    = color[id][math.ceil(i / 8)],
	        position    = ccp(px[num][math.ceil(i / 8)], V.h - 120  - 60 * ((i - 1) % 8) - Y_OFFSET),
	    }):scale(1.4):to(self, 111):bindTouch({
	    	pnSubmit = true,
	    	rectFactorY = 1.5,
	    	fnBegan = function(target, x, y)
	    		target:line({
	    			{"scaleTo", 0.1, 1.1},
	    			{"scaleTo", 0.1, 1.4},
					{"fn", function()
						print(v[1])
						game:enterScene(v[1], v[3])
	    			end}
	    		})
	    	end
	    })
	 end
	 
	 -- 加载模块标题
	for k, v in pairs(title[id]) do
		local lb = U.loadLabelTTF({
			text        = string.format("%s", v),
			fontSize    = 16,
			color        = ccc3(0, 255, 0),
			position    = ccp(px[num][k], V.h - 60 - Y_OFFSET),
		}):scale(1.2):to(self, 111)
	end

end













----------------------
-- 结点析构
----------------------
--[[--

视图析构，处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end


return M
