--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = class('Button', BaseButton)


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
	M.super.ctor(self, params)
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self, params)
    -- self.btn_back:display("g/button/btn_home.png") 
    self:backBtnHide()
end

-- 返回键隐藏
function M:backBtnHide()
	self.btn_back:hide()
	-- self._isBackBtnHide = true
end

-- 返回键显示
function M:backBtnShow()
    self.btn_back:show():scale(0):unbindTouch()
    self.btn_back:line({
        {"scaleto", 0.2, 1.1},
        {"scaleto", 0.1, 1},
        {"fn", function()
            self.btn_back:bindTouch()
        end},
    })
	-- self._isBackBtnHide = false 
end

--按钮返回键点击事件
function M:btnBackEvent()
    -- self:btnBackOther()
    umengOP.recordSelectEnd()
    -- countProductTime:settlementProduct()
    -- 停止背景音乐
    -- sound.stopMusic()
    self:backBtnHide()
    local mainLayer = self:getScene():getMainLayer()
    mainLayer._handbookBtn:hide():unbindTouch()
    mainLayer:closeTheBook()   
    -- 退出还原默认
    -- bb.hotUpdate.reset()
    -- game:enterScene("select", {})
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end



return M
