--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch   = false
    --完成的数目
    self._doneGame   = self:getScene()._doneGame
    --是否选择结束
    self._isOver     = false
    --非一周目日历
    self._calendarTb = {}
    --是否为开场进入
    self._openAniEnter = self:getScene()._openAniEnter
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 加载结点
    self:loadPageNode()
    --加载彩蛋
    self:loadEggs()
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
    --[友盟][bbgcj003]选择界面进入
    umengOP.recordbbgcj003()
    umengOP.recordSelectBegin()
    -- local labelTTF1 = U.loadLabelTTF({
    --     text        = "进入模块数: "..G_ENTER_GAME,
    --     fontSize    = 19,
    --     position    = ccp(V.w_2-50, V.h - 20),
    --     fontColor = ccc3(0, 0, 0)
    -- }):to(self, 9999):anchor(cc.p(0, 1))
    -- local labelTTF1 = U.loadLabelTTF({
    --     text        = "模块完成数: " .. G_DONE_GAME,
    --     fontSize    = 19,
    --     position    = ccp(V.w_2 - 50, V.h - 50),
    --     fontColor = ccc3(0, 0, 0)
    -- }):to(self, 9999):anchor(cc.p(0, 1))
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    print("是否为开场进入=====》", self._openAniEnter)
    if self._openAniEnter then
        local title = "common/help1.png"
        local time = 0.8
        Tools:enterSceneScale(self, title, time, nil, "common/exitbg/4.png")
        self:line({
            { "delay", time - 0.3 },
            { "fn", function()
                --开始
                self:gameStart()
            end }
        }) 
    else
        if self:getScene()._resetMusic then
            -- 播放音效[057BGM03]选择界面
            -- sound:play057BGM03()
        end
        --开始
        self:gameStart()
    end
    -- 播放音效[057BGM03]选择界面
    sound:play057BGM03()
end

--加载背景
function M:loadBg()
    local bg = U.loadBg("select/bg/bg.png"):to(self)
    --加载其他
    self:loadOtherDecorate()
end

--加载其他
function M:loadOtherDecorate()
    --加载下面的装饰
    self:loadDownDecorate()
    --加载鞭炮
    self:loadFirecrackers()
    --f加载灯笼
    self:loadLantern()
    local light = D.img("select/bg/light.png"):to(self, 1000):p(V.w_2 + 20, 500)
end

--加载下面的装饰
function M:loadDownDecorate()
    local posTb = { cc.p(-50, -49.1), cc.p(114.3, -71.1), cc.p(319.1, -49.8), cc.p(505.1, -64.4),
    cc.p(657.4, -50), cc.p(823.5, -71.4), cc.p(978, -51.3),}
    for i, v in ipairs(posTb) do
        local circle = D.img("select/bg/circle.png"):to(self, math.random(2, 9)):p(v.x + X_OFFSET, v.y)

        local function moveAct1(node)
            local dis = math.random(6, 10)
            local time = math.random(10, 15) / 10
            node:line({
                { "moveBy", time, cc.p(0, dis) },
                { "moveBy", time, cc.p(0, -dis) },
                { "fn", function()
                    return moveAct1(node)
                end }
            })
        end
        moveAct1(circle)
    end

    local posTb = { cc.p(46.5, 77.4), cc.p(204.4, 73.2), cc.p(412.9, 5.6), cc.p(472.7, 84.6),
    cc.p(545.5, 90.9), cc.p(701.9, 10.1), cc.p(764.5, 70.1), cc.p(915.9, 109.8),}
    local idTb = { 1, 3, 1, 4, 3, 2, 1, 2 }
    local zTb = { 1, 1, 9, 1, 1, 9, 2, 1 }
    for i, v in ipairs(posTb) do
        local dec = D.img("select/bg/" .. idTb[i] .. ".png"):to(self, zTb[i]):p(v.x + X_OFFSET, v.y):rotate(math.random(-15, 15))
        local function moveAct2(node)
            local dis = math.random(6, 8)
            local time = math.random(15, 20) / 10
            node:line({
                { "moveBy", time, cc.p(0, dis) },
                { "moveBy", time, cc.p(0, -dis) },
                { "fn", function()
                    return moveAct2(node)
                end }
            })
        end
        moveAct2(dec)
    end
end

--f加载灯笼
function M:loadLantern()
    local posTb = { cc.p(234 + X_OFFSET, 900.2), cc.p(726.6 + X_OFFSET, 900.5),}
    for i, v in ipairs(posTb) do
        local lantern = D.img("select/bg/lantern.png"):to(self, 888):p(v):anchor(ccp(0.5, 1))
        local function moveAct3(node)
            local num = math.random(1, 1)
            A.line({
                { "rotateby", 0.8, -num },
                { "rotateby", 0.8, num },
                { "rotateby", 0.8, num },
                { "rotateby", 0.8, -num },
                { "fn", function()
                    return moveAct3(node)
                end }
            }):at(node)
        end
        moveAct3(lantern)
    end
end

--加载鞭炮
function M:loadFirecrackers()
    local posTb = { cc.p(-10 + X_OFFSET, 760.2), cc.p(979.5 + X_OFFSET, 760.5),}
    local flipX = {1, -1}
    for i, v in ipairs(posTb) do
        local firecrackers = D.img("select/bg/firecrackers.png"):to(self, 999):p(v):anchor(ccp(0.5, 1)):scaleX(flipX[i]):bindTouch()
        local fire1 = D.img("select/bg/fire2.png"):to(firecrackers):p(126.5, -12.8)--:bindTouch()
        local fire2 = D.img("select/bg/fire1.png"):to(firecrackers):p(126.4, -13.4)
        firecrackers._fire1 = fire1
        firecrackers._fire2 = fire2
        self:eggTouchEvent(firecrackers, i)
        fire1:cycle({
            { "scaleTo", 0.5, 1.1},
            { "scaleTo", 0.5, 1},
        })
        fire2:cycle({
            { "scaleTo", 0.5, 1.3 },
            { "scaleTo", 0.5, 1 },
        })
        local function moveAct4(node)
            local num = math.random(1, 2)
            A.line({
                { "rotateby", 0.8, -num },
                { "rotateby", 0.8, num },
                { "rotateby", 0.8, num },
                { "rotateby", 0.8, -num },
                { "fn", function()
                    return moveAct4(node)
                end }
            }):at(node)
        end
        moveAct4(firecrackers)
    end
end

-- 加载结点
function M:loadPageNode()
    local result = ST.getNumber("FIRST_ENTER_SELECT_CALENDAR")
    if self._doneGame < 3 then
        -- 加载背景
        self:loadBg()
        --加载一周目日历
        self:loadNewGameCalendar()
        self._canTouch = false
        self._calender._canTouch = false
        --关闭引导
        self:closeGuide()
        --点击事件
        self._calender:touchEvent()
    else
        -- 加载背景
        self:loadBg2()
        -- 加载三个入口
        self:loadThreeEnter()
        -- 加载主包的三个入口图片
        self:loadThreeMainEnter()
        -- 白屏进场
        self:whiteEnterScene()
    end
    --加载图鉴按钮
    self:loadHandBookBtn()
end

--加载图鉴按钮
function M:loadHandBookBtn()
    if self._doneGame < 3 then return end
    local handbookBtn = import("app.select.node.HandbookBtn").new({
        layer = self,
    }):to(self, 9999):p(cc.p(getButtonX_Right() - 20, V.h - 70)):scale(0)
    self._handbookBtn = handbookBtn
end

--加载一周目日历
function M:loadNewGameCalendar(isBindTouch)
    isBindTouch = ifnil(isBindTouch, true)
    local pos = ccp(V.w_2, 330 + Y_OFFSET)
    -- 因为翻页锚点不是在中间且父节点不是日历，点击缩放就不对，所以加载一个空节点,用于整个日历的缩放
    local node = U.loadNode({}):to(self, 998):p(V.w_2, 500 + Y_OFFSET)
    self._node = node
    local doneGame = self._doneGame <=3 and self._doneGame or 3
    local calender = import("app.select.node.NewGameCalendar").new({
        layer      = self,
        belong     = self._node,
        id         = doneGame + 1
    }):to(node)
    self._calender = calender

    if isBindTouch then
        node:bindTouch()
        self._node:cycle({
            { "rotateby", 1, 4 },
            { "rotateby", 1, -4 },
            { "rotateby", 1, -4 },
            { "rotateby", 1, 4 },
        })
    end
end

--引导
function M:partsGuide()
    if self._partsGuideAction or self._isOver then
        return
    end
    local index = N.random(1, #self._calendarTb)
    local partsGuideAction = A.cycle({
        { "delay", 3 },
        { "fn", function()
            if not tolua.isnull(self._calendarTb[index]) then
                --引导
                self._calendarTb[index]:openGuide()
            end
            index = index + 1
            if index > #self._calendarTb then
                index = 1
            end
        end }
    }):at(self)
    self._partsGuideAction = partsGuideAction
end

--停止引导
function M:stopPartsGuide()
    if not self._partsGuideAction then return end
    self:stopAction(self._partsGuideAction)
    self._partsGuideAction = nil
end

--其余日历掉落
function M:otherCalendarDown(chooseCalendar)
    if self._allDown then return end
    self._allDown = true
    -- 播放音效[sfx05701006]另外两张挂历掉下去
    soundEffect:playEffectsfx05701006()
    for k, v in pairs(self._calendarTb) do
        if chooseCalendar ~= v then
            v:line({
                { "rotateto", 0.2 * 0.8, 15 },
                { "rotateto", 0.4 * 0.8, -10 },
                { "rotateto", 0.3 * 0.8, 8 },
                { "rotateto", 0.2 * 0.8, -3 },
                { "moveby", 0.3, cc.p(0, -V.h) },
            })
        end
    end
end

--播放点击进入语音
function M:playEnterVoice(id)
    local voiceId = { "78", "79", "80" }
    soundVoice["playEffectv0571" .. voiceId[id]](soundVoice)
end

--获取语音长度
function M:getTime(id)
    local voiceId = { "78", "79", "80" }
    local time = soundVoice:soundDuration("v0571" .. voiceId[id], 3)
    return time
end

--进入下个场景
function M:enterNextScene(id)
    -- G_ENTER_GAME = G_ENTER_GAME + 1
    -- ST.setNumber("ENTER_GAME_NUM", G_ENTER_GAME)
    umengOP.recordSelectEnd()
    --增加完成的数目
    Tools:addDoneNum()
    local sceneNameTb = {"tfgoodswalk", "evekitchen", "nyvisit"} 
    game:enterScene("loading", {nextScene = sceneNameTb[id]})
    -- game:enterSceneWithLoading(sceneNameTb[id])
    
end

--进入图鉴页面
function M:enterHandBookScene()
    umengOP.recordSelectEnd()
    game:enterScene("handbook", { }, "fade", 0.25, COLOR3_WHITE)
end

--开始
function M:gameStart()
    if self._doneGame < 3 then
        self._canTouch = true
        --开启引导
        self:openGuide()
    else
        self:plan(function ()
            self._canTouch = true
        end, 1)
    end
end

--开启引导
function M:openGuide()
    if self._doneGame < 3 then return end
    if self._guideAct then return end
    self._guideAct= A.line({
        {"delay", 3},
        {"fn", function ()
            local pos = self._node:worldpoint()
            pos = cc.p(pos.x, pos.y - 200)
            Tools:addHand(self, pos, true)
        end}
    }):at(self)
end

--关闭引导
function M:closeGuide()
    if self._guideAct then
        self:stopAction(self._guideAct)
        self._guideAct = nil
    end
    -- 移除引导遮罩
    Tools:removeGuideMask(self)
end

---------------------------------------- 二周目 背景 -----------------------------------------
-- 加载背景图
function M:loadBg2()
    local empty = U.loadNode({contentSize = CCSize(V.h, V.w)}):p(0, 0):anchor(cc.p(0,0)):to(self):bindTouch()
    self._emptyNode = empty
    local bg1 = D.img("select/bg2/1.png"):to(empty):p(V.w_2, 150):scale(BG_SCALE)
    local bg2 = D.img("select/bg2/2.png"):to(empty):p(bg1:px(), bg1:py() + bg1:ch() * BG_SCALE):scale(BG_SCALE)
    self._emptyNode:py(self._emptyNode:py() - 190)
    bg1:py(bg1:py() - 150 + Y_OFFSET)
    bg2:py(bg2:py() - 150 + Y_OFFSET)
    -- 加载桌上的装饰物
    self:loadDecorations()
    self._page = {}
    -- 加载封面
    self:loadCover()
    -- 加载三页
    self:loadPage()
    -- 加载书本底部
    self:loadBook()
end

-- 加载桌上的装饰物
function M:loadDecorations()
    local pos = {
        cc.p(1060, 580), cc.p(-123, 584), --cc.p(-130, 300)
    }
    self._decoration = {}
    for k, v in pairs(pos) do
        local decoration            = import("app.select.node.PageUi").new({
            -- 基类参数
            imgPath             = "select/bg2/"..k + 2 ..".png",
            rotationDir         = 2,
            initRotation        = 0,
            polySpriteScaleX    = 1,
            polySpriteScaleY    = 1,
            -- -- 子类参数
            openImg             = "select/bg2/"..k + 2 ..".png",
            main                = self,
        }):to(self._emptyNode):p(v.x + X_OFFSET, v.y + Y_OFFSET)--:bindTouchLocate()
        table.insert(self._decoration, decoration)
        decoration:open(55, _)
    end
end

-- 加载封面
function M:loadCover()
    local cover                 = import("app.select.node.Page").new({
        -- 基类参数
        imgPath                 = "select/book/1.png",
        rotationDir             = 2,
        initRotation            = 0,
        -- initStretch          = 220,
        polySpriteScaleX        = 1,
        polySpriteScaleY        = 1,
        -- -- 子类参数
        stretchMax              = 250,
        stretchNum              = 60,
        openImg                 = "select/book/3.png",
        main                    = self
    }):to(self._emptyNode, 20):p(488.3 + X_OFFSET, 537.5 + Y_OFFSET)
    -- :bindTouchLocate()
    self._cover                 = cover
end

-- 加载书本底部
function M:loadBook()
    local book                  = import("app.select.node.PageBotton").new({
        -- 基类参数
        imgPath                 = "select/book/4.png",
        rotationDir             = 2,
        initRotation            = 0,
        -- initStretch          = 220,
        polySpriteScaleX        = 1,
        polySpriteScaleY        = 1,
        -- -- 子类参数
        stretchMax              = 250,
        stretchNum              = 60,
        openImg                 = "select/book/4.png",
        main                    = self
    }):to(self._emptyNode):p(487 + X_OFFSET, 525.8 + Y_OFFSET):rotate(90):anchor(cc.p(0, 0.5))
    self._bookBotton            = book
end

-- 加页纸
function M:loadPage()
    for i = 1, 2 do
        local page              = import("app.select.node.PageBotton").new({
            -- 基类参数
            imgPath             = "select/book/2.png",
            rotationDir         = 2,
            initRotation        = 0,
            -- initStretch      = 220,
            polySpriteScaleX    = 1,
            polySpriteScaleY    = 1,
            -- -- 子类参数
            stretchMax          = 250,
            stretchNum          = 60,
            openImg             = "select/book/2.png",
            main                = self,
            id                  = i,   
        }):to(self._emptyNode, 30 - i):p(487 + X_OFFSET+ 1 * (i - 1), 526.2 + Y_OFFSET):rotate(90):anchor(cc.p(0, 0.5))--:bindTouch()
        table.insert(self._page, page)
    end
end

-- 加载三个入口
function M:loadThreeEnter()
    local pos = {
        cc.p(209.6, 272.6), cc.p(762.5, 258.3), cc.p(485.3, 377.3) ,
    }
    self._enter = {}
    for i = 1, 3 do
        local btn       = import("app.select.node.Btn").new({
            imgName     = "select/book/ui/"..i..".png",
            layer       = self,
            pos         = cc.p(pos[i].x + X_OFFSET, pos[i].y + Y_OFFSET),
            id          = i,
        }):to(self._emptyNode, 32-i):p(pos[i].x + X_OFFSET, pos[i].y + Y_OFFSET):rotate(-90):anchor(cc.p(0, 0.5))
        :scaleX(0.6):unbindTouch()
        -- :bindTouchLocate():opacity(180)
        -- :unbindTouch()
        table.insert(self._enter, btn)
    end
end

-- 加载主包的三个入口图片
function M:loadThreeMainEnter()
    local pos = {
        cc.p(234.8, 271.8), cc.p(479.7, 348.9) , cc.p(732.5,270.8)
    }
    self._mainEnter = {}
    local tab = {61, 62, 63}
    for i = 1, 3 do
        local imgPath   = tab[i]..".png"
        if device.language ~= "zh" then
            imgPath   = "select/book/mainui/1/"..i..".png"
        end
        local mainBtn = import("app.select.node.Mainbtn").new({
            imgName     = imgPath,
            layer       = self,
            pos         = cc.p(pos[i].x + X_OFFSET, pos[i].y + Y_OFFSET),
            id          = i,
        }):to(self._emptyNode, 30):p(pos[i].x + X_OFFSET, pos[i].y + Y_OFFSET)
        :rotate(-90):anchor(cc.p(0, 0.5)):hide()
        table.insert(self._mainEnter, mainBtn)
    end
end 

--------------------------
-- 功能函数
--------------------------

-- 白屏进场
function M:whiteEnterScene(time)
    time = time or 1
    local mask = U.loadNodeMask({contentSize = cc.size(V.w, V.h), color = ccc3(255, 255, 255),opacity = 255})
    :to(self, 990000):p(V.w_2, V.h_2) 
    mask:line({
        {"fadeTo", time, 0},
        {"fn", function()
            self:bindTouch()
            self._emptyNode:bindTouch()
        end},
        {"remove"}
    })
    -- 二周目
    self:twoWeek()
end

-- 返回键关书
function M:closeTheBook()
    for k, v in pairs(self._enter) do
        v:hide()
    end
    for k, v in pairs(self._page[2]._things) do
        v:show()
        v:close()
    end
    self._page[1]:close()
end

-- 二周目
function M:twoWeek()
    for k, v in pairs(self._enter) do
        -- 按钮翘起
        v:standUp()
    end
    -- 开启引导提示
    self:guideTime()
    self:plan(function ()
        for k, v in pairs(self._enter) do
            v:bindTouch()
        end
        -- 返回键显示
        self:getScene():getButtonLayer():backBtnShow()
        self._handbookBtn:moveIn()
    end, 1)
end

-- - 引导定时器开关
function M:guideTime(bool)
    bool = ifnil(bool, true)
    if bool then
        local time = 5
        -- 循环执行函数
        self._planCycleAction = self:planCycle(self.randomTip, time)
    else
        if self._planCycleAction then
            self:stopAction(self._planCycleAction)
        end
    end
end

-- 随机按钮跳动
function M:randomTip()
    if self._isSkip then return end
    local randomNum = RD.number(1, #self._enter)
    local node = self._enter[randomNum]
    node:unbindTouch()
    -- 按钮跳动
    node:iconTip()
end

-- 获取进入场景的名称
function M:getPassName(nowPass)
    local nameTab = {
        "tfgoodswalk",
        "evekitchen",
        "nyvisit",
    }
    -- local sceneNameTb = {"tfgoodswalk", "evekitchen", "nyvisit"} 
    local passName = nameTab[nowPass]
    return passName
end

-- 获取进入场景的名称
function M:getVoiceInfo(nowPass)
    local infoTab = {
        { name = "v057178", time = 4, func = function()
            soundVoice:playEffectv057178()
        end },
        { name = "v057179", time = 4, func = function()
            soundVoice:playEffectv057179()
        end },
        { name = "v057180", time = 4, func = function()
            soundVoice:playEffectv057180()
        end },
    }
    local info = infoTab[nowPass]
    return info
end

-- 加载洞窟离开场景
function M:exitSceneScale(node)
    -- 隐藏返回按键
    self:getScene():getButtonLayer().btn_back:hide()
    self._handbookBtn:stopAllActions()
    self._handbookBtn:hide():unbindTouch()
    local initPos = self._emptyNode:convertToWorldSpace(node._pos)
    dump(initPos)
    -- 获取场景名称
    local sceneName = self:getPassName(node._id)
    -- 获取音效信息
    local voiceInfo = self:getVoiceInfo(node._id)
    if not initPos or not sceneName or not voiceInfo then return end
    -- 获取音频执行时间
    local voiceTime = soundVoice:soundDuration(voiceInfo.name, voiceInfo.time)
    -- -- 播放音频
    -- voiceInfo.func()
    Tools.exitSceneScale2(self, {
        pos         = ccp(initPos.x, initPos.y + node:cw()/2),
        scale       = 0.97, -- 停留的大小
        delayTime   = voiceTime, -- 停留的时间
        imgPath     = "select/mask/"..node._id..".png",
        bgPath      = "loading/bg.png",
        callback    = function()
            self:enterScene(sceneName)
        end
    })
end

-- 跳转场景
function M:enterScene(sceneName)
    game:enterScene("loading", {nextScene = sceneName})
end

--------------------------------------------------------------------------------------------

-- 加载其他
function M:loadRenderOtherwise()
    
end

--加载彩蛋
function M:loadEggs()
    local eggsArea = U.loadNode({
    }):to(self, 9999):p(V.w_2, V.h_2):scale(0):opacity(0):hide()
    --子节点跟随父节点透明度
    eggsArea:setCascadeOpacityEnabled(true)

    eggsArea._wordTb = {}
    local posTb = { ccp(-200, 0), ccp(-70, 0),
    ccp(70, 0), ccp(200, 0) }
    local wordTb = { "新", "年", "快", "乐" }
    local angleTb = {-60, -50, 50, 60 }
    for i, v in ipairs(posTb) do
        local word1 = U.loadLabelTTF({
            text        = wordTb[i],
            fontSize    = 100,
            position    = v,
            fontColor = COLOR3_RED
        }):to(eggsArea, 9999):rotate(angleTb[i])
        table.insert(eggsArea._wordTb, word1)
    end
    self._eggs = eggsArea
    self._leftTouchCount = 0
    self._rightTouchCount = 0
    self._inputString = ""
    --密码为 1231
    self._password = "123"
end

--显示彩蛋
function M:showEggs()
    --彩蛋密码复位
    self:resetTouchConfig()
    self._eggs:line({
        { "show" },
        { "union", {
            { "easing", "backout", { "scaleto", 0.8, 1.8 } },
            { "fadeTo", 0.8, 255 },
        } },
        { "Delay", 0.5 },
        { "fadeto", 0.5, 0 },
        { "fn", function()
            self._eggs:scale(0):hide()
            local angleTb = {-60, -50, 50, 60 }
            for i, v in ipairs(self._eggs._wordTb) do
                v:rotate(angleTb[i])
            end
        end }
    })
    local timeTb = { 1.2, 1.3, 1.4, 1.5 }
    local hideTb = { 90, 100, 110, 120 }
    for i, v in ipairs(self._eggs._wordTb) do
        v:line({
            { "union", {
                { "jumpby", timeTb[i], cc.p(0, 0), hideTb[i], 2 },
                { "easing", "elasticOut", { "rotateTo", 1.5, 0 } },
            } },
        })
    end
end

--左右两边鞭炮点击
function M:eggTouchEvent(node1, type)
    local this = self
    --级联子节点
    node1:setTouchCascadeDetected(true)
    function node1:onTouchBegan(x, y, touches)
        this._eggs:stopAllActions()
        --延迟三秒没点击，彩蛋复位
        this:delayReset()
        local action= A.line({
            { "rotateTo", 0.1, 5 },
            { "rotateto", 0.1, 0 }
        }):at(node1._fire1)
        node1._fire1._act = action
        local action = A.line({
            { "rotateTo", 0.1, 10 },
            { "rotateto", 0.1, 0 }
        }):at(node1._fire2)
        node1._fire2._act = action
        if type == 1 then
            this._leftTouchCount = this._leftTouchCount + 1
            if this._rightTouchCount ~= 0 then
                this._inputString = this._inputString .. this._rightTouchCount
                this._rightTouchCount = 0
                print(this._inputString)
                if this._inputString == this._password then
                    --显示彩蛋
                    this:showEggs()
                end
            end
        else
            this._rightTouchCount = this._rightTouchCount + 1
            if this._leftTouchCount ~= 0 then
                this._inputString = this._inputString .. this._leftTouchCount
                this._leftTouchCount = 0
                print(this._inputString)
                if this._inputString == this._password then
                    --显示彩蛋
                    this:showEggs()
                end
            end
        end
    end
end

--延迟三秒没点击，彩蛋复位
function M:delayReset()
    self._eggs:line({
        {"delay", 3},
        {"fn", function ()
            --彩蛋密码复位
            self:resetTouchConfig()
        end}
    })
end

--彩蛋密码复位
function M:resetTouchConfig()
    self._leftTouchCount = 0
    self._rightTouchCount = 0
    self._inputString = ""
end

--------------------------
-- 触控
-------------------------- 
-- function M:onTouchBegan(x, y, touches)
--     --  触控有效
--     return true
-- end

-- function M:onTouchMoved(x, y, touches)
--     --   
-- end

-- function M:onTouchEnded(x, y, touches)
--     --  
-- end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    -- 清除图片资源
    R.removeAllTextures()
    R.removeAllFrames()
    -- 清除骨骼资源
    bb.si.DragonBone.removeAll()
    -- 停止音频
    sound.stopAllSounds()
end

return M
