--[[

    Copyright (c) 2011-2021 baby-bus.com

    TODO:   子包入口
    Author: Light
    Date:   2021.06.30
 
    http://www.babybus.com/ 

]] 






--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 
----------------------
local M     = classSpriteTouch("Btn")
M.TAG       = "Btn"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..
local mainLayer





----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    mainLayer         = params.layer
    self._pos         = params.pos
    self._id          = params.id
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
end

--------------------------
-- 加载函数
--------------------------


--------------------------
-- 功能函数
--------------------------

-- 卡片立起来
function M:standUp()
    self:line({
        {"scaleto", 0.4, 1},
    })
end

-- 卡片倒下
function M:fellDown()
    self:line({
        {"scaleto", 0.25, 0.6, 1},
    })
end

-- 设置成打开状态
function M:setOpenStatus()
    self:scale(1)
end

-- 隐藏入口UI
function M:hideEnter()
    -- 小百科开启触控
    mainLayer._handbookBtn:unbindTouch()
end

-- 点击事件
function M:touchEvent()
    self:hideEnter()
    --播放点击进入语音
    mainLayer:playEnterVoice(self._id)
    mainLayer:exitSceneScale(self)
end
-- 按钮跳动
function M:iconTip()
    self:stopAllActions()
    -- 按钮恢复正常
    self:line({
        { "scaleTo", 0.15, 0.8, 1 },
        { "union", {
            { "easing", "sineout", { "scaleTo", 0.25, 1.2,} },
            { "easing", "sineout", { "moveBy", 0.25, cc.p(0, 50) } },
        } },
        { "rotateBy", 0.05, -15 },
        { "rotateBy", 0.1, 30 },
        { "rotateBy", 0.1, -30 },
        { "rotateBy", 0.05, 15 },
        { "delay", 0.1 },
        { "union", {
            { "easing", "sinein", { "scaleTo", 0.1, 1 } },
            { "easing", "sinein", { "moveBy", 0.1, cc.p(0, -50) } },
        } },
        { "scaleTo", 0.05, 0.8, 1 },
        { "scaleTo", 0.025, 1 },
        { "fn", function()
            self:bindTouch()
        end }
    })
    soundEffect:playEffectsfx27318003()
end

--------------------------
-- 触控
-------------------------- 

function M:onTouchBegan(x, y, touches)
    if mainLayer._touchLock then
        return
    end
    self:scale(1.1)
    -- 停止跳动引导
    mainLayer:guideTime(false)
    return SIGN_TOUCH_BEGAN_SWALLOWS 
end

function M:onTouchEnded(x, y, touches)
    self:scale(1)
    if self:isTouchInside(x, y) then
        self:unbindTouch()
        mainLayer._touchLock = true
        self:touchEvent()
    end
end









----------------------
-- 结点析构
----------------------
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end


----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M