--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 非一周目日历
----------------------
local M     = class("Calendar", import("app.common.node.BaseNode"))
M.TAG       = "Calendar"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = true
    --id
    self._id       = ifnil(params.id, 1)
    --位置
    self._enterPos = ifnil(params.enterPos, ccp(V.w_2, 500 + Y_OFFSET))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("5"..(self._id + 1)..".png")
end

-- 加载结点
function M:loadPageNode()
    --加载胶带
    self:loadTape()
end

--加载胶带
function M:loadTape()
    local tape = D.img("select/three/4.png"):to(self):p(self:cw()/2, self:ch())
end


--开始引导
function M:openGuide()
    if self._guideAction then return end
    local scaleSize = 1
    self._guideAction = A.line({
        { "fn", function()
            -- 播放音效[sfx05701005]挂历晃动
            soundEffect:playEffectsfx05701005()
        end },
        self:shakeAct(),
        { "fn", function()
            self._guideAction = nil
        end }
    }):at(self)
end

--晃动
function M:shakeAct()
    local action = A.line({
        { "rotateby", 0.2, 8 },
        { "rotateby", 0.2, -8 },
        { "rotateby", 0.2, -8 },
        { "rotateby", 0.2, 8 },
        { "rotateby", 0.15, 5 },
        { "rotateby", 0.15, -5 },
        { "rotateby", 0.15, -5 },
        { "rotateby", 0.15, 5 },
        { "rotateby", 0.1, 2 },
        { "rotateby", 0.1, -2 },
        { "rotateby", 0.1, -2 },
        { "rotateby", 0.1, 2 },
    })
    return action
end

--停止引导
function M:stopGuide()
    if not self._guideAction then return end
    self:stopAction(self._guideAction)
    self:rotate(0)
    self._guideAction = nil
end

--点击事件
function M:touchEvent()
    self:stopAllActions()
    Tools:changeAnchorP(self, cc.p(0.5, 0.5))
    --洞窥出场
    local title = "5" .. (self._id + 1) .. ".png"
    local pos = self:worldpoint()
    local time = self._layer:getTime(self._id)
    Tools:exitSceneScale(self._layer, title, 0.7, pos, 1.05, nil, time, function()
        --进入下个场景
        self._layer:enterNextScene(self._id)
    end, nil, ccp(1.5, 1.5))
    self:line({
        { "delay", 0.3 },
        { "fn", function()
            --播放点击进入语音
            self._layer:playEnterVoice(self._id)
        end }
    })
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if self._layer._canTouch then
        if self._canTouch then
            self._layer._canTouch = false
            --停止引导
            self:stopGuide()
            --停止引导
            self._layer:stopPartsGuide()
            self:line({
                { "scaleto", 0.2, 1.1 },
                { "scaleto", 0.1, 1 },
                { "fn", function()

                end }
            })
            --  触控有效
            return true
        end
    end
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --其余日历掉落
    self._layer:otherCalendarDown(self) 
    self:line({
        { "Delay", 1 },
        { "moveto", 0.5, cc.p(V.w_2, 440 + Y_OFFSET) },
        { "fn", function ()
            --点击事件
            self:touchEvent()
        end}
    }) 
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
