--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 图鉴按钮类
----------------------
local M = class("HandbookBtn", import("app.common.node.BaseNode"))

----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)

end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    --加载显示
    self:loadDisplay()
end

--加载显示
function M:loadDisplay()
    if device.language == "zh" then
        self:display("8.png")
    else
        self:display("handbook/2.png")
    end
end

--呼吸动作
function M:breathAct()
    local time = 1

    self:cycle({
        { "scaleto", time, 0.95 },
        { "scaleto", time, 1 },
    })

    self:cycle({
        { "moveBy", time, cc.p(0, 5) },
        { "moveBy", time, cc.p(0, -5) },
    })
end
----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    
end

-- 进场
function M:moveIn()
    self:scale(0):unbindTouch()
    self:line({
        {"scaleto", 0.2, 1.1},
        {"scaleto", 0.1, 1},
        {"fn", function()
            self._canTouch = true
            self:bindTouch()
            self:breathAct()
        end},
    })
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    
end




----------------------
-- 点击
----------------------
function M:onTouchBegan(x, y, touches)
    if self._layer._canTouch then
        if self._canTouch then
            self._layer._canTouch = false
            self._canTouch = false
            -- 缩放动作
            self:scaleAction(self)
            return true
        end
    end
end

function M:onTouchMoved(x, y, touches)
end

function M:onTouchEnded(x, y, touches)
    -- 结束缩放动作
    self:stopScaleAction(self, function()
        --进入图鉴页面
        self._layer:enterHandBookScene()
    end)
end




----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
