--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 一周目日历
----------------------
local M     = classSpriteTouch("NewGameCalendar")
M.TAG       = "NewGameCalendar"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..
local FlipPage = import("app.select.node.flippage.FlipPage")





----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = true
    -- id
    self._id       = ifnil(params.id, 1)
    --属于
    self._belong = params.belong
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    --开始引导
    -- self:openGuide()
end

-- 图片渲染
function M:loadDisplay()
    self:display("select/calendar/base.png"):p(0, -190)
end

-- 加载结点
function M:loadPageNode()
    --加载其他
    self:loadOther()
    -- 加载翻页页面
    self:loadPage()
end

--加载其他
function M:loadOther()
    local nextId = (self._id + 1) <= 4 and (self._id + 1) or 4
    local calendar = {}

    print(nextId)
    if nextId ~= 1 then
        calendar = D.img("5"..(nextId + 3)..".png"):to(self):p(self:cw() / 2, 175.5)
    else
        calendar = D.img("select/calendar/date/"..nextId..".png"):to(self):p(self:cw() / 2, 175.5)
    end


    self._nextCalender = calendar

    local pos1 = ccp(479 + X_OFFSET, 435 + Y_OFFSET - 19)
    pos1 = self._belong:convertToNodeSpace(pos1)
    local pos2 = ccp(479 + X_OFFSET, 419 + Y_OFFSET - 19)
    pos2 = self._belong:convertToNodeSpace(pos2)
    local addZ = 0

    --加载
    local up1 = D.img("select/calendar/up.png"):to(self._belong, 999 + addZ):p(pos1)
    local up2 = D.img("select/calendar/date/up.png"):to(self._belong, 998 + addZ):p(pos2):scaleX(1.0021)
    self._up1 = up1
    self._up2 = up2
end

function M:changeUpZorder()
    self._up1:z(999)
    self._up2:z(998)
end

-- 加载翻页页面
function M:loadPage()
    local a = D.img("select/calendar/date/clip.png")
    local size = a:getContentSize()
    size = cc.size(size.width, size.height)

    local width = size.width * 2.5
    local height = size.height

    local worldP = self._belong:convertToNodeSpace(self._nextCalender:worldpoint())
    -- 翻页逻辑
    local flipPage = FlipPage.new({
        pageWidth     = width,
        pageHeight    = height,
        id            = self._id,
        parent        = self
    }):to(self._belong, 1000):p(worldP.x - 127.9, worldP.y - size.height / 2 + 7.5):anchor(cc.p(0, 0)):scale(1)
    self._flipPage = flipPage
end

--开始引导
function M:openGuide()
    self._flipPage.checkPoint:openGuide()
end

--停止引导
function M:stopGuide()
    self._flipPage.checkPoint:stopGuide()
end

--点击事件
function M:touchEvent()
    self._belong:z(999)
    self._belong:stopAllActions()
    self._belong:rotate(0)
    self._belong:line({
        { "scaleto", 0.2, 1.1 },
        { "scaleto", 0.1, 1 },
        { "fn", function()
           -- 播放音效[sfx05701004]撕开挂历
            soundEffect:playEffectsfx05701004() 
            --自动翻页
            self._flipPage:autoFlip()
            self._layer:line({
                {"Delay", 1.8},
                {"fn", function ()
                    --点击事件
                    self:exitScale()
                end}
            })
        end }
    })
end

--点击事件
function M:exitScale()
    self:stopAllActions()
    Tools:changeAnchorP(self, cc.p(0.5, 0.5))
    --洞窥出场
    local title = "select/calendar/base.png"
    local pos = self:worldpoint()
    local time = self._layer:getTime(self._id)--获取语音长度
    Tools:exitSceneScale(self._layer, title, 0.7, pos, 1, nil, time, function()
        --进入下个场景
        self._layer:enterNextScene(self._id)
    end, nil, ccp(1.5, 2))
    self:line({
        {"delay", 0.3},
        {"fn", function ()
            --播放点击进入语音
            self._layer:playEnterVoice(self._id)
        end}
    })
end


--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if self._layer._canTouch then
        if self._canTouch then
            self._layer._canTouch = false
            self._canTouch = false
            --关闭引导
            self._layer:closeGuide()
            --点击事件
            self:touchEvent()
            return true
        end
    end
end

function M:onTouchMoved(x, y, touches)
end

function M:onTouchEnded(x, y, touches)

end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
