--[[

    Copyright (c) 2011-2021 baby-bus.com

    TODO:   封面
    Author: Light
    Date:   2021.06.29
 
    http://www.babybus.com/ 

]] 





--------------------------
-- 引入命名空间
--------------------------
-- local BaseLayer = import("app.common.layer.BaseLayer")
--[[    类
--]]
local M = class("Page", require("app.select.node.PageBase"))




--------------------------
-- 构造函数
--------------------------
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    -- [本类调用]
    -- 最大拉伸
    self._stretchMax    = params.stretchMax or 200
    self._openImg       = params.openImg
    self._lastAngle     = 0
end

--------------------------
-- 渲染
--------------------------
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- self:setOpenStatus()
    self:open()
end

-- 设置成打开的状态
function M:setOpenStatus()
    self:changePolySprite(self._lastAngle, 0)
    local changeImgPath = self._openImg
    -- 改变节点精灵
    self:setSpriteTexture(changeImgPath)
end


--------------------------
-- 功能函数
--------------------------
-- 打开封面
function M:open()
    local openTime = 0
    local stretchMax = self._stretchMax
    local changeImgPath = self._openImg
    local endStretch = 200
    self:sunken(0, -15)
    self:line({
        {"OrbitCamera", openTime, 1, 0, 0, endStretch, 0, 0},  -- 水平翻转180度
        {"fn", function()
            self._lastAngle =  endStretch + self._lastAngle
        end},
    })
    -- 翻页到90度
    local time1 = 90 / endStretch * openTime
    self:changePolySpriteByTime(time1, 90, stretchMax)
    self:line({
        { "moveby", time1, ccp(0, -11) },    -- 书本下移一点
        { "fn", function()
            -- self:hideTitle()
            -- 改变节点精灵
            self:setSpriteTexture(changeImgPath)
            -- 翻页到180度
            self:changePolySpriteByTime(openTime - time1, endStretch, -15)
        end },
        {"delay", openTime - time1},
        {"fn", function()
            if self._main._bg33 then
                self._main._bg33:remove()
            end
            -- self:close() 
            -- -- 返回键显示
            -- self._main:getScene():getButtonLayer():backBtnShow()
            end},
        })
        -- self:plan(function ()
        --     local path = G_CAMERA_PHOTO_PATH.."/maskbook.png"
        --     local shot = SO.shot({
        --         rect         = rectForPointSize(cc.p(V.w_2, V.h_2), CCSize(V.w, V.h)),    -- 屏幕区域
        --         nodes        = {self._main._emptyNode},               -- 渲染结点集合
        --         path	     = path
        --     })
        -- end, 2)
    -- 播放音效[sfx27301015]端午节选择界面-大书本打开
    -- soundEffect:playEffectsfx27301015()
end

-- 关闭
function M:close()
    local openTime = 1
    local stretchMax = self._stretchMax
    local changeImgPath = self._imgPath
    local endStretch = -self._lastAngle
    self:line({
        {"OrbitCamera", openTime, 1, 0, self._lastAngle, endStretch, 0, 0},  -- 水平翻转180度
        {"fn", function()
            self._lastAngle =  endStretch + self._lastAngle
        end},
    })
    self:plan(function ()
        self:z(50)
    end, 0.15)
    -- 翻页到90度
    local time1 = (90 + endStretch) / endStretch * openTime
    self:changePolySpriteByTime(time1, 90, stretchMax)
    self:line({
        { "moveby", time1, ccp(0, 11) },    -- 书本下移一点
        { "fn", function()
            -- self:showTitle()
            -- 改变节点精灵
            self:setSpriteTexture(changeImgPath)
            -- 翻页到180度
            self:changePolySpriteByTime(openTime - time1, 0,0)
        end },
        {"delay", openTime - time1},
        {"fn", function()
            self:cycle({
                {"fn", function ()
                    -- 有偏差最后一帧设置正确尺寸
                    self:changePolySprite(0,0)
                end},
                {"delay", 0.1},
            }, 10)
        end},
        {"delay", 0.3},
        {"fn", function()
            game:enterScene("gameplay", {isSelectBack = true}) 
        end},
    })
end

--------------------------
-- 析构
--------------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
    -- [本类调用]
end








return M