--[[

    Copyright (c) 2011-2021 baby-bus.com

    TODO:   翻页基类
    Author: Light
    Date:   2021.06.29
 
    http://www.babybus.com/ 

]] 





--------------------------
-- 引入命名空间
--------------------------
-- local BaseLayer = import("app.common.layer.BaseLayer")
--[[    类
--]]
local M = classSpriteTouch("PageBase")




--------------------------
-- 构造函数
--------------------------
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    -- [本类调用]
    self._main              = params.main
    -- 渲染的图片
    self._imgPath           = params.imgPath
    -- 旋转方向 0--不旋转 1--逆时针旋转90度 2--顺时针旋转90
    self._rotationDir       = params.rotationDir or 0
    -- 翻转角度
    self._rotation          = params.initRotation or 0
    -- 当前Y轴拉伸
    self._stretch           = params.initStretch or 0
    -- 总下标数
    self.stretchNum         = params.stretchNum or 5
    -- 多边形精灵缩放X轴
    self._polySpriteScaleX  = params.polySpriteScaleX or 1
    -- 多边形精灵缩放Y轴
    self._polySpriteScaleY  = params.polySpriteScaleY or 1
end

--------------------------
-- 渲染
--------------------------
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- [本类调用]
    -- 加载渲染节点
    self:loadDisplay()
    -- 加载多边形精灵
    self:loadSp()
    -- 初始化尺寸
    self:initSize()
end

-- 节点渲染
function M:loadDisplay()
    local imgPath = self._imgPath
    if not imgPath then return end
    self:display(imgPath):opacity(0):anchor(cc.p(0, 0.5))
    if self._rotationDir == 1 then
        self:rotate(-90)
    else if self._rotationDir == 2 then
            self:rotate(90)
        end
    end
end

-- 加载多边形精灵
function M:loadSp()
    local imgPath = self._imgPath
    if not imgPath then return end
    local ps = self:loadPolySprite({
        image    = imgPath,
    }):to(self):p(self:cw() / 2, self:ch() / 2)
    self._ps = ps
end

-- 创建多边形精灵
function M:loadPolySprite(params)
    local image    = params.image
    local ps = CCNodeExtend.extend(PolySprite:create(image))
    return ps
end

-- 改变多边形精灵
function M:setSpriteTexture(imgPath)
    if not imgPath then return end
    self._ps:setTexture(CCTextureCache:sharedTextureCache():addImage(imgPath))
end

-- 初始化尺寸
function M:initSize()
    local rotation = self._rotation
    local stretch = self._stretch
    self:changePolySprite(rotation, stretch)
end

-- 通过角度获得缩放值 角度至为0 - 180
function M:setScaleByRotate(rotation)
    if not rotation or rotation > 180 or rotation < 0 then return end
    local polySpriteScaleX = self._polySpriteScaleX
    local polySpriteScaleY = self._polySpriteScaleY
    local scalex = polySpriteScaleX - rotation / 90 * polySpriteScaleX
    local scaley = polySpriteScaleY
    -- 精灵镜像
    if rotation > 90 and scaley > 0 then
        scaley = -scaley
    end
    -- 设置缩放
    self:scaleX(scalex)
    self:scaleY(scaley)
end
--------------------------
-- 功能函数
--------------------------
-- 通过设置角度和拉伸改变多边形精灵形状
function M:changePolySprite(rotation, stretch)
    rotation = rotation or self._rotation
    stretch = stretch or self._stretch
    self._rotation = rotation
    self._stretch = stretch
    -- 设置缩放值
    self:setScaleByRotate(rotation)
    -- Y轴拉伸
    self:sunken(0, stretch)
end

-- 页面变化  给定时间设置角度和拉伸改变多边形精灵形状
function M:changePolySpriteByTime(time, targetRotation, targetStretch)
    local rotationSpan = targetRotation - self._rotation
    local stretchSpan = targetStretch - self._stretch
    local dt = 60
    self:cycle({
        { "delay", 1 / dt },
        { "fn", function()
            local rotation = self._rotation + rotationSpan / (time * dt)
            local stretch = self._stretch + stretchSpan / (time * dt)
            -- 通过设置角度和拉升改变多边形精灵形状
            -- self:changePolySprite(rotation, stretch)
             -- Y轴拉伸
            self._stretch = stretch
            self:sunken(0, stretch)
        end },
    }, (time * dt))
end

--------------------------
-- 多边形精灵操作函数
--------------------------
-- Y轴拉伸
function M:sunken(posX, posY)
    -- 总长度
    local width = self:cw()
    -- 总高度
    local height = self:ch()
    -- 总下标数
    local num    = self.stretchNum
    -- 每格间距
    local span = width / num
    -- 高度
    local y = { height / 2, 0, -height / 2 }
    local p = {}
    for i = 1, 3 do
        for j = 1, num do
            local number = j - 1
            local x    = width / (num - 1) * (j - num) + width / 2 + posX / (num - 1) * number
            if i == 1 then
                table.insert(p, cc.p(x, y[i] + posY / (num - 1) * number))
            elseif i == 2 then -- 正常位置
                table.insert(p, cc.p(x, y[i]))
            elseif i == 3 then
                table.insert(p, cc.p(x, y[i] - posY / (num - 1) * number))
            end
        end
    end
    self._ps:setVertices(self:meshVerticesAndTexcoords(3, num, p))
end

-- polySprite - 计算点
function M:meshVerticesAndTexcoords(row, col, arr)
    if #arr ~= row * col then
        return
    end
    -- 行 列 
    local num = (2 * math.max(row, col) + 1) * (math.min(row, col) - 1)
    local vertices = cc.PointArray:create(num)
    local texcoords = cc.PointArray:create(num)
    local r = row - 1
    local c = col - 1
    local tmp = 1
    -- 优化生成点的数量
    if row < col then
        for i = 0, r - 1 do
            if i % 2 == 0 then
                for j = 0, c do
                    tmp = i * col + j + 1
                    vertices:addControlPoint(arr[tmp])
                    vertices:addControlPoint(arr[tmp + col])
                    texcoords:addControlPoint(cc.p(j / c, i / r))
                    texcoords:addControlPoint(cc.p(j / c, (i + 1) / r))
                end
            else
                for j = c, 0, -1 do
                    tmp = i * col + j + 1
                    vertices:addControlPoint(arr[tmp])
                    vertices:addControlPoint(arr[tmp + col])
                    texcoords:addControlPoint(cc.p(j / c, i / r))
                    texcoords:addControlPoint(cc.p(j / c, (i + 1) / r))
                end
            end
        end
    else
        for i = 0, c - 1 do
            if i % 2 == 0 then
                for j = 0, r do
                    tmp = j * col + i + 1
                    vertices:addControlPoint(arr[tmp])
                    vertices:addControlPoint(arr[tmp + 1])
                    texcoords:addControlPoint(cc.p(i / r, j / c))
                    texcoords:addControlPoint(cc.p((i + 1) / r, j / c))
                end
            else
                for j = r, 0, -1 do
                    tmp = j * col + i + 1
                    vertices:addControlPoint(arr[tmp])
                    vertices:addControlPoint(arr[tmp + 1])
                    texcoords:addControlPoint(cc.p(i / r, j / c))
                    texcoords:addControlPoint(cc.p((i + 1) / r, j / c))
                end
            end
        end
    end
    return num, vertices, texcoords
end

--------------------------
-- 析构
--------------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
    -- [本类调用]
end








return M