--[[

    Copyright (c) 2011-2021 baby-bus.com

    TODO:   书页/书本底部
    Author: Light
    Date:   2021.06.29
 
    http://www.babybus.com/ 

]] 





--------------------------
-- 引入命名空间
--------------------------
-- local BaseLayer = import("app.common.layer.BaseLayer")
--[[    类
--]]
local M = class("PageBotton", require("app.select.node.PageBase"))




--------------------------
-- 构造函数
--------------------------
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    -- [本类调用]
    -- 最大拉伸
    self._stretchMax    = params.stretchMax or 250
    self._openImg       = params.openImg
    self._lastAngle     = 0
    self._id            = params.id
end

--------------------------
-- 渲染
--------------------------
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    self:loadOtherThings()
    if self._id == 1 then
        self:open2()
    else
        self:open()
    end
end

--------------------------
-- 加载函数
--------------------------

-- 加载元素
function M:loadOtherThings()
    if self._id then
        self["loadPageThings"..self._id](self)
    end
end

-- 加载三个子包入口[第一页]
function M:loadPageThings1()
    -- 端午春节中秋
    local pos = {
    cc.p(393.1, 116.6), cc.p(274.2, 360.5) , cc.p(395.4, 613.7)
    }
    self._things = {}
    local tab = {61, 62, 63}
    for i = 1, 3 do
        local imgPath   = tab[i]..".png"
        if device.language ~= "zh" then
            imgPath   = "select/book/mainui/1/"..i..".png"
        end
        local page              = import("app.select.node.PageUi").new({
            -- 基类参数
            imgPath             = imgPath,
            rotationDir         = 2,
            initRotation        = 0,
            polySpriteScaleX    = 1,
            polySpriteScaleY    = 1,
            -- -- 子类参数
            openImg             = imgPath,
            main                = self,
            id                  = i,   
        }):to(self, 10 - i):p(pos[i].x, pos[i].y):rotate(180):hide()
        -- :bindTouchLocate()--:opacity(0)
        table.insert(self._things, page)
    end
end

-- 加载入口
function M:loadPageThings2()
    local pos = {
        cc.p(394.1, 91.1), cc.p(412.4, 642.8), cc.p(228.8, 365.1) ,
    }
    self._things = {}
    for i = 1, 3 do
        local page              = import("app.select.node.PageUi").new({
            -- 基类参数
            imgPath             = "select/book/ui/"..i..".png",
            rotationDir         = 2,
            initRotation        = 0,
            polySpriteScaleX    = 1,
            polySpriteScaleY    = 1,
            -- -- 子类参数
            openImg             = "select/book/ui/"..i..".png",
            main                = self,
            id                  = i,   
        }):to(self, 10 - i):p(pos[i].x, pos[i].y):rotate(180):hide()
        -- :bindTouchLocate()--:opacity(0)
        -- table.insert(self._page, page)
        table.insert(self._things, page)
        self:plan(function ()
            page:open()
        end, 1)
    end
end

function M:loadPageThings3()
    
end



--------------------------
-- 功能函数
--------------------------

-- 设置成打开的状态
function M:setOpenStatus()
    self:changePolySprite(180, 0)
    local changeImgPath = self._openImg
    -- 改变节点精灵
    self:setSpriteTexture(changeImgPath)
end

function M:open(angle)
    local time = 0
    angle = angle or 50
    self:line({
        {"OrbitCamera", time, 1, 0, 0, angle, 0, 0},  -- 水平翻转180度
    })
    self._lastAngle =  angle + self._lastAngle
    -- Y轴拉伸
    self:sunken(0, 130)
end

function M:open2(enterId)
    enterId = enterId or 1
    -- Y轴拉伸
    self:sunken(0, -15)
    local time = 0
    local angle = 220 - 50
    -- 改变节点精灵
    self:setSpriteTexture("select/book/back/"..enterId..".png")
    self:line({
        {"OrbitCamera", time, 1, 0, self._lastAngle, angle, 0, 0},  -- 水平翻转180度
    })
    self._lastAngle =  angle + self._lastAngle
end

-- 显示书上东西
function M:showPageSth()
    if istable(self._things) and #self._things > 1 then
        for k, v in pairs(self._things) do
            v:show()
            v:setState()
            v:open(_, 0.4)
        end
    end
end

-- 隐藏书上东西
function M:hidePageSth()
    if istable(self._things) and #self._things > 1 then
        for k, v in pairs(self._things) do
            v:hide()
        end
    end
end

-- 树上的UI隐藏  Layer加载新的
function M:hideUI()
    for k, v in pairs(self._main._mainEnter) do
        v:setState()
        v:show()
    end
    self:hidePageSth()
end

-- 关闭
function M:close()
    local time = 1
    local angle = - self._lastAngle + 50
    -- 到九十度的时候 设置层级
    self:z(self:z() - 2)
    self:plan(function ()
        self:z(self:z() + 2)
        -- 改变节点精灵
        self:setSpriteTexture("select/book/2.png")
        -- 显示书上东西
        self:showPageSth()
    end,(self._lastAngle-60) / self._lastAngle * time)
    self:line({
        {"OrbitCamera", time, 1, 0, self._lastAngle, angle, 0, 0},  -- 水平翻转180度
        {"fn", function()
            self:hideUI()
            self:z(self:z()-1)
            self._lastAngle =  angle + self._lastAngle
            self:cycle({
                {"fn", function ()
                    -- 有偏差最后一帧设置正确尺寸
                    self:changePolySprite(0,130)
                end},
                {"delay", 0.1},
            }, 10)
        end},
        {"delay", 0.2},
        {"fn", function()
            -- 退出还原默认
            bb.hotUpdate.reset()
            game:enterScene("select", {mark = 2}) 
        end},
    })
    -- 翻页到90度
    self:changePolySpriteByTime(time, angle*2, 130)
end
--------------------------
-- 析构
--------------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
    -- [本类调用]
end








return M