--[[

    Copyright (c) 2011-2021 baby-bus.com

    TODO:   书本UI
    Author: Light
    Date:   2021.06.29
 
    http://www.babybus.com/ 

]] 





--------------------------
-- 引入命名空间
--------------------------
-- local BaseLayer = import("app.common.layer.BaseLayer")
--[[    类
--]]
local M = class("PageUi", require("app.select.node.PageBase"))




--------------------------
-- 构造函数
--------------------------
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    -- [本类调用]
    -- 最大拉伸
    self._stretchMax    = params.stretchMax or 250
    self._openImg       = params.openImg
    self._lastAngle     = 0
    self._id            = params.id
    self._packBagName = {"newyear", "dragonboat", "midautumn"}
    -- 包名
    self._packName    = params.packName or self._packBagName[self._id]
end

--------------------------
-- 渲染
--------------------------
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    
end

--------------------------
-- 功能函数
--------------------------

-- 设置成打开的状态
function M:setOpenStatus()
    self:changePolySprite(180, 0)
    local changeImgPath = self._openImg
    -- 改变节点精灵
    self:setSpriteTexture(changeImgPath)
end

-- 

function M:open(angle, time)
    time = time or 0
    angle = angle or 60
    self:line({
        {"OrbitCamera", time, 1, 0, 0, angle, 0, 0},  -- 水平翻转180度
    })
    self._lastAngle =  angle + self._lastAngle
end

-- 关闭
function M:close()
    local time = (220 - 100) / 220 * 1
    local angle = - self._lastAngle
    self:line({
        -- {"OrbitCamera", time, 1, 0, self._lastAngle, -self._lastAngle, 0, 0},  -- 水平翻转180度
        {"union",{
            {"OrbitCamera", time, 1, 0, self._lastAngle, -self._lastAngle, 0, 0},  -- 水平翻转180度
            -- {"scaleto", time, 0.7, 1}
        }},
        {"fn", function()
            self._lastAngle =  angle + self._lastAngle
        end},
    })
end

-- 关闭
function M:close1()
    local time = 0.5
    local angle = - self._lastAngle
    self:line({
        {"union",{
            {"OrbitCamera", time, 1, 0, self._lastAngle, -self._lastAngle, 0, 0},  -- 水平翻转180度
            {"scaleto", time, 0.7, 1}
        }},
        {"fn", function()
            self._lastAngle =  angle + self._lastAngle
        end},
    })
end

------------------------ 下载逻辑【只是用来显示进度】 --------------------

function M:setState()
    self:isNeedDownLoad()
end

-- 是否需要下载
function M:isNeedDownLoad()
    if self._id ~= 1 then
        -- 加载下载资源过程的进度条遮罩
        self:loadDownloadingRes()
        -- 加载下载标志
        self:loadDownLoadSign()
        self:updateModuleStatus()
    end
end

-- 加载下载资源过程的进度条遮罩
function M:loadDownloadingRes()
    -- if not self._isNeedDownload then return end
    print("加载下载资源过程的进度条遮罩")
    local imgPath   = "select/mask1/"..self._id..".png"
    local pos   = cc.p(119.5, 109.1)
    if device.language ~= "zh" then
        imgPath   = "select/mask1/1/"..self._id..".png"
        pos   = cc.p(pos.x - 10, pos.y)
    end
    local downloadingClip = D.img(imgPath)
    :p(pos):rotate(90):opacity(200)--:bindTouchLocate()
    local node = D.img("select/download_mask.png"):p(self:cw()/2, self:ch()/2)
    local clip = CCNodeExtend.extend(cc.ClippingNode:create(node)):to(self)
    clip:setInverted(false)
    clip:setAlphaThreshold(0) -- 显示透明区域
    clip:addChild(downloadingClip)
    self._clip = clip
    self._downloadingClip = downloadingClip
    self._node = node
    node._posX = node:px()
end

-- 删除下载资源过程的进度条遮罩
function M:removeDownloadingRes(isDownLoadFinish)
    if self._clip then
        self._downloadingClip:remove()
        self._downloadingClip = nil
        self._clip:remove()
        self._clip = nil
        if isDownLoadFinish then
            -- local particle = Tools.newParticle("particle/find.plist", 170, 40):to(self, 300)
			-- particle:scale(1/self._scale)
        end
    end
end

-- 加载下载标志
function M:loadDownLoadSign()
    -- if self._downLoadSign and not tolua.isnull(self._downLoadSign) then return end
    -- if self._isNeedDownload then
        local downLoadSign = D.img("select/question.png"):to(self, 11):p(self:cw()/2, self:ch()/2):rotate(90)
        self._downLoadSign = downLoadSign
    -- end
end

-- 删除下载标志
function M:removeDownLoadSign()
    if self._downLoadSign and not tolua.isnull(self._downLoadSign) then
        self._downLoadSign:remove()
        self._downLoadSign = nil
    end
end

-- 更新下载状态 (1.已完成  2.未完成但正在下载  3.未完成但在下载队列  4.未完成也未在队列)
function M:updateModuleStatus()
    if self._id == 1 then return end
    -- 获取子包下载状态
    local status = DownloadManager:getModuleStatus(self._packName)
    print("获取子包下载状态==", status)
    -- 状态判定
    if status == 1 then 
        self._isNeedDownload = false
        self:downloadOver()
    elseif status == 2 then 
        self._isNeedDownload = true
        self:downloading()
    elseif status == 3 then 
        self._isNeedDownload = true
        self:downloadWriting()
    elseif status == 4 then 
        self._isNeedDownload = true
    end
    -- 状态赋值
    self._moduleStatus = status
end 

-- 下载中
function M:downloading(progress)
    local progress = progress or DownloadManager._progressNum
    -- print("progress==", progress)
    local x = self._node._posX - progress/100 * self._node._posX
    self._node:px(x)
end

-- 等待下载
function M:downloadWriting()
    print("等待下载")
    self._node:px(self._node._posX)
end

-- 下载结束
function M:downloadOver()
    -- 删除下载资源过程的进度条遮罩
    self:removeDownloadingRes(true)
    -- 删除下载标志
    self:removeDownLoadSign() 
end

-- 成功下载完成
function M:successDownload()
    self._moduleStatus = 1
    -- 下载结束
    self:downloadOver()
end

--------------------------
-- 析构
--------------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
    -- [本类调用]
end








return M