--[[Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]
local M 	= classSprite("DragedMask")




--------------------------
-- 构造函数
--------------------------

function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
 	-- [本类调用]

end

--------------------------
-- 渲染
--------------------------

function M:onRender()
	M.super.onRender(self)

 	-- [本类调用]
	-- 加载节点
	self:loadDisplay() 
end 

-- 加载节点
function M:loadDisplay()
	self.drawBG  = cc.DrawNode:create()
	self.bg = U.loadNode():to(self)
	self.bg:addChild(self.drawBG)
end 



--------------------------
-- 析构
--------------------------

function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
 	-- [本类调用]
end








--------------------------
-- 功能函数
--------------------------
function M:drawMask(cPoint, dPoint, bPoint, aPoint)
    self.drawBG:clear()
    local triangleVector = nil

    local point    = nil
    local fillColor = ccc4f(0, 0.3, 0.8, 0.01)

	if not iswindows() and not ismac() then
        fillColor = ccc4f(0, 0, 0, 0)
        local point = self:convertToWorldSpace(self:point())
        dPoint    = cc.p(dPoint.x + point.x, dPoint.y + point.y)
        bPoint    = cc.p(bPoint.x + point.x, bPoint.y + point.y)
        cPoint    = cc.p(cPoint.x + point.x, cPoint.y + point.y)
		if aPoint then
			aPoint      = cc.p(aPoint.x + point.x, aPoint.y + point.y)
		end
    end

    if aPoint then
        triangleVector = { cPoint, dPoint, bPoint, aPoint }
    else
        triangleVector = { cPoint, dPoint, bPoint }
    end

    self.drawBG:drawPolygon(triangleVector, { fillColor    = fillColor,
											  borderWidth  = 0,
											  borderColor  = ccc4f(0.5, 0.5, 0.5, 1)
											})
end

function M:clear( )
	self.drawBG:clear()
end


--------------------------
-- 属性
--------------------------




--------------------------
-- 父类重写
-------------------------- 




return M






