--[[Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--------------------------
-- 引入命名空间
--------------------------
local StaticMask    = import("app.select.node.flippage.StaticMask")
local DragedMask    = import("app.select.node.flippage.DragedMask")
local CheckPoint    = import("app.select.node.flippage.CheckPoint")
local HalfPage      = import("app.select.node.flippage.HalfPage")
local ShadowMask    = import("app.select.node.flippage.ShadowMask")
local ShadowManager = import("app.select.node.flippage.ShadowManager")
local Shadow        = import("app.select.node.flippage.Shadow")

local M 	= classSprite("FlipPage")




--------------------------
-- 构造函数
--------------------------

function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
 	-- [本类调用]
 	self.pageWidth  = params.pageWidth
 	self.pageHeight = params.pageHeight
 	self._id 		= ifnil(params.id, 1)

 	self._parent 	= params.parent
 	-- 是否加载完翻页页面
 	self.loadOk     = false
end

--------------------------
-- 渲染
--------------------------

function M:onRender()
	M.super.onRender(self)
	-- 加载节点
	self:loadDisplay()
end 

-- 加载节点
function M:loadDisplay()
    -- 不动的页面的遮罩
	self.staticPageMask  = StaticMask.new({}):to(self):p(0, 0)
	-- 被拖动的页面的遮罩
	self.dragedPageMask  = DragedMask.new({}):to(self):p(0, 0)
	-- 翻页点运算
	self.checkPoint      = CheckPoint.new({}):to(self):p(0, 0)
	self.checkPoint:setSize(self.pageWidth, self.pageHeight)

	local maskAll  = self.staticPageMask
	local maskHalf = self.dragedPageMask
	self.halfPage  = HalfPage.new({
		pageWidth  = self.pageWidth,
		pageHeight = self.pageHeight,
		staticPageMask = maskAll,
		dragedPageMask = maskHalf,
		id 		= self._id
	}):to(self, 10):p(0, 0)

	-- 设置阴影
	-- 跟随移动的阴影的遮罩
	self.downShadowMask = ShadowMask.new({}):to(self):p(0, 0)
	self.downShadowMask:creat(self.pageWidth, self.pageHeight)

	-- 加载阴影图片
	self.downShadow = D.img("tear/shadow_1.png"):p(0, 0)
	-- self.downShadow:scale(1.2)--:opacity(0)
	self:clipFunShadow()

	-- 阴影管理
	self.shadowManager = ShadowManager.new({}):to(self):p(0, 0)
	self.shadowManager:setdownShadow(self.downShadow)
end 

-- 遮罩 CCClippingNode
function M:clipFunShadow()
	local clipImg    = D.img("56.png"):p(130, self.pageHeight / 2):scale(1)
    self.clipDownShadow = CCNodeExtend.extend(cc.ClippingNode:create(clipImg)):to(self, 100)--:hide()
    self.clipDownShadow:setInverted(false)
    self.clipDownShadow:setAlphaThreshold(0) -- 显示透明区域
    self.clipDownShadow:addChild(self.downShadow)
end



--------------------------
-- 功能函数
--------------------------
-- 拖动翻页
function M:dragFlip(x, y)
	self.dragX, self.dragY = self:dragRange(x, y)
	self.checkPoint:checkPoints(self.dragX, self.dragY)
end

-- 拖动范围
function M:dragRange(x, y)
	local point = self:convertToNodeSpace(cc.p(x, y))
	if point.x > self.pageWidth then -- 如果鼠标滑出书的右边
		point.x = self.pageWidth
	elseif point.x < 0 then          --如果鼠标滑出书的左边
		point.x = 0
	end
	return point.x, point.y
end

-- 判断是否手动翻页
function M:adjustFlip(result)
	if result then
		local node = U.loadNode():to(self.checkPoint):p(cc.p(self.dragX, self.dragY))
		self.checkPoint:pageFirstMoveCompleteHandler(node)
		return
	end
	print("111:",self.dragX)
	print("222:", self.pageWidth * 11 / 20)
	if self.dragX > self.pageWidth * 11 / 20 then
		local node = U.loadNode():to(self.checkPoint):p(cc.p(self.dragX, self.dragY))
		self.checkPoint:pageFirstMoveCompleteHandler(node)
	else
		print("不翻下一页")
		local node = U.loadNode():to(self.checkPoint):p(cc.p(self.dragX, self.dragY))
		self.checkPoint:notPageFlipCompleteHandler(node)
	end
end

-- 加载下个页面
function M:addNewPage()
	print(self.loadOk)
	if self.loadOk then return end
	self.halfPage:addAllPage()
	self.loadOk = true
end

-- 运动过程中
function M:moveHandler()
	local checkPoint = self.checkPoint
	self.dragedPageMask:drawMask(checkPoint.cPoint, checkPoint.dPoint, checkPoint.bPoint, checkPoint.aPoint) -- 调整遮罩
	self.staticPageMask:drawMask(self.pageWidth, self.pageHeight, checkPoint.dPoint, checkPoint.bPoint, checkPoint.aPoint) -- 调整遮罩
	self.halfPage:onDrag(checkPoint.cPoint, checkPoint.pageAngle) -- 调整运动的半页的状态
	self.shadowManager:setShadow(checkPoint.dPoint, checkPoint.bPoint, checkPoint.lineAngle, self.flipDir, self.pageWidth); -- 调整阴影状态
end

--自动翻页
function M:autoFlip()
	-- 添加滑动页面
	self:addNewPage()
	local pos1 = cc.p(20, 10)
	local node = U.loadNode():to(self.checkPoint):p(pos1)
	self.checkPoint:pageFirstMoveCompleteHandler(node)
end

-- 翻页完成
function M:pageMoveComplete( )
	self.clipDownShadow:hide()
	
	Tools:resetParent(self.halfPage._backPage, self:getScene():getMainLayer(),999)
	self:hide()
	self.halfPage._backPage:line({
		{ "union", {
			{"rotateby", 1, math.random(-10, -50)},
			{"moveby", 1, cc.p(0, -V.h * 1.2) },
		}},
		{"remove"}
	})
end

-- 翻页不成功完成
function M:notpageMoveComplete( )
	print("翻页不成功完成")
	self.halfPage:free()
	self.dragedPageMask:clear()
	self.staticPageMask:clear()
	self.shadowManager:flipCompleteHandler()
	-- self._parent:overFlip()
	self._parent._isFlipPage = false
	self.loadOk  = false
end





--------------------------
-- 析构
--------------------------

function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
 	-- [本类调用]
end



return M






