--[[Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

local M 	= classSprite("HalfPage")




--------------------------
-- 构造函数
--------------------------

function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
 	-- [本类调用]
 	self.pageWidth  = params.pageWidth
 	self.pageHeight = params.pageHeight
 	self._id 		= params.id
 	self.staticPageMask = params.staticPageMask
 	self.dragedPageMask = params.dragedPageMask
end

--------------------------
-- 渲染
--------------------------

function M:onRender()
	M.super.onRender(self)

 	-- [本类调用]
	-- 加载节点
	self:loadDisplay() 
end 

-- 加载节点
function M:loadDisplay()
	self.allPage  = U.loadNode():anchor(cc.p(0, 0))
	
	local page2 = {}
	if self._id ~= 1 then
		page2 = D.img("5"..(self._id + 3)..".png"):to(self.allPage):anchor(cc.p(0, 0)):p(cc.p(0, 0))--:hide()
	else
		page2 = D.img("select/calendar/date/" .. self._id .. ".png"):to(self.allPage):anchor(cc.p(0, 0)):p(cc.p(0, 0))--:hide()

    end

	self:clipFunAll()
end 


--------------------------
-- 析构
--------------------------

function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
 	-- [本类调用]

end







--------------------------
-- 功能函数
--------------------------
function M:addAllPage()
	self.halfPage = U.loadNode():anchor(cc.p(0, 0))
	local page = D.img("select/calendar/date/back.png"):to(self.halfPage):anchor(cc.p(1, 0)):p(0, 0):flipX(true)--:hide()
	self._backPage =  page
	self:clipFunHalf()
end

-- 遮罩 CCClippingNode
function M:clipFunAll()
	self.clip1 = CCNodeExtend.extend(cc.ClippingNode:create(self.staticPageMask)):to(self:getParent(), 10)
	self.clip1:setInverted(true)
	self.clip1:setAlphaThreshold(0) -- 显示透明区域
	self.clip1:addChild(self.allPage)
end

-- 遮罩 CCClippingNode
function M:clipFunHalf()
	self.clip2 = CCNodeExtend.extend(cc.ClippingNode:create(self.dragedPageMask)):to(self:getParent(), 10)
	self.clip2:setInverted(false)
	self.clip2:setAlphaThreshold(0) -- 显示透明区域
	self.clip2:addChild(self.halfPage)
end

function M:onDrag(cPoint, angle)
	self.halfPage:p(cPoint.x, cPoint.y)
	self.halfPage:rotation(-angle - 180)
end



-- 释放内存
function M:free( )
	self.halfPage:remove()
	self.clip2:remove()
	self.allPage  = nil
	self.halfPage = nil
	self.clip2    = nil
end



--------------------------
-- 属性
--------------------------




--------------------------
-- 父类重写
-------------------------- 




return M






