--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    -- 触控区域
    self._clearPos = {
        cc.p(354.5 + X_OFFSET, 371.7 + Y_OFFSET), cc.p(315.6 + X_OFFSET, 169.8 + Y_OFFSET), cc.p(610.6 + X_OFFSET, 137.0 + Y_OFFSET), cc.p(615.2 + X_OFFSET, 380.2 + Y_OFFSET), cc.p(501.4 + X_OFFSET, 251.8 + Y_OFFSET), 
        cc.p(479.8 + X_OFFSET, 88.2 + Y_OFFSET), cc.p(466.4 + X_OFFSET, 441.2 + Y_OFFSET), cc.p(294.0 + X_OFFSET, 255.6 + Y_OFFSET), cc.p(641.5 + X_OFFSET, 244.9 + Y_OFFSET), cc.p(422.3 + X_OFFSET, 176.1 + Y_OFFSET), 
        cc.p(581.9 + X_OFFSET, 262.2 + Y_OFFSET), cc.p(500.9 + X_OFFSET, 144.7 + Y_OFFSET), cc.p(491.9 + X_OFFSET, 352.0 + Y_OFFSET), cc.p(376.0 + X_OFFSET, 146.9 + Y_OFFSET), cc.p(372.1 + X_OFFSET, 202.4 + Y_OFFSET), 
        cc.p(542.8 + X_OFFSET, 214.4 + Y_OFFSET), cc.p(493.6 + X_OFFSET, 196.6 + Y_OFFSET), cc.p(615.9 + X_OFFSET, 208.1 + Y_OFFSET), cc.p(659.0 + X_OFFSET, 211.2 + Y_OFFSET), cc.p(397.6 + X_OFFSET, 87.1 + Y_OFFSET), 
        cc.p(556.8 + X_OFFSET, 96.0 + Y_OFFSET), cc.p(563.4 + X_OFFSET, 167.1 + Y_OFFSET), cc.p(374.7 + X_OFFSET, 312.8 + Y_OFFSET), cc.p(415.9 + X_OFFSET, 322.3 + Y_OFFSET), cc.p(441.7 + X_OFFSET, 376.1 + Y_OFFSET), 
        cc.p(532.1 + X_OFFSET, 372.8 + Y_OFFSET), cc.p(528.6 + X_OFFSET, 300.6 + Y_OFFSET), cc.p(600.9 + X_OFFSET, 313.6 + Y_OFFSET), cc.p(638.9 + X_OFFSET, 326.7 + Y_OFFSET), cc.p(455.1 + X_OFFSET, 275.8 + Y_OFFSET), 
        cc.p(400.4 + X_OFFSET, 411.1 + Y_OFFSET), cc.p(582.2 + X_OFFSET, 414.4 + Y_OFFSET), cc.p(430.1 + X_OFFSET, 227.8 + Y_OFFSET), cc.p(314.5 + X_OFFSET, 326.3 + Y_OFFSET), cc.p(370.1 + X_OFFSET, 273.4 + Y_OFFSET), 
    }
    self._bgPos = {
        {cc.p(274.4  , 117.7 + Y_OFFSET), cc.p(414.4  , 200   + Y_OFFSET), cc.p(381.7 , 17.3   + Y_OFFSET), cc.p(295.7 , -103.6 + Y_OFFSET)}, 
        {cc.p(-372.4 , 107.3 + Y_OFFSET), cc.p(-215.3 , 144.3 + Y_OFFSET), cc.p(-414.8, -54.6  + Y_OFFSET), cc.p(-250  , -214.1 + Y_OFFSET)}, 
        {cc.p(-923.3 , 209.0 + Y_OFFSET), cc.p(-693.2 , 46.4  + Y_OFFSET), cc.p(-459.1, -94.5  + Y_OFFSET), cc.p(-736.0, -224.5 + Y_OFFSET)}, 
        {cc.p(-1031.1, -94.0 + Y_OFFSET), cc.p(-572.1 , 154.6 + Y_OFFSET), cc.p(857.2 , -219.2 + Y_OFFSET), cc.p(1019.7, -27.6  + Y_OFFSET)}, 
        {cc.p(694.9  , 17.0  + Y_OFFSET), cc.p(492.3  , 155.6 + Y_OFFSET), cc.p(1073.0, 192.3  + Y_OFFSET), cc.p(601.7 , -248.1 + Y_OFFSET)}
    }
    -- 虚线表
    self._circleTab      = {}
    -- 虚线表
    self._lineTab        = {}
    -- 右大花表
    self._rightFlowerTab = {}
    -- 左大花表
    self._lightFlowerTab = {}
    -- 计数
    self._count    = 0
    -- 是否可以点击
    self._canTouch = true
    -- 游戏事件顺序
    self._order    = 1
    -- 装饰表
    self._lastTab  = {}
    -- 窗户偏移量
    self._offset   = 50
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 加载背景
    self:loadBg()
    -- 加载窗户
    self:loadDoor()
    -- 加载窗户的雪花
    self:loadSnows()
    -- 加载污渍
    self:loadDirty()
    -- 加载雾气
    self:loadFog()
    -- 加载熊猫手
    self:loadHand()
    -- 跳转贴窗户
    -- self:loadTowel()
    -- self._towel:enter()
    -- Tools:loadTestNode(self, #self._clearPos, self._clearPos)
    -- 跳转挂装饰
    -- self:finishFlower()
    -- 去广告
    Tools:closeAd(true)
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- 熊猫手出现
    self._hand:enter()
    -- 播放配音
    soundVoice:playEffectv057080()
end

--加载递出的手
function M:loadHand()
    local hand = import("app.common.node.BaseHand").new({
        layer = self,
    }):to(self, 999):bindTouch()
    self._hand = hand
    -- 加载起泡刷
    self:loadBrush()
end

--加载背景
function M:loadBg()
    local bg = U.loadBg("tfcleanwindow/bg.png"):to(self)--:scale(1.25)
    -- 加载一个空节点
    local node = U.loadNode({}):to(self, 50):p(V.w_2, V.h_2):scale(1.1)--:bindTouchLocate()
    self._node = node
    -- 加载几粒
    for i = 1, 5 do
        for j = 1, 4 do 
            -- 加载纹理
            local bg1  = D.img("tfcleanwindow/bg/"..j..".png"):to(self._node, 90):p(self._bgPos[i][j])--:bindTouchLocate()
        end
    end
end

-- 加载窗户
function M:loadDoor()
    local frame   = D.img("tfcleanwindow/door/frame.png"):to(self._node, 10):p(3.6, -6.4)--:scale(0.9):bindTouchLocate()
    self._frame   = frame
    local scenery = D.img("tfcleanwindow/door/scenery.png"):to(frame, -5):p(244.8, 240.2)
    self._scenery = scenery
end

-- 加载窗户雪花
function M:loadSnows()
    -- 加载裁切
    local mask = D.img("tfcleanwindow/door/scenery.png"):to(self._frame, -10):p(244.8, 240.2)--:opacity(0)
    local clippingNode = CCNodeExtend.extend(cc.ClippingNode:create(mask)):bindTouch()
    clippingNode:to(self._frame, -1):setInverted(false):setContentSize(CCSize(100, 100)):setAlphaThreshold(0)
    local snow = D.img("tfcleanwindow/door/scenery.png"):to(clippingNode):p(244.8, 240.2):scale(1):opacity(0)
    --雪花
    Tools:loadSnows(snow, 999, nil, 5, true, nil, nil, true)
end

-- 加载起泡刷
function M:loadBrush()
    local node      = import("app.tfcleanwindow.node.Brush")
    local brush     = node.new({
        imgName     = "tfcleanwindow/blister/brush.png",
        layer       = self,
    }):to(self._hand, 180):bindTouch():scale(1)
    local handPos = self._hand:getCenterPos()
    local offsetX = 0
    local offsetY = 25
    brush:p(handPos.x + offsetX, handPos.y + offsetY)
    self._hand._handThing = brush
    self._brush     = brush 
end

-- 加载刷子
function M:loadScrape()
    local node      = import("app.tfcleanwindow.node.Scrape")
    local scrape    = node.new({
        imgName     = "tfcleanwindow/scrape.png",
        layer       = self,
    }):to(self._hand, 180):bindTouch():scale(1)--:bindTouchLocate()
    local handPos = self._hand:getCenterPos()
    local offsetX = 0
    local offsetY = 25
    scrape:p(handPos.x + offsetX, handPos.y + offsetY)
    self._hand._handThing = scrape
    self._scrape    = scrape  
end

-- 加载毛巾
function M:loadTowel()
    local node     = import("app.tfcleanwindow.node.Towel")
    local towel    = node.new({
        imgName    = "tfcleanwindow/towel/1.png",
        layer      = self,
    }):to(self._hand, 180):bindTouch():scale(1)--:bindTouchLocate()
    local handPos = self._hand:getCenterPos()
    local offsetX = 0
    local offsetY = 25
    towel:p(handPos.x + offsetX, handPos.y + offsetY)
    self._hand._handThing = towel
    self._towel    = towel  
end

-- 加载污渍
function M:loadDirty()
    local pos   = {ccp(383.2 + X_OFFSET, 340.5 + Y_OFFSET), ccp(558.3 + X_OFFSET, 331.2 + Y_OFFSET), ccp(389.1 + X_OFFSET, 169.7 + Y_OFFSET), ccp(563.6 + X_OFFSET, 172.4 + Y_OFFSET)}
    local erasePos = {}
    T.copyTable(erasePos, self._clearPos) 
    -- 擦除纹理节点
	local scrapeTexture = import("app.common.Texture").new({
        paint       = "tfcleanwindow/scrape.png",
        size        = cc.size(V.w, V.h),
        clearPos    = erasePos,
    }):to(self._node, 40):p(self._node:cw()/2, self._node:ch()/2)
    self._scrapeTexture = scrapeTexture
    for i = 1, 4 do
        -- 添加污渍
        scrapeTexture:addImg("tfcleanwindow/blot/"..i..".png", pos[i], 1)
    end
end

-- 加载雾气
function M:loadFog()
    if self._texture then return end
    local pos = {}
    T.copyTable(pos, self._clearPos) 
    local towelTexture = import("app.common.Texture").new({
        size        = cc.size(V.w, V.h),
        clearPos    = pos,
        paint       = "common/point.png",
    }):to(self, 90):p(483.2 + X_OFFSET, 261.9 + Y_OFFSET):scale(1.1):hide()
    towelTexture:addImg("tfcleanwindow/door/fog.png", cc.p(towelTexture:cw()/2, towelTexture:ch()/2), 1)
    towelTexture:opacity(0)
    self._towelTexture = towelTexture
    -- 加载一层假的雾气
    local fog = D.img("tfcleanwindow/door/fog.png"):to(self, 90):p(483.2 + X_OFFSET, 261.9 + Y_OFFSET):scale(1.1):opacity(0)
    self._fog = fog
end


----------  Ui栏  ---------------
-- 加载滚动Ui栏
function M:loadScrolUi(index, isScrol)
    local sprite = require("app.common.node.ScrollUi")
    local ui = sprite.new({
        picPath   	= "common/ui/uiBar.png",
        layer       = self,
        pos         = cc.p(1160 + 1.5 * X_OFFSET, 250 + Y_OFFSET),
        zOrder      = 100,
        showNumber  = 4,
        arrowScroll = isScrol
    }):to(self, 200):scale(1)--:bindTouchLocate()
    self._ui = ui
end
----------  Ui栏  ---------------


--------- 加载窗花ui栏 -----------
function M:loadFlowerScrolUi()
    -- 加载通用ui栏
    self:loadScrolUi(4, false)
    -- 加载ui栏内滚动的盘子
    self:loadUiPlate()
    -- 加载虚线
    self:loadDotted()
    -- 加载ok按钮
    self:loadOkBtn()
end

-- 加载窗花格子
function M:loadUiPlate()
    self._itemTab = {}
    for i = 1, 4 do
        local sprite = require("app.tfcleanwindow.node.Doorflower")
        local item   = sprite.new({
            imgName      = "common/ui/item.png",
            index        = i,
            layer        = self,
        })
        item._itemSize   = 0
        table.insert(self._itemTab, item)
    end
    -- 在滚动栏中添加初始项
    self._ui._scrollView:addItemToScrollView(self._itemTab)
end

-- 加载虚线
function M:loadDotted()
    local pos = {ccp(364.2 - self._offset + X_OFFSET, 276.1 + Y_OFFSET), ccp(598.8 - self._offset + X_OFFSET, 276.1 + Y_OFFSET)}
    for i = 1, 2 do 
        local circle = D.img("tfcleanwindow/doorflower/circle.png"):to(self, 250):p(pos[i]):scale(1.2):opacity(0)
        table.insert(self._circleTab, circle)
    end
end
--------- 加载窗花ui栏 -----------


--------- 加载装饰ui栏 -----------
function M:loadDecorateScrolUi()
    -- 加载ok按钮
    self:loadOkBtn()
    -- 加载通用ui栏
    self:loadScrolUi(6, true)
    -- 加载装饰
    self._itemTab = {}
    for i = 1, 6 do
        local sprite = require("app.tfcleanwindow.node.Decorate")
        local item   = sprite.new({
            imgName  = "common/ui/item.png",
            index    = i,
            layer    = self,
        })
        item._itemSize   = 0
        table.insert(self._itemTab, item)
    end
    -- 在滚动栏中添加初始项
    self._ui._scrollView:addItemToScrollView(self._itemTab)
    local pos = {ccp(235 + X_OFFSET, 250 + Y_OFFSET), ccp(500 + X_OFFSET, 250 + Y_OFFSET)}
    for i = 1, 2 do
        local line = D.img("tfcleanwindow/decorate/line.png"):to(self, 250):p(pos[i]):scale(0.9):opacity(0)--:bindTouchLocate()
        table.insert(self._lineTab, line)
    end
end
--------- 加载装饰ui栏 -----------


-- 加载ok按钮
function M:loadOkBtn(pos)
    local okBtn = import("app.common.node.BaseOkBtn").new({
        imgName = "common/okbtn/line.png",
        pos     = pos,
    }):to(self, 999)
    self._okBtn = okBtn
end

-- 加载3秒无炒作自动打勾
function M:laterTime()
    if tolua.isnull(self._laterTimeAct) then 
        self._laterTimeAct = A.line({
            {"delay", 3},
            {"fn", function ()
                if not tolua.isnull(self._okBtn._btn) then 
                    self._okBtn._btn:onTouchBegan()
                end
            end}
        }):at(self)
    end
end

-- 停止3秒计算重新计时
function M:stopLaterTime()
    for i, v in ipairs(self._itemTab) do
        v:stopAllActions()
    end
    if not tolua.isnull(self._laterTimeAct) then 
        print("三秒结束")
        self:stopAction(self._laterTimeAct)
        self._laterTimeAct = nil
    end
end

-- 下一个事件
function M:okNextStep()
    -- 加广告
    Tools:openAd()
    self._adOnceEnter = false
    self._canTouch = false
    -- 清空数据
    self:stopLaterTime()
    self._count          = 0
    self._rightFlowerTab = {}
    self._lightFlowerTab = {}
    -- ui栏退出
    self._ui:quit()
    if self._order == 1 then 
        -- 播放配音
        soundVoice:playEffectv057004()
        self:finishFlower()
    elseif self._order == 2 then
        self:finishLightDecorate()
    elseif self._order == 3 then
        self:finishRightDecorate()
    end
    -- 顺序计数
    self._order = self._order + 1
end

-- 结束贴窗花
function M:finishFlower()
    print("结束贴窗花")
    -- 镜头拉远
    A.line({
        {"delay", 0.5},
        {"scaleTo", 0.7, 1},
        {"delay", 1},
        {"union",{
            {"moveBy", 1.2, ccp(450 + self._offset + X_OFFSET, 0)},
            {"fn", function()
                -- 音效[sfx05703009]
     	        soundEffect:playEffectsfx05703009()
            end},
        }},
        {"fn", function ()
            self._canTouch = true
            -- 加载新的ui栏
            self:loadDecorateScrolUi()
        end}
    }):at(self._node)
end

--结束左边装饰
function M:finishLightDecorate()
    A.line({
        {"delay", 1},
        {"union",{
            {"moveBy", 1.2, ccp(-1120 - X_OFFSET * 2.3, 0)},
            {"fn", function()
                -- 音效[sfx05703009]
     	        soundEffect:playEffectsfx05703009()
            end},
        }},
        {"fn", function ()
            self._canTouch = true
            -- 加载新的ui栏
            self:loadDecorateScrolUi()
        end}
    }):at(self._node)
end

--结束右边装饰
function M:finishRightDecorate()
    A.line({
        {"delay", 1},
        {"union",{
            {"moveBy", 1.2, ccp(675 + X_OFFSET, 0)},
            {"scaleTo", 1.2, 0.6},
        }},
        {"fn", function ()
            -- 加载墙壁粒子
            self:stimulate()
            -- 切换场景
            A.line({
                {"delay", 1},
                {"fn", function ()
                    local tab = self._lastTab
                    --装饰存入本地表中
                    T.copyTable(G_ROOM_DECORATE_CONFIG["decorateTb"], tab)
                    ST.setTable("ROOM_DECORATE_CONFIG", G_ROOM_DECORATE_CONFIG)
                    game:enterScene("tfroom", {enterCount = 2, lastTab = tab}, "fade", 1, COLOR3_WHITE)
                end}
            }):at(self)
        end}
    }):at(self._node)
end

-- 墙壁粒子激励
function M:stimulate()
    --  加载粒子
    local pos = {ccp(80 + X_OFFSET, 250 + Y_OFFSET), ccp(220 + X_OFFSET, 250 + Y_OFFSET), ccp(430 + X_OFFSET, 260 + Y_OFFSET), 
                ccp(550 + X_OFFSET, 260 + Y_OFFSET), ccp(750 + X_OFFSET, 250 + Y_OFFSET), ccp(880 + X_OFFSET, 250 + Y_OFFSET)}
    for i = 1, 6 do 
        local particle = Tools:newParticle("particle/qiangbi_jili.plist", pos[i].x, pos[i].y):to(self, 999)
        Tools:insertParticleTb(self, particle)
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
