--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("brush")
-- M.TAG       = "DemoNode"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    self._layer = params.layer
    -- 泡沫
    self._foams      = {}
    -- 泡泡计数
    self._foamCnt    = 0
    -- 泡泡的最大数量
    self._foamMaxNum = 30 
    -- 是否可以点击
    self._canTouch   = false
    -- 起始泡泡表
    self._beginHubbleTb = {}
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
    -- 初始化
    self:getTouchRange()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    self:scale(1)
    -- 开启引导
    guideFn:openGuide(self, 0.1, 3)
end

-- 加载其他
function M:loadRenderOtherwise()
    local pos = {ccp(50, 104.5), ccp(62, 40), ccp(110, 72.3)}
    for i = 1, 3 do 
       -- 加载泡泡
        local hubble = D.img("tfcleanwindow/blister/"..i..".png"):to(self, -1):p(pos[i]):scale(0.75):hide():opacity(0)--:bindTouchLocate() 
        table.insert(self._beginHubbleTb, hubble)
        hubble:line({
            {"scaleTo", 0.1, 0.65},
            {"fn", function()
                hubble:cycle({
                    {"scaleTo", 0.4, 0.85, 0.75},
                    {"scaleTo", 0.8, 1.05, 0.65},
                    {"scaleTo", 0.4, 0.90},
                })
            end},
        })
    end
end

-- 泡泡出现
function M:hubbleAppear()
    if not self._onceEnter then 
        self._onceEnter = true
        for i, v in ipairs(self._beginHubbleTb) do
            A.line({
                {"show"},
                {"fadeTo", 0.5, 200},
            }):at(v)
        end
    end
end

-- 泡泡出现
function M:createFoams(pos)
    for k,v in pairs(self._foams) do
        -- 防止泡泡生成太密集
        if not tolua.isnull(v) and PT.distance(v:point(), pos) < 52.5 then return end
    end
  
    local index = math.random(1, 3)
    local foam = D.img("tfcleanwindow/foam/"..index..".png"):to(self._layer, 100):p(pos):scale(0):opacity(200)
    if self._foamCnt % 2 == 0 then
        local particle = Tools:newParticle("particle/paomo.plist", foam:point().x, foam:point().y):to(self._layer, 99):scale(1.1)
        Tools:insertParticleTb(self._layer, particle)
        foam._particle = particle
    end
    foam:line({
        {"scaleTo", 0.1, 0.9},
        {"fn", function()
            foam:cycle({
                {"scaleTo", 0.5, 1.2, 1},
                {"scaleTo", 1, 1.4, 0.9},
                {"scaleTo", 0.5, 1.1},
            })
        end},
    })
    self._foamCnt = self._foamCnt + 1
    -- 如果存在泡泡了,将旧的泡泡删除
    self:removeOldFoam()
    self._foams[self._foamCnt] = foam
    -- 如果泡泡达到最大数量，重置为1
    if self._foamCnt >= self._foamMaxNum then
        self._foamCnt = 1
    end
end

-- 删除旧泡泡
function M:removeOldFoam()
    if self._foams[self._foamCnt] then
        local node = self._foams[self._foamCnt]
        self._foams[self._foamCnt] = nil
        local fadeTime = math.random(10, 40)*0.1
        node:line({
            {"union", {
                {"scaleTo", fadeTime, 0},
                {"fadeTo", fadeTime, 0}
            }},
            {"fn", function()
                if node._particle and not tolua.isnull(node._particle) then
                    node._particle:remove()
                    node._particle = nil
                end

                if node and not tolua.isnull(node) then
                    node:remove()
                    node = nil
                end
            end},
        })
    end
end

--初始化
function M:getTouchRange()
	--长
	self._h = 202
	--宽
	self._w = 202
	--位置
    self._centerPo = ccp(V.w_2, 260 + Y_OFFSET)
    local h = self._h
    local w = self._w
    local centerPo = self._centerPo
    local c = math.sqrt((h * h) - (w * w))
    self._poc1 = ccp(centerPo.x - c, centerPo.y)
    self._poc2 = ccp(centerPo.x + c, centerPo.y)
    self._2h = h * 2
    self._exMoveNum = 0
end

--滑动限制
function M:dragLimit(x, y)
	local dis1 = bb.UPoint.distance(ccp(x, y), self._poc1)
	local dis2 = bb.UPoint.distance(ccp(x, y), self._poc2)
    if dis1 + dis2 < self._2h then
        -- 音效[sfx05703003]涂抹泡沫
        self:playSoundEffect()
        self:hubbleAppear()
        self:createFoams(ccp(x, y))
	end
end

-- 涂抹泡沫
function M:playSoundEffect()
    if not self._sfx05703003 then
        -- 播放音效[sfx25601011]拉拉链
        self._sfx05703003     = soundEffect:playEffectsfx05703003()
        sound.setFinishCallback(self._sfx05703003, function()
            self._sfx05703003 = nil
        end)
    end
end

-- 刷子离场
function M:brushOut()
    sound.voiceFadeTo(self._sfx05703003, 0.07, 1)
    -- 手进场
    self:handEnter()
    A.line({
        {"union",{
            {"jumpTo", 0.25, ccp(830 + X_OFFSET, 70), 50, 1},
            {"fn", function()
                -- 音效[sfx05700004]
     	        soundEffect:playEffectsfx05703004()
            end},
        }},
        {"fn", function ()
            Tools:resetParent(self, self._layer._hand, 93)
            commonAct:nodeScale(self, 1, 0.5)
            -- 结束动作
            self:fishAct()
        end}
    }):at(self)
end

-- 结束动作
function M:fishAct()
    A.line({
        {"delay", 0.3},
        {"fn", function ()
            -- 手手消失
            self._layer._hand:quit() 
            guideFn:stopGuide(self)
        end},
        {"delay", 0.4},
        {"fn", function ()
            self._layer._hand:enter()
            -- 加载刷子
            self._layer:loadScrape() 
        end},
        {"hide"}
    }):at(self)
end

-- 手进场
function M:handEnter()
    self._layer._hand:enter(nil, true) 
end

-- 刷子动作
function M:brushAct()
    if not self._brushAct then 
        self._scrapeAct = A.cycle({
            {"scaleTo", 0.2, 1.1, 0.9},
            {"scaleTo", 0.2, 1}
        }):at(self)
    end
end

-- 停止刷子动作
function M:stopBrushAct()
    if self._brushAct then 
        self:scale(1)
        A.line({
            {"scaleTo", 0.1, 1},
            {"fn", function ()
                -- 开启引导
                guideFn:openGuide(self, 0.1, 3)
            end}
        }):at(self)
        self:stopAction(self._brushAct)
        self._brushAct = nil
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end
    -- 音效[sfx05700001]点击拿起海绵（复用）
    soundEffect:playEffectsfx05700001()
    -- 关闭引导
    guideFn:stopGuide(self)
    self:brushAct()
    -- 手手消失
    if not self._once then 
        self._once = true
        self._layer._hand:quit() 
    end
    self._startPos = cc.p(x, y)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    if not self._canTouch then return end
    local px, py = Tools:dragLimit(self, x, y, self:cw()/2, V.w - self:cw()/2 , 0, V.h - self:ch()/2)
    self:p(px, py)
    bb.si.Tool.limitButtonMove({node = self})
    self:dragLimit(x, y)
    if #self._foams >= 30 then 
        -- 刷子离场
        self:brushOut()
        print("完成了")
        self._canTouch = false
    end
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return end
    sound.voiceFadeTo(self._sfx05703003, 0.07, 1)
    self:stopBrushAct()
    if #self._foams >= 27 then 
        -- 刷子离场
        self:brushOut()
        print("完成了")
        self._canTouch = false
    end
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
