--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Decorate")
-- M.TAG       = "DecorateNode"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    self._layer    = params.layer
    -- 花的种类
    self._index    = params.index
    -- 是否可以点击
    self._canTouch = true
    -- 是否拖动出去
    self._isMove   = false
    -- 是否可以创建
    self._canCreat = true
    -- 是否可以结束
    self._isEnd    = false
    -- 计数
    self._num      = #self._layer._lastTab
end

----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载装饰
    self:loadDecorate()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 加载花
function M:loadDecorate()
    local decorate = D.img("tfcleanwindow/decorate/ui/"..self._index..".png"):scale(1):to(self, 300):p(50, 50)
    self._decorate = decorate
end

-- 加载新的拖动
function M:loadNew(pos)
    if self._canCreat then 
        self._canCreat = false
        local doorNewdecorate = D.img("tfcleanwindow/decorate/"..self._index..".png"):scale(0.9):to(self._layer, 300):p(pos)
        if self._index <= 4 then 
            print(self._index)
            local pos = {ccp(90, 245), ccp(97, 215), ccp(75, 215), ccp(75, 245)}
            local nut   = import("app.tfcleanwindow.node.Nut").new({
                layer   = self,
                imgName = "tfcleanwindow/decorate/nail/nut.png",
            }):scale(1):to(doorNewdecorate, 20):p(pos[self._index]):hide()
            self._nut = nut
            local nail = D.img("tfcleanwindow/decorate/nail/nail1.png"):to(doorNewdecorate, 10):p(pos[self._index].x - 5, pos[self._index].y - 20):hide()
            self._nail = nail
        end 
        self._doorNewdecorate = doorNewdecorate
    end
end

-- 虚线引导圈
function M:circleAct()
    local tabName = {self._layer._lightFlowerTab, self._layer._rightFlowerTab}
    for i = 1, 2 do 
        if not tabName[i][1] then
            if self._layer._lineTab[i]._circleAct then return end
            self._layer._lineTab[i]._circleAct = A.cycle({
                {"fadein", 0.5},
                {"delay", .3},
                {"fadeout", 0.5},
            }):at(self._layer._lineTab[i])
        end
    end
end

-- 停止引导
function M:stopCircleAct() 
    for i, v in ipairs(self._layer._lineTab) do
        if v._circleAct then 
            A.line({
                {"fadeout", 0.2},
            }):at(v)
            v:stopAction(v._circleAct)
            v._circleAct = nil
        end
    end
end

-- 虚线引导圈
-- function M:circleAct()
--     if self._circleAct then return end
--     self._circleAct = A.cycle({
--         {"fadein", 0.5},
--         {"delay", .3},
--         {"fadeout", 0.5},
--     }):at(self._layer._line)
-- end

-- -- 停止引导
-- function M:stopCircleAct() 
--     if not self._circleAct then return end
--     A.line({
--         {"fadeout", 0.5},
--     }):at(self._layer._line)
--     self:stopAction(self._circleAct)
--     self._circleAct = nil
-- end

-- 贴窗花
function M:creatBigFlower(type)
    local tabName = {self._layer._rightFlowerTab, self._layer._lightFlowerTab}
    for i, v in ipairs(tabName[type]) do
        if v then 
            T.removeOrder(tabName[type], v)
            v:remove()
        end
    end
    -- 新东西的动作
    self:bewflowerAct(type)
    table.insert(tabName[type], self._doorNewdecorate)
    -- 判断是否完成
    self:isFinish()
    self._layer._lastTab[type + self._num] = self._index
end

-- 新东西的动作
function M:bewflowerAct(type)
    local pos = {ccp(500 + X_OFFSET, 252 + Y_OFFSET), ccp(250 + X_OFFSET, 252 + Y_OFFSET)}
    if self._nut then 
        self._nut:show()
        self._nail:show()
    end
    A.line({
        {"easing", "backout", {"union",{
            {"scaleTo", 0.2, 1.5},
            {"moveTo", 0.2, ccp(pos[type].x + 20, pos[type].y + 10)},
            {"fn", function ()
                print(self._index)
                if self._index > 4 then 
                    -- 音效[sfx05703008]
                    soundEffect:playEffectsfx05703008()
                else
                    -- 音效[sfx05703010]
                    soundEffect:playEffectsfx05703010()
                end
            end}
        }},},
        {"union",{
            {"scaleTo", 0.1, 1.15},
            {"moveTo", 0.1, ccp(pos[type].x, pos[type].y)}
        }},
        {"fn", function ()
            --  加载粒子
            self:loadParticle()
        end}
    }):at(self._doorNewdecorate)
end

-- 加载粒子
function M:loadParticle()
    local particle = Tools:newParticle("particle/window_chuanghua.plist", 75, 110):to(self._doorNewdecorate, 999)
    Tools:insertParticleTb(self, particle)
    if self._index <= 4 then 
        Tools:resetParent(self._doorNewdecorate, self._layer._node, 93)
        if self._nut then 
            self._nut:nailAct()
        end
        Tools:changeAnchorP(self._doorNewdecorate, ccp(0.5, 1))
        -- 晃动
        self:rock()
    else
        Tools:resetParent(self._doorNewdecorate, self._layer._node, 93)
        commonAct:nodeScale(self._doorNewdecorate, 1, 0.5)
    end
end

-- 晃动
function M:rock()
    A.line({
        {"rotateTo", 0.2, 10},
        {"easing", "elasticOut", {"rotateTo", 3, 0}},
    }):at(self._doorNewdecorate)
end

-- 判断是否完成
function M:isFinish()
    if #self._layer._rightFlowerTab == 1 and #self._layer._lightFlowerTab == 1 then 
        if not self._layer._adOnceEnter then 
            self._layer._adOnceEnter = true
            -- 去广告
            Tools:closeAd()
        end
        if not self._layer._onceEnter1 then 
            self._layer._onceEnter1 = true
            -- 播放配音
     	    soundVoice:playEffectv057083()
        end
        self._layer._okBtn:enter()
        A.line({
            {"delay", 3.5},
            {"fn", function ()
                -- 加载3秒无炒作自动打勾
                self._layer:laterTime()
            end}
        }):at(self)
        -- 计数
        self._layer._count = self._layer._count + 1
    else
        
    end
end


-- 隐藏
function M:moveHide()
    if not self._moveHideAct then 
        self._moveHideAct = A.line({
            {"union",{
                {"scaleTo", 0.1, 0},
                {"fadeout", 0.1},
            }},
            {"hide"}
        }):at(self._decorate)
    end
end

-- 显示
function M:moveShow()
    self._canCreat = true
    A.line({
        {"delay", 0.1},
        {"union",{
            {"fadein", 0.5},
            {"scaleTo", 0.5, 1},
            {"fn", function ()
                self._decorate:show()
            end}
        }},
        {"fn", function ()
            self._layer._canTouch = true
            if self._moveHideAct then 
                self._moveHideAct = nil
            end
        end}
    }):at(self._decorate)
end

-- 返回
function M:back()
    local worldPos = self:getParent():convertToWorldSpace(self:point())
    A.line({
        {"union",{
            {"scaleTo", 0.25, 0.35},
            {"moveTo", 0.25, ccp(worldPos.x - 3, worldPos.y + 21)},
            {"fn", function ()
                -- 音效[sfx05700008]
     	        soundEffect:playEffectsfx05700008()
            end}
        }},
        {"fn", function ()
            -- 花动作
            self:flowerAct()
            self._canCreat = true
   
        end},
        {"delay", 0.12},
        {"remove"}
    }):at(self._doorNewdecorate)
end

-- 花动作
function M:flowerAct()
    A.line({
        {"union",{
            {"fadein", 0.1},
            {"scaleTo", 0.1, 1}
        }},
        {"show"},
        {"fn", function ()
            commonAct:nodeScale(self._decorate, 1, 0.5)
        end},
        {"delay", 0.05},
        {"fn", function ()
            self._layer._canTouch = true
            if self._moveHideAct then 
                self._moveHideAct = nil
            end
        end},
    }):at(self._decorate)
end

-- 放置
function M:put()
    if self._doorNewdecorate:py() < 415 + Y_OFFSET  and self._doorNewdecorate:py() > 85 + Y_OFFSET then 
        if self._doorNewdecorate:px() < 635 + X_OFFSET and self._doorNewdecorate:px() > 338 + X_OFFSET then 
            -- 显示
            self:moveShow()
            -- 贴窗花
            self:creatBigFlower(1)
        elseif self._doorNewdecorate:px() <= 338 + X_OFFSET and self._doorNewdecorate:px() > 106 + X_OFFSET then
            self:moveShow()
            self:creatBigFlower(2)
        else
            -- 返回
            self:back()
        end
    else 
        -- 返回
        self:back()
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._layer._canTouch then return end
    -- 音效[sfx05700001]
    soundEffect:playEffectsfx05700001()
    self._layer:stopLaterTime()
    self._layer._canTouch = false
    self._isEnd = false
    self._decorate:scale(1.2)
    self._startPos = ccp(x, y)
    -- 可穿透
	return SIGN_TOUCH_BEGAN_NO_SWALLOWS	
end

function M:onTouchMoved(x, y, touches)
    local offset = ccpSub(self._startPos , ccp(x, y))
    if math.abs(offset.x) >= 40  then
        self._isMove = true
        self._isEnd  = true
        self._layer._ui._scrollView._canTouch = false
        self:loadNew(ccp(x, y))
        -- -- 虚线动作
        self:circleAct()
        -- -- 隐藏
        self:moveHide()
        self._doorNewdecorate:p(x, y)
    else
        if self._doorNewdecorate and self._isMove then
            self._doorNewdecorate:p(x, y)
        end
    end
    bb.si.Tool.limitRectMove({
        node = self._doorNewdecorate,
        -- marginTop = 80,
        -- boundingRect = cc.rect(20, 0, self:size().width - 40, self:size().height)
    })
    bb.si.Tool.limitButtonMove({node = self._doorNewdecorate})
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return  end
    self._decorate:scale(1)
    -- 继续滚动
    self._layer._ui._scrollView:startRoll()
    self._layer._ui._scrollView._canTouch = true
    -- -- 停止虚线 
    self:stopCircleAct()
    self._isMove = false
    if self._layer._count > 0 then 
        -- 加载3秒无炒作自动打勾
        self._layer:laterTime()
    end
    if not self._isEnd then 
        self._layer._canTouch = true
        return  
    end
    -- 放置
    self:put()
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
