--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("scrape")
-- M.TAG       = "DemoNode"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    self._layer = params.layer
    -- 已擦除泡泡计数
    self._count        = 0
    -- 是否可以点击
    self._canTouch     = false
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    self:scale(1)
    -- 开启引导
    guideFn:openGuide(self, 0.1, 3)
end

-- 泡泡消失
function M:disappearFoams(foam, type, offset)
    offset = offset or 0
    -- 播放音效[sfx05703005]刮去泡沫
    self:playSoundEffect()
    foam:stopAllActions()
    if foam._particle and not tolua.isnull(foam._particle) then
        foam._particle:remove()
        foam._particle = nil
    end
    if type then 
        if foam and not tolua.isnull(foam) then
            T.removeOrder(self._layer._brush._foams, foam)
        end
    end
    local dir = -1 
    if offset < 0 then 
        dir = 1
    end
    local num = N.random(50, 80)
    foam:line({
        {"union",{
            {"moveBy", .7, ccp(0, dir * num)},
            {"fadeTo", 1, 100},
            {"scaleTo", 1, 0}
        }},
        {"remove"}
    })
end

-- 结束
function M:scrapeOut(type)
    sound.voiceFadeTo(self._sfx05703005, 0.07, 1)
    self._canTouch = false
    for i, v in pairs(self._layer._brush._foams) do
        self:disappearFoams(v, type)
    end
    self._layer._scrapeTexture:hide()
    if self._layer._scrapeTexture and not tolua.isnull(self._layer._scrapeTexture) then
        self._layer._scrapeTexture:remove()
        self._layer._scrapeTexture = nil
    end
    -- 新道具
    self:newProp()
end


-- 新道具
function M:newProp()
    -- 手进场
    self:handEnter()
    -- 雾气渐显
    self:fogAct()
    A.line({
        {"union",{
            {"jumpTo", 0.25, ccp(830 + X_OFFSET, 70), 50, 1},
            {"fn", function()
                -- 音效[sfx05700004]
     	        soundEffect:playEffectsfx05703004()
            end},
        }},
        {"fn", function ()
            Tools:resetParent(self, self._layer._hand, 93)
            commonAct:nodeScale(self, 1, 0.5)
            -- 结束动作
            self:fishAct()
        end}
    }):at(self)
end

-- 结束动作
function M:fishAct()
    A.line({
        {"delay", 0.3},
        {"fn", function ()
            -- 手手消失
            self._layer._hand:quit() 
            guideFn:stopGuide(self)
        end},
        {"delay", 1.2},
        {"fn", function ()
            self._layer._hand:enter()
            -- 加载刷子
            self._layer:loadTowel() 
        end},
        {"hide"}
    }):at(self)
end

-- 手进场
function M:handEnter()
    self._layer._hand:enter(nil, true) 
end

-- 雾气渐显
function M:fogAct()
    --  加载粒子
    local particle = Tools:newParticle("particle/window_clean.plist", V.w_2, V.h_2):to(self._layer, 999)
    Tools:insertParticleTb(self._layer, particle)
    -- 音效
    soundEffect:playEffectsfx05703014()
    A.line({
        {"delay", 1.8},
        {"union",{
            {"fadein", 1},
            {"fn", function ()
                -- 音效
                soundEffect:playEffectsfx05703015()
                --  加载粒子
                local particle = P.newParticle("particle/ice.plist"):to(self._layer, 999):p(V.w_2, V.h_2):scale(1)
                Tools:insertParticleTb(self._layer, particle)
            end}
        }},
        {"fn", function ()
            self._layer._towelTexture:show()
        end},
        {"remove"}
    }):at(self._layer._fog)
end

-- 刮去泡沫
function M:playSoundEffect()
    if not self._sfx05703005 then
        -- 播放音效[sfx05703005]刮去泡沫
        self._sfx05703005     = soundEffect:playEffectsfx05703005()
        sound.setFinishCallback(self._sfx05703005, function()
            self._sfx05703005 = nil
        end)
    end
end

-- 刷子动作
function M:scrapeAct()
    if not self._scrapeAct then 
        self._scrapeAct = A.cycle({
            {"scaleTo", 0.2, 0.9, 1.1},
            {"scaleTo", 0.2, 1}
        }):at(self)
    end
end

-- 停止刷子动作
function M:stopScrapeAct()
    if self._scrapeAct then 
        self:scale(1)
        A.line({
            {"scaleTo", 0.1, 1},
            {"fn", function ()
                -- 开启引导
                guideFn:openGuide(self, 0.1, 3)
            end}
        }):at(self)
        self:stopAction(self._scrapeAct)
        self._scrapeAct = nil
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end
    -- 音效[sfx05700001]点击拿起海绵（复用）
    soundEffect:playEffectsfx05700001()
    -- 关闭引导
    guideFn:stopGuide(self)
    self:scrapeAct()
     -- 手手消失
     if not self._once then 
        self._once = true
        self._layer._hand:quit() 
    end
    self._startPos = cc.p(x, y)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    if not self._canTouch then return end
    local px, py = Tools:dragLimit(self, x, y, self:cw()/2, V.w - self:cw()/2 , 0, V.h - self:ch()/2)
    self:p(px, py)
    bb.si.Tool.limitButtonMove({node = self})
    local endPos = ccp(x, y)
    local offset = self._startPos.y - endPos.y
    self._layer._scrapeTexture:erasure(self._startPos, ccp(x, y), nil, 255, self._earCurScale)
    for i, v in pairs(self._layer._brush._foams) do
        if not v.isClean and PT.distance(v:worldpoint(), ccp(x, y)) < 40 then
            -- 擦除泡泡
            v.isClean    = true
            self._count  = self._count  + 1
            self:disappearFoams(v, true, offset)
        end
    end
    if self._count >= 30 then 
        -- 结束
        self:scrapeOut(false)
        self._canTouch = false
    end
    self._startPos = ccp(x, y)
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return end
    sound.voiceFadeTo(self._sfx05703005, 0.07, 1)
    self:stopScrapeAct()
    if self._count >= 26 then 
        -- 结束
        self:scrapeOut(false)
        self._canTouch = false
    end
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
