--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Towel")
-- M.TAG       = "DemoNode"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    self._layer = params.layer
    -- 已擦除泡泡计数
    self._count        = 0
    -- 是否可以点击
    self._canTouch     = false
    -- 计数
    self._clearCount   = 0
    -- 粒子表
    self._particletab  = {}
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- 开启引导
    guideFn:openGuide(self, 0.1, 3)
end

-- 手进场
function M:handEnter()
    self._layer._hand:enter(nil, true) 
end

-- 抹布离场
function M:towelOut()
    sound.voiceFadeTo(self._sfx05703006, 0.07, 1)
    self._canTouch = false
    self._layer._towelTexture:fadeOutEvent()
    -- 手进场
    self:handEnter()
    A.line({
        {"union",{
            {"jumpTo", 0.25, ccp(830 + X_OFFSET, 70), 50, 1},
            {"fn", function()
                -- 音效[sfx05700004]
     	        soundEffect:playEffectsfx05703004()
            end},
        }},
        {"fn", function ()
            Tools:resetParent(self, self._layer._hand, 93)
            commonAct:nodeScale(self, 1, 0.5)
            -- 进入贴窗花
            self:enter()
            A.line({
                {"delay", 0.3},
                {"fn", function ()
                    -- 手手消失
                    self._layer._hand:quit() 
                    guideFn:stopGuide(self)
                end},
            }):at(self) 
        end}
    }):at(self)
end

-- 进入贴窗花
function M:enter()
    -- 加广告
    Tools:openAd()
    -- 粒子和动作
    self:particleAct()
    -- 镜头拉远
    A.line({
        {"delay", 1.5},
        {"union",{
            {"scaleTo", 0.5, 1.3},
            {"moveBy", 0.5, ccp(-self._layer._offset, 0)},
            {"fn", function ()
                -- 播放配音
	            soundVoice:playEffectv057003()
                self._layer:loadFlowerScrolUi()
            end}
        }},
    }):at(self._layer._node)
end

-- 粒子和动作
function M:particleAct()
    -- 音效
    soundEffect:playEffectsfx05703016()
    --  加载粒子
    local particle = Tools:newParticle("particle/window_jili.plist", V.w_2, V.h_2):to(self._layer, 999)
    table.insert(self._particletab, particle)
    Tools:insertParticleTb(self._layer, particle)
    local particle1 = Tools:newParticle("particle/window_jili.plist", V.w_2, V.h_2):to(self._layer, 999)
    table.insert(self._particletab, particle1)
    Tools:insertParticleTb(self._layer, particle)
    self:moveroundAct(particle, true)
    self:moveroundAct(particle1, false)
end

-- 环绕动作
function M:moveroundAct(node, boole, angle)
    A.line({
        {"moveround", 1.5, cc.p(V.w_2, V.h_2), 240, boole, 90},
        {"fn", function()
            node:stopSystem()
        end},
        {"delay", 0.5},
        {"remove"}      
    }):at(node)
end

-- 抹布动作
function M:towelAction()
    if self._towelAct then return end
    --  加载粒子
    self._particle = P.newParticle("particle/ice_ca1.plist"):to(self, 999):p(150, 150):scale(1)
    Tools:insertParticleTb(self, self._particle)
    self._towelAct = A.cycle({
        {"image", "tfcleanwindow/towel/", 5, 0.1}
    }):at(self)
end

-- 停止抹布动作
function M:stopTowelAction()
    if not self._towelAct then return end
    if self._particle then 
        self._particle:remove()
    end
    self:stopAction(self._towelAct)
    self._towelAct = nil
end

-- 计算函数
function M:count()
    for i,v in ipairs(self._layer._clearPos) do
        if PT.distance(v, self._startPos) < 50 then
            self:playSoundEffect()
            if self._layer._testNodeTable then
                self._layer._testNodeTable[i]:hide()
                table.remove(self._layer._testNodeTable, i)
            end
            table.remove(self._layer._clearPos, i)
            self._clearCount = self._clearCount + 1
            break
        end
    end
end

-- 擦除水渍
function M:playSoundEffect()
    if not self._sfx05703006 then
        -- 播放音效[sfx05703006]擦除水渍
        self._sfx05703006     = soundEffect:playEffectsfx05703006()
        sound.setFinishCallback(self._sfx05703006, function()
            self._sfx05703006 = nil
        end)
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end
    -- 音效[sfx05700001]点击拿起海绵（复用）
    soundEffect:playEffectsfx05700001()
    -- 关闭引导
    guideFn:stopGuide(self)
    -- 手手消失
    if not self._once then 
        self._once = true
        self._layer._hand:quit() 
    end
    -- 抹布动作
    self:towelAction()
    self._startPos = cc.p(x, y)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    if not self._canTouch then return end
    local px, py = Tools:dragLimit(self, x, y, self:cw()/2, V.w - self:cw()/2 , 0, V.h - self:ch()/2)
    self:p(px, py)
    bb.si.Tool.limitButtonMove({node = self})
    local endPos = ccp(x, y)
    self._layer._towelTexture:erasure(self._startPos, ccp(x, y + 50), nil, 255, 1.2)
    self._startPos = ccp(x, y)
    -- 计算函数
    self:count()
    if self._clearCount == 35 then 
        self:towelOut()
        self._canTouch = false
    end 
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return end
    sound.voiceFadeTo(self._sfx05703006, 0.07, 1)
    -- 开启引导
    guideFn:openGuide(self, 0.1, 3)
    -- 停止抹布动作
    self:stopTowelAction()
    if self._clearCount >= 28 then 
        -- 结束
        self:towelOut()
        self._canTouch = false
    end
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    for k, v in pairs(self._particletab) do
        if not tolua.isnull(v) then 
            v:remove()
            v = nil
        end
    end
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
